/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEQueryClockIDEnable
extends TENEExplorerBean {
    private TIntArrayList clockidList = new TIntArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData.setBussinessParams(new BussinessParams());
        this.adddefault();
        int retCode = this.handleClockIDEnable(operationList);
        if (retCode == 1090646019) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        try {
            new TEGetOtherFiberEndAdapter(1).appendOtherFiberEndParam(neid, this.clockidList.toNativeArray(), this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get figer fail!", (Throwable)e);
        }
    }

    public void adddefault() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getClonedBoardList();
        int m = boardList.size();
        for (int i = 0; i < m; ++i) {
            this.handleInputData((TEBoard)boardList.get(i));
        }
    }

    private void handleInputData(TEBoard board) {
        String[] ver;
        TENE ne;
        int netype;
        List tempPorts;
        TEGenCfgAttribute cfgAttribute;
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        int slotid = board.getSlotID();
        int boardType = board.getBoardType();
        int subslotid = 255;
        ArrayList<Object> portIDList = new ArrayList<Object>();
        if (boardType == 2084) {
            return;
        }
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
        boolean isFromBoardModel = false;
        if (null != genCfgModel && null != (cfgAttribute = genCfgModel.getAttrFromId("ATTR_CLOCK_CLOCKIDPRI"))) {
            ArrayList portList = cfgAttribute.getPortList();
            for (int i = 0; i < portList.size(); ++i) {
                portIDList.add(new TEPort(this.neid, slotid, boardType, ((TEGenCfgPortAttribute)portList.get(i)).getPort()));
                isFromBoardModel = true;
            }
        }
        if (!isFromBoardModel) {
            if (2102 == boardType) {
                List portList = TEConfigurationDataMgr.getInstance().getPortListFromPortType(this.neid, boardType, 1025);
                int m = portList.size();
                for (int i = 0; i < m; ++i) {
                    int portId = (Integer)portList.get(i);
                    if (portId == 9) continue;
                    portIDList.add(new TEPort(this.neid, slotid, boardType, portId));
                }
            } else if (2439 == boardType) {
                portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 1025));
                portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 1799));
            } else if (cfgDataMgr.isIFboard(boardType)) {
                portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 1802));
                portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 2817));
            } else if (cfgDataMgr.isSDHLineBoard(this.neid, slotid)) {
                if (1624 == boardType) {
                    portIDList.add(new TEPort(this.neid, slotid, boardType, 1));
                } else {
                    portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 1798));
                    portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 256));
                }
            } else if (cfgDataMgr.isBranchBoard(this.neid, slotid)) {
                List idList = cfgDataMgr.getPortList(this.neid, slotid, 259);
                if (idList.size() > 2) {
                    portIDList.add(idList.get(0));
                    portIDList.add(idList.get(1));
                } else {
                    portIDList.addAll(idList);
                }
            } else if (TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neid, boardType)) {
                ArrayList logicPorts = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, slotid);
                int size = logicPorts.size();
                for (int j = 0; j < size; ++j) {
                    int port = (Integer)logicPorts.get(j);
                    portIDList.add(new TEPort(this.neid, slotid, boardType, port));
                }
            } else {
                portIDList.addAll(cfgDataMgr.getPortList(this.neid, slotid, 1799));
            }
        }
        if (!(tempPorts = TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_STG_SUBNET", "PORTSOFBOARD_SUPPORT_CLOCKPRISOURCE")).isEmpty()) {
            portIDList.clear();
            boolean isDynBd = TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neid, boardType);
            ArrayList existPorts = new ArrayList();
            if (isDynBd) {
                existPorts.addAll(TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, slotid));
            }
            for (String tempPort : tempPorts) {
                if ((!isDynBd || !existPorts.contains(Integer.valueOf(tempPort))) && isDynBd) continue;
                portIDList.add(new TEPort(this.neid, slotid, boardType, Integer.valueOf(tempPort).intValue()));
            }
        }
        if ((netype = (ne = TENEListMgr.getInstance().getNE(this.neid)).getNEType()) == 92 && (Integer.parseInt((ver = ne.getShowNEVersion().split("\\."))[2]) > 1 || Integer.parseInt(ver[2]) == 1 && Integer.parseInt(ver[3]) >= 20)) {
            ArrayList<Operation> operList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_RTN_CFG_GET_RADIO_1J1PG");
            operList.add(oper);
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, 10);
            if (result.retCode == 0 && oper.getOutput(0).getFault(0).getCode().equals("0")) {
                portIDList.add(new TEPort(this.neid, 1, 2454, 4));
            }
        }
        int clockid = (slotid << 24) + (subslotid << 16);
        int portId = 0;
        RowParams rowParams = null;
        int m = portIDList.size();
        for (int i = 0; i < m; ++i) {
            portId = ((TEPort)portIDList.get(i)).getPortNo();
            if (2264 == boardType && !TEClockUtility.isLogiPortExistForRTN(this.neid, slotid, portId)) continue;
            this.clockidList.add(clockid + portId);
            rowParams = new RowParams();
            rowParams.addParam("clockid", clockid + portId + "");
            rowParams.addParam("clockidenable", "1");
            rowParams.addParam("clockname", TEClockUtility.getClockSourceNameExForPTN(this.neid, clockid + portId));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private int handleClockIDEnable(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        if (outputArr.length == 0) {
            return 1090646019;
        }
        int[] clockid = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = Integer.parseInt(output.getFault()[0].getCode());
            if (retCode != 0 && retCode != 38662) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (value == null || value.equals("")) continue;
                if (name.equalsIgnoreCase("clocknum")) {
                    clocknum = Integer.parseInt(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata")) continue;
                clockid = new int[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    clockid[i] = Integer.parseInt(value.substring(index, index + 8), 16);
                    index += 8;
                }
            }
        }
        if (clockid == null) {
            clockid = new int[]{0};
        }
        this.setClockidEnable(clockid);
        return 0;
    }

    private void setClockidEnable(int[] clockid) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        int len = rowparas.length;
        for (int i = 0; i < len; ++i) {
            Param para = rowparas[i].getParam("clockid");
            int id = Integer.parseInt(para.getValue());
            for (int j = 0; j < clockid.length; ++j) {
                if (id != clockid[j]) continue;
                rowparas[i].getParam("clockidenable").setValue("0");
            }
        }
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }
}

