/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQuery2mClockPriority
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int retCode = this.handleclockidlist(operationList);
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        retCode = this.handleclockState(operationList);
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        this.handlclocklock(operationList);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private int handlclocklock(ArrayList operationList) {
        RowParams[] rowpara = this.outputData.getBussinessParams().getRowParams();
        Operation operation = (Operation)operationList.get(2);
        Output[] outputArr = operation.getOutput();
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("clockid");
            int clockid = new Integer(value);
            String lockstate = output.getPartValue("lockstate");
            int len1 = rowpara.length;
            for (int i = 0; i < len1; ++i) {
                Param param = rowpara[i].getParam("clockid");
                int id = new Integer(param.getValue());
                if (clockid != id) continue;
                param = rowpara[i].getParam("lockstate");
                param.setValue(lockstate);
            }
        }
        return retCode;
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }

    private int handleclockState(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(1);
        Output[] outputArr = operation.getOutput();
        String[] clockidstr = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockidstr = new String[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    int clockidlength = 8;
                    clockidstr[i] = value.substring(index, index + clockidlength);
                    index += clockidlength;
                }
            }
        }
        if (clockidstr == null) {
            clockidstr = new String[]{};
        }
        this.handleClockstatedata(clockidstr);
        return retCode;
    }

    private int handleclockidlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        String[] clockidstr = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockidstr = new String[clocknum];
                int lens = value.length() / 8;
                int index = 0;
                for (int i = 0; i < lens; ++i) {
                    int clockidlength = 8;
                    clockidstr[i] = value.substring(index, index + clockidlength);
                    index += clockidlength;
                }
            }
        }
        if (clockidstr == null) {
            clockidstr = new String[]{};
        }
        this.handleClockiddata(clockidstr);
        return retCode;
    }

    private void handleClockstatedata(String[] clockidstr) {
        RowParams[] rowpara = this.outputData.getBussinessParams().getRowParams();
        for (int j = 0; j < clockidstr.length; ++j) {
            int stateid = Integer.parseInt(clockidstr[j], 16);
            int len = rowpara.length;
            for (int i = 0; i < len; ++i) {
                Param param = rowpara[i].getParam("clockid");
                int clockid = new Integer(param.getValue());
                if (stateid != clockid) continue;
                param = rowpara[i].getParam("clockstate");
                param.setValue("1");
            }
        }
    }

    private void handleClockiddata(String[] clockidstr) {
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < clockidstr.length; ++i) {
            RowParams rtnRowParams = new RowParams();
            int clockid = Integer.parseInt(clockidstr[i], 16);
            rtnRowParams.addParam("clockid", clockid + "");
            rtnRowParams.addParam("clockname", TEClockUtility.getClockSourceNameExForPTN(this.neid, clockid));
            rtnRowParams.addParam("clockstate", "0");
            rtnRowParams.addParam("lockstate", "1");
            rtnRowParams.addParam("number", String.valueOf(i + 1));
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
    }
}

