/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.sdh.clock_v2r8c01.TEUsableResource;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetPortsBean
implements TENEMgrInterface {
    private Datainterface datainterface = new Datainterface();
    private BussinessParams bParams = new BussinessParams();
    private int neID = -1;
    private ArrayList usableResourceList = new ArrayList();
    private static final int TIMEOUT = 10;
    private static final int INVALID_BOARD = 65535;
    private static final int INVALID_SUBBOARD = 255;
    private static final int MLPPP_PORT = 4096;
    private static final int VIRTUAL_PORT = 10240;
    private static final int SERIAL_PORT = 6144;
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    private static final int BOARDTYPE_EFG2 = 1171;
    private static final int BOARDTYPE_EG16 = 1125;
    private static final int BOARDTYPE_POD41 = 1134;
    private static final int TN81ETFC = 1133;
    private static final int TN81D12 = 1135;
    private static final int TN81D75 = 1137;
    private static final int LAST_E1_PORTID = 32;
    private static final int LAST_FE_PORTID = 12;
    private static final int TNC1CXPE = 1299;
    private static final int TNC1CXPF = 1300;
    private static final String INVALID_SUBSLOTID = "255";
    private static final int PORT_NUM = 20;
    private Operation portNameOper = null;
    private ArrayList processingBoardList = new ArrayList();
    private static final int BOARD_CXPA = 1410;
    private static final int BOARD_CXPB = 1411;
    private static final int BOARD_ML1 = 1417;
    private static final int BOARD_ML1A = 1418;
    private boolean processingBoardFlag = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getBoardList();
        Collections.sort(boardList);
        if (boardList == null || boardList.size() == 0) {
            this.datainterface.setBussinessParams(this.bParams);
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource usableRes;
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            int slotID = board.getSlotID();
            String bdName = board.getBoardName();
            List subBoardList = board.getSubBoardList();
            int len = subBoardList.size();
            int subBoardType = 0;
            int subBoardId = 255;
            ArrayList portList = null;
            String subdName = "";
            if (0 < len) {
                for (int k = 0; k < len; ++k) {
                    TEUsableResource usableRes2;
                    TESubBoard subBoard = (TESubBoard)subBoardList.get(k);
                    subBoardId = subBoard.getSubSlotID();
                    subBoardType = subBoard.getSubBoardType();
                    portList = this.cfgDataMgr.getBoardPortList(neid, subBoardType, slotID);
                    ArrayList<String> portidList = new ArrayList<String>();
                    ArrayList<String> portNameList = new ArrayList<String>();
                    int size3 = portList.size();
                    for (int l = 0; l < size3; ++l) {
                        int portID = (Integer)portList.get(l);
                        portidList.add(l, portID + "");
                        String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, subBoardType, portID);
                        portNameList.add(l, portName);
                    }
                    if (portidList.size() <= 0 || this.usableResourceList.contains((Object)(usableRes2 = new TEUsableResource(slotID, bdName, subBoardId, subdName = this.cfgDataMgr.getBoardTypeName(this.neID, subBoardType), portidList, portNameList)))) continue;
                    this.usableResourceList.add(usableRes2);
                }
                continue;
            }
            portList = this.getPortList(slotID, bdType);
            ArrayList<String> portidList = new ArrayList<String>();
            ArrayList<String> portNameList = new ArrayList<String>();
            int size3 = portList.size();
            if (bdType == 1299 || bdType == 1300) {
                size3 = 20;
            }
            for (int l = 0; l < size3; ++l) {
                int portID = (Integer)portList.get(l);
                if ((1135 == bdType || 1137 == bdType) && 0 == slotID % 2 && 32 == portID || 1133 == bdType && 2 == slotID % 4 && 12 == portID) continue;
                portidList.add(l, portID + "");
                String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, bdType, portID);
                portNameList.add(l, portName);
            }
            if (portidList.size() <= 0 || this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotID, bdName, subBoardId, subdName, portidList, portNameList)))) continue;
            this.usableResourceList.add(usableRes);
        }
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("CES");
        if (null != param) {
            this.processingBoardFlag = true;
            this.getProcessingBoard();
        }
        if (null != (param = inputData.getBussinessParams().getRowParams(0).getParam("pppFlag"))) {
            if (this.portNameOper == null) {
                this.queryPortName();
            }
            this.getQueryMLPPPOper();
        }
        if (null != (param = inputData.getBussinessParams().getRowParams(0).getParam("serialport"))) {
            this.getQuerySerialPortOper(boardList);
        }
        if (null != (param = inputData.getBussinessParams().getRowParams(0).getParam("vport"))) {
            if (this.portNameOper == null) {
                this.queryPortName();
            }
            this.getQueryVportOper();
        }
        return this.constructRtnData();
    }

    private void getProcessingBoard() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            int slotid;
            String boardName;
            TEBoard board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            if (1410 != boardType && 1411 != boardType && 1417 != boardType && 1418 != boardType || this.processingBoardList.contains(boardName = (slotid = board.getSlotID()) + "-" + this.cfgDataMgr.getBoardTypeName(this.neID, boardType))) continue;
            this.processingBoardList.add(boardName);
        }
    }

    private void getQuerySerialPortOper(Vector boardList) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int slotID = board.getSlotID();
            Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT");
            Input input = operation.getInput();
            input.setPartValue("slotid", slotID + "");
            input.setPartValue("subslotid", "0");
            input.setPartValue("serialport", "0");
            operationList.add(operation);
            Operation operation1 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT_VC12");
            Input input1 = operation1.getInput();
            input1.setPartValue("slotid", slotID + "");
            input1.setPartValue("subslotid", "0");
            input1.setPartValue("serialport", "0");
            operationList.add(operation1);
        }
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        size = operationList.size();
        for (int index = 0; index < size; ++index) {
            int slotid = 0;
            String boardname = "";
            int subslotid = 0;
            String subboardname = "";
            Operation tmpOper = (Operation)operationList.get(index);
            Output[] outputArr = tmpOper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEUsableResource usableRes;
                boolean emptyFlag = false;
                Output output = outputArr[i];
                for (Fault fault : output.getFault()) {
                    String code = fault.getCode();
                    if (null != code && Integer.parseInt(code) == 0) continue;
                    emptyFlag = true;
                    break;
                }
                if (emptyFlag) continue;
                slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardtype = this.cfgDataMgr.getBoardType(this.neID, slotid);
                boardname = this.cfgDataMgr.getBoardTypeName(this.neID, boardtype);
                subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                int subboardtype = 0;
                subboardname = "";
                if (255 != subslotid) {
                    subboardtype = this.cfgDataMgr.getSubboardType(this.neID, slotid, subslotid);
                    subboardname = this.cfgDataMgr.getBoardTypeName(this.neID, subboardtype);
                }
                int serialport = Integer.parseInt(output.getPartValue("serialport"));
                String portname = serialport - 6144 + "(Serial-" + (serialport - 6144) + ")";
                boolean isExist = false;
                int len2 = this.usableResourceList.size();
                for (int j = 0; j < len2; ++j) {
                    usableRes = (TEUsableResource)((Object)this.usableResourceList.get(j));
                    int slotidInArray = usableRes.getSlotID();
                    int subslotidInArray = usableRes.getSubslotID();
                    if (slotid != slotidInArray || subslotid != subslotidInArray) continue;
                    isExist = true;
                    ArrayList portidList = usableRes.getPortidList();
                    portidList.add(portidList.size(), serialport + "");
                    ArrayList portNameList = usableRes.getPortNameList();
                    portNameList.add(portNameList.size(), portname);
                }
                if (isExist) continue;
                ArrayList<String> portidList = new ArrayList<String>();
                portidList.add(serialport + "");
                ArrayList<String> portNameList = new ArrayList<String>();
                portNameList.add(portname);
                usableRes = new TEUsableResource(slotid, boardname, subslotid, subboardname, portidList, portNameList);
                this.usableResourceList.add(usableRes);
            }
        }
        operationList.clear();
    }

    private void getQueryMLPPPOper() {
        TEUsableResource usableRes;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_MLPPP_GET_MP");
        Input input = operation.getInput();
        input.setPartValue("groupno", "0");
        operationList.add(operation);
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        int slotid = 65535;
        String boardname = "ML-PPP";
        int subslotid = 255;
        String subboardname = "";
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList<String> portNameList = new ArrayList<String>();
        for (Output output : outputArr) {
            int mpid;
            boolean isRepeat;
            Fault[] faultArr = output.getFault();
            boolean isEmpty = false;
            for (Fault fault : faultArr) {
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                isEmpty = true;
                break;
            }
            if (isEmpty || (isRepeat = portidList.contains((mpid = Integer.parseInt(output.getPartValue("groupno"))) + ""))) continue;
            portidList.add(mpid + "");
        }
        operationList.clear();
        block2: for (Output output2 : this.portNameOper.getOutput()) {
            String portname = null;
            int mpidlen = portidList.size();
            for (int k = 0; k < mpidlen; ++k) {
                int portId2;
                int portId = Integer.parseInt((String)portidList.get(k));
                if (portId != (portId2 = Integer.parseInt(output2.getPartValue("port")))) continue;
                portname = (output2.getPartValue("portName") == null || "".equals(output2.getPartValue("portName").trim()) ? Integer.valueOf(portId2 - 4096).toString() : output2.getPartValue("portName")).trim();
                portNameList.add(portId2 - 4096 + "(MP-" + portname + ")");
                continue block2;
            }
        }
        if (0 < portidList.size() && !this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotid, boardname, subslotid, subboardname, portidList, portNameList)))) {
            this.usableResourceList.add(usableRes);
        }
    }

    private void getQueryVportOper() {
        TEUsableResource usableRes;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_PORT_GET_VPORT");
        Input input = operation.getInput();
        input.setPartValue("slotid", "65535");
        input.setPartValue("subslotid", INVALID_SUBSLOTID);
        input.setPartValue("vport", "0");
        operationList.add(operation);
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        int slotid = 65535;
        String boardname = "Virtual Ethernet";
        int subslotid = 255;
        String subboardname = "";
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList<String> portNameList = new ArrayList<String>();
        block0: for (Output output : outputArr) {
            Fault[] faultArr = output.getFault();
            boolean isEmpty = false;
            for (Fault fault : faultArr) {
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                isEmpty = true;
                break;
            }
            if (isEmpty) continue;
            int vport = Integer.parseInt(output.getPartValue("vport"));
            portidList.add(vport + "");
            for (Output output2 : this.portNameOper.getOutput()) {
                String portname = null;
                int portId2 = Integer.parseInt(output2.getPartValue("port"));
                if (vport != portId2) continue;
                portname = (output2.getPartValue("portName") == null || "".equals(output2.getPartValue("portName").trim()) ? Integer.valueOf(portId2 - 10240).toString() : output2.getPartValue("portName")).trim();
                portNameList.add(vport - 10240 + "(VEther-" + portname + ")");
                continue block0;
            }
        }
        if (0 < portidList.size() && !this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotid, boardname, subslotid, subboardname, portidList, portNameList)))) {
            this.usableResourceList.add(usableRes);
        }
    }

    public Datainterface constructRtnData() {
        RowParams rParams = null;
        Param param = null;
        if (this.processingBoardFlag) {
            StringBuffer boardNameArray = new StringBuffer();
            int size = this.processingBoardList.size();
            for (int i = 0; i < size; ++i) {
                boardNameArray.append((String)this.processingBoardList.get(i)).append(",");
            }
            rParams = new RowParams();
            param = new Param("boardNameArray", boardNameArray.toString());
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            rParams = new RowParams();
            param = null;
            param = new Param("slotid", Integer.valueOf(res.getSlotID()).toString());
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("subslotid", Integer.valueOf(res.getSubslotID()).toString());
            rParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            int size1 = res.getPortidList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortidList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            param = new Param("portName", (String)res.getPortNameList().get(0));
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortNameList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        this.datainterface.setBussinessParams(this.bParams);
        this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        return this.datainterface;
    }

    private void queryPortName() {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input2 = oper.getInput();
        input2.setPartValue("slotid", "65535");
        input2.setPartValue("subslotid", INVALID_SUBSLOTID);
        input2.setPartValue("port", "0");
        operationList.add(oper);
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        this.portNameOper = (Operation)operationList.get(0);
        operationList.clear();
    }

    private ArrayList getPortList(int slotid, int boardType) {
        ArrayList allPortList = this.cfgDataMgr.getBoardPortList(this.neID, boardType, slotid);
        ArrayList existPortList = null;
        if (1171 == boardType || 1125 == boardType || 1134 == boardType) {
            existPortList = this.getExistPortList(allPortList, slotid);
        }
        if (2079 == boardType || 2080 == boardType || 2082 == boardType || 2083 == boardType || 2418 == boardType || 2417 == boardType) {
            existPortList = this.cfgDataMgr.getETHMACPort(this.neID, boardType);
        }
        if (null == existPortList || existPortList.isEmpty()) {
            return allPortList;
        }
        return existPortList;
    }

    private ArrayList getExistPortList(ArrayList portList, int slotid) {
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_SUBBD_GET_PORT");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotid));
            input.setPartValue("subslotid", INVALID_SUBSLOTID);
            input.setPartValue("port", "0");
            operationList.add(oper);
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            if (operationList.size() == 0) {
                return returnList;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)this.neID, operationList, (int)10).retCode;
            if (result == 0) {
                Operation oOperation = (Operation)operationList.get(0);
                for (Output output : oOperation.getOutput()) {
                    if (!String.valueOf(0).equals(output.getFault()[0].getCode())) continue;
                    String portId = output.getPartValue("port");
                    returnList.add(Integer.valueOf(portId));
                }
            }
            return returnList;
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

