/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockConstant;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TEGetAllClockSource
extends TENEExplorerBean {
    private ArrayList clockidlist = new ArrayList();
    private static final int BOARDTYPE_CXPE = 1299;
    private HashSet filerslot = new HashSet();
    private HashMap clockportlist = new HashMap();
    private int clockslotno = 0;
    private int sourceindex = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.inputData = inputData;
        this.fetchinfoR8();
        this.getclocksourceR8();
        this.fetchfromboardR8();
        this.filterClockR8(inputData);
        Collections.sort(this.clockidlist);
        this.outputData = new Datainterface();
        BussinessParams bussinessParamForR8 = new BussinessParams();
        Iterator iter = this.clockidlist.iterator();
        while (iter.hasNext()) {
            RowParams rowparam = new RowParams();
            int clockid = (Integer)iter.next();
            rowparam.addParam("clockid", clockid + "");
            rowparam.addParam("clockname", TEClockUtility.getClockSourceNameExForPTN(neid, clockid));
            bussinessParamForR8.addRowParams(rowparam);
        }
        this.outputData.setBussinessParams(bussinessParamForR8);
        try {
            int[] clockid_r8 = new int[this.clockidlist.size()];
            int len = this.clockidlist.size();
            for (int i = 0; i < len; ++i) {
                clockid_r8[i] = (Integer)this.clockidlist.get(i);
            }
            try {
                new TEGetOtherFiberEndAdapter(1).appendOtherFiberEndParam(neid, clockid_r8, this.outputData);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("", (Throwable)e);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get other fiber end fail!", (Throwable)e);
        }
        return this.outputData;
    }

    private void fetchfromboardR8() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        int netype = ne.getNEType();
        Vector boardList = ne.getClonedBoardList();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardslot = board.getSlotID();
            if (this.filerslot.contains(boardslot + "")) {
                this.addACRClockidR8(board);
                continue;
            }
            if (this.clockportlist.get(boardslot + "") != null) {
                this.clockidlist.add((Integer)this.clockportlist.get(boardslot + ""));
                this.addACRClockidR8(board);
                continue;
            }
            this.addclockidR8(netype, board);
        }
        if (this.sourceindex == 0 && ne.getNEType() != 89 && ne.getNEType() != 90) {
            this.clockidlist.add(0xF00001);
            String hostVersion = ne.getHostVersion();
            hostVersion = hostVersion.trim();
            String[] neVersions = hostVersion.split("\\.");
            if (neVersions == null || neVersions.length < 4) {
                if (ne.getNEType() != 76) {
                    this.clockidlist.add(0xF00002);
                }
            } else if (ne.getNEType() != 76 && ne.getNEType() != 114) {
                this.clockidlist.add(0xF00002);
            } else if (Integer.parseInt(neVersions[1]) == 76 && Integer.parseInt(neVersions[2]) < 2) {
                this.clockidlist.add(0xF00002);
            }
        }
        if (TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_CFG_STG_SYNSRCPRV", "CLOCKPRI_SUPPORT_FIRSTCLOCKSOURCE") && !this.clockidlist.contains(0xF00001)) {
            this.clockidlist.add(0xF00001);
        }
        if (TESpecialAttrMgr.getInstance().isNENotSupport(this.neid, "TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME", "CLOCKPRI_SUPPORT_SECONDCLOCKSOURCE") && this.clockidlist.contains(0xF00002)) {
            this.clockidlist.remove((Object)0xF00002);
        }
    }

    private void fetchinfoR8() {
        RowParams[] rowparas = this.inputData.getBussinessParams().getRowParams();
        Param para = rowparas[0].getParam("clockslotno");
        this.clockslotno = Integer.parseInt(para.getValue());
        para = rowparas[0].getParam("sourceindex");
        this.sourceindex = Integer.parseInt(para.getValue());
    }

    private int getclocksourceR8() {
        ArrayList<Operation> operationList_r8 = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SYN_CLASS");
        Input input = oper.getInput();
        input.getPart("clockslotno").setValue(this.clockslotno + "");
        operationList_r8.add(oper);
        for (int i = 0; i < 2; ++i) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_2MPLL_CLASS_EX");
            input = oper.getInput();
            input.getPart("clockslotno").setValue(this.clockslotno + "");
            input.getPart("clock2mindex").setValue(i + 1 + "");
            operationList_r8.add(oper);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList_r8, 10);
        if (result.retCode != 0) {
            return result.retCode;
        }
        int size = operationList_r8.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList_r8.get(i);
            Output[] outputArr_r8 = operation.getOutput();
            int retCode = Integer.parseInt(outputArr_r8[0].getFault()[0].getCode());
            if (retCode != 0) continue;
            String clockindex = outputArr_r8[0].getPartValue("clock2mindex");
            if (clockindex == null) {
                clockindex = "0";
            }
            int clocknum = Integer.parseInt(outputArr_r8[0].getPartValue("clocknum"));
            String value = outputArr_r8[0].getPartValue("clockdata");
            int[] clockidstr = new int[clocknum];
            int clockidlength = 8;
            int index = 0;
            for (int k = 0; k < clocknum; ++k) {
                clockidstr[k] = Integer.parseInt(value.substring(index, index + clockidlength), 16);
                index += clockidlength;
            }
        }
        return 0;
    }

    private void filterClockR8(Datainterface inputData) {
        RowParams[] rowparams = inputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        block0: for (int i = 1; i < len; ++i) {
            Param param_r8 = rowparams[i].getParam("clockid");
            int hasclocid = Integer.parseInt(param_r8.getValue());
            int lens = this.clockidlist.size();
            for (int j = 0; j < lens; ++j) {
                int newclock = (Integer)this.clockidlist.get(j);
                if (newclock != hasclocid) continue;
                this.clockidlist.remove(j);
                continue block0;
            }
        }
        this.delDbExtS(this.clockidlist, 0xF00001);
        this.delDbExtS(this.clockidlist, 0xF00002);
    }

    private void addclockidR8(int netype, TEBoard board) {
        int slotid = board.getSlotID();
        int boardtype = board.getBoardType();
        if (TEClockConstant.clockboardtype.contains(boardtype) || TESpecialAttrMgr.getInstance().isCPSupportByType(board.getBoardType(), "TE_FUNC_CFG_STG_SYNSRCPRV", "BOARD_SUPPORT_CLOCKPRISOURCE")) {
            int subboardid = 255;
            int clockid = 0;
            ArrayList portList_r8 = this.getPortList(netype, slotid, boardtype);
            TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
            if (mgr.isDynPortBoardType(this.neid, boardtype)) {
                portList_r8.removeAll(mgr.getSupportedDynPortList(this.neid, boardtype));
                portList_r8.addAll(mgr.getLogicPortList(this.neid, board.getSlotID()));
            }
            int len = portList_r8.size();
            for (int j = 0; j < len; ++j) {
                int portId = (Integer)portList_r8.get(j);
                if (1299 == boardtype && j >= 20 || this.clockidlist.contains(clockid = (slotid << 24) + (subboardid << 16) + portId)) continue;
                this.clockidlist.add(clockid);
            }
            this.addACRClockidR8(board);
        }
    }

    private void addACRClockidR8(TEBoard board) {
        int boardtype = board.getBoardType();
        int slotid = board.getSlotID();
        if (this.sourceindex == 0 && this.isSupportTwoClcR8(boardtype)) {
            int clockid = 131072 + (slotid << 8) + 1;
            this.clockidlist.add(clockid);
            clockid = 131072 + (slotid << 8) + 2;
            this.clockidlist.add(clockid);
        }
    }

    private boolean isSupportTwoClcR8(int boardtype) {
        return boardtype == 1417 || boardtype == 1418 || boardtype == 1410 || boardtype == 1411;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void delDbExtS(ArrayList list, int value) {
        boolean flg = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            int source = Integer.valueOf(it.next().toString());
            if (source != value) continue;
            if (!flg) {
                flg = true;
                continue;
            }
            it.remove();
        }
    }

    private ArrayList getPortList(int netype, int slotid, int boardType) {
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        ArrayList allPortList = cfgDataMgr.getBoardPortList(this.neid, boardType, slotid);
        ArrayList existPortList = new ArrayList();
        List tempPorts = TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_STG_SYNSRCPRV", "PORTSOFBOARD_SUPPORT_CLOCKPRISOURCE");
        if (!tempPorts.isEmpty()) {
            for (String tempPort : tempPorts) {
                existPortList.add(Integer.valueOf(tempPort));
            }
            return existPortList;
        }
        existPortList.addAll(cfgDataMgr.getPortListFromPortType(this.neid, boardType, 2817));
        existPortList.addAll(cfgDataMgr.getPortListFromPortType(this.neid, boardType, 1802));
        if (2082 == boardType || 2083 == boardType || 2418 == boardType || 2417 == boardType || 2471 == boardType) {
            existPortList.addAll(cfgDataMgr.getPortListFromPortType(this.neid, boardType, 1799));
        }
        if (2102 == boardType) {
            existPortList.clear();
            existPortList.addAll(cfgDataMgr.getPortListFromPortType(this.neid, boardType, 1025));
            int index = existPortList.indexOf(9);
            if (index >= 0) {
                existPortList.remove(index);
            }
        }
        if (2439 == boardType) {
            existPortList.clear();
            existPortList.addAll(cfgDataMgr.getPortListFromPortType(this.neid, boardType, 1025));
            existPortList.addAll(cfgDataMgr.getPortListFromPortType(this.neid, boardType, 1799));
        }
        if ((2084 == boardType || 2099 == boardType) && 95 != netype) {
            existPortList = new ArrayList();
            if (this.sourceindex == 0) {
                existPortList.add(1);
                existPortList.add(2);
            }
            return existPortList;
        }
        if (2081 == boardType || 1624 == boardType) {
            existPortList = new ArrayList();
            existPortList.add(1);
        }
        if (2469 == boardType) {
            existPortList = new ArrayList();
            existPortList.add(1);
            existPortList.add(2);
            existPortList.add(3);
            existPortList.add(4);
        }
        if (2274 == boardType || 2273 == boardType || 2269 == boardType) {
            existPortList = new ArrayList();
            existPortList.add(1);
            existPortList.add(2);
        }
        if (null == existPortList || existPortList.isEmpty()) {
            existPortList = allPortList;
        }
        List portList = TESpecialAttrMgr.getInstance().getNEAttrListValue(this.neid, "TE_FUNC_CFG_ETH_CLOKTRANS", "ETH_ATTR_SUPPORT_CLOCKTRANS");
        if (2469 == boardType) {
            portList.add("5");
            portList.add("6");
        }
        if (!portList.isEmpty()) {
            existPortList.addAll(TEClockUtility.getCustomInternalClockSource(this.neid, slotid, portList));
        }
        if (2264 == boardType) {
            Iterator iterator = existPortList.iterator();
            while (iterator.hasNext()) {
                if (TEClockUtility.isLogiPortExistForRTN(this.neid, slotid, (Integer)iterator.next())) continue;
                iterator.remove();
            }
        }
        return existPortList;
    }
}

