/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock_u2kv1r7c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockConstant;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class TEGetAllClockSource
extends TENEExplorerBean {
    private ArrayList clockidlist = new ArrayList();
    private static final int BOARDTYPE_CXPE = 1299;
    private HashSet filerslot = new HashSet();
    private HashMap clockportlist = new HashMap();
    private HashSet filerthisclock = new HashSet();
    private int clockslotno = 0;
    private int sourceindex = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.inputData = inputData;
        this.fetchinfoR7();
        this.getclocksourceR7();
        this.fetchfromboardR7();
        this.filterClockR7(inputData);
        Collections.sort(this.clockidlist);
        this.outputData = new Datainterface();
        BussinessParams bussinessParamForR7 = new BussinessParams();
        Iterator iter = this.clockidlist.iterator();
        while (iter.hasNext()) {
            RowParams rowparam = new RowParams();
            int clockid = (Integer)iter.next();
            rowparam.addParam("clockid", clockid + "");
            rowparam.addParam("clockname", TEClockUtility.getClockSourceNameExForPTN(neid, clockid));
            bussinessParamForR7.addRowParams(rowparam);
        }
        this.outputData.setBussinessParams(bussinessParamForR7);
        try {
            int[] clockid_r7 = new int[this.clockidlist.size()];
            int len = this.clockidlist.size();
            for (int i = 0; i < len; ++i) {
                clockid_r7[i] = (Integer)this.clockidlist.get(i);
            }
            try {
                new TEGetOtherFiberEndAdapter(1).appendOtherFiberEndParam(neid, clockid_r7, this.outputData);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("", (Throwable)e);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get other fiber end fail!", (Throwable)e);
        }
        return this.outputData;
    }

    private void fetchfromboardR7() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getClonedBoardList();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardslot = board.getSlotID();
            if (this.filerslot.contains(boardslot + "")) {
                this.addACRClockidR7(board);
                continue;
            }
            if (this.clockportlist.get(boardslot + "") != null) {
                this.clockidlist.add((Integer)this.clockportlist.get(boardslot + ""));
                this.addACRClockidR7(board);
                continue;
            }
            this.addclockidR7(board);
        }
    }

    private void fetchinfoR7() {
        RowParams[] rowparas = this.inputData.getBussinessParams().getRowParams();
        Param para = rowparas[0].getParam("clockslotno");
        this.clockslotno = Integer.parseInt(para.getValue());
        para = rowparas[0].getParam("sourceindex");
        this.sourceindex = Integer.parseInt(para.getValue());
    }

    private int getclocksourceR7() {
        ArrayList<Operation> operationList_r7 = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SYN_CLASS");
        Input input = oper.getInput();
        input.getPart("clockslotno").setValue(this.clockslotno + "");
        operationList_r7.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList_r7, 10);
        if (result.retCode != 0) {
            return result.retCode;
        }
        int size = operationList_r7.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList_r7.get(i);
            Output[] outputArr_r7 = operation.getOutput();
            int retCode = Integer.parseInt(outputArr_r7[0].getFault()[0].getCode());
            if (retCode != 0) continue;
            String clockindex = outputArr_r7[0].getPartValue("clock2mindex");
            if (clockindex == null) {
                clockindex = "0";
            }
            int clocknum = Integer.parseInt(outputArr_r7[0].getPartValue("clocknum"));
            String value = outputArr_r7[0].getPartValue("clockdata");
            int[] clockidstr = new int[clocknum];
            int clockidlength = 8;
            int index = 0;
            for (int k = 0; k < clocknum; ++k) {
                clockidstr[k] = Integer.parseInt(value.substring(index, index + clockidlength), 16);
                index += clockidlength;
                if (!clockindex.equals("" + this.sourceindex)) continue;
                this.filerthisclock.add(clockidstr[k]);
            }
            if (clockindex.equals("" + this.sourceindex)) continue;
            this.setfilerslotR7(clockidstr);
        }
        return 0;
    }

    private void setfilerslotR7(int[] clockidstr) {
        int slotid;
        int i;
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < clockidstr.length; ++i) {
            slotid = clockidstr[i] >> 24 & 0xFF;
            if (set.contains(slotid + "")) {
                this.filerslot.add(slotid + "");
                continue;
            }
            set.add(slotid + "");
        }
        for (i = 0; i < clockidstr.length; ++i) {
            slotid = clockidstr[i] >> 24 & 0xFF;
            if (this.filerslot.contains(slotid + "")) continue;
            this.clockportlist.put(slotid + "", clockidstr[i]);
        }
    }

    private void filterClockR7(Datainterface inputData) {
        RowParams[] rowparams = inputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        block0: for (int i = 1; i < len; ++i) {
            Param param_r7 = rowparams[i].getParam("clockid");
            int hasclocid = Integer.parseInt(param_r7.getValue());
            int lens = this.clockidlist.size();
            for (int j = 0; j < lens; ++j) {
                int newclock = (Integer)this.clockidlist.get(j);
                if (newclock != hasclocid) continue;
                this.clockidlist.remove(j);
                continue block0;
            }
        }
    }

    private void addclockidR7(TEBoard board) {
        int slotid = board.getSlotID();
        int boardtype = board.getBoardType();
        if (TEClockConstant.clockboardtype.contains(boardtype)) {
            int subboardid = 255;
            int clockid = 0;
            ArrayList portList_r7 = this.getPortList(slotid, boardtype);
            TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
            if (mgr.isDynPortBoardType(this.neid, boardtype)) {
                portList_r7.removeAll(mgr.getSupportedDynPortList(this.neid, boardtype));
                portList_r7.addAll(mgr.getLogicPortList(this.neid, board.getSlotID()));
            }
            int len = portList_r7.size();
            for (int j = 0; j < len; ++j) {
                int portId = (Integer)portList_r7.get(j);
                if (1299 == boardtype && j >= 20 || this.clockidlist.contains(clockid = (slotid << 24) + (subboardid << 16) + portId)) continue;
                this.clockidlist.add(clockid);
            }
            this.addACRClockidR7(board);
        }
    }

    private void addACRClockidR7(TEBoard board) {
        int boardtype = board.getBoardType();
        int slotid = board.getSlotID();
        if (this.sourceindex == 0 && this.isSupportTwoClcR7(boardtype)) {
            int clockid = 131072 + (slotid << 8) + 1;
            this.clockidlist.add(clockid);
            clockid = 131072 + (slotid << 8) + 2;
            this.clockidlist.add(clockid);
        }
    }

    private boolean isSupportTwoClcR7(int boardtype) {
        return boardtype == 1417 || boardtype == 1418 || boardtype == 1410 || boardtype == 1411;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private ArrayList getPortList(int slotid, int boardType) {
        String[] ver;
        ArrayList<Integer> existPortList = new ArrayList<Integer>();
        existPortList.add(1);
        existPortList.add(2);
        existPortList.add(3);
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (2484 == boardType) {
            existPortList.add(4);
        } else if (2454 == boardType && (Integer.parseInt((ver = ne.getShowNEVersion().split("\\."))[2]) > 1 || Integer.parseInt(ver[2]) == 1 && Integer.parseInt(ver[3]) >= 20)) {
            ArrayList<Operation> operList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_RTN_CFG_GET_RADIO_1J1PG");
            operList.add(oper);
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, 10);
            if (result.retCode == 0 && oper.getOutput(0).getFault(0).getCode().equals("0")) {
                existPortList.add(4);
            }
        }
        return existPortList;
    }
}

