/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock.jni;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.necommon.otherfiberend.TEFiberEnd;
import com.huawei.nglct.nemgr.necommon.otherfiberend.TEGetOtherFiberEnd;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEClockSource;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEClockSourceOrgin;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEClockSourceV2R8C01;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEGetOtherFiberEndAdapter {
    private static final String PARAM_CLOCKID = "clockid";
    private static final String PARAM_OTHERFIBEREND = "otherfiberend";
    public static final String DEFUALT_OTHER_FIBER_END = "/";
    public static final int VERSION_ORGIN = 0;
    public static final int VERSION_V2R8C01 = 1;
    public static final int UNSUPPORT_SUBRACK_ID = -1;
    private int version = 0;

    public TEGetOtherFiberEndAdapter(int version) {
        this.version = version;
    }

    public TEErrInfoReturn getOtherEnd(int neID, int[] clockid, Map<Integer, TEClockSource> clockSourceIDObjMap) {
        TEErrInfoReturn errRet = null;
        if (null == clockid || 0 == clockid.length) {
            errRet = new TEErrInfoReturn();
            return errRet;
        }
        List<TEClockSource> clockSourceList = this.constructClockSource(neID, clockid);
        errRet = this.getOtherEnd(clockSourceList);
        for (TEClockSource clockSource : clockSourceList) {
            clockSourceIDObjMap.put(clockSource.getClockID(), clockSource);
        }
        return errRet;
    }

    public List<RowErrors> contructErrorMessage(int neid, TEErrInfoReturn errInfoRet) {
        ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
        for (TEErrInfo errInfo : errInfoRet.getErrList()) {
            ErrorMessage newErrMsg = TEErrorResourceUtil.getErrorMessage((int)errInfo.getErrorCode());
            Param param = new Param();
            param.setName("neid");
            param.setValue(String.valueOf(neid));
            RowErrors rowError = new RowErrors();
            rowError.addParam(param);
            rowError.setErrorMessage(newErrMsg);
            rowErrorList.add(rowError);
        }
        return rowErrorList;
    }

    public void appendOtherFiberEndParam(int neID, int[] clockidArr, Datainterface outputData) {
        if (null == clockidArr || 0 == clockidArr.length || null == outputData || null == outputData.getBussinessParams()) {
            return;
        }
        String otherFiberEnd = null;
        TEClockSource clockSource = null;
        HashMap<Integer, TEClockSource> clockSourceIDObjMap = new HashMap<Integer, TEClockSource>();
        TEErrInfoReturn errInfoRet = this.getOtherEnd(neID, clockidArr, clockSourceIDObjMap);
        if (0 != errInfoRet.getResult()) {
            TELogFactory.getNormalLogger().info("get other fiber end. errInfoRet" + errInfoRet.toString());
        }
        RowParams[] rowparams = outputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        for (int i = 0; i < len; ++i) {
            Param param = rowparams[i].getParam(PARAM_CLOCKID);
            if (null == param || !TEStringUtils.isNumber((String)param.getValue())) continue;
            int clockid = Integer.parseInt(param.getValue());
            otherFiberEnd = DEFUALT_OTHER_FIBER_END;
            clockSource = (TEClockSource)clockSourceIDObjMap.get(clockid);
            if (null != clockSource) {
                otherFiberEnd = clockSource.getOtherFiberEnd();
            }
            rowparams[i].addParam(PARAM_OTHERFIBEREND, otherFiberEnd);
        }
    }

    private TEErrInfoReturn getOtherEnd(List<TEClockSource> clockSourceList) {
        TEClockSource clocksource = null;
        if (null == clockSourceList || clockSourceList.isEmpty()) {
            return new TEErrInfoReturn();
        }
        TEClockSource[] clocksourceArr = new TEClockSource[clockSourceList.size()];
        int len = clockSourceList.size();
        for (int index = 0; index < len; ++index) {
            clocksourceArr[index] = clocksource = clockSourceList.get(index);
        }
        return this.getOtherEnd(clocksourceArr);
    }

    private TEErrInfoReturn getOtherEnd(TEClockSource[] clocksourceArr) {
        TEErrInfoReturn errInfoRet = null;
        List<TEFiberEnd> currEndList = this.consturctCurrEndList(clocksourceArr);
        HashMap endMap = new HashMap();
        errInfoRet = TEGetOtherFiberEnd.getOtherEnd(currEndList, endMap);
        if (endMap.isEmpty()) {
            return errInfoRet;
        }
        TEFiberEnd otherEnd = null;
        int len = currEndList.size();
        for (int i = 0; i < len; ++i) {
            otherEnd = (TEFiberEnd)endMap.get(currEndList.get(i));
            if (null != otherEnd) {
                clocksourceArr[i].setOtherFiberEnd(otherEnd.toClientString());
                continue;
            }
            clocksourceArr[i].setOtherFiberEnd(DEFUALT_OTHER_FIBER_END);
        }
        return errInfoRet;
    }

    private List<TEClockSource> constructClockSource(int neID, int[] clockid) {
        ArrayList<TEClockSource> clockSourceList = new ArrayList<TEClockSource>();
        if (null == clockid || 0 == clockid.length) {
            return clockSourceList;
        }
        int len = clockid.length;
        for (int i = 0; i < len; ++i) {
            clockSourceList.add(this.constructClockSource(neID, clockid[i]));
        }
        return clockSourceList;
    }

    private TEClockSource constructClockSource(int neID, int clockid) {
        TEClockSource clock = null;
        clock = 1 == this.version ? new TEClockSourceV2R8C01(neID, clockid) : new TEClockSourceOrgin(neID, clockid);
        clock.setPortID(TEClockUtility.convertSPPort(neID, clock.getSlotID(), clock.getPortID()));
        return clock;
    }

    private List<TEFiberEnd> consturctCurrEndList(TEClockSource[] clocksourceArr) {
        ArrayList<TEFiberEnd> currEndList = new ArrayList<TEFiberEnd>();
        for (TEClockSource clock : clocksourceArr) {
            currEndList.add(this.constructFiberEnd(clock));
        }
        return currEndList;
    }

    private TEFiberEnd constructFiberEnd(TEClockSource clock) {
        TEFiberEnd fiberEnd = new TEFiberEnd();
        int neID = clock.getNeID();
        int slotID = clock.getSlotID();
        int portID = clock.getPortID();
        int subrackID = TEGetOtherFiberEnd.getSubrackIDFromSlot((int)neID, (int)slotID);
        fiberEnd.setBoardName("");
        fiberEnd.setNeid(neID);
        fiberEnd.setNeName("");
        fiberEnd.setPortID(portID);
        fiberEnd.setPortName("");
        fiberEnd.setSlotID(TEBoardUtil.bigSlotToSmall((int)slotID));
        fiberEnd.setSubrackID(subrackID);
        fiberEnd.setSubrackName("");
        return fiberEnd;
    }
}

