/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEResourceUtil;

public class TESet2MProperty
extends TENEExplorerBean {
    private Datainterface newinput = null;
    private int clockslotno = 0;
    private Datainterface oldinput = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        TEResourceUtil resourceUtil = TEClockUtility.getResourceUtil(this.neid);
        String des = "";
        RowParams[] rowParamsArr = this.oldinput.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            Param para = rowParamsArr[i].getParam("outclockmode");
            int mode = new Integer(para.getValue());
            des = des + rowParamsArr[i].getParam("clockname").getValue() + ":" + resourceUtil.getString("outclockmode") + ":" + resourceUtil.getString("outclockmode" + mode) + ",";
            if (mode == 0 && rowParamsArr[i].getParam("s1slot") != null) {
                String outclocks = rowParamsArr[i].getParam("s1slot").getValue();
                des = des + resourceUtil.getString("outclocks") + ":" + resourceUtil.getString("outclocks" + outclocks) + ",";
            }
            para = rowParamsArr[i].getParam("s1quality");
            des = des + resourceUtil.getString("2moutquality") + ":" + resourceUtil.getString("s1limit" + para.getValue()) + ",";
            para = rowParamsArr[i].getParam("lapseflag");
            des = des + resourceUtil.getString("loscondition") + ":" + resourceUtil.getString("lapseflag" + para.getValue()) + ",";
            para = rowParamsArr[i].getParam("losaction");
            des = des + resourceUtil.getString("losaction") + ":" + resourceUtil.getString("losaction" + para.getValue());
        }
        return des;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.oldinput = inputData;
        this.newinput = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        this.newinput.setBussinessParams(businessParam);
        this.clockslotno = this.getClockSlot(inputData);
        this.handleExtOutMode(inputData);
        this.handelS1Slot(inputData);
        this.handelS1Limit(inputData);
        this.handelLosAction(inputData);
        this.handelLAPSE(inputData);
        return super.performBussinessProcess(neid, subFunc, this.newinput, memeryData, user, ipAddress);
    }

    private void handelLAPSE(Datainterface inputData) {
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            int flag1 = 0;
            int flag2 = 0;
            Param para = rowParamsArr[i].getParam("lapseflag");
            int lapseflag = new Integer(para.getValue());
            if (lapseflag == 1) {
                flag1 = 1;
            } else if (lapseflag == 2) {
                flag2 = 1;
            } else if (lapseflag == 3) {
                flag1 = 1;
                flag2 = 1;
            }
            RowParams rowpara = new RowParams();
            rowpara.addParam("clockslotno", this.clockslotno + "");
            rowpara.addParam("clockid", rowParamsArr[i].getParam("clockid").getValue());
            rowpara.addParam("lapseid", "1");
            rowpara.addParam("flag", flag1 + "");
            this.newinput.getBussinessParams().addRowParams(rowpara);
            rowpara = new RowParams();
            rowpara.addParam("clockslotno", this.clockslotno + "");
            rowpara.addParam("clockid", rowParamsArr[i].getParam("clockid").getValue());
            rowpara.addParam("lapseid", "2");
            rowpara.addParam("flag", flag2 + "");
            this.newinput.getBussinessParams().addRowParams(rowpara);
        }
    }

    private void handelLosAction(Datainterface inputData) {
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            RowParams rowpara = new RowParams();
            rowpara.addParam("clockslotno", this.clockslotno + "");
            rowpara.addParam("outclockno", rowParamsArr[i].getParam("outclockno").getValue());
            Param para = rowParamsArr[i].getParam("losaction");
            rowpara.addParam("losaction", para.getValue());
            this.newinput.getBussinessParams().addRowParams(rowpara);
        }
    }

    private void handelS1Limit(Datainterface inputData) {
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            RowParams rowpara = new RowParams();
            rowpara.addParam("clockslotno", this.clockslotno + "");
            rowpara.addParam("clockid", rowParamsArr[i].getParam("clockid").getValue());
            Param para = rowParamsArr[i].getParam("s1quality");
            rowpara.addParam("s1quality", para.getValue());
            this.newinput.getBussinessParams().addRowParams(rowpara);
        }
    }

    private void handleExtOutMode(Datainterface inputData) {
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        RowParams rowpara = new RowParams();
        rowpara.addParam("clockslotno", this.clockslotno + "");
        rowpara.addParam("outclockmode1", "0");
        rowpara.addParam("outclockmode2", "0");
        for (int i = 0; i < len; ++i) {
            Param para = rowParamsArr[i].getParam("outclockmode");
            int clockid = Integer.parseInt(rowParamsArr[i].getParam("clockid").getValue());
            if (clockid == 61441 || clockid == 0xF00001) {
                rowpara.getParam("outclockmode1").setValue(para.getValue());
                continue;
            }
            rowpara.getParam("outclockmode2").setValue(para.getValue());
        }
        this.newinput.getBussinessParams().addRowParams(rowpara);
    }

    private void handelS1Slot(Datainterface inputData) {
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            RowParams rowpara = new RowParams();
            rowpara.addParam("clockslotno", this.clockslotno + "");
            rowpara.addParam("clockid", rowParamsArr[i].getParam("clockid").getValue());
            Param para = rowParamsArr[i].getParam("s1slot");
            if (para == null) continue;
            rowpara.addParam("s1slot", para.getValue());
            this.newinput.getBussinessParams().addRowParams(rowpara);
        }
    }

    private int getClockSlot(Datainterface inputData) {
        RowParams[] rowparas = inputData.getBussinessParams().getRowParams();
        Param para = rowparas[0].getParam("clockslotno");
        return new Integer(para.getValue());
    }
}

