/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Vector;

public class TEQueryClockSwitchConBean
extends TENEExplorerBean {
    private Datainterface newinput = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.newinput = new Datainterface();
        BussinessParams businessP = new BussinessParams();
        this.newinput.setBussinessParams(businessP);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getClonedBoardList();
        int slotId = 0;
        TEBoard boad = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            boad = (TEBoard)boardList.get(i);
            slotId = boad.getSlotID();
            if (cfgDataMgr.isIFboard(boad.getBoardType())) {
                this.handleIFBoard(boad);
                continue;
            }
            if (!cfgDataMgr.isSDHLineBoard(neid, slotId) || cfgDataMgr.isEthBoard(neid, slotId)) continue;
            this.handleInputData(boad);
        }
        if (this.newinput.getBussinessParams().getRowParamsCount() <= 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        this.operationList = this.getOperation(neid, subFunc, this.newinput, memeryData);
        int resultCode = this.sendMessage(neid);
        if (resultCode == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultCode));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void handleInputData(TEBoard board) {
        RowParams rtnRowParas = new RowParams();
        rtnRowParas.addParam("slotno", board.getSlotID() + "");
        rtnRowParas.addParam("partno", "0");
        rtnRowParas.addParam("alarmid", "33");
        this.newinput.getBussinessParams().addRowParams(rtnRowParas);
        rtnRowParas = new RowParams();
        rtnRowParas.addParam("slotno", board.getSlotID() + "");
        rtnRowParas.addParam("partno", "0");
        rtnRowParas.addParam("alarmid", "35");
        this.newinput.getBussinessParams().addRowParams(rtnRowParas);
    }

    private void handleIFBoard(TEBoard board) {
        ArrayList<Object> operationLists = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_IFMODE_CLOCK");
        Input input = oper.getInput();
        for (Part part : input.getPart()) {
            if (part.getName().equals("slotid")) {
                part.setValue(new Integer(board.getSlotID()).toString());
            }
            if (!part.getName().equals("portno")) continue;
            part.setValue("1");
        }
        operationLists.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationLists, this.TIME_OUT);
        if (result.retCode != 0) {
            return;
        }
        int size = operationLists.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationLists.get(i);
            for (Output opt : operation.getOutput()) {
                int retCode = new Integer(opt.getFault()[0].getCode());
                if (retCode != 0) {
                    TELogFactory.getNormalLogger().info("handleIFBoard " + this.neid + "failed");
                    return;
                }
                String value = opt.getPartValue("workmode");
                int workmode = new Integer(value);
                if (workmode != 7) continue;
                this.handleInputData(board);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int retCode = this.handleAISPara(neid, operationList);
        if (retCode == 1090646019) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
        if (retCode != 0) {
            return;
        }
        retCode = this.addB2EXCPara(operationList);
        if (retCode == 1090646019) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
        if (retCode != 0) {
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private int addB2EXCPara(ArrayList operationList) {
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operat = (Operation)operationList.get(i);
            Output[] outputArr = operat.getOutput();
            if (outputArr.length == 0) {
                return 1090646019;
            }
            for (int j = 0; j < outputArr.length; ++j) {
                Output opt = outputArr[j];
                int retCode = new Integer(opt.getFault()[0].getCode());
                if (retCode == 40004 || retCode == 41681) continue;
                if (retCode != 0) {
                    this.setErrorDate(retCode);
                    return retCode;
                }
                String value = opt.getPartValue("alarmid");
                int alarmid = new Integer(value);
                if (alarmid == 33) continue;
                value = opt.getPartValue("slotno");
                int slotno = new Integer(value);
                value = opt.getPartValue("partno");
                int partno = new Integer(value);
                RowParams rtnRowParams = this.getRowParams(slotno, partno);
                value = opt.getPartValue("isswitch");
                if (rtnRowParams == null) continue;
                rtnRowParams.addParam("b2eswitch", value);
            }
        }
        return 0;
    }

    private RowParams getRowParams(int slotno, int partno) {
        RowParams[] rowParas = this.outputData.getBussinessParams().getRowParams();
        int len = rowParas.length;
        for (int i = 0; i < len; ++i) {
            Param parm = rowParas[i].getParam("slotno");
            int otherslot = new Integer(parm.getValue());
            parm = rowParas[i].getParam("partno");
            int otherpart = new Integer(parm.getValue());
            if (slotno != otherslot || partno != otherpart) continue;
            return rowParas[i];
        }
        return null;
    }

    private int handleAISPara(int neid, ArrayList operationList) {
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)operationList.get(i);
            Output[] outputArrs = operation.getOutput();
            if (outputArrs.length == 0) {
                return 1090646019;
            }
            for (int j = 0; j < outputArrs.length; ++j) {
                Output output = outputArrs[j];
                int retCode = new Integer(output.getFault()[0].getCode());
                if (retCode == 40004 || retCode == 41681) continue;
                if (retCode != 0) {
                    this.setErrorDate(retCode);
                    return retCode;
                }
                RowParams rtnRowParas = new RowParams();
                String value = output.getPartValue("alarmid");
                int alarmid = new Integer(value);
                if (alarmid == 35) continue;
                rtnRowParas.addParam("nename", nename);
                value = output.getPartValue("slotno");
                int slotno = new Integer(value);
                rtnRowParas.addParam("slotno", value);
                value = output.getPartValue("partno");
                int partno = new Integer(value);
                rtnRowParas.addParam("partno", value);
                rtnRowParas.addParam("clockname", this.getClockName(slotno, partno));
                value = output.getPartValue("isswitch");
                rtnRowParas.addParam("aisswitch", value);
                rtnRowParas.addParam("b1switch", "-");
                rtnRowParas.addParam("rlosswitch", "1");
                rtnRowParas.addParam("cvswitch", "-");
                rtnRowParas.addParam("cvlimit", "-");
                this.outputData.getBussinessParams().addRowParams(rtnRowParas);
            }
        }
        return 0;
    }

    private String getClockName(int slotno, int partno) {
        int clkID = (slotno << 8) + partno;
        return TEClockUtility.getClockSourceName(this.neid, clkID);
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }
}

