/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryClockQuality
extends TENEExplorerBean {
    private int[] SystemClockid = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        int retcode = this.getClockSlot(neid, inputData);
        this.outputData = new Datainterface();
        if (retcode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)retcode));
            return this.outputData;
        }
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int getClockSlot(int neid, Datainterface inputData) {
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param paraa = rowpara.getParam("clockslotno");
        int slotno = Integer.parseInt(paraa.getValue());
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_SYN_CLASS");
        Input input = oper.getInput();
        for (Part part : input.getPart()) {
            if (!part.getName().equals("clockslotno")) continue;
            part.setValue(paraa.getValue());
        }
        operationList.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 10);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        int[] clockid = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockid = new int[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    clockid[i] = Integer.parseInt(value.substring(index, index + 4), 16);
                    index += 4;
                }
            }
        }
        this.SystemClockid = clockid;
        for (int i = 0; i < clockid.length; ++i) {
            RowParams rowparam = new RowParams();
            Param para = new Param();
            para.setName("clockslotno");
            para.setValue(slotno + "");
            para.setModifyFlag(false);
            rowparam.addParam(para);
            rowparam.addParam("clockid", (int)clockid[i] + "");
            inputData.getBussinessParams().addRowParams(rowparam);
        }
        return 0;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 0 && this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            this.handleData(this.outputData);
        }
    }

    private void handleData(Datainterface outputData) {
        RowParams[] rowdatas = outputData.getBussinessParams().getRowParams();
        for (int i = rowdatas.length - 1; i >= 0; --i) {
            Param para = rowdatas[i].getParam("clockid");
            int clockid = Integer.parseInt(para.getValue());
            boolean flag = true;
            for (int j = 0; j < this.SystemClockid.length; ++j) {
                if (this.SystemClockid[j] != clockid) continue;
                flag = false;
                break;
            }
            if (flag) {
                outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            rowdatas[i].addParam("clockname", TEClockUtility.getClockSourceName(this.neid, clockid));
            para = rowdatas[i].getParam("configquality");
            int t = 0;
            if (para.getValue().equals("")) {
                para.setValue("0");
            } else {
                int configquality = Integer.parseInt(para.getValue());
                t = configquality;
                if (t != 0 && t != 2 && t != 4 && t != 8 && t != 11 && t != 15 && t != 255) {
                    para.setValue("0");
                }
            }
            para = rowdatas[i].getParam("clockquality");
            if ("".equals(para.getValue())) {
                para.setValue("16");
                continue;
            }
            t = Integer.parseInt(para.getValue());
            if ((t &= 0xF) != 0 && t != 2 && t != 4 && t != 8 && t != 11 && t != 15) {
                para.setValue("16");
                continue;
            }
            para.setValue(t + "");
        }
    }
}

