/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryClockPriority
extends TENEExplorerBean {
    private int[] clockid;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int retCode = this.handleclockidlist(operationList);
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        retCode = this.handleclockmode(operationList);
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        this.handles1byte(operationList, 1);
        this.handles1byte(operationList, 2);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        try {
            new TEGetOtherFiberEndAdapter(0).appendOtherFiberEndParam(neid, this.clockid, this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
    }

    private int handles1byte(ArrayList operationList, int id) {
        Operation operation = (Operation)operationList.get(id + 1);
        Output[] outputArr = operation.getOutput();
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("s1byte");
            int s1byte = new Integer(value);
            value = output.getPartValue("extclockid");
            int extclockid = new Integer(value);
            this.joinS1Byte(s1byte, extclockid);
        }
        return retCode;
    }

    private void joinS1Byte(int s1byte, int extid) {
        RowParams[] rowpara = this.outputData.getBussinessParams().getRowParams();
        int len = rowpara.length;
        for (int i = 0; i < len; ++i) {
            Param param = rowpara[i].getParam("clockid");
            int clockid = new Integer(param.getValue());
            if (clockid != extid) continue;
            rowpara[i].getParam("s1byte").setValue(s1byte + "");
        }
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }

    private int handleclockmode(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(1);
        Output[] outputArr = operation.getOutput();
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("extclockmode1");
            int mode = new Integer(value);
            this.joinClockMode(mode, 61441);
            value = output.getPartValue("extclockmode2");
            mode = new Integer(value);
            this.joinClockMode(mode, 61442);
        }
        return retCode;
    }

    private void joinClockMode(int clockmode, int extid) {
        RowParams[] rowpara = this.outputData.getBussinessParams().getRowParams();
        int len = rowpara.length;
        for (int i = 0; i < len; ++i) {
            Param param = rowpara[i].getParam("clockid");
            int clockid = new Integer(param.getValue());
            if (clockid != extid) continue;
            rowpara[i].getParam("outclockmode").setValue(clockmode + "");
        }
    }

    private int handleclockidlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        int[] clockid = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockid = new int[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    clockid[i] = Integer.parseInt(value.substring(index, index + 4), 16);
                    index += 4;
                }
            }
        }
        if (clockid == null) {
            clockid = new int[]{};
        }
        this.handleClockiddata(clockid);
        this.clockid = clockid;
        return retCode;
    }

    private void handleClockiddata(int[] clockid) {
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < clockid.length; ++i) {
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("clockid", clockid[i] + "");
            rtnRowParams.addParam("clockname", TEClockUtility.getClockSourceName(this.neid, clockid[i]));
            rtnRowParams.addParam("outclockmode", "0");
            rtnRowParams.addParam("s1byte", "0");
            rtnRowParams.addParam("branchboard", "-");
            rtnRowParams.addParam("number", String.valueOf(i + 1));
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
    }
}

