/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryClockNetBean
extends TENEExplorerBean {
    private Datainterface otheroutputData = null;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.otheroutputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 38662 || faultCode == 0) {
            this.handleData(this.otheroutputData);
            return;
        }
        this.outputData = this.otheroutputData;
    }

    private int handleclockidlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        int[] clockid = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockid = new int[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    clockid[i] = Integer.parseInt(value.substring(index, index + 4), 16);
                    index += 4;
                }
            }
        }
        this.handleClockiddata(clockid);
        return 0;
    }

    private void handleClockiddata(int[] clockid) {
        this.outputData = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < clockid.length; ++i) {
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("clockid", clockid[i] + "");
            rtnRowParams.addParam("clockname", TEClockUtility.getClockSourceName(this.neid, clockid[i]));
            int clocknetid = this.getClockNetNo(clockid[i]);
            rtnRowParams.addParam("clocknetid", clocknetid + "");
            businessParam.addRowParams(rtnRowParams);
        }
        int clocknetno = 0;
        if (this.otheroutputData.getBussinessParams().getRowParamsCount() > 0) {
            RowParams rowpara = this.otheroutputData.getBussinessParams().getRowParams(0);
            Param p = rowpara.getParam("clocknetno");
            clocknetno = Integer.parseInt(p.getValue());
        }
        int len = businessParam.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams rowpara = businessParam.getRowParams(i);
            rowpara.addParam("clocknetno", clocknetno + "");
        }
        this.outputData.setBussinessParams(businessParam);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
    }

    private int getClockNetNo(int clockid) {
        if (this.otheroutputData.getBussinessParams().getRowParamsCount() <= 0) {
            return 0;
        }
        RowParams[] rowparam = this.otheroutputData.getBussinessParams().getRowParams();
        int len = rowparam.length;
        for (int j = 0; j < len; ++j) {
            Param para = rowparam[j].getParam("clockid");
            int clockidvalue = Integer.parseInt(para.getValue());
            if (clockidvalue != clockid) continue;
            Param p = rowparam[j].getParam("clocknetid");
            return Integer.parseInt(p.getValue());
        }
        return 0;
    }

    private void handleData(Datainterface otheroutputData) {
        Param clockpara = this.inputData.getBussinessParams().getRowParams(0).getParam("clockslotno");
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SYN_CLASS");
        Input input = oper.getInput();
        for (Part part : input.getPart()) {
            if (!part.getName().equals("clockslotno")) continue;
            part.setValue(clockpara.getValue());
        }
        operationList.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 10);
        if (result.retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result.retCode));
            return;
        }
        int retCode = this.handleclockidlist(operationList);
        if (retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
            return;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(38662));
        return list;
    }
}

