/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.nemgr.sdh.clock.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;

public class TEQueryClockIDEnable
extends TENEExplorerBean {
    private TIntArrayList clockidList = new TIntArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int retCode = this.handleclockidlist(operationList);
        if (retCode == 1090646019) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        retCode = this.handleclockidenable(operationList);
        if (retCode == 1090646019) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        try {
            new TEGetOtherFiberEndAdapter(0).appendOtherFiberEndParam(neid, this.clockidList.toNativeArray(), this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get figer fail!", (Throwable)e);
        }
    }

    private int handleclockidenable(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(1);
        Output[] outputArr = operation.getOutput();
        if (outputArr.length == 0) {
            return 1090646019;
        }
        int[] clockid = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0 && retCode != 38662) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (value == null || value.equals("")) continue;
                if (name.equalsIgnoreCase("clocknum")) {
                    clocknum = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata")) continue;
                clockid = new int[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    clockid[i] = Integer.parseInt(value.substring(index, index + 4), 16);
                    index += 4;
                }
            }
        }
        if (clockid == null) {
            clockid = new int[]{0};
        }
        this.setClockidEnable(clockid);
        return 0;
    }

    private void setClockidEnable(int[] clockid) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        int len = rowparas.length;
        for (int i = 0; i < len; ++i) {
            Param para = rowparas[i].getParam("clockid");
            int id = new Integer(para.getValue());
            for (int j = 0; j < clockid.length; ++j) {
                if (id != clockid[j]) continue;
                rowparas[i].getParam("clockidenable").setValue("0");
            }
        }
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }

    private int handleclockidlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        int[] clockid = new int[outputArr.length];
        if (outputArr.length == 0) {
            return 1090646019;
        }
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                int id;
                String name = part.getName();
                String value = part.getValue();
                if (!name.equalsIgnoreCase("clockid") || value == null || (id = new Integer(value).intValue()) == 61441 || id == 61442) continue;
                clockid[j] = id;
                this.clockidList.add(id);
            }
        }
        this.handleClockiddata(clockid);
        return 0;
    }

    private void handleClockiddata(int[] clockid) {
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < clockid.length; ++i) {
            if (clockid[i] == 0) continue;
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("clockid", clockid[i] + "");
            rtnRowParams.addParam("clockname", TEClockUtility.getClockSourceName(this.neid, clockid[i]));
            rtnRowParams.addParam("clockidenable", "1");
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
    }
}

