/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Vector;

public class TEQuery2MProperty
extends TENEExplorerBean {
    private static int NSERR_CFG_BAD_SYN_SOURCE = 38709;
    private Datainterface newinput = null;
    private int outclocknum = 0;
    private int clockslotno = 0;
    private boolean isSmallSlot = true;
    private int extclockmode1 = 61441;
    private int extclockmode2 = 61442;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.newinput = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        this.newinput.setBussinessParams(businessParam);
        this.outputData = new Datainterface();
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getClonedBoardList();
        int boardType = 0;
        TEBoard board = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardList.get(i);
            if (!cfgDataMgr.isCPHaveFB(board.getBoardType(), 29)) continue;
            boardType = board.getBoardType();
            ++this.outclocknum;
        }
        if (this.outclocknum <= 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        this.clockslotno = this.getClockSlot(inputData);
        this.isSmallSlot = TEClockUtility.isSmallSlot(ne, boardType, this.clockslotno);
        this.handleInputData();
        this.operationList = this.getOperation(neid, subFunc, this.newinput, memeryData);
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int getClockSlot(Datainterface inputData) {
        RowParams[] rowparas = inputData.getBussinessParams().getRowParams();
        Param para = rowparas[0].getParam("clockslotno");
        return new Integer(para.getValue());
    }

    private int[] getOutClockID() {
        int[] outclockid = null;
        if (TESpecialAttrMgr.getInstance().isNENotSupport(this.neid, "TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME", "CLOCKPRI_SUPPORT_SECONDCLOCKSOURCE")) {
            outclockid = new int[1];
            outclockid[0] = !this.isSmallSlot ? this.extclockmode2 : this.extclockmode1;
        } else {
            outclockid = new int[2];
            if (!this.isSmallSlot) {
                outclockid[0] = this.extclockmode2;
                outclockid[1] = this.extclockmode1;
            } else {
                outclockid[0] = this.extclockmode1;
                outclockid[1] = this.extclockmode2;
            }
        }
        return outclockid;
    }

    private void handleInputData() {
        int i;
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)this.subfunc.getQxMapping(0).getContent());
        if (null != operation && operation.getInput().getPart("clockslotno").getLength() == 2) {
            this.extclockmode1 = 0xF00001;
            this.extclockmode2 = 0xF00002;
        }
        int[] outclockid = this.getOutClockID();
        RowParams rtnRowParams = new RowParams();
        rtnRowParams.addParam("clockslotno", this.clockslotno + "");
        this.newinput.getBussinessParams().addRowParams(rtnRowParams);
        Param para = null;
        for (i = 0; i < outclockid.length; ++i) {
            rtnRowParams = new RowParams();
            para = new Param();
            para.setName("clockslotno");
            para.setValue(this.clockslotno + "");
            para.setModifyFlag(false);
            rtnRowParams.addParam(para);
            rtnRowParams.addParam("clockid", outclockid[i] + "");
            this.newinput.getBussinessParams().addRowParams(rtnRowParams);
            rtnRowParams = new RowParams();
            para = new Param();
            para.setName("clockslotno");
            para.setValue(this.clockslotno + "");
            para.setModifyFlag(false);
            rtnRowParams.addParam(para);
            rtnRowParams.addParam("outclockno", String.valueOf(i + 1));
            this.newinput.getBussinessParams().addRowParams(rtnRowParams);
        }
        for (i = 0; i < outclockid.length; ++i) {
            rtnRowParams = new RowParams();
            para = new Param();
            para.setName("clockslotno");
            para.setValue(this.clockslotno + "");
            para.setModifyFlag(false);
            rtnRowParams.addParam(para);
            para = new Param();
            para.setName("clockid");
            para.setValue(outclockid[i] + "");
            para.setModifyFlag(false);
            rtnRowParams.addParam(para);
            rtnRowParams.addParam("lapseid", "1");
            this.newinput.getBussinessParams().addRowParams(rtnRowParams);
            rtnRowParams = new RowParams();
            para = new Param();
            para.setName("clockslotno");
            para.setValue(this.clockslotno + "");
            para.setModifyFlag(false);
            rtnRowParams.addParam(para);
            para = new Param();
            para.setName("clockid");
            para.setValue(outclockid[i] + "");
            para.setModifyFlag(false);
            rtnRowParams.addParam(para);
            rtnRowParams.addParam("lapseid", "2");
            this.newinput.getBussinessParams().addRowParams(rtnRowParams);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        BussinessParams businessParam = new BussinessParams();
        int[] outclockid = new int[]{this.extclockmode1, this.extclockmode2};
        int clockNumber = 2;
        if (TESpecialAttrMgr.getInstance().isNENotSupport(neid, "TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME", "CLOCKPRI_SUPPORT_SECONDCLOCKSOURCE")) {
            clockNumber = 1;
        }
        for (int i = 0; i < clockNumber; ++i) {
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("outclockname", i + 1 + "");
            rtnRowParams.addParam("clockid", outclockid[i] + "");
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
        int retcode = 0;
        String name = null;
        Operation operation = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            name = operation.getName();
            if (name.equalsIgnoreCase("NSCMD_CFG_GET_EXTOUT_MODE")) {
                retcode = this.handleExtOutMode(operation, clockNumber);
            } else if (name.equalsIgnoreCase("NSCMD_CFG_GET_EXTIN_S1INPSLOT")) {
                retcode = this.handelS1Slot(operation, clockNumber);
            } else if (name.equalsIgnoreCase("NSCMD_CFG_GET_EXTOUT_TH_EX")) {
                retcode = this.handelS1Limit(operation, clockNumber);
            } else if (name.equalsIgnoreCase("NSCMD_CFG_GET_2MPLL_SYNLOS_ACTION_EX")) {
                retcode = this.handelLosAction(operation, clockNumber);
            } else if (name.equalsIgnoreCase("NSCMD_CFG_GET_EXT_LAPSE_TERM")) {
                retcode = this.handelLAPSE(operation, clockNumber);
            }
            if (retcode == 0) continue;
            this.setErrorDate(retcode);
            return;
        }
        this.joinLAPSE();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private void joinLAPSE() {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        for (int i = rowparas.length - 1; i >= 0; --i) {
            Param p1 = rowparas[i].getParam("aisflag");
            if (p1 == null) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            int ais = new Integer(p1.getValue());
            p1 = rowparas[i].getParam("lofflag");
            int lof = new Integer(p1.getValue());
            int addvalue = 0;
            if (ais == 1) {
                ++addvalue;
            }
            if (lof == 1) {
                addvalue += 2;
            }
            rowparas[i].addParam("lapseflag", addvalue + "");
        }
    }

    private int handelLAPSE(Operation operation, int clockNumber) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0 && !this.isFilterErrorCode(retCode)) {
                return retCode;
            }
            if (retCode != 0) continue;
            String value = output.getPartValue("clockid");
            int id = new Integer(value);
            value = output.getPartValue("lapseid");
            int lapseid = new Integer(value);
            value = output.getPartValue("flag");
            int flag = new Integer(value);
            if (id == this.extclockmode1) {
                if (lapseid == 1) {
                    rowparas[0].addParam("aisflag", flag + "");
                    continue;
                }
                rowparas[0].addParam("lofflag", flag + "");
                continue;
            }
            if (clockNumber <= 1) continue;
            if (lapseid == 1) {
                rowparas[1].addParam("aisflag", flag + "");
                continue;
            }
            rowparas[1].addParam("lofflag", flag + "");
        }
        return 0;
    }

    private int handelLosAction(Operation operation, int clockNumber) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        block4: for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0 && !this.isFilterErrorCode(retCode)) {
                return retCode;
            }
            if (retCode != 0) continue;
            String action = output.getPartValue("losaction");
            int outclockno = Integer.valueOf(output.getPartValue("outclockno"));
            switch (outclockno) {
                case 1: {
                    rowparas[0].addParam("outclockno", outclockno + "");
                    rowparas[0].addParam("losaction", action);
                    continue block4;
                }
                case 2: {
                    if (clockNumber <= 1) continue block4;
                    rowparas[1].addParam("outclockno", outclockno + "");
                    rowparas[1].addParam("losaction", action);
                    continue block4;
                }
                default: {
                    rowparas[0].addParam("outclockno", outclockno + "");
                    rowparas[0].addParam("losaction", action);
                    if (clockNumber <= 1) continue block4;
                    rowparas[1].addParam("outclockno", outclockno + "");
                    rowparas[1].addParam("losaction", action);
                }
            }
        }
        return 0;
    }

    private int handelS1Limit(Operation operation, int clockNumber) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0 && !this.isFilterErrorCode(retCode)) {
                return retCode;
            }
            if (retCode != 0) continue;
            String value = output.getPartValue("clockid");
            int id = new Integer(value);
            value = output.getPartValue("s1quality");
            int s1 = new Integer(value);
            if (id == this.extclockmode1) {
                rowparas[0].addParam("s1quality", s1 + "");
                continue;
            }
            if (clockNumber <= 1) continue;
            rowparas[1].addParam("s1quality", s1 + "");
        }
        return 0;
    }

    private int handelS1Slot(Operation operation, int clockNumber) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = Integer.parseInt(output.getFault()[0].getCode());
            if (retCode != 0 && !this.isFilterErrorCode(retCode)) {
                return retCode;
            }
            if (retCode != 0) continue;
            String value = output.getPartValue("clockid");
            int id = Integer.parseInt(value);
            value = output.getPartValue("s1slot");
            int s1 = Integer.parseInt(value);
            if (id == this.extclockmode1) {
                rowparas[0].addParam("s1slot", s1 + "");
                continue;
            }
            if (clockNumber <= 1) continue;
            rowparas[1].addParam("s1slot", s1 + "");
        }
        return 0;
    }

    private int handleExtOutMode(Operation operation, int clockNumber) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0 && !this.isFilterErrorCode(retCode)) {
                return retCode;
            }
            if (retCode != 0) continue;
            String value = output.getPartValue("outclockmode1");
            int mode = new Integer(value);
            rowparas[0].addParam("outclockmode", mode + "");
            if (clockNumber <= 1) continue;
            value = output.getPartValue("outclockmode2");
            mode = new Integer(value);
            rowparas[1].addParam("outclockmode", mode + "");
        }
        return 0;
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }

    private boolean isFilterErrorCode(int errcode) {
        boolean isFilter = false;
        if (errcode == 38722 || errcode == NSERR_CFG_BAD_SYN_SOURCE) {
            isFilter = true;
        }
        return isFilter;
    }
}

