/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.clock;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.bscfg.installcp.TECPOccupySlot;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.clock.TEClockConstant;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TEClockUtility {
    private static final int IFH2_CLOCL_IF = 1;
    private static final int IFH2_CLOCL_ETH = 2;
    private static final int BDTYPE_SL61EGS4 = 2423;
    private static final int TIME_OUT = 10;
    private static final int INVALID_VALUE = 65535;

    private TEClockUtility() {
    }

    public static TEResourceUtil getResourceUtil(int neid) {
        return TEGetFilePath.getResource((int)neid, (String)TEClockConstant.RES_PATH);
    }

    private static void addclockid(int neid, TEBoard board, ArrayList clockidlist) {
        TEConfigurationDataMgr cfgDataMgr;
        int boardType;
        int slotid = board.getSlotID();
        ArrayList portnolist = TEQueryLogicPort.getLogicPortList((int)neid, (int)slotid, (int)(boardType = board.getBoardType()));
        int len = portnolist.size();
        if (len > 2 && boardType != 2423) {
            len = 2;
        }
        if ((cfgDataMgr = TEConfigurationDataMgr.getInstance()).isIFboard(boardType)) {
            len = 1;
            if (boardType == 1548) {
                len = 2;
                portnolist.add(2);
            }
        }
        for (int i = 0; i < len; ++i) {
            int portid = (Integer)portnolist.get(i);
            if (cfgDataMgr.isBranchBoard(neid, slotid) && boardType != 1176 && boardType != 1177 && cfgDataMgr.getPortIterfaceLevel(neid, boardType, portid) != 4097 || boardType == 2423 && cfgDataMgr.getPortType(neid, boardType, portid) == 61005) continue;
            int clockid = (slotid << 8) + portid;
            clockidlist.add(clockid);
        }
    }

    public static ArrayList getClocklist(int neid) {
        ArrayList<Integer> clockidlist = new ArrayList<Integer>();
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getClonedBoardList();
        TEBoard board = null;
        int slotId = 0;
        int boardType = 0;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardList.get(i);
            boardType = board.getBoardType();
            slotId = board.getSlotID();
            if (cfgDataMgr.isCPHaveFB(boardType, 29)) {
                if (TEClockUtility.isSmallSlot(ne, boardType, slotId)) {
                    clockidlist.add(61441);
                    continue;
                }
                clockidlist.add(61442);
                continue;
            }
            if (board.getBoardType() != 2423 && board.getBoardType() != 2455 && !cfgDataMgr.isIFboard(boardType) && (!cfgDataMgr.isSDHLineBoard(neid, slotId) || cfgDataMgr.isEthBoard(neid, slotId)) && !cfgDataMgr.isBranchBoard(neid, slotId)) continue;
            TEClockUtility.addclockid(neid, board, clockidlist);
        }
        Collections.sort(clockidlist);
        return clockidlist;
    }

    public static String getClockSourceName(int neid, int clockid) {
        int slotid = clockid >> 8 & 0xFF;
        int portid = clockid & 0xFF;
        String clockname = null;
        TEResourceUtil res = TEClockUtility.getResourceUtil(neid);
        if (slotid <= 0 || portid <= 0) {
            clockname = res.getString("noinfo");
            return clockname;
        }
        if (clockid == 61441) {
            clockname = res.getString("extclock1");
            return clockname;
        }
        if (clockid == 61442) {
            clockname = res.getString("extclock2");
            return clockname;
        }
        if (clockid == 61697) {
            clockname = res.getString("innerclcok");
            return clockname;
        }
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TEBoard board = cfgDataMgr.getBoard(neid, slotid);
        if (board == null) {
            clockname = res.getString("noinfo");
            return clockname;
        }
        int boardtype = board.getBoardType();
        String portname = null;
        if (cfgDataMgr.isBranchBoard(neid, slotid) && portid == 2) {
            portid = 5;
        }
        portname = cfgDataMgr.getPortName(neid, slotid, boardtype, portid);
        if (boardtype == 1548 || boardtype == 1219 || boardtype == 2096) {
            if (portid == 2) {
                portname = "2(ETH)";
            } else if (portid == 1) {
                portname = "1(IF)";
            }
        }
        String boardname = cfgDataMgr.getBoardTypeName(neid, boardtype);
        StringBuffer name = new StringBuffer();
        name.append(slotid).append('-').append(boardname).append('-').append(portname);
        return name.toString();
    }

    public static String getClockSourceNameEx(int neid, int clockid) {
        int slotid = clockid >> 24 & 0xFF;
        int portid = clockid & 0xFFFF;
        int subboardid = clockid >> 16 & 0xFF;
        StringBuffer name = new StringBuffer();
        String clockname = null;
        TEResourceUtil res = TEGetFilePath.getResource((int)neid, (String)TEClockConstant.RES_PATH);
        if (clockid == 0xF00001) {
            clockname = res.getString("extclock1");
            return clockname;
        }
        if (clockid == 0xF00002) {
            clockname = res.getString("extclock2");
            return clockname;
        }
        if (clockid == 65537) {
            clockname = res.getString("adapttopclock");
            return clockname;
        }
        if (clockid == 65538) {
            clockname = res.getString("difftopclock1");
            return clockname;
        }
        if (clockid == 65539) {
            clockname = res.getString("difftopclock2");
            return clockname;
        }
        if (clockid == 0xF10001) {
            clockname = res.getString("innerclcok");
            return clockname;
        }
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        if (slotid == 0 && subboardid == 2) {
            slotid = clockid >> 8 & 0xFF;
            int acrid = clockid & 0xFF;
            TEBoard board = cfgDataMgr.getBoard(neid, slotid);
            if (board == null) {
                clockname = res.getString("noinfo");
                return clockname;
            }
            int boardtype = board.getBoardType();
            String boardname = cfgDataMgr.getBoardTypeName(neid, boardtype);
            name.append(slotid).append('-').append(boardname).append("-ACR").append(acrid);
            return name.toString();
        }
        if (slotid <= 0 || portid <= 0) {
            clockname = res.getString("noinfo");
            return clockname;
        }
        TEBoard board = cfgDataMgr.getBoard(neid, slotid);
        if (board == null) {
            clockname = res.getString("noinfo");
            return clockname;
        }
        int boardtype = board.getBoardType();
        String boardname = cfgDataMgr.getBoardTypeName(neid, boardtype);
        if (subboardid != 255) {
            int subboardtype = cfgDataMgr.getSubboardType(neid, slotid, subboardid);
            String subboardname = cfgDataMgr.getBoardTypeName(neid, subboardtype);
            String portname = cfgDataMgr.getPortNameForNARTN(neid, slotid, subboardtype, portid);
            name.append(slotid).append('-').append(boardname).append('-').append(subboardid).append('-').append(subboardname).append('-').append(portname);
        } else {
            String portname = "";
            TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neid);
            portname = cfgDataMgr.isIFboard(boardtype) && cfgDataMgr.isPTNDevice(ne) ? cfgDataMgr.getPortNameByPortType(neid, slotid, boardtype, portid, 1802) : cfgDataMgr.getPortNameForNARTN(neid, slotid, boardtype, portid);
            if (boardtype == 2084 || boardtype == 1353 || boardtype == 2099 || boardtype == 2273 || boardtype == 2274 || boardtype == 2269) {
                int netype;
                if (portid == 2 && 95 != (netype = cfgDataMgr.getNE(neid).getNEType())) {
                    portid = 5;
                }
                portname = boardtype == 2084 || boardtype == 1353 || boardtype == 2099 ? portid + "(SDH_TU-" + portid + ")" : cfgDataMgr.getPortName(neid, slotid, boardtype, portid);
            }
            name.append(slotid).append('-').append(boardname).append('-').append(portname);
        }
        return name.toString();
    }

    public static String getClockSourceNameExForPTN(int neid, int ptnclockid) {
        int slotid = ptnclockid >> 24 & 0xFF;
        int portid = ptnclockid & 0xFFFF;
        int subboardid = ptnclockid >> 16 & 0xFF;
        StringBuffer ptnname = new StringBuffer();
        String ptnclockname = null;
        TEResourceUtil res = TEGetFilePath.getResource((int)neid, (String)TEClockConstant.RES_PATH);
        if (ptnclockid == 0xF00001) {
            ptnclockname = res.getString("extclock1");
            return ptnclockname;
        }
        if (ptnclockid == 0xF00002) {
            ptnclockname = res.getString("extclock2");
            return ptnclockname;
        }
        if (ptnclockid == 65537) {
            ptnclockname = res.getString("adapttopclock");
            return ptnclockname;
        }
        if (ptnclockid == 65538) {
            ptnclockname = res.getString("difftopclock1");
            return ptnclockname;
        }
        if (ptnclockid == 65539) {
            ptnclockname = res.getString("difftopclock2");
            return ptnclockname;
        }
        if (ptnclockid == 0xF10001) {
            ptnclockname = res.getString("innerclcok");
            return ptnclockname;
        }
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        if (slotid == 0 && subboardid == 2) {
            slotid = ptnclockid >> 8 & 0xFF;
            int acrid = ptnclockid & 0xFF;
            TEBoard board = cfgDataMgr.getBoard(neid, slotid);
            if (board == null) {
                ptnclockname = res.getString("noinfo");
                return ptnclockname;
            }
            int boardtype = board.getBoardType();
            String boardname = cfgDataMgr.getBoardTypeName(neid, boardtype);
            ptnname.append(slotid).append('-').append(boardname).append("-ACR").append(acrid);
            return ptnname.toString();
        }
        if (slotid <= 0 || portid <= 0) {
            ptnclockname = res.getString("noinfo");
            return ptnclockname;
        }
        TEBoard board = cfgDataMgr.getBoard(neid, slotid);
        if (board == null) {
            ptnclockname = res.getString("noinfo");
            return ptnclockname;
        }
        int boardtype = board.getBoardType();
        String boardname = cfgDataMgr.getBoardTypeName(neid, boardtype);
        if (subboardid != 255) {
            int subboardtype = cfgDataMgr.getSubboardType(neid, slotid, subboardid);
            String subboardname = cfgDataMgr.getBoardTypeName(neid, subboardtype);
            String portname = cfgDataMgr.getPortName(neid, slotid, subboardtype, portid);
            ptnname.append(slotid).append('-').append(boardname).append('-').append(subboardid).append('-').append(subboardname).append('-').append(portname);
        } else {
            String portname = "";
            TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neid);
            portname = cfgDataMgr.isIFboard(boardtype) && cfgDataMgr.isPTNDevice(ne) ? cfgDataMgr.getPortNameByPortType(neid, slotid, boardtype, portid, 1802) : cfgDataMgr.getPortName(neid, slotid, boardtype, portid);
            if (boardtype == 2084 || boardtype == 1353 || boardtype == 2099 || boardtype == 1417 || boardtype == 2273 || boardtype == 2274 || boardtype == 2269) {
                portid = TEClockUtility.convertSPPort(neid, slotid, portid);
                portname = boardtype == 2084 || boardtype == 1353 || boardtype == 2099 ? portid + "(SDH_TU-" + portid + ")" : cfgDataMgr.getPortName(neid, slotid, boardtype, portid);
            }
            if (boardtype == 2469 && (portid == 5 || portid == 6)) {
                if (TESysManagerBean.getInstance().getlanguage().equalsIgnoreCase("zh")) {
                    ptnname.append(slotid).append('-').append(boardname).append('-').append(portid).append(res.getString("clocksourcename"));
                } else {
                    ptnname.append(slotid).append('-').append(boardname).append('-').append(res.getString("clocksourcename")).append(portid);
                }
            } else {
                ptnname.append(slotid).append('-').append(boardname).append('-').append(portname);
            }
        }
        return ptnname.toString();
    }

    public static int convertSPPort(int neID, int slotID, int portID) {
        int netype;
        int retPortID = portID;
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        int boardtype = cfgDataMgr.getBoardType(neID, slotID);
        if ((boardtype == 2084 || boardtype == 1353 || boardtype == 2099 || boardtype == 1417 || boardtype == 2273 || boardtype == 2274 || boardtype == 2269) && portID == 2 && 95 != (netype = cfgDataMgr.getNE(neID).getNEType())) {
            retPortID = 5;
        }
        return retPortID;
    }

    public static List getPortIDList(int neid, int slotid) {
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        ArrayList portIDList = new ArrayList();
        portIDList.addAll(cfgDataMgr.getPortList(neid, slotid, 1802));
        portIDList.addAll(cfgDataMgr.getPortList(neid, slotid, 2817));
        portIDList.addAll(cfgDataMgr.getPortList(neid, slotid, 1798));
        portIDList.addAll(cfgDataMgr.getPortList(neid, slotid, 256));
        List idList = cfgDataMgr.getPortList(neid, slotid, 259);
        if (idList.size() > 2) {
            portIDList.add(idList.get(0));
            portIDList.add(idList.get(1));
        } else {
            portIDList.addAll(idList);
        }
        portIDList.addAll(cfgDataMgr.getPortList(neid, slotid, 1799));
        int boardType = cfgDataMgr.getBoardType(neid, slotid);
        if (2264 == boardType) {
            Iterator iterator = portIDList.iterator();
            TEPort port = null;
            while (iterator.hasNext()) {
                port = (TEPort)iterator.next();
                if (TEClockUtility.isLogiPortExistForRTN(neid, slotid, port.getPortNo())) continue;
                iterator.remove();
            }
        }
        return portIDList;
    }

    public static boolean isLogiPortExistForRTN(int neId, int slotId, int portNo) {
        Operation oper = TECreateObjectFactory.getOperation((int)neId, (String)"NSCMD_CFG_SUBBD_GET_PORT_WBID");
        if (null == oper) {
            return true;
        }
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(String.valueOf(slotId));
        part = input.getPart("port");
        part.setValue(String.valueOf(portNo));
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
        return result == 0 && "0".equals(oper.getOutput()[0].getFault()[0].getCode());
    }

    public static void getUninstalledLogiPortForRTN(int neId, int slotId, List<TEPortProperty> portList) {
        if (null == portList || portList.isEmpty()) {
            return;
        }
        ArrayList<Integer> portNumList = new ArrayList<Integer>(0);
        Iterator<TEPortProperty> iterator = portList.iterator();
        while (iterator.hasNext()) {
            int portid = iterator.next().getPortNo();
            if (!portNumList.contains(portid)) {
                portNumList.add(portid);
                continue;
            }
            iterator.remove();
        }
        portNumList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)neId, (String)"NSCMD_CFG_SUBBD_GET_PORT_WBID");
        if (null == oper) {
            return;
        }
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(String.valueOf(slotId));
        part = input.getPart("port");
        part.setValue("0");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
        if (result == 0) {
            Output[] outs = oper.getOutput();
            if (!"0".equals(outs[0].getFault()[0].getCode())) {
                return;
            }
            ArrayList<String> existPorts = new ArrayList<String>(0);
            for (Output o : outs) {
                existPorts.add(o.getPartValue("port"));
            }
            if (!existPorts.isEmpty()) {
                Iterator<TEPortProperty> it = portList.iterator();
                while (it.hasNext()) {
                    int portNo = it.next().getPortNo();
                    if (!existPorts.contains(String.valueOf(portNo))) continue;
                    it.remove();
                }
            }
        }
    }

    public static boolean isSmallSlot(TENE ne, int boardType, int clockslotno) {
        boolean isSmallSlot = true;
        int eqType = TEGetNEDomainVersion.getInstance().getDevType(ne.getNEType());
        if (ne.getNEType() == 55) {
            return clockslotno == 1;
        }
        ArrayList occupySlotList = new ArrayList();
        TEEquipmentDescription.getInstance().getInstallSlotByCPType(eqType, ne.getShelfType(), boardType, occupySlotList);
        ArrayList<Integer> iList = new ArrayList<Integer>();
        int m = occupySlotList.size();
        for (int i = 0; i < m; ++i) {
            iList.add(((TECPOccupySlot)occupySlotList.get(i)).getM_SlotID());
        }
        Collections.sort(iList);
        if (!iList.isEmpty() && (Integer)iList.get(0) != clockslotno) {
            isSmallSlot = false;
        }
        return isSmallSlot;
    }

    public static boolean isPTPBoard(int boardType) {
        boolean result = false;
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1410);
        list.add(1411);
        list.add(1415);
        list.add(1414);
        list.add(1404);
        list.add(1416);
        list.add(1607);
        list.add(1608);
        list.add(1609);
        list.add(2079);
        list.add(2080);
        list.add(2083);
        list.add(2082);
        list.add(2418);
        list.add(2417);
        list.add(2268);
        list.add(2267);
        list.add(2266);
        list.add(2088);
        list.add(2087);
        list.add(2455);
        list.add(2454);
        list.add(2488);
        list.add(2489);
        list.add(2471);
        list.add(2473);
        list.add(2470);
        list.add(2548);
        list.add(2474);
        list.add(2475);
        list.add(2468);
        list.add(2265);
        list.add(3062);
        list.add(3063);
        result = list.contains(boardType);
        if (TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "BOARD_SUPPORT_PTPCLOCKSYNATTR")) {
            result = true;
        }
        return result;
    }

    public static ArrayList getCustomInternalClockSource(int neId, int slotid, List<String> portList) {
        ArrayList<Integer> resultPortList = new ArrayList<Integer>();
        Operation oper = TECreateObjectFactory.getOperation((int)neId, (String)"NSCMD_CFG_GET_SDHCLK_RNVC12");
        if (null == oper) {
            return resultPortList;
        }
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotid));
            part = input.getPart("clocksource");
            part.setValue(portList.get(i));
            operationList.add((Operation)oper.clone());
        }
        int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
        if (result == 0) {
            int len2 = portList.size();
            for (int i = 0; i < len2; ++i) {
                Operation operation = (Operation)operationList.get(i);
                int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
                if (0 != errorCode) continue;
                String sdhport = operation.getOutput(0).getPartValue("sdhport");
                if (String.valueOf(65535).equals(sdhport)) continue;
                resultPortList.add(Integer.parseInt(operation.getOutput(0).getPartValue("clocksource")));
            }
        }
        return resultPortList;
    }

    public static String getBoradPortName(int neid, int slotid, int subslotid, int portid) {
        StringBuffer boardPortName = new StringBuffer();
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        String portName = "";
        int boardType = configurDataMgr.getBoardType(neid, slotid);
        String boardName = configurDataMgr.getBoardTypeName(neid, boardType);
        if (255 != subslotid) {
            int subboardType = configurDataMgr.getSubboardType(neid, slotid, subslotid);
            String subboardName = configurDataMgr.getBoardTypeName(neid, subboardType);
            portName = configurDataMgr.getPortName(neid, slotid, boardType, portid);
            boardPortName.append(slotid).append("-").append(boardName).append("-").append(subslotid).append("-").append(subboardName).append("-").append(portName).append(" ");
        } else {
            TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neid);
            portName = configurDataMgr.isIFboard(boardType) && configurDataMgr.isPTNDevice(ne) ? configurDataMgr.getPortNameByPortType(neid, slotid, boardType, portid, 1802) : configurDataMgr.getPortName(neid, slotid, boardType, portid);
            boardPortName.append(slotid).append("-").append(boardName).append("-").append(portName);
        }
        return boardPortName.toString();
    }
}

