/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TEGetAddablePortBean
extends TENEExplorerBean {
    private int neId = 0;
    private int slotId = 0;
    private int boardtype = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        this.neId = Integer.parseInt(rParams.getParam("neId").getValue());
        this.slotId = Integer.parseInt(rParams.getParam("slotID").getValue());
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        this.boardtype = mgr.getBoardType(neid, this.slotId);
        int neVersion = TEConvertUtil.convertVerStrToInt((String)mgr.getNE(this.neId).getHostVersion());
        List portRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(this.boardtype);
        String queryType = rParams.getParam("querytype").getValue();
        if (queryType.equals("0")) {
            int portID = Integer.parseInt(rParams.getParam("portID").getValue());
            Set<Integer> signalList = this.getPortTypeList(portRecordList, neVersion, portID);
            Iterator<Integer> iterator = signalList.iterator();
            while (iterator.hasNext()) {
                RowParams rowParam = new RowParams();
                rowParam.addParam("portType", String.valueOf(iterator.next()));
                this.outputData.getBussinessParams().addRowParams(rowParam);
            }
            return this.outputData;
        }
        if (queryType.equals("2")) {
            int portID = Integer.parseInt(rParams.getParam("portID").getValue());
            int portType = Integer.parseInt(rParams.getParam("portType").getValue());
            Set<Integer> signalList = this.getSpeedLevelList(portRecordList, neVersion, portID, portType);
            Iterator<Integer> iterator = signalList.iterator();
            while (iterator.hasNext()) {
                RowParams rowParam = new RowParams();
                rowParam.addParam("speedLevel", String.valueOf(iterator.next()));
                this.outputData.getBussinessParams().addRowParams(rowParam);
            }
            return this.outputData;
        }
        this.removeExistPort(portRecordList);
        TECPAddiblePortRecord portRecord = null;
        int n = portRecordList.size();
        for (int j = 0; j < n; ++j) {
            portRecord = (TECPAddiblePortRecord)portRecordList.get(j);
            if (!portRecord.isWithInRange(neVersion)) continue;
            RowParams rowParam = new RowParams();
            rowParam.addParam(new Param("portID", String.valueOf(portRecord.portID)));
            if (portRecord.signalType == 0) {
                portRecord.signalType = 2;
            }
            rowParam.addParam(new Param("portType", String.valueOf(portRecord.signalType)));
            rowParam.addParam(new Param("speedLevel", String.valueOf(this.convertSpeedLevel(portRecord.m_interface))));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        return this.outputData;
    }

    private Set<Integer> getSpeedLevelList(List<TECPAddiblePortRecord> portRecordList, int neVersion, int portID, int portType) {
        HashSet<Integer> returnList = new HashSet<Integer>();
        TECPAddiblePortRecord portRecord = null;
        int n = portRecordList.size();
        for (int j = 0; j < n; ++j) {
            portRecord = portRecordList.get(j);
            if (!portRecord.isWithInRange(neVersion) || portRecord.portID != portID || portRecord.signalType != portType) continue;
            returnList.add(this.convertSpeedLevel(portRecord.m_interface));
        }
        return returnList;
    }

    private Set<Integer> getPortTypeList(List<TECPAddiblePortRecord> portRecordList, int neVersion, int portID) {
        HashSet<Integer> returnList = new HashSet<Integer>();
        TECPAddiblePortRecord portRecord = null;
        int n = portRecordList.size();
        for (int j = 0; j < n; ++j) {
            portRecord = portRecordList.get(j);
            if (!portRecord.isWithInRange(neVersion) || portRecord.portID != portID) continue;
            returnList.add(portRecord.signalType);
        }
        return returnList;
    }

    private int convertSpeedLevel(int emsSpeedLevel) {
        int speed = 1;
        switch (emsSpeedLevel) {
            case 6401: {
                speed = 1;
                break;
            }
            case 6404: {
                speed = 2;
                break;
            }
            case 16388: {
                speed = 6;
                break;
            }
            case 16387: {
                speed = 7;
                break;
            }
            case 128: {
                speed = 128;
                break;
            }
            case 129: {
                speed = 129;
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEGetAddablePortBean.convertSpeedLevel() emsSpeedLevel:" + emsSpeedLevel + " not in case!");
            }
        }
        return speed;
    }

    private void removeExistPort(List<TECPAddiblePortRecord> portRecordList) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PORT");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Input input = oper.getInput();
        input.getPart("slotID").setValue(String.valueOf(this.slotId));
        input.getPart("portID").setValue("0");
        operationList.add(oper);
        int resualt = TENECommMgr.getInstance().sendCommand((int)this.neid, operationList, (int)this.TIME_OUT).retCode;
        if (resualt == 0) {
            int iLength = oper.getOutputCount();
            for (int i = 0; i < iLength; ++i) {
                int portid = -1;
                if (oper.getOutput(i).getFault(0).getCode().equals(String.valueOf(0))) {
                    portid = Integer.valueOf(oper.getOutput(i).getPartValue("portID"));
                }
                for (int j = portRecordList.size() - 1; j >= 0; --j) {
                    TECPAddiblePortRecord record = portRecordList.get(j);
                    if (record.portID != portid) continue;
                    portRecordList.remove(j);
                }
            }
        }
    }
}

