/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEDeletLogicPortBean
extends TENEExplorerBean {
    private static final int TIME_OUT = 10;
    private static Logger log = TELogFactory.getNormalLogger();
    private int slotId = 0;
    private int portID = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        String Name = "";
        String Value = "";
        Param[] rParams = inputData.getBussinessParams().getRowParams()[0].getParam();
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            Name = rParams[i].getName();
            Value = rParams[i].getValue();
            if (Name.equalsIgnoreCase("slotID")) {
                this.slotId = new Integer(Value);
                continue;
            }
            if (!Name.equalsIgnoreCase("portID")) continue;
            this.portID = new Integer(Value);
        }
        Operation oper = null;
        int iBoardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotId);
        oper = TEBoardConfigurationDataMgr.getInstance().isCPHaveFB(iBoardType, 10001) ? TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SUBBD_DEL_PORT_WBID") : TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_DEL_PORT");
        if (null == oper) {
            log.info("The operation NSCMD_CFG_DEL_PORT is not found!");
            return null;
        }
        Input input = oper.getInput();
        Part part = input.getPart("slotID");
        part.setValue(String.valueOf(this.slotId));
        part = input.getPart("portID");
        part.setValue(String.valueOf(this.portID));
        this.operationList = new ArrayList();
        this.operationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
        this.outputData = new Datainterface();
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
            if (oper.getOutput()[0].getFault()[0].getCode().equals(String.valueOf(0))) {
                TENE ne = TENEListMgr.getInstance().getNE(neid);
                ne.removeAlarm(this.slotId, this.portID);
                TEConfigurationDataMgr.getInstance().deletLogicPort(neid, this.slotId, this.portID);
                TEConfigurationDataMgr.getInstance().deletePortName(neid, this.slotId, this.portID);
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEDeletLogicPortBean.this.operationToString();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationToString() {
        StringBuffer filePath = new StringBuffer();
        filePath.append("sdh").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("channel").append(File.separator).append("channelpathres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer buf = new StringBuffer();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotId);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardType);
        buf.append(res.getString("deletLogicPort"));
        buf.append(this.slotId).append("-");
        buf.append(boardName);
        buf.append("-");
        buf.append("portID").append(":").append(this.portID);
        return buf.toString();
    }
}

