/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEAlarm;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.TELCTFunBlockComparator;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nemgr.sdh.channel.TEChannelDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEChannelPathGraph
extends TENEExplorerBean {
    private int boardtype = -1;
    private int slotID = -1;
    private static final String GET_ALL = "0";
    boolean isDynPortBoardType = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        this.slotID = Integer.parseInt(slotinfo);
        this.boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        String requesType = inputData.getBussinessParams().getRowParams(0).getParam("requesType").getValue();
        if (requesType.equalsIgnoreCase(GET_ALL)) {
            this.isDynPortBoardType = TEConfigurationDataMgr.getInstance().isDynPortBoardType(neid, this.boardtype);
        }
        this.getChannelData(neid, this.slotID);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void getChannelData(int neID, int slotID) {
        List funblockList = TEChannelDataMgr.getInstance().getLctFunBlockList(neID, slotID, this.isDynPortBoardType);
        TELCTFunBlockComparator comparator = new TELCTFunBlockComparator();
        Collections.sort(funblockList, comparator);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        for (int i = 0; i < funblockList.size(); ++i) {
            TELCTFunBlock fb = (TELCTFunBlock)funblockList.get(i);
            RowParams rowParam = new RowParams();
            rowParam.addParam("id", fb.id);
            rowParam.addParam("pid", fb.pid);
            rowParam.addParam("name", fb.name);
            rowParam.addParam("portID", String.valueOf(fb.portid));
            rowParam.addParam("pathID", String.valueOf(fb.pathid));
            rowParam.addParam("canDelPort", String.valueOf(fb.canDelPort));
            rowParam.addParam("canModifyPort", String.valueOf(fb.canModifyPort));
            rowParam.addParam("functionType", String.valueOf(fb.functionType));
            rowParam.addParam("loopback", String.valueOf(fb.loopback));
            rowParam.addParam("payload", String.valueOf(fb.payload));
            rowParam.addParam("portName", fb.portName);
            rowParam.addParam("portStatus", String.valueOf(fb.portStatus));
            rowParam.addParam("usageState", String.valueOf(fb.usageState));
            rowParam.addParam("IsDynBoard", String.valueOf(this.isDynPortBoardType));
            rowParam.addParam("logicPortInPosition", String.valueOf(fb.logicPortInPosition));
            rowParam.addParam("portSpeed", String.valueOf(fb.portSpeed));
            rowParam.addParam("portType", String.valueOf(fb.portType));
            fb.topAlarmLevel = 0;
            if (fb.pathid >= 0) {
                this.geAlarmStatus(neID, slotID, fb);
            }
            rowParam.addParam("topAlarmLevel", String.valueOf(fb.topAlarmLevel));
            rowParam.addParam("boardType", String.valueOf(this.boardtype));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
    }

    private void geAlarmStatus(int neID, int slotID, TELCTFunBlock functionblock) {
        TENE neobj = TENEListMgr.getInstance().getNE(neID);
        Vector alarams = neobj.getAlarmList();
        ArrayList supportAlmList = TEAlarmDataMgr.getInstance().getAlarmFbList(this.boardtype);
        functionblock.topAlarmLevel = 0;
        int size = alarams.size();
        for (int i = 0; i < size; ++i) {
            boolean isBranchBoard;
            TEAlarm alarm = (TEAlarm)alarams.get(i);
            int slot = alarm.getSlotID();
            int port = alarm.getPort();
            int path = alarm.getPath();
            if (port > 0 && path <= 0) {
                path = 1;
            }
            int fbType = alarm.getFuncBlock();
            boolean bl = isBranchBoard = TEConfigurationDataMgr.getInstance().isBranchBoardBybdType(neID, this.boardtype) && (neobj.getNEType() == 60 || neobj.getNEType() == 54 || neobj.getNEType() == 55);
            if (!isBranchBoard ? slot != slotID || port != functionblock.portid && port > 0 && functionblock.portid > 0 || !this.compareFBType(fbType, functionblock.functionType) : slot != slotID || path != functionblock.portid || !this.compareFBType(fbType, functionblock.functionType)) continue;
            if (!isBranchBoard && functionblock.pathid > 0 && path != functionblock.pathid) continue;
            if (supportAlmList == null) {
                return;
            }
            int size2 = supportAlmList.size();
            for (int k = 0; k < size2; ++k) {
                TEAlmFBObj alarmFb = (TEAlmFBObj)supportAlmList.get(k);
                if (!this.compareFBType(alarmFb.m_usFBType, fbType) || alarmFb.m_usPortID != port && alarmFb.m_usPortID > 0 || alarmFb.m_usPathID != path && alarmFb.m_usPathID != (path & 0xFFFF) && alarmFb.m_usPathID != 0) continue;
                int AlarmLevel = alarm.getAlarmLevel();
                if (AlarmLevel > 0 && functionblock.topAlarmLevel > 0 && AlarmLevel < functionblock.topAlarmLevel) {
                    functionblock.topAlarmLevel = AlarmLevel;
                    continue;
                }
                if (functionblock.topAlarmLevel != 0 || AlarmLevel <= 0) continue;
                functionblock.topAlarmLevel = AlarmLevel;
            }
        }
    }

    private boolean compareFBType(int firstFb, int secondFB) {
        boolean result = false;
        if (!(firstFb != 19 && firstFb != 909 || secondFB != 19 && secondFB != 909)) {
            result = true;
        } else if (firstFb == secondFB) {
            result = true;
        } else if (TEConfigurationDataMgr.getInstance().getBidirFBType(firstFb) == TEConfigurationDataMgr.getInstance().getBidirFBType(secondFB)) {
            result = true;
        }
        return result;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, this.boardtype);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
                loginfo.setOperateDesc(neid + "-" + this.slotID + "-" + boardName);
            } else {
                loginfo.setOperateObject(neObj.getNEName());
                loginfo.setOperateDesc(neObj.getNEName() + "-" + this.slotID + "-" + boardName);
            }
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                loginfo.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                    break;
                }
            } else {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

