/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.channel;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TEGenCfgCmdFactory;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.channel.ChannelPathNode;
import com.huawei.nglct.nelist.model.channel.TEChannelModeDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.sdh.channel.TECPTPModelMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEChannelDataMgr {
    private static final int TIME_OUT = 10;
    private static TEChannelDataMgr instance = null;
    private static Map<Integer, Boolean[]> vc4Map = new HashMap<Integer, Boolean[]>();
    private static final String PORT_MODE_FIRST = "1";
    private static final String PORT_MODE_SECOND = "2";
    private static final String PORT_MODE_MIX = "4";
    private static final int RTN950_LOW_VERSION = 88867624;
    private static final int RTN950_HIGH_VERSION = 88892259;
    private static final int RTN980_LOW_VERSION = 89326376;
    private static final int RTN980_HIGH_VERSION = 0x5536363;
    private static final int RTN905_VERSION = 90113290;
    private static final int FUNC_LASER = 912;
    private static final int FUNC_IP = 903;
    private static final List<Integer> IFBOARDS = new ArrayList<Integer>();
    private static final String RTN_ENVIROMENT_FILE = TEResourceManager.getPath() + "nemgr" + File.separator + "sdh" + File.separator + "conf" + File.separator + "gencfg" + File.separator + "pemuinterfaceqx.xml";
    private int neId = -1;
    private int slotId = -1;

    private TEChannelDataMgr() {
    }

    public static synchronized TEChannelDataMgr getInstance() {
        if (null == instance) {
            Boolean[] SL71IF0 = new Boolean[]{false};
            Boolean[] SL61EMS = new Boolean[]{false, true};
            Boolean[] SLEFT4 = new Boolean[]{false, true};
            Boolean[] SL61IF1A = new Boolean[]{false};
            Boolean[] SL61IF1B = new Boolean[]{false};
            Boolean[] SL61IF0A = new Boolean[]{false};
            Boolean[] SL61IF0B = new Boolean[]{false};
            Boolean[] SL61EGS4 = new Boolean[]{false, true};
            Boolean[] SL91EMS6 = new Boolean[]{false, false, false, true};
            vc4Map.put(1219, SL71IF0);
            vc4Map.put(1210, SL61EMS);
            vc4Map.put(1066, SLEFT4);
            vc4Map.put(1032, SL61IF1A);
            vc4Map.put(1033, SL61IF1B);
            vc4Map.put(1176, SL61IF0A);
            vc4Map.put(1177, SL61IF0B);
            vc4Map.put(2423, SL61EGS4);
            vc4Map.put(2439, SL91EMS6);
            instance = new TEChannelDataMgr();
        }
        return instance;
    }

    public List getFunBlockList(int neID, int slotID) {
        ArrayList result = new ArrayList();
        return result;
    }

    public void geFunBlockStatus(TELCTFunBlock funblock) {
    }

    public String getNESlotBoardName(int neID, int slotID) {
        int boardType;
        StringBuffer sb = new StringBuffer();
        TENE neobj = TENEListMgr.getInstance().getNE(neID);
        if (neobj != null) {
            sb.append(neobj.getNEName()).append("-");
        }
        if (slotID > 0 && slotID != 255) {
            sb.append(slotID).append("-");
        }
        if ((boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID)) > 0) {
            sb.append(TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType));
        }
        return sb.toString();
    }

    public List getLctFunBlockList(int neID, int slotID, boolean isDynPortBoardType) {
        List portPropertyList;
        this.neId = neID;
        this.slotId = slotID;
        int iBoardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neID);
        int curNEVersion = TEConvertUtil.convertVerStrToInt((String)ne.getHostVersion());
        ArrayList<TELCTFunBlock> result = new ArrayList<TELCTFunBlock>();
        TELCTFunBlock funblock = new TELCTFunBlock();
        funblock.name = this.getNESlotBoardName(neID, slotID);
        funblock.id = "0";
        funblock.pid = "-1";
        funblock.seqenceLevel = 0;
        result.add(funblock);
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        List boardFunPropertyList = mgr.getBoardFunBlockList(iBoardType);
        if (boardFunPropertyList != null && boardFunPropertyList.size() > 0) {
            int size = boardFunPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEFunBlockProperty fbproperty = (TEFunBlockProperty)boardFunPropertyList.get(i);
                int fbtype = fbproperty.getFuctionBlockType();
                String attrName = "";
                if (fbtype == 122) {
                    attrName = "ENVCTRL_COM_INPUTCSK_NAME";
                }
                if (fbtype == 124) {
                    attrName = "ENVCTRL_EMU_OUTCSK_NAME";
                }
                Map<String, String> relayName = this.processBoardRelayName(neID, slotID, iBoardType, attrName);
                ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                if (fbNoList == null || fbNoList.size() <= 0) continue;
                int length = fbNoList.size();
                for (int j = 0; j < length; ++j) {
                    TELCTFunBlock fb = new TELCTFunBlock();
                    fb.id = funblock.id + "-" + result.size();
                    fb.pid = funblock.id;
                    fb.functionType = fbtype;
                    fb.pathid = 0;
                    fb.portid = 0;
                    int id = j + 1;
                    if (relayName != null && relayName.containsKey(String.valueOf(id))) {
                        fb.name = relayName.get(String.valueOf(id));
                    }
                    if (fb.name.equals("")) {
                        fb.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(fbtype) + "-" + id;
                    }
                    fb.seqenceLevel = 1;
                    result.add(fb);
                }
            }
        }
        if ((portPropertyList = mgr.getPortPropertyList(iBoardType)) != null && portPropertyList.size() > 0) {
            int size = portPropertyList.size();
            block10: for (int i = 0; i < size; ++i) {
                ArrayList channelModeData;
                TEPortProperty portproperty = (TEPortProperty)portPropertyList.get(i);
                int portNO = portproperty.getPortNo();
                if (!(portNO == -1 || (channelModeData = (ArrayList)TEChannelModeDataMgr.getInstance().getChannelData(iBoardType, portNO)) == null || TEChannelDataMgr.isAddibleCPPort(iBoardType, portNO, curNEVersion) && "false".equals(this.isLogiPortExist(portNO)))) {
                    this.processPathViewInCP(neID, slotID, channelModeData, portproperty, iBoardType, "0", result);
                    continue;
                }
                int portType = portproperty.getPortType();
                if (TEConfigurationDataMgr.getInstance().isWDMBoardType(neID, iBoardType) && portType != 61005) {
                    this.processWDMPort(portproperty, neID, iBoardType, "0", result, slotID);
                    continue;
                }
                switch (portType) {
                    case 61005: 
                    case 64001: {
                        this.processETHPort(portproperty, neID, iBoardType, "0", result);
                        continue block10;
                    }
                    case 1799: {
                        this.processMACPort(portproperty, neID, iBoardType, "0", result, isDynPortBoardType, slotID);
                        continue block10;
                    }
                    case 1025: {
                        this.processMACPort(portproperty, neID, iBoardType, "0", result, slotID);
                        continue block10;
                    }
                    case 2817: {
                        this.processIFPort(portproperty, neID, iBoardType, "0", result, slotID, "IF");
                        continue block10;
                    }
                    case 1802: {
                        this.processIFPort(portproperty, neID, iBoardType, "0", result, slotID, "RTNIF");
                        continue block10;
                    }
                    case 1803: {
                        this.processIFPort(portproperty, neID, iBoardType, "0", result, slotID, "RTNRF");
                        continue block10;
                    }
                    default: {
                        if (IFBOARDS.contains(iBoardType)) {
                            this.processIFPort(portproperty, neID, iBoardType, "0", result, slotID, "SDH");
                            continue block10;
                        }
                        this.processSDHPort(portproperty, neID, iBoardType, "0", result, isDynPortBoardType, slotID, slotID);
                    }
                }
            }
        }
        return result;
    }

    private Map<String, String> processBoardRelayName(int neID, int slotID, int boardType, String attrName) {
        TEGenCfgFunCmd funCmd;
        TEGenCfgFunAttr funAttr;
        Map<String, String> relayName = null;
        if (!attrName.equals("") && TEGenCfgDataMgr.isBoardSupportAttr((int)neID, (int)boardType, (String)attrName) && (funAttr = (funCmd = TEGenCfgCmdFactory.getInstance().getFunCmd(RTN_ENVIROMENT_FILE)).getGenCfgFunAttr(attrName, "query")) != null) {
            int result;
            ArrayList<String> operationNameList = new ArrayList<String>();
            operationNameList.add(funAttr.getPtcode());
            Datainterface inputData = new Datainterface();
            BussinessParams bussiness = new BussinessParams();
            inputData.setBussinessParams(bussiness);
            RowParams rowParams = new RowParams();
            bussiness.addRowParams(rowParams);
            Param param = new Param("neID", String.valueOf(neID));
            rowParams.addParam(param);
            param = new Param("slotID", String.valueOf(slotID));
            rowParams.addParam(param);
            ArrayList operationList = TEGenCfgDataConvertor.convertToOperation((TEGenCfgFunAttr)funAttr, (Datainterface)inputData, (int)neID, operationNameList);
            if (!operationList.isEmpty() && (result = TENECommMgr.getInstance().sendCommand((int)neID, (List)operationList, (int)10).retCode) == 0) {
                relayName = this.getRelayNameFromOperationList(operationList, attrName);
            }
        }
        return relayName;
    }

    private Map<String, String> getRelayNameFromOperationList(List operationList, String attrName) {
        HashMap<String, String> relayName = new HashMap<String, String>();
        Operation operation = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            int partLen = operation.getOutputCount();
            for (int j = 0; j < partLen; ++j) {
                if (!operation.getOutput(j).getFault(0).getCode().equals(String.valueOf(0)) || operation.getOutput(j).getPart("switch") == null || operation.getOutput(j).getPart(attrName) == null) continue;
                relayName.put(operation.getOutput(j).getPartValue("switch"), IOStreamConvertor.replaceSpecialStr((String)operation.getOutput(j).getPartValue(attrName)));
            }
        }
        return relayName;
    }

    private Set<Integer> getDynPortList(int neID, int boardType) {
        ArrayList dynProList = TEConfigurationDataMgr.getInstance().getDynPropertyList(neID, boardType);
        HashSet<Integer> dynPortSet = new HashSet<Integer>();
        int size = dynProList.size();
        for (int i = 0; i < size; ++i) {
            TEPortProperty portProperty = (TEPortProperty)dynProList.get(i);
            int portType = portProperty.getPortType();
            if ((portType & 2) != 2) continue;
            dynPortSet.add(portProperty.getPortNo());
        }
        return dynPortSet;
    }

    private void processPathViewInCP(int neID, int slotID, ArrayList channelModeData, TEPortProperty portproperty, int iBoardType, String pid, ArrayList result) {
        if (null == channelModeData) {
            return;
        }
        int portNo = portproperty.getPortNo();
        if (portNo > 0) {
            TELCTFunBlock fb = new TELCTFunBlock();
            fb.portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo, portproperty.getPortType());
            if (fb.portName.equals("")) {
                fb.portName = "PORT-" + portNo;
            }
            if (this.getDynPortList(neID, iBoardType).contains(portNo)) {
                fb.canDelPort = 1;
            }
            fb.functionType = 11025;
            fb.pid = pid;
            fb.portid = portNo;
            fb.id = pid + "-" + result.size();
            fb.seqenceLevel = 3;
            result.add(fb);
            int size = channelModeData.size();
            for (int i = 0; i < size; ++i) {
                ChannelPathNode modeNode = (ChannelPathNode)channelModeData.get(i);
                modeNode.convertToLCTFunBlock(fb, (List)result, "", "");
            }
        }
    }

    public void processWDMPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, int slotID) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0) {
            TELCTFunBlock fb = new TELCTFunBlock();
            StringBuffer portName = new StringBuffer(TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo));
            int indexOfSpecialChar = portName.indexOf("(");
            if (-1 != indexOfSpecialChar) {
                portName.delete(0, indexOfSpecialChar + 1);
                portName.deleteCharAt(portName.length() - 1);
            }
            fb.portName = portName.toString();
            fb.functionType = 10769;
            fb.pid = pid;
            fb.portid = portNo;
            fb.id = pid + "-" + result.size();
            result.add(fb);
            if (funblockPropertyList != null && funblockPropertyList.size() > 0) {
                int iiLength = funblockPropertyList.size();
                for (int ii = 0; ii < iiLength; ++ii) {
                    TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                    int funblocktype = fbproperty.getFuctionBlockType();
                    ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                    if (fbNoList == null || fbNoList.size() <= 0) continue;
                    int jjLength = fbNoList.size();
                    for (int jj = 0; jj < jjLength; ++jj) {
                        TELCTFunBlock fb2 = new TELCTFunBlock();
                        int id = jj + 1;
                        fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                        fb2.functionType = funblocktype;
                        fb2.pid = fb.id;
                        fb2.pathid = jj + 1;
                        fb2.portid = fb.portid;
                        fb2.id = fb.id + "-" + result.size();
                        result.add(fb2);
                    }
                }
            }
        }
    }

    public void processMACPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, int slotID) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0) {
            TELCTFunBlock fb = new TELCTFunBlock();
            fb.portName = "PORT-" + portNo;
            if (iBoardType == 1607 || iBoardType == 1410 || iBoardType == 1608) {
                fb.portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo, portproperty.getPortType());
            }
            if (iBoardType == 1550 && portNo == 5) {
                fb.portName = "IFUP-1";
            }
            fb.functionType = 11025;
            fb.pid = pid;
            fb.portid = portNo;
            fb.id = pid + "-" + result.size();
            fb.seqenceLevel = 3;
            result.add(fb);
            if (funblockPropertyList != null && funblockPropertyList.size() > 0) {
                String level = "";
                if (iBoardType == 1607 || iBoardType == 1410 || iBoardType == 1608 || TEGenCfgDataMgr.isBoardSupportAttr((int)neID, (int)iBoardType, (String)"SDHPORT_ATTR_MODE")) {
                    level = this.getPortModeLevel(slotID, portNo);
                }
                int iiLength = funblockPropertyList.size();
                for (int ii = 0; ii < iiLength; ++ii) {
                    ArrayList fbNoList;
                    TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                    int funblocktype = fbproperty.getFuctionBlockType();
                    if (level.equals(PORT_MODE_MIX) && funblocktype == 912 || level.equals(PORT_MODE_SECOND) && funblocktype == 903 || !this.isSupportFBBySingleType(portproperty.getSignalType(), funblocktype) || (fbNoList = fbproperty.getFunctionBlockNoList()) == null || fbNoList.size() <= 0) continue;
                    int jjLength = fbNoList.size();
                    for (int jj = 0; jj < jjLength; ++jj) {
                        TELCTFunBlock fb2 = new TELCTFunBlock();
                        int id = jj + 1;
                        fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                        fb2.functionType = funblocktype;
                        fb2.pid = fb.id;
                        fb2.pathid = 1;
                        fb2.portid = fb.portid;
                        fb2.id = fb.id + "-" + result.size();
                        result.add(fb2);
                    }
                }
            }
        }
    }

    private ArrayList getPortFuncListFromSpeed(int neid, int boardType, int portid, int portlevel) {
        ArrayList portpropertys = TEConfigurationDataMgr.getInstance().getDynPropertyList(neid, boardType);
        TEPortProperty property = null;
        for (int i = portpropertys.size() - 1; i >= 0; --i) {
            property = (TEPortProperty)portpropertys.get(i);
            if (property.getPortNo() != portid || property.getPortSpeed() != portlevel) continue;
            return property.getFunBlockPropertyList();
        }
        return null;
    }

    public void processMACPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, boolean isDynPortBoardType, int slotID) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0) {
            TELCTFunBlock fb = new TELCTFunBlock();
            fb.portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo, portproperty.getPortType());
            if (fb.portName.equals("")) {
                fb.portName = "PORT-" + portNo;
            }
            if (iBoardType == 1550 && portNo == 5) {
                fb.portName = "IFUP-1";
            }
            boolean LogiPortExist = true;
            String portType = null;
            TENE ne = TEConfigurationDataMgr.getInstance().getNE(neID);
            int curNEVersion = TEConvertUtil.convertVerStrToInt((String)ne.getHostVersion());
            if (isDynPortBoardType && TEChannelDataMgr.isAddibleCPPort(iBoardType, portNo, curNEVersion)) {
                String queryVar = this.isLogiPortExist(portNo);
                if ("false".equals(queryVar)) {
                    LogiPortExist = false;
                } else {
                    portType = queryVar.split("-")[1];
                    LogiPortExist = true;
                }
                if (TEBoardConfigurationDataMgr.getInstance().isCPHaveFB(iBoardType, 10001) && !"255".equals(fb.portSpeed)) {
                    LogiPortExist = true;
                }
                if (LogiPortExist) {
                    fb.portType = portType;
                    fb.portSpeed = this.isLogiPortExistForRTN(portNo);
                    if (String.valueOf(30).equals(portType)) {
                        funblockPropertyList = this.getPortFuncListFromSpeed(neID, iBoardType, portNo, Integer.parseInt(fb.portSpeed));
                    }
                    if (LogiPortExist && (curNEVersion >= 88867624 && curNEVersion <= 88892259 || curNEVersion >= 89326376 && curNEVersion <= 0x5536363) || curNEVersion >= 90113290) {
                        fb.canDelPort = 1;
                    }
                    TEConfigurationDataMgr.getInstance().addLogicPort(neID, slotID, portNo);
                } else {
                    TEConfigurationDataMgr.getInstance().deletLogicPort(neID, slotID, portNo);
                    fb.logicPortInPosition = 0;
                }
            }
            fb.functionType = 11025;
            fb.pid = pid;
            fb.portid = portNo;
            fb.id = pid + "-" + result.size();
            fb.seqenceLevel = 3;
            result.add(fb);
            if (funblockPropertyList != null && funblockPropertyList.size() > 0) {
                String level = "";
                if (iBoardType == 1607 || iBoardType == 1410 || iBoardType == 1608 || TEGenCfgDataMgr.isBoardSupportAttr((int)neID, (int)iBoardType, (String)"SDHPORT_ATTR_MODE")) {
                    level = this.getPortModeLevel(slotID, portNo);
                }
                if (null != portType) {
                    this.filterFunBlock(portType, funblockPropertyList);
                }
                int iiLength = funblockPropertyList.size();
                for (int ii = 0; ii < iiLength; ++ii) {
                    ArrayList fbNoList_rep1;
                    TEFunBlockProperty fbproperty_rep1 = (TEFunBlockProperty)funblockPropertyList.get(ii);
                    int funblocktype_rep1 = fbproperty_rep1.getFuctionBlockType();
                    if (level.equals(PORT_MODE_MIX) && funblocktype_rep1 == 912 || level.equals(PORT_MODE_SECOND) && funblocktype_rep1 == 903 || !this.isSupportFBBySingleType(portproperty.getSignalType(), funblocktype_rep1) || (fbNoList_rep1 = fbproperty_rep1.getFunctionBlockNoList()) == null || fbNoList_rep1.size() <= 0) continue;
                    int jjLength = fbNoList_rep1.size();
                    for (int jj = 0; jj < jjLength; ++jj) {
                        TELCTFunBlock fb2_rep1 = new TELCTFunBlock();
                        int id = jj + 1;
                        fb2_rep1.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype_rep1) + "-" + id;
                        fb2_rep1.functionType = funblocktype_rep1;
                        fb2_rep1.pid = fb.id;
                        fb2_rep1.pathid = 1;
                        fb2_rep1.portid = fb.portid;
                        fb2_rep1.id = fb.id + "-" + result.size();
                        fb2_rep1.logicPortInPosition = fb.logicPortInPosition;
                        result.add(fb2_rep1);
                    }
                }
            }
        }
    }

    private void filterFunBlock(String portType, List funblockPropertyList) {
        if (portType.equals(PORT_MODE_SECOND)) {
            for (int i = funblockPropertyList.size() - 1; i >= 0; --i) {
                TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(i);
                if (fbproperty.getFuctionBlockType() != 912) continue;
                funblockPropertyList.remove(i);
            }
        }
    }

    private boolean isSupportFBBySingleType(int singleType, int fbType) {
        boolean bSupport = true;
        switch (fbType) {
            case 912: {
                if (singleType == 1) {
                    bSupport = true;
                    break;
                }
                bSupport = false;
                break;
            }
        }
        return bSupport;
    }

    public void processSDHPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, boolean isDynPortBoardType, int slotID, int slotID2) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0) {
            TELCTFunBlock fb = new TELCTFunBlock();
            fb.portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo, portproperty.getPortType());
            boolean LogiPortExist = true;
            String portType = null;
            if (isDynPortBoardType) {
                String queryVar = this.isLogiPortExist(portNo);
                if ("false".equals(queryVar)) {
                    LogiPortExist = false;
                } else {
                    portType = queryVar.split("-")[1];
                    LogiPortExist = true;
                }
                if (iBoardType == 2264) {
                    fb.portSpeed = this.isLogiPortExistForRTN(portNo);
                    if (!"255".equals(fb.portSpeed)) {
                        LogiPortExist = true;
                    }
                }
                if (LogiPortExist) {
                    fb.canDelPort = 1;
                    TEConfigurationDataMgr.getInstance().addLogicPort(neID, slotID, portNo);
                } else {
                    TEConfigurationDataMgr.getInstance().deletLogicPort(neID, slotID, portNo);
                    fb.logicPortInPosition = 0;
                }
            }
            if (!(iBoardType != 1254 && iBoardType != 2264 || portType == null || portType.equals(""))) {
                fb.portType = portType;
            }
            if (TESpecialAttrMgr.getInstance().isCPSupport(neID, slotID, "TE_FUNC_SDH_PATH_CONFIG", "SDH_CES_PORT_REPLACE") && portType != null && !portType.equals("")) {
                if (portType.equals(PORT_MODE_SECOND)) {
                    portType = "0";
                }
                fb.portType = portType;
            }
            fb.functionType = 10256;
            fb.pid = pid;
            fb.portid = portNo;
            fb.id = pid + "-" + result.size();
            fb.seqenceLevel = 3;
            result.add(fb);
            if (funblockPropertyList != null && funblockPropertyList.size() > 0) {
                String level = "";
                if (iBoardType == 1607 || iBoardType == 1410 || iBoardType == 1608 || TEGenCfgDataMgr.isBoardSupportAttr((int)neID, (int)iBoardType, (String)"SDHPORT_ATTR_MODE")) {
                    level = this.getPortModeLevel(slotID, portNo);
                }
                int iiLength = funblockPropertyList.size();
                for (int ii = 0; ii < iiLength; ++ii) {
                    ArrayList fbNoList;
                    TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                    int funblocktype = fbproperty.getFuctionBlockType();
                    if ((level.equals(PORT_MODE_SECOND) || level.equals(PORT_MODE_FIRST)) && funblocktype == 903 || (fbNoList = fbproperty.getFunctionBlockNoList()) == null || fbNoList.size() <= 0) continue;
                    int jjLength = fbNoList.size();
                    for (int jj = 0; jj < jjLength; ++jj) {
                        if (TECPTPModelMgr.getInstance().convertFBList(neID, iBoardType, fb, result, funblocktype)) continue;
                        TELCTFunBlock fb2 = new TELCTFunBlock();
                        int id = jj + 1;
                        boolean idsupportvc12 = vc4Map.get(iBoardType) == null ? true : vc4Map.get(iBoardType)[jj];
                        fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                        fb2.functionType = funblocktype;
                        fb2.pid = fb.id;
                        fb2.pathid = jj + 1;
                        fb2.portid = fb.portid;
                        fb2.id = fb.id + "-" + result.size();
                        fb2.logicPortInPosition = fb.logicPortInPosition;
                        if (("VC4-2".equals(fb2.name) || "VC4-3".equals(fb2.name) || "VC4-4".equals(fb2.name)) && PORT_MODE_FIRST.equals(fb.portSpeed)) {
                            fb2.logicPortInPosition = 0;
                        }
                        fb2.seqenceLevel = 4;
                        if (TESpecialAttrMgr.getInstance().isCPSupport(neID, slotID, "TE_FUNC_SDH_PATH_CONFIG", "SDH_CES_PORT_REPLACE") && fb.portType != null && !fb.portType.equals("")) {
                            fb2.portType = fb.portType;
                        }
                        result.add(fb2);
                        if (fb2.functionType != 4) continue;
                        this.processFunblockVC4(fb2, result, idsupportvc12);
                    }
                }
            }
        }
    }

    private void processFunblockVC4(TELCTFunBlock fbVC4, List result, boolean idsupportvc12) {
        TELCTFunBlock fbVC12 = null;
        TELCTFunBlock fbVC3 = null;
        int vc3Count = 1;
        int j = 0;
        for (int i = 0; i < 63; ++i) {
            if (i % 21 == 0) {
                j = 0;
                fbVC3 = new TELCTFunBlock();
                fbVC3.functionType = 91;
                fbVC3.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(fbVC3.functionType) + "-" + vc3Count + "[" + vc3Count + "-0-0]";
                fbVC3.pid = fbVC4.id;
                fbVC3.portid = fbVC4.portid;
                fbVC3.pathid = (fbVC4.pathid - 1) * 3 + vc3Count;
                fbVC3.id = fbVC4.id + "-" + fbVC3.pathid;
                fbVC3.logicPortInPosition = fbVC4.logicPortInPosition;
                fbVC3.seqenceLevel = 5;
                result.add(fbVC3);
                ++vc3Count;
            }
            if (!idsupportvc12) continue;
            fbVC12 = new TELCTFunBlock();
            fbVC12.functionType = 92;
            fbVC12.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(fbVC12.functionType) + "[" + (vc3Count - 1) + "-" + (j / 3 + 1) + "-" + (i % 3 + 1) + "]" + "(" + (i + 1) + ")";
            fbVC12.pid = fbVC3.id;
            fbVC12.portid = fbVC3.portid;
            fbVC12.pathid = fbVC4.pathid * 65536 + (i + 1);
            fbVC12.id = fbVC3.id + "-" + fbVC12.pathid * 4;
            fbVC12.logicPortInPosition = fbVC3.logicPortInPosition;
            result.add(fbVC12);
            ++j;
        }
    }

    public void processIFPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, int slotID, String portFirstName) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0) {
            TELCTFunBlock fb = new TELCTFunBlock();
            String tmpName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo, portproperty.getPortType());
            fb.portName = tmpName.indexOf("SDH-") <= -1 && portproperty.getPortType() == 1802 ? tmpName : portFirstName + "-" + portNo;
            fb.functionType = 11025;
            fb.pid = pid;
            fb.portid = portNo;
            fb.id = pid + "-" + result.size();
            fb.seqenceLevel = 3;
            result.add(fb);
            if (funblockPropertyList != null && funblockPropertyList.size() > 0) {
                int iiLength = funblockPropertyList.size();
                for (int ii = 0; ii < iiLength; ++ii) {
                    TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                    int funblocktype = fbproperty.getFuctionBlockType();
                    ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                    if (fbNoList == null || fbNoList.size() <= 0) continue;
                    int jjLength = fbNoList.size();
                    for (int jj = 0; jj < jjLength; ++jj) {
                        TELCTFunBlock fb2 = new TELCTFunBlock();
                        int id = jj + 1;
                        fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                        fb2.functionType = funblocktype;
                        fb2.pid = fb.id;
                        fb2.pathid = 1;
                        fb2.portid = fb.portid;
                        fb2.id = fb.id + "-" + result.size();
                        result.add(fb2);
                    }
                }
            }
        }
    }

    public void processETHPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0 && funblockPropertyList != null && funblockPropertyList.size() > 0) {
            int iiLength = funblockPropertyList.size();
            for (int ii = 0; ii < iiLength; ++ii) {
                TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                int funblocktype = fbproperty.getFuctionBlockType();
                ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                if (fbNoList == null || fbNoList.size() <= 0) continue;
                int jjLength = fbNoList.size();
                for (int jj = 0; jj < jjLength; ++jj) {
                    TELCTFunBlock fb2 = new TELCTFunBlock();
                    int id = portNo & 0xFFF;
                    fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                    fb2.functionType = funblocktype;
                    fb2.pid = pid;
                    fb2.pathid = jj + 1;
                    fb2.portid = portNo;
                    fb2.id = pid + "-" + result.size();
                    fb2.seqenceLevel = 2;
                    result.add(fb2);
                }
            }
        }
    }

    private String isLogiPortExist(int portNo) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neId, (String)"NSCMD_CFG_GET_PORT");
        Input input = oper.getInput();
        Part part = input.getPart("slotID");
        part.setValue(String.valueOf(this.slotId));
        part = input.getPart("portID");
        part.setValue(String.valueOf(portNo));
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)this.neId, operationList, (int)10).retCode;
        String portType = "";
        if (result == 0 && "0".equals(oper.getOutput()[0].getFault()[0].getCode())) {
            portType = oper.getOutput(0).getPartValue("ATTR_ETHOVERPTN_LOGIC_PORTTYPE");
            return "true-" + portType;
        }
        return "false";
    }

    private String isLogiPortExistForRTN(int portNo) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neId, (String)"NSCMD_CFG_SUBBD_GET_PORT_WBID");
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(String.valueOf(this.slotId));
        part = input.getPart("port");
        part.setValue(String.valueOf(portNo));
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)this.neId, operationList, (int)10).retCode;
        if (result == 0 && "0".equals(oper.getOutput()[0].getFault()[0].getCode())) {
            return oper.getOutput()[0].getPartValue("speedLevel");
        }
        return "255";
    }

    private String getPortModeLevel(int slotid, int portId) {
        String level = "";
        Operation oper = TECreateObjectFactory.getOperation((int)this.neId, (String)"NSCMD_PTNETY_GET_LEVELMODE");
        if (oper == null) {
            return level;
        }
        Input input = oper.getInput();
        input.setPartValue("slotid", String.valueOf(slotid));
        input.setPartValue("port", String.valueOf(portId));
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)this.neId, operationList, (int)10).retCode;
        if (result == 0 && String.valueOf(0).equals(oper.getOutput(0).getFault()[0].getCode())) {
            level = oper.getOutput(0).getPartValue("PTNIF_PORT_ATTR_MODE");
        }
        return level;
    }

    public static boolean isAddibleCPPort(int boardType, int portNo, int neVersion) {
        List portRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType, portNo);
        TECPAddiblePortRecord portRecord = null;
        if (portRecordList == null || portRecordList.isEmpty()) {
            return false;
        }
        int size = portRecordList.size();
        for (int j = 0; j < size; ++j) {
            portRecord = (TECPAddiblePortRecord)portRecordList.get(j);
            if (!portRecord.isWithInRange(neVersion)) continue;
            return true;
        }
        return false;
    }

    static {
        IFBOARDS.add(2080);
        IFBOARDS.add(2079);
        IFBOARDS.add(2266);
        IFBOARDS.add(2267);
    }
}

