/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nemgr.sdh.channel.TECPTPInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TECPTPModelMgr {
    private static final int DEFAULT_TP_NUM = 1;
    private static final int FB_VC3 = 91;
    private static final int FB_VC12 = 92;
    private static final String FB_VC3_NAME_FORMAT = "[%d-%d-%d]";
    private static final String FB_VC12_NAME_FORMAT = "[%d-%d-%d](%d)";
    private static TECPTPModelMgr instance = null;
    private static Map<String, Map<List<Integer>, List<TECPTPInfo>>> tpInfoMap = new HashMap<String, Map<List<Integer>, List<TECPTPInfo>>>();

    private TECPTPModelMgr() {
    }

    public static synchronized TECPTPModelMgr getInstance() {
        if (instance == null) {
            instance = new TECPTPModelMgr();
        }
        return instance;
    }

    private static void parsePortXML(int neType, String hostVersion) {
        Document doc = null;
        NodeList nodeList = null;
        NodeList moNodeList = null;
        NodeList tp1NodeList = null;
        Element elementTmp = null;
        Element element = null;
        try {
            StringBuffer path = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH);
            path.append("model").append(File.separator).append("cp_tp_model.xml");
            String filepath = TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath((int)neType, (String)hostVersion, (String)path.toString());
            doc = TEParseXMLFile.parseFile((String)filepath);
            if (null == doc) {
                return;
            }
            HashMap<List<Integer>, List<TECPTPInfo>> tempMap = new HashMap<List<Integer>, List<TECPTPInfo>>();
            tpInfoMap.put(filepath, tempMap);
            nodeList = doc.getElementsByTagName("circuitpack_tp_desc");
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                elementTmp = (Element)nodeList.item(i);
                String cpTypeStr = elementTmp.getAttribute("cp_type");
                List<Integer> cpTypeList = TECPTPModelMgr.getCPTypeList(neType, hostVersion, cpTypeStr);
                moNodeList = elementTmp.getElementsByTagName("port_item");
                if (null == moNodeList || moNodeList.getLength() <= 0) continue;
                int size = moNodeList.getLength();
                for (int index = 0; index < size; ++index) {
                    element = (Element)moNodeList.item(index);
                    tp1NodeList = element.getElementsByTagName("tp1_item");
                    List<TECPTPInfo> tpInfoList = TECPTPModelMgr.handelTPNode(neType, hostVersion, tp1NodeList);
                    tempMap.put(cpTypeList, tpInfoList);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TECPTPModelMgr.parsePortXML() fail!", (Throwable)e);
        }
    }

    private static List<TECPTPInfo> handelTPNode(int neType, String hostVersion, NodeList tp1NodeList) {
        ArrayList<TECPTPInfo> cpTPInfoList = new ArrayList<TECPTPInfo>();
        if (null == tp1NodeList || tp1NodeList.getLength() == 0) {
            return cpTPInfoList;
        }
        Element tp1Element = null;
        Element tp2Element = null;
        Element tp3Element = null;
        NodeList tp2NodeList = null;
        NodeList tp3NodeList = null;
        int size = tp1NodeList.getLength();
        for (int i = 0; i < size; ++i) {
            tp1Element = (Element)tp1NodeList.item(i);
            TECPTPInfo tp1Info = new TECPTPInfo();
            int tp1Type = TECPTPModelMgr.getTPType(neType, hostVersion, tp1Element);
            List<Integer> tp1List = TECPTPModelMgr.getTPList(neType, hostVersion, tp1Element);
            if (tp1Element.hasAttribute("slotMode")) {
                int slotMode = Integer.parseInt(tp1Element.getAttribute("slotMode"));
                tp1Info.setSlotMode(slotMode);
            }
            tp1Info.setTpType(tp1Type);
            tp1Info.addAllTPNO(tp1List);
            tp2NodeList = tp1Element.getElementsByTagName("tp2_item");
            if (null == tp2NodeList || tp2NodeList.getLength() == 0) continue;
            int jSize = tp2NodeList.getLength();
            for (int j = 0; j < jSize; ++j) {
                tp2Element = (Element)tp2NodeList.item(j);
                TECPTPInfo tp2Info = new TECPTPInfo();
                int tp2Type = TECPTPModelMgr.getTPType(neType, hostVersion, tp2Element);
                List<Integer> tp2List = TECPTPModelMgr.getTPList(neType, hostVersion, tp2Element);
                tp2Info.setTpType(tp2Type);
                tp2Info.addAllTPNO(tp2List);
                tp1Info.addSubTp(tp2Info);
                tp3NodeList = tp2Element.getElementsByTagName("tp3_item");
                if (null == tp3NodeList || tp3NodeList.getLength() == 0) continue;
                int kSize = tp3NodeList.getLength();
                for (int k = 0; k < kSize; ++k) {
                    tp3Element = (Element)tp3NodeList.item(k);
                    TECPTPInfo tp3Info = new TECPTPInfo();
                    int tp3Type = TECPTPModelMgr.getTPType(neType, hostVersion, tp3Element);
                    List<Integer> tp3List = TECPTPModelMgr.getTPList(neType, hostVersion, tp3Element);
                    tp3Info.setTpType(tp3Type);
                    tp3Info.addAllTPNO(tp3List);
                    tp2Info.addSubTp(tp3Info);
                }
            }
            cpTPInfoList.add(tp1Info);
        }
        return cpTPInfoList;
    }

    private static int getTPType(int neType, String hostVersion, Element tpElement) {
        String tp1TypeStr = tpElement.getAttribute("tp_type");
        String newStr = tp1TypeStr.substring(1, tp1TypeStr.length() - 1);
        int tpType = SDXMLInterpreterMgr.getInstance().parseInt(newStr);
        return tpType;
    }

    private static List<Integer> getCPTypeList(int neType, String hostVersion, String cpTypeStr) {
        ArrayList<Integer> cpTypeList = new ArrayList<Integer>();
        if (null == cpTypeStr || "".equals(cpTypeStr)) {
            return cpTypeList;
        }
        String newStr = cpTypeStr.substring(1, cpTypeStr.length() - 1);
        if (newStr.contains(",")) {
            String[] cpTypeArr = newStr.split(",");
            for (int i = 0; i < cpTypeArr.length; ++i) {
                Integer cpTypeObj = SDXMLInterpreterMgr.getInstance().parseInt(cpTypeArr[i]);
                if (cpTypeObj == null) continue;
                int cpType = cpTypeObj;
                cpTypeList.add(cpType);
            }
        } else {
            cpTypeList.add(SDXMLInterpreterMgr.getInstance().parseInt(newStr));
        }
        return cpTypeList;
    }

    private static List<Integer> getTPList(int neType, String hostVersion, Element tpElement) {
        String tp1ListStr = tpElement.getAttribute("tp_list");
        ArrayList<Integer> tpList = new ArrayList<Integer>();
        if (null == tp1ListStr || "".equals(tp1ListStr)) {
            tpList.add(1);
            return tpList;
        }
        String newStr = tp1ListStr.substring(1, tp1ListStr.length() - 1);
        if (newStr.contains("-")) {
            String[] tp1ListArr = newStr.split("-");
            int from = Integer.parseInt(tp1ListArr[0]);
            int to = Integer.parseInt(tp1ListArr[1]);
            for (int i = from; i <= to; ++i) {
                tpList.add(i);
            }
        } else {
            tpList.add(Integer.parseInt(newStr));
        }
        return tpList;
    }

    public boolean convertFBList(int neid, int boardType, TELCTFunBlock parent, List result, int fbType) {
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String hostVersion = ne.getHostVersion();
        StringBuffer path = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH);
        path.append("model").append(File.separator).append("cp_tp_model.xml");
        String filePath = TEGetFilePath.getFilePath((int)neType, (String)hostVersion, (String)path.toString());
        if (null == filePath) {
            return false;
        }
        String key = TEResourceManager.getPath() + File.separator + filePath;
        if (!tpInfoMap.containsKey(key)) {
            TECPTPModelMgr.parsePortXML(neType, hostVersion);
        }
        boolean hasConverted = false;
        Map<List<Integer>, List<TECPTPInfo>> temp = tpInfoMap.get(key);
        List<TECPTPInfo> cpInfoList = this.getCPInfoList(boardType, temp);
        if (null == cpInfoList) {
            return hasConverted;
        }
        int slotMode = TESysManagerBean.getInstance().getSlotMode();
        int size = cpInfoList.size();
        for (int i = 0; i < size; ++i) {
            TECPTPInfo tpInfo = cpInfoList.get(i);
            if (fbType != tpInfo.getTpType() || -1 != tpInfo.getSlotMode() && slotMode != tpInfo.getSlotMode()) continue;
            hasConverted = true;
            this.createFB(tpInfo, parent, result);
        }
        return hasConverted;
    }

    private List<TECPTPInfo> getCPInfoList(int boardType, Map<List<Integer>, List<TECPTPInfo>> map) {
        Iterator<Map.Entry<List<Integer>, List<TECPTPInfo>>> iter = map.entrySet().iterator();
        Map.Entry<List<Integer>, List<TECPTPInfo>> entry = null;
        while (iter.hasNext()) {
            entry = iter.next();
            if (!entry.getKey().contains(boardType)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void createFB(TECPTPInfo tpInfo, TELCTFunBlock parent, List result) {
        int fbType = tpInfo.getTpType();
        List<Integer> tpNoList = tpInfo.getTpNOList();
        int len = tpNoList.size();
        for (int listIndex = 0; listIndex < len; ++listIndex) {
            TELCTFunBlock fb2 = new TELCTFunBlock();
            int id = tpNoList.get(listIndex);
            fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(fbType);
            fb2.name = fbType == 91 ? fb2.name + String.format(FB_VC3_NAME_FORMAT, id, 0, 0) : (fbType == 92 ? fb2.name + this.getFBVC12NameStr(parent, id) : fb2.name + "-" + id);
            fb2.functionType = fbType;
            fb2.pid = parent.id;
            fb2.pathid = id;
            fb2.portid = parent.portid;
            fb2.id = parent.id + "-" + result.size();
            fb2.seqenceLevel = parent.seqenceLevel + 1;
            fb2.logicPortInPosition = parent.logicPortInPosition;
            result.add(fb2);
            if (!tpInfo.hasChild()) continue;
            List<TECPTPInfo> subTPList = tpInfo.getSubTpList();
            int size = subTPList.size();
            for (int i = 0; i < size; ++i) {
                TECPTPInfo subTpInfo = subTPList.get(i);
                this.createFB(subTpInfo, fb2, result);
            }
        }
    }

    private String getFBVC12NameStr(TELCTFunBlock parent, int id) {
        int slotMode = TESysManagerBean.getInstance().getSlotMode();
        if (slotMode == 0) {
            int tempInt1 = id % 7;
            int tempInt2 = ((id - 1) / 7 + 1) % 3;
            int tempId = (id - 1) * 3 + parent.pathid;
            return String.format(FB_VC12_NAME_FORMAT, parent.pathid, tempInt1 == 0 ? 7 : tempInt1, tempInt2 == 0 ? 3 : tempInt2, tempId);
        }
        if (slotMode == 1) {
            int tempInt1 = id % 3;
            int tempInt2 = ((id - 1) / 3 + 1) % 7;
            return String.format(FB_VC12_NAME_FORMAT, parent.pathid, tempInt2 == 0 ? 7 : tempInt2, tempInt1 == 0 ? 3 : tempInt1, id);
        }
        return "";
    }
}

