/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00.TECESBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00.TECESBitTestData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;

public class TERefreshTableDataBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        TECESBitTestData testData = TECESBitTestCache.getInstance().getBitTestCache(neid, slotid, portid);
        if (testData != null) {
            this.createRowData(testData, slotid, portid);
            if (0 == testData.getTestState()) {
                TECESBitTestCache.getInstance().delBitTestCache(neid, slotid, portid);
            }
        }
        return this.outputData;
    }

    private void createRowData(TECESBitTestData testData, int slotid, int portid) {
        RowParams row = new RowParams();
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        row.addParam("nename", neObj.getNEName());
        row.addParam("portid", String.valueOf(portid));
        String portname = TEBitTestUtility.getPortName(this.neid, slotid, portid);
        row.addParam("portname", portname);
        row.addParam("direction", String.valueOf(testData.getDirection()));
        int frameset = testData.getFrameset();
        String tmpFrameset = String.valueOf(frameset);
        if (frameset == 255) {
            tmpFrameset = "-";
        }
        row.addParam("frameset", tmpFrameset);
        row.addParam("reportcycle", String.valueOf(testData.getReportcycle()));
        row.addParam("testtime", String.valueOf(testData.getTestTime()));
        row.addParam("starttime", testData.getStartTime());
        String endtime = testData.getCurrentTime();
        if (testData.getStartTimeToLong() > testData.getCurrentTimeToLong()) {
            endtime = "";
        }
        row.addParam("currenttime", endtime);
        row.addParam("progress", testData.getProgress() + "%");
        row.addParam("actualtesttime", String.valueOf(testData.getPasttime()));
        row.addParam("teststate", String.valueOf(testData.getTestState()));
        row.addParam("portmode", testData.getPortMode());
        if (testData.getIsE1PRBSTest() != null && testData.getIsE1PRBSTest().booleanValue()) {
            row.addParam("e1bitNumRate", String.valueOf(testData.getE1_errBitRate()));
            row.addParam("e1errBitNum", String.valueOf(testData.getE1_errBitNum()));
            row.addParam("e1bgErrBit", String.valueOf(testData.getE1_bgErrBit()));
            row.addParam("e1errBitSecond", String.valueOf(testData.getE1_errBitSecond()));
            row.addParam("e1severityErrBitSecond", String.valueOf(testData.getE1_severityErrBitSecond()));
            row.addParam("e1unUsableSecond", String.valueOf(testData.getE1_unUsableSecond()));
            row.addParam("e1unUsableSecond", String.valueOf(testData.getE1_unUsableSecond()));
            row.addParam("isE1PRBSTest", "1");
        } else {
            row.addParam("errBitNum", String.valueOf(testData.getErrBitNum()));
            row.addParam("errBitRate", String.valueOf(testData.getErrBitRate()));
            if (TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_RTN_PRBS", "TE_ATTR_RTN_SUPPORT_PRBS_NEW_ATTR")) {
                row.addParam("bgErrBit", String.valueOf(testData.getBgErrBit()));
                row.addParam("errBitSecond", String.valueOf(testData.getErrBitSecond()));
                row.addParam("severityErrBitSecond", String.valueOf(testData.getSeverityErrBitSecond()));
                row.addParam("unUsableSecond", String.valueOf(testData.getUnUsableSecond()));
            }
            row.addParam("isE1PRBSTest", "0");
        }
        BussinessParams bussiness = new BussinessParams();
        bussiness.addRowParams(row);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(bussiness);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
    }
}

