/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00.TEBitDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class TEQueryTestReportBean
extends TENEExplorerBean {
    private int slotid = -1;
    private TimeZoneDateBean timeTool = null;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    TEResourceUtil resourceUtil;
    private String portMode = "1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int slotid;
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        this.slotid = slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portmode");
        this.portMode = para.getValue();
        if ("0".equals(this.portMode)) {
            subFunc.getQxMapping(0).setContent("NSCMD_CFG_GET_BIT_TEST_RESULT_EX2_WBID");
        } else if ("2".equals(this.portMode)) {
            Param isE1PRBSTest = rowpara.getParam("isE1PRBSTest");
            if (isE1PRBSTest != null && isE1PRBSTest.getValue().equals("1")) {
                subFunc.getQxMapping(0).setContent("NSCMD_CFG_GET_MV_E1PRBS_RESULT_EX");
            } else {
                subFunc.getQxMapping(0).setContent("NSCMD_CFG_GET_IF_BITTEST_RESULT_EX_WBID");
            }
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String STRING_SOURCE = "sdh" + File.separator + "res" + File.separator + "bittest" + File.separator + "bittestres_" + LANGUAGE + ".ini";
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        int opSize = operationList.size();
        this.outputData.setBussinessParams(new BussinessParams());
        Operation tmeoper = null;
        Output[] tmpout = null;
        Output out = null;
        int filterErrCount = 0;
        ArrayList filterList = this.getFilterErrorCodeList();
        int lenj = operationList.size();
        for (int j = 0; j < lenj; ++j) {
            String errcodestr;
            tmeoper = new Operation();
            tmeoper = (Operation)operationList.get(j);
            tmpout = tmeoper.getOutput();
            if (tmpout.length <= 0 || !filterList.contains(Integer.valueOf(errcodestr = (out = tmpout[0]).getFault(0).getCode()))) continue;
            ++filterErrCount;
        }
        ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        RowParams row = null;
        if (!errorData.isEmpty()) {
            row = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                row.addRowErrors(rErrors);
            }
            this.outputData.getBussinessParams().addRowParams(row);
        }
        int errcode = -1;
        if (errorData.isEmpty()) {
            errcode = 0;
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            if (errorData.size() == opSize - filterErrCount) {
                errcode = 2;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                return;
            }
            errcode = 1;
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
        this.timeTool = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        if (errcode != 2) {
            this.addBasicInfo();
        }
        Operation operation = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            Output output = operation.getOutput(0);
            if (!"0".equals(output.getFault(0).getCode())) continue;
            this.handleOperationData(operation);
        }
    }

    private void addBasicInfo() {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        RowParams row = new RowParams();
        row.addParam("reportArr", "nenameres");
        row.addParam("reportVar", neObj.getNEName());
        this.outputData.getBussinessParams().addRowParams(row);
        row = new RowParams();
        row.addParam("reportArr", "slotidres");
        row.addParam("reportVar", String.valueOf(this.slotid));
        this.outputData.getBussinessParams().addRowParams(row);
        String boardName = this.mgr.getBoardName(this.neid, this.slotid);
        row = new RowParams();
        row.addParam("reportArr", "boardnameres");
        row.addParam("reportVar", boardName);
        this.outputData.getBussinessParams().addRowParams(row);
    }

    private void handleOperationData(Operation operation) {
        Output output = null;
        RowParams row = null;
        int countNum = 1;
        int len = operation.getOutputCount();
        for (int i = 0; i < len; ++i) {
            String[] errData;
            output = operation.getOutput(i);
            if (output.getPartCount() < 1) continue;
            int boardType = this.mgr.getBoardType(this.neid, this.slotid);
            String testType = "";
            if (2269 == boardType) {
                if ("NSCMD_CFG_E1_GET_BIT_TEST_RESULT_EX2".equals(operation.getName())) {
                    testType = " (CES)";
                }
                if ("NSCMD_CFG_GET_BIT_TEST_RESULT_EX2_WBID".equals(operation.getName())) {
                    testType = " (PDH)";
                }
            }
            row = new RowParams();
            row.addParam("reportArr", "testresultnores");
            row.addParam("reportVar", countNum + testType);
            ++countNum;
            this.outputData.getBussinessParams().addRowParams(row);
            row = new RowParams();
            row.addParam("reportArr", "portidres");
            row.addParam("reportVar", TEBitTestUtility.getShortPortName(this.neid, this.slotid, Integer.parseInt(output.getPartValue("portid"))));
            this.outputData.getBussinessParams().addRowParams(row);
            Calendar startTimeCa = TEDateUtils.byteStrToCalendar((String)output.getPartValue("starttime"));
            String startTime = this.timeTool.calendarToTime(startTimeCa);
            row = new RowParams();
            row.addParam("reportArr", "starttimeres");
            row.addParam("reportVar", startTime);
            this.outputData.getBussinessParams().addRowParams(row);
            Calendar endTimeCa = TEDateUtils.byteStrToCalendar((String)output.getPartValue("endtime"));
            String endTime = this.timeTool.calendarToTime(endTimeCa);
            int tmpReportcycle = Integer.parseInt(output.getPartValue("reportcycle"));
            row = new RowParams();
            row.addParam("reportArr", "testperiodres");
            String cycleString = this.resourceUtil.getString("reportcycle" + tmpReportcycle);
            row.addParam("reportVar", cycleString);
            this.outputData.getBussinessParams().addRowParams(row);
            int actcycle = Integer.parseInt(output.getPartValue("actcycle"));
            row = new RowParams();
            row.addParam("reportArr", "testtimeres");
            row.addParam("reportVar", String.valueOf(actcycle));
            this.outputData.getBussinessParams().addRowParams(row);
            row = new RowParams();
            row.addParam("reportArr", "endtesttimeres");
            row.addParam("reportVar", endTime);
            this.outputData.getBussinessParams().addRowParams(row);
            int tmpDatatypenum = Integer.parseInt(output.getPartValue("datatypenum"));
            String tmpBitdata = output.getPartValue("bitdata");
            ArrayList<String> errDataNames = new ArrayList<String>();
            if ("2".equals(this.portMode) && output.getPart("pathid") != null && output.getPart("direction") != null) {
                row = new RowParams();
                row.addParam("reportArr", "pathres");
                row.addParam("reportVar", output.getPartValue("pathid"));
                this.outputData.getBussinessParams().addRowParams(row);
                errData = TEBitDataMgr.getE1PRBSErrData(this.neid, tmpDatatypenum, tmpBitdata);
                errDataNames.add("e1_bitNum");
                errDataNames.add("e1_bitNumRate");
                errDataNames.add("e1_errBitSecond");
                errDataNames.add("e1_severityErrBitSecond");
                errDataNames.add("e1_unUsableSecond");
                errDataNames.add("e1_bgErrBit");
                row = new RowParams();
            } else {
                errData = TEBitDataMgr.getNewErrData(this.neid, tmpDatatypenum, tmpBitdata, this.portMode);
                errDataNames.add("biterrnumres");
                errDataNames.add("biterrrateres");
                errDataNames.add("errBitSecondres");
                errDataNames.add("severityErrBitSecondres");
                errDataNames.add("unUsableSecondres");
                errDataNames.add("bgErrBitres");
            }
            for (int j = 0; j < errData.length; ++j) {
                row = new RowParams();
                row.addParam("reportArr", (String)errDataNames.get(j));
                row.addParam("reportVar", errData[j]);
                this.outputData.getBussinessParams().addRowParams(row);
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        errorList.add(38664);
        errorList.add(42165);
        return errorList;
    }
}

