/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.necommon.netimelocalization.TENETimeUtility;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00.TEBitDataMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Calendar;

public class TEQueryPortResultBean
extends TENEExplorerBean {
    private int slotid = -1;
    private TimeZoneDateBean timeTool = null;
    private String portMode = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int slotid;
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        this.slotid = slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portmode");
        this.portMode = para.getValue();
        if ("0".equals(this.portMode)) {
            subFunc.getQxMapping(0).setContent("NSCMD_CFG_GET_BIT_TEST_RESULT_EX2_WBID");
        } else if ("2".equals(this.portMode)) {
            Param isE1PRBSTest = rowpara.getParam("isE1PRBSTest");
            if (isE1PRBSTest != null && isE1PRBSTest.getValue().equals("1")) {
                subFunc.getQxMapping(0).setContent("NSCMD_CFG_GET_MV_E1PRBS_RESULT_EX");
            } else {
                subFunc.getQxMapping(0).setContent("NSCMD_CFG_GET_IF_BITTEST_RESULT_EX_WBID");
            }
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        long neTime = TENETimeUtility.getNEDateTime((int)neid, (ArrayList)operationList);
        ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || 0 == operationList.size()) {
            return;
        }
        boolean succ = false;
        boolean row_succ = false;
        boolean fault = false;
        RowParams rowparams = null;
        Output output = null;
        this.outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            if (operation.getOutputCount() > 0) {
                output = operation.getOutput(0);
                row_succ = TEDataConverter.handleRowError((Output)output, filterErrorCodeList);
            }
            if (!row_succ) continue;
            succ = true;
            boolean flag = true;
            int outputIndex = -1;
            long startTime = -1L;
            this.timeTool = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(0).getCode()))) {
                    flag = false;
                    break;
                }
                Calendar startTimeCa = TEDateUtils.byteStrToCalendar((String)output.getPartValue("starttime"));
                long tmpStartTime = startTimeCa.getTime().getTime();
                if (tmpStartTime <= startTime) continue;
                startTime = tmpStartTime;
                outputIndex = row;
            }
            if (!flag) break;
            rowparams = new RowParams();
            output = operation.getOutput(outputIndex);
            this.handleRowData(neid, rowparams, output, neTime);
            flag = false;
            if (0 == rowparams.getParamCount()) continue;
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        if (null != errorData && 0 != errorData.size()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }

    private void handleRowData(int neid, RowParams row, Output out, long neTime) {
        String[] errData;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        boolean isE1PRBSTest = false;
        row.addParam("nename", neObj.getNEName());
        String portid = out.getPartValue("portid");
        row.addParam("portid", portid);
        String portname = TEBitTestUtility.getPortName(neid, this.slotid, Integer.parseInt(portid));
        row.addParam("portname", portname);
        String direction = "-";
        if (!"2".equals(this.portMode)) {
            direction = out.getPartValue("direction");
            if ("0".equals(this.portMode) && "1".equals(direction)) {
                direction = String.valueOf(3);
            }
        } else if (out.getPart("direction") != null) {
            direction = out.getPartValue("direction");
            isE1PRBSTest = true;
        }
        row.addParam("direction", direction);
        String frameset = "-";
        if (out.getPart("frameset") != null && out.getPartValue("frameset") != null) {
            frameset = out.getPartValue("frameset");
        }
        row.addParam("frameset", frameset);
        row.addParam("reportcycle", out.getPartValue("reportcycle"));
        Calendar startTimeCa = TEDateUtils.byteStrToCalendar((String)out.getPartValue("starttime"));
        String startTime = this.timeTool.calendarToTime(startTimeCa);
        row.addParam("starttime", startTime);
        long starttime = TEDateUtils.TEUTC2UTC((Calendar)startTimeCa);
        Calendar endTimeCa = TEDateUtils.byteStrToCalendar((String)out.getPartValue("endtime"));
        String endTime = this.timeTool.calendarToTime(endTimeCa);
        row.addParam("currenttime", endTime);
        int progress = Integer.parseInt(out.getPartValue("progress"));
        row.addParam("progress", progress + "%");
        int tmpReportcycle = Integer.parseInt(out.getPartValue("reportcycle"));
        int actcycle = Integer.parseInt(out.getPartValue("actcycle"));
        row.addParam("actualtesttime", String.valueOf(actcycle));
        row.addParam("testtime", String.valueOf(actcycle));
        String teststate = "-1";
        if (progress > 0 && progress < 100) {
            teststate = "1";
        } else if (progress == 100) {
            teststate = "0";
        }
        row.addParam("teststate", teststate);
        row.addParam("portmode", this.portMode);
        int tmpDatatypenum = Integer.parseInt(out.getPartValue("datatypenum"));
        String tmpBitdata = out.getPartValue("bitdata");
        if (isE1PRBSTest) {
            errData = TEBitDataMgr.getE1PRBSErrData(neid, tmpDatatypenum, tmpBitdata);
            row.addParam("e1errBitNum", errData[0]);
            row.addParam("e1bitNumRate", errData[1]);
            row.addParam("e1errBitSecond", errData[2]);
            row.addParam("e1severityErrBitSecond", errData[3]);
            row.addParam("e1unUsableSecond", errData[4]);
            row.addParam("e1bgErrBit", errData[5]);
            row.addParam("isE1PRBSTest", "1");
        } else {
            errData = TEBitDataMgr.getNewErrData(neid, tmpDatatypenum, tmpBitdata, this.portMode);
            row.addParam("errBitNum", errData[0]);
            row.addParam("errBitRate", errData[1]);
            if (TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_RTN_PRBS", "TE_ATTR_RTN_SUPPORT_PRBS_NEW_ATTR") && errData.length == 6) {
                row.addParam("errBitSecond", errData[2]);
                row.addParam("severityErrBitSecond", errData[3]);
                row.addParam("unUsableSecond", errData[4]);
                row.addParam("bgErrBit", errData[5]);
            }
            row.addParam("isE1PRBSTest", "0");
        }
        int pathid = -1;
        Part p = out.getPart("pathid");
        if (p != null && p.getValue() != null) {
            pathid = Integer.parseInt(p.getValue());
        }
        String hashvalue = TEBitTestUtility.getPortName(neid, this.slotid, Integer.parseInt(portid), pathid);
        TEBitTestData testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
        if (null == testdata) {
            testdata = new TEBitTestData(neid);
            testdata.setNeid(neid);
            testdata.setSlotid(this.slotid);
            testdata.setPortid(Integer.parseInt(portid));
            testdata.setTimeUnit(tmpReportcycle);
            testdata.setTesttime(actcycle);
            testdata.setStartTime(starttime);
            testdata.setProgress(0);
            testdata.setNeToNmsTime(neTime - TENETimeUtility.getNmsUTCTime());
            testdata.setTeststate(0);
            testdata.refreshdata(1, Long.parseLong(errData[0]));
            TEBitTestCache.getInstance().addCahce(hashvalue, testdata);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        return errorList;
    }
}

