/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.necommon.netimelocalization.TENETimeUtility;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00.TECESBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00.TECESBitTestData;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.Calendar;

public class TEBitDataMgr {
    public static void handleReportRowData(int neid, Output output, String portMode) {
        TECESBitTestData bitCache;
        int tmpReportcycle;
        int tmpSlotid = Integer.parseInt(output.getPartValue("slotid"));
        int tmpPortid = Integer.parseInt(output.getPartValue("portid"));
        int tmpPasttime = Integer.parseInt(output.getPartValue("pasttime"));
        Calendar starttime = TEDateUtils.byteStrToCalendar((String)output.getPartValue("starttime"));
        long tmpStarttime = starttime.getTime().getTime();
        Calendar currenttime = TEDateUtils.byteStrToCalendar((String)output.getPartValue("currenttime"));
        long tmpCurrenttime = currenttime.getTime().getTime();
        int tmpProgress = Integer.parseInt(output.getPartValue("progress"));
        int tmpDatatypenum = Integer.parseInt(output.getPartValue("datatypenum"));
        String tmpBitdata = output.getPartValue("bitdata");
        String tmpErrBitNum = "0";
        String tmpErrBitRate = "0";
        String bgErrBit = "0";
        String errBitSecond = "0";
        String severityErrBitSecond = "0";
        String unUsableSecond = "0";
        String[] errData = TEBitDataMgr.getNewErrData(neid, tmpDatatypenum, tmpBitdata, portMode);
        tmpErrBitNum = errData[0];
        tmpErrBitRate = errData[1];
        if (TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_RTN_PRBS", "TE_ATTR_RTN_SUPPORT_PRBS_NEW_ATTR") && errData.length == 6) {
            errBitSecond = errData[2];
            severityErrBitSecond = errData[3];
            unUsableSecond = errData[4];
            bgErrBit = errData[5];
        }
        if ((tmpReportcycle = Integer.parseInt(output.getPartValue("reportcycle"))) == 2 || tmpReportcycle == 3) {
            tmpPasttime = 60 * tmpPasttime;
        }
        long milliseconds = (currenttime.getTimeInMillis() - starttime.getTimeInMillis()) / 1000L;
        int convertTime = TEBitDataMgr.convertTestTime(tmpReportcycle, milliseconds);
        if (tmpReportcycle == 1) {
            convertTime = tmpPasttime;
        }
        if ((bitCache = TECESBitTestCache.getInstance().getBitTestCache(neid, tmpSlotid, tmpPortid)) != null) {
            bitCache.setPasttime(tmpPasttime);
            bitCache.setTestTime(convertTime);
            bitCache.setStartTime(tmpStarttime);
            bitCache.setCurrentTime(tmpCurrenttime);
            bitCache.setProgress(tmpProgress);
            bitCache.setErrBitNum(tmpErrBitNum);
            bitCache.setErrBitRate(tmpErrBitRate);
            bitCache.setBgErrBit(bgErrBit);
            bitCache.setErrBitSecond(errBitSecond);
            bitCache.setSeverityErrBitSecond(severityErrBitSecond);
            bitCache.setUnUsableSecond(unUsableSecond);
            if (tmpProgress >= 100) {
                bitCache.setTestState(0);
            }
            if ("0".equals(portMode)) {
                int tmpServicelevel = Integer.parseInt(output.getPartValue("servicelevel"));
                int tmpTimeslot = Integer.parseInt(output.getPartValue("timeslot"));
                bitCache.setServicelevel(tmpServicelevel);
                bitCache.setTimeslot(tmpTimeslot);
            }
        } else {
            int tmpDirection = -1;
            if (TEBitDataMgr.isValidPart(output, "direction")) {
                tmpDirection = Integer.parseInt(output.getPartValue("direction"));
            }
            int tmpFrameset = -1;
            if (TEBitDataMgr.isValidPart(output, "frameset")) {
                tmpFrameset = Integer.parseInt(output.getPartValue("frameset"));
            }
            int tmpTestState = 1;
            bitCache = new TECESBitTestData(neid, tmpPortid, tmpDirection, tmpFrameset, tmpReportcycle, convertTime, tmpStarttime, tmpCurrenttime, portMode);
            bitCache.setPasttime(tmpPasttime);
            bitCache.setProgress(tmpProgress);
            bitCache.setErrBitNum(tmpErrBitNum);
            bitCache.setErrBitRate(tmpErrBitRate);
            bitCache.setBgErrBit(bgErrBit);
            bitCache.setErrBitSecond(errBitSecond);
            bitCache.setSeverityErrBitSecond(severityErrBitSecond);
            bitCache.setUnUsableSecond(unUsableSecond);
            if (tmpProgress >= 100) {
                tmpTestState = 0;
            }
            bitCache.setTestState(tmpTestState);
            if ("0".equals(portMode)) {
                int tmpServicelevel = Integer.parseInt(output.getPartValue("servicelevel"));
                int tmpTimeslot = Integer.parseInt(output.getPartValue("timeslot"));
                bitCache.setServicelevel(tmpServicelevel);
                bitCache.setTimeslot(tmpTimeslot);
            }
            TECESBitTestCache.getInstance().addBitTestCache(neid, tmpSlotid, tmpPortid, bitCache);
        }
        TEBitDataMgr.handleImageData(neid, output, Long.valueOf(tmpErrBitNum));
    }

    public static void handleImageData(int neid, Output output, long errnum) {
        int slotid = Integer.parseInt(output.getPartValue("slotid"));
        int portid = Integer.parseInt(output.getPartValue("portid"));
        int testtime = Integer.parseInt(output.getPartValue("pasttime"));
        Calendar starttime = TEDateUtils.byteStrToCalendar((String)output.getPartValue("starttime"));
        long tmpStarttime = starttime.getTime().getTime();
        int pathid = -1;
        Part p = output.getPart("pathid");
        if (p != null && p.getValue() != null) {
            pathid = Integer.parseInt(p.getValue());
        }
        String hashvalue = TEBitTestUtility.getPortName(neid, slotid, portid, pathid);
        TEBitTestData testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
        if (testdata == null) {
            return;
        }
        testdata.setStartTime(tmpStarttime);
        testdata.setNeToNmsTime(tmpStarttime - TENETimeUtility.getNmsUTCTime());
        if (testdata.getTeststate() != 1) {
            return;
        }
        if (errnum <= 0L) {
            errnum = 0L;
        }
        testdata.refreshdata(testtime, errnum);
    }

    public static boolean isValidPart(Output out, String partid) {
        boolean flag = false;
        if (null != out.getPart(partid) && null != out.getPart(partid).getValue() && !out.getPart(partid).getValue().isEmpty()) {
            flag = true;
        }
        return flag;
    }

    public static int convertTestTime(int tmpReportcycle, long tmpActualTestTime) {
        long testTime = 0L;
        if (2 == tmpReportcycle) {
            long remain = tmpActualTestTime % 600L;
            long full = tmpActualTestTime / 600L;
            testTime = remain != 0L ? full + 1L : full;
        } else if (3 == tmpReportcycle) {
            long remain = tmpActualTestTime % 3600L;
            long full = tmpActualTestTime / 3600L;
            testTime = remain != 0L ? full + 1L : full;
        } else {
            testTime = tmpActualTestTime;
        }
        return Integer.parseInt(testTime + "");
    }

    public static int convertDataType(String arr) {
        String dataType = arr.substring(0, 2);
        return Integer.parseInt(dataType, 16);
    }

    public static long convertDataValue(String arr) {
        String dataType = arr.substring(2, 10);
        return Long.parseLong(dataType, 16);
    }

    public static String[] getErrData(int neid, int dataTypeNum, String bitData) {
        String[] errData = new String[dataTypeNum];
        int tmpDataType = -1;
        for (int j = 1; j <= dataTypeNum; ++j) {
            String eachTypeData = bitData.substring((j - 1) * 10, j * 10);
            tmpDataType = TEBitDataMgr.convertDataType(eachTypeData);
            if (1 == tmpDataType) {
                errData[0] = String.valueOf(TEBitDataMgr.convertDataValue(eachTypeData));
                continue;
            }
            if (2 == tmpDataType) {
                errData[1] = TEBitDataMgr.convertErrNum(neid, TEBitDataMgr.convertDataValue(eachTypeData));
                continue;
            }
            errData[j - 1] = String.valueOf(TEBitDataMgr.convertDataValue(eachTypeData));
        }
        if (errData[0] == null) {
            errData[0] = "0";
            errData[1] = TEBitDataMgr.convertErrNum(neid, 0L);
            if (dataTypeNum == 6) {
                errData[2] = "0";
                errData[3] = "0";
                errData[4] = "0";
                errData[5] = "0";
            }
        }
        return errData;
    }

    public static String[] getNewErrData(int neid, int dataTypeNum, String bitData, String portMode) {
        return TEBitDataMgr.getErrData(neid, dataTypeNum, bitData);
    }

    public static String convertErrNum(int neid, long errNum) {
        return errNum + "E-10";
    }

    public static boolean isCESBoard(int neid, int slotid) {
        boolean flag = false;
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int boardType = mgr.getBoardType(neid, slotid);
        if (2274 == boardType || 2273 == boardType) {
            flag = true;
        }
        return flag;
    }

    public static boolean isInvalid(int neid, long bitdata) {
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        return 92 == neObj.getNEType() ? 0xFFFFFFL == bitdata : 0xFFFFFFFFL == bitdata;
    }

    public static String[] getE1PRBSErrData(int neid, int dataTypeNum, String bitData) {
        return TEBitDataMgr.getIFPRBSErrData(neid, dataTypeNum, bitData);
    }

    public static String[] getIFPRBSErrData(int neid, int dataTypeNum, String bitData) {
        return TEBitDataMgr.getErrData(neid, dataTypeNum, bitData);
    }

    public static void handleE1ReportRowData(int neid, Output output, String portMode) {
        TECESBitTestData bitCache;
        int tmpSlotid = Integer.parseInt(output.getPartValue("slotid"));
        int tmpPortid = Integer.parseInt(output.getPartValue("portid"));
        int tmpPasttime = Integer.parseInt(output.getPartValue("pasttime"));
        Calendar starttime = TEDateUtils.byteStrToCalendar((String)output.getPartValue("starttime"));
        long tmpStarttime = starttime.getTime().getTime();
        Calendar currenttime = TEDateUtils.byteStrToCalendar((String)output.getPartValue("currenttime"));
        long tmpCurrenttime = currenttime.getTime().getTime();
        int tmpProgress = Integer.parseInt(output.getPartValue("progress"));
        int tmpDatatypenum = Integer.parseInt(output.getPartValue("datatypenum"));
        String tmpBitdata = output.getPartValue("bitdata");
        String[] data = new String[tmpDatatypenum];
        data = TEBitDataMgr.getE1PRBSErrData(neid, tmpDatatypenum, tmpBitdata);
        int tmpReportcycle = Integer.parseInt(output.getPartValue("reportcycle"));
        if (tmpReportcycle == 2 || tmpReportcycle == 3) {
            tmpPasttime = 60 * tmpPasttime;
        }
        long milliseconds = (currenttime.getTimeInMillis() - starttime.getTimeInMillis()) / 1000L;
        int convertTime = TEBitDataMgr.convertTestTime(tmpReportcycle, milliseconds);
        if (tmpReportcycle == 1) {
            convertTime = tmpPasttime;
        }
        if ((bitCache = TECESBitTestCache.getInstance().getBitTestCache(neid, tmpSlotid, tmpPortid)) != null) {
            bitCache.setPasttime(tmpPasttime);
            bitCache.setTestTime(convertTime);
            bitCache.setStartTime(tmpStarttime);
            bitCache.setCurrentTime(tmpCurrenttime);
            bitCache.setProgress(tmpProgress);
            bitCache.setE1_errBitNum(data[0]);
            bitCache.setE1_errBitRate(data[1]);
            bitCache.setE1_errBitSecond(data[2]);
            bitCache.setE1_severityErrBitSecond(data[3]);
            bitCache.setE1_unUsableSecond(data[4]);
            bitCache.setE1_bgErrBit(data[5]);
            if (tmpProgress >= 100) {
                bitCache.setTestState(0);
            }
        } else {
            int tmpDirection = -1;
            if (TEBitDataMgr.isValidPart(output, "direction")) {
                tmpDirection = Integer.parseInt(output.getPartValue("direction"));
            }
            int tmpFrameset = -1;
            if (TEBitDataMgr.isValidPart(output, "frameset")) {
                tmpFrameset = Integer.parseInt(output.getPartValue("frameset"));
            }
            int tmpTestState = 1;
            bitCache = new TECESBitTestData(neid, tmpPortid, tmpDirection, tmpFrameset, tmpReportcycle, convertTime, tmpStarttime, tmpCurrenttime, portMode, true);
            bitCache.setPasttime(tmpPasttime);
            bitCache.setProgress(tmpProgress);
            bitCache.setE1_errBitNum(data[0]);
            bitCache.setE1_errBitRate(data[1]);
            bitCache.setE1_errBitSecond(data[2]);
            bitCache.setE1_severityErrBitSecond(data[3]);
            bitCache.setE1_unUsableSecond(data[4]);
            bitCache.setE1_bgErrBit(data[5]);
            if (tmpProgress >= 100) {
                tmpTestState = 0;
            }
            bitCache.setTestState(tmpTestState);
            TECESBitTestCache.getInstance().addBitTestCache(neid, tmpSlotid, tmpPortid, bitCache);
        }
        TEBitDataMgr.handleImageData(neid, output, Long.valueOf(data[0]));
    }
}

