/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.nemgr.necommon.netimelocalization.TENETimeUtility;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;

public class TEQueryRTNBitTestBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "sdh" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "bittest" + File.separator + "bittestres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        String des = "";
        RowParams rowpara = this.inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        des = des + this.resourceUtil.getString("slot") + slotid + "," + this.resourceUtil.getString("port") + portid;
        return des;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList operationList = super.getOperation(neid, subFunc, inputData, memeryData);
        operationList = TENETimeUtility.appendNEDateTimeOperation((int)neid, (ArrayList)operationList);
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        long neTime = TENETimeUtility.getNEDateTime((int)neid, (ArrayList)operationList);
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        TEBitTestData testdata = null;
        int len = outputArr.length;
        for (int j = 0; j < len; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode == 38662) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return;
            }
            if (retCode != 0) {
                this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
                return;
            }
            if (j == 0) {
                Part p = output.getPart("slotid");
                int slot = Integer.parseInt(p.getValue());
                p = output.getPart("portid");
                int port = Integer.parseInt(p.getValue());
                String hashvalue = TEBitTestUtility.getPortName(neid, slot, port);
                testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
                if (testdata != null) {
                    testdata.init();
                } else {
                    testdata = new TEBitTestData(neid);
                    int slotid = Integer.parseInt(output.getPart("slotid").getValue());
                    testdata.setSlotid(slotid);
                    int portid = Integer.parseInt(output.getPart("portid").getValue());
                    testdata.setPortid(portid);
                    int timeunit = Integer.parseInt(output.getPart("timeunit").getValue());
                    testdata.setTimeUnit(timeunit);
                    Calendar startTime = TEDateUtils.byteStrToCalendar((String)output.getPart("starttime").getValue());
                    testdata.setStartTime(startTime.getTimeInMillis());
                    int testtime = Integer.parseInt(output.getPart("testtime").getValue());
                    testdata.setTesttime(testtime);
                    testdata.setNeToNmsTime(neTime - TENETimeUtility.getNmsUTCTime());
                    hashvalue = TEBitTestUtility.getPortName(neid, slotid, portid);
                    TEBitTestCache.getInstance().addCahce(hashvalue, testdata);
                }
            }
            int firstpoint = Integer.parseInt(output.getPart("firstpoint").getValue());
            Part p = output.getPart("errdata");
            String value = p.getValue();
            int num = value.length() / 8;
            int index = 0;
            for (int i = 0; i < num; ++i) {
                long errnum = new BigInteger(value.substring(index, index + 8), 16).longValue();
                index += 8;
                if (errnum <= 0L) {
                    errnum = 0L;
                }
                testdata.addQueryResult(errnum, firstpoint);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }
}

