/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.nemgr.necommon.netimelocalization.TENETimeUtility;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class TEQueryNormalBitTestBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "sdh" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "bittest" + File.separator + "bittestres_" + LANGUAGE + ".ini";
    private static final String ATM_VC12 = "3";
    private TEResourceUtil resourceUtil = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        String des = "";
        RowParams rowpara = this.inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        des = des + this.resourceUtil.getString("slot") + slotid + "," + this.resourceUtil.getString("port") + portid;
        para = rowpara.getParam("vc4");
        if (para != null && para.getValue() != null) {
            int pathid = Integer.parseInt(para.getValue());
            des = des + this.resourceUtil.getString("channel") + pathid;
        }
        return des;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        inputData.getBussinessParams().getRowParams(0).addParam("level", this.getLevel(neid, inputData));
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("isbranch");
        if (null != param && "false".equalsIgnoreCase(param.getValue()) && subFunc.getQxMapping(0).getContent().equals("NSCMD_CFG_GET_BIT_TEST_RESULT") && null != TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_BIT_TEST_RESULT_SDH")) {
            subFunc.removeQxMapping(subFunc.getQxMapping(0));
            subFunc.addQxMapping(new QxMapping("NSCMD_CFG_GET_BIT_TEST_RESULT_SDH"));
        }
        this.operationList = TENETimeUtility.appendNEDateTimeOperation((int)neid, (ArrayList)TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid));
        return this.operationList;
    }

    public String getLevel(int neid, Datainterface inputData) {
        int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int portid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("portid").getValue());
        TEConfigurationDataMgr instace = TEConfigurationDataMgr.getInstance();
        int boardtype = instace.getBoardType(neid, slotid);
        if (TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "SDH_ATTR_SUPPORT_ATM_PRBS")) {
            return ATM_VC12;
        }
        int interfaceLevel = instace.getPortIterfaceLevel(neid, boardtype, portid);
        switch (interfaceLevel) {
            case 4099: {
                return "1";
            }
        }
        return "0";
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        long neTime = TENETimeUtility.getNEDateTime((int)neid, (ArrayList)operationList);
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        TEBitTestData testdata = null;
        int len = outputArr.length;
        for (int j = 0; j < len; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode == 38662) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return;
            }
            if (retCode != 0) {
                this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
                return;
            }
            if (j == 0) {
                TEBitTestData oldData;
                testdata = new TEBitTestData(neid);
                int slotid = Integer.parseInt(output.getPart("slotid").getValue());
                testdata.setSlotid(slotid);
                int portid = Integer.parseInt(output.getPart("portid").getValue());
                testdata.setPortid(portid);
                int pathid = -1;
                if (null != output.getPart("vc4")) {
                    pathid = Integer.parseInt(output.getPart("vc4").getValue());
                }
                testdata.setPathid(pathid);
                Part direcpart = output.getPart("direction");
                if (direcpart != null) {
                    int direction = Integer.parseInt(direcpart.getValue());
                    testdata.setDirection(direction);
                }
                int timeunit = Integer.parseInt(output.getPart("timeunit").getValue());
                testdata.setTimeUnit(timeunit);
                Calendar startTime = TEDateUtils.byteStrToCalendar((String)output.getPart("starttime").getValue());
                if (startTime == null) continue;
                testdata.setStartTime(startTime.getTimeInMillis());
                int testtime = Integer.parseInt(output.getPart("testtime").getValue());
                testdata.setTesttime(testtime);
                testdata.setNeToNmsTime(neTime - TENETimeUtility.getNmsUTCTime());
                String hashvalue = TEBitTestUtility.getPortName(neid, slotid, portid, pathid);
                if (TEBitTestCache.getInstance().containKey(hashvalue) && (oldData = TEBitTestCache.getInstance().getCahce(hashvalue)) != null) {
                    testdata.setAccumulation(oldData.isAccumulation());
                }
                TEBitTestCache.getInstance().addCahce(hashvalue, testdata);
            }
            int firstpoint = Integer.parseInt(output.getPart("firstpoint").getValue());
            Part p = output.getPart("errdata");
            String value = p.getValue();
            if (value == null) continue;
            int num = value.length() / 8;
            int index = 0;
            for (int i = 0; i < num; ++i) {
                long errnum = Long.parseLong(value.substring(index, index + 8), 16);
                index += 8;
                if (errnum <= 0L) {
                    errnum = 0L;
                }
                testdata.addQueryResult(errnum, firstpoint);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }
}

