/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TESpecialAppInterface;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEExportPRBSTestReport
implements TESpecialAppInterface {
    private static final String path = "sdh" + File.separator + "conf" + File.separator + "bittest_u2kv1r3c00" + File.separator + "prbstestreport_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static TEResourceUtil resource;
    private static final String lineSep;
    private static final int COL_SPACE = 4;

    public void performBussinessProcess(HttpServletRequest request, HttpServletResponse response) {
        int neid = Integer.valueOf(request.getParameter("neid"));
        int slotid = Integer.valueOf(request.getParameter("slotid"));
        int port = Integer.valueOf(request.getParameter("port"));
        resource = TEGetFilePath.getResource((int)neid, (String)path);
        String key = TEBitTestUtility.getPortName(neid, slotid, port);
        TEBitTestData testData = TEBitTestCache.getInstance().getCahce(key);
        if (testData == null) {
            this.exportReport(response, resource.getString("nodata"));
            return;
        }
        PRBSTestDataBean dataBean = this.getPRBSTestData(request, testData);
        Map<String, String> tableHeadObjs = this.getTableHead(dataBean);
        StringBuilder cont = new StringBuilder("");
        cont.append(this.getTitleCont(tableHeadObjs));
        cont.append(this.getTabHeadCont(tableHeadObjs));
        cont.append(this.getTabBodyCont(dataBean, tableHeadObjs, neid));
        this.exportReport(response, cont.toString());
    }

    private PRBSTestDataBean getPRBSTestData(HttpServletRequest request, TEBitTestData testData) {
        int neid = Integer.valueOf(request.getParameter("neid"));
        int slotid = Integer.valueOf(request.getParameter("slotid"));
        int port = Integer.valueOf(request.getParameter("port"));
        String linkID = request.getParameter("linkID");
        String errRate = request.getParameter("errRate");
        String key = TEBitTestUtility.getPortName(neid, slotid, port);
        TEConfigurationDataMgr cfDataMgr = TEConfigurationDataMgr.getInstance();
        PRBSTestDataBean dataBean = new PRBSTestDataBean();
        TEBoard board = cfDataMgr.getBoard(neid, slotid);
        dataBean.setBoardType(board.getBoardType());
        TENE tene = cfDataMgr.getNE(neid);
        dataBean.setNeIp(this.getNEGWAddressIp(tene));
        dataBean.setPortName(key);
        dataBean.setStartTime(testData.getStartTimeToLong());
        dataBean.setUnit(testData.getTimeUnit());
        dataBean.setTestTotalErrBits(TEBitTestUtility.getTotalErrNum(testData));
        dataBean.setTestTotalTime(this.getRealTestTotalTime(testData));
        dataBean.setInvalidCount(TEBitTestUtility.getInvalidPeriodCount(testData));
        dataBean.setLinkId(linkID);
        dataBean.setErrBitRate(errRate);
        return dataBean;
    }

    protected String getNEGWAddressIp(TENE currentNE) {
        if (currentNE == null) {
            return "/";
        }
        String neIP = currentNE.getNeIp();
        if (neIP == null || neIP.equals("")) {
            neIP = currentNE.getNEGWAddress();
        }
        return neIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportReport(HttpServletResponse response, String cont) {
        FilterOutputStream bos = null;
        try {
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment; filename=\"TestReport.txt\"");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            response.setHeader("Cache-Control", "public");
            ServletOutputStream out = response.getOutputStream();
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] tmp = cont.getBytes();
            ((BufferedOutputStream)bos).write(tmp, 0, tmp.length);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error(e.getMessage());
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("Close stream failed");
            }
        }
    }

    private long getRealTestTotalTime(TEBitTestData data) {
        int testTimes = TEBitTestUtility.getTotalTestPeriodCount(data) - TEBitTestUtility.getInvalidPeriodCount(data);
        return (long)testTimes * TEBitTestUtility.getTotalSecondsPerPeriod(data);
    }

    private Map<String, String> getTableHead(PRBSTestDataBean dataBean) {
        HashMap<String, String> headObjs = new HashMap<String, String>();
        headObjs.put("port", this.getValidTabHeadText(resource.getString("tbHead_port"), dataBean.getPortName()));
        headObjs.put("linkID", this.getValidTabHeadText(resource.getString("tbHead_linkID"), String.valueOf(dataBean.getLinkId())));
        headObjs.put("gateWayIP", this.getValidTabHeadText(resource.getString("tbHead_gateWayIP"), dataBean.getNeIp()));
        headObjs.put("startTime", this.getValidTabHeadText(resource.getString("tbHead_startTime"), dataBean.getStartTime()));
        headObjs.put("periodUnit", this.getValidTabHeadText(resource.getString("tbHead_periodUnit"), dataBean.getUnit()));
        headObjs.put("testTotalTime", this.getValidTabHeadText(resource.getString("tbHead_testTotalTime"), String.valueOf(dataBean.getTestTotalTime())));
        headObjs.put("testTotalErrBits", this.getValidTabHeadText(resource.getString("tbHead_testTotalErrBits"), String.valueOf(dataBean.getTestTotalErrBits())));
        headObjs.put("errBitRate", this.getValidTabHeadText(resource.getString("tbHead_errBitRate"), dataBean.getErrBitRate()));
        headObjs.put("invalidCount", resource.getString("tbHead_invalidCount"));
        return headObjs;
    }

    private String getValidTabHeadText(String tabHead, String tabCont) {
        int length2;
        int spaceCount = 4;
        int length1 = this.getStrLength(tabCont);
        if (length1 > (length2 = this.getStrLength(tabHead))) {
            spaceCount = length1 + 4 - length2;
        }
        return this.addSpecialCharStr(tabHead, " ", spaceCount, false);
    }

    private String getTitleCont(Map<String, String> tabHeadObjs) {
        StringBuilder cont = new StringBuilder("");
        Set<String> keys = tabHeadObjs.keySet();
        int totalLength = 0;
        for (String key : keys) {
            totalLength += this.getStrLength(tabHeadObjs.get(key));
        }
        String title = resource.getString("title");
        int spaceLength = (totalLength - this.getStrLength(title)) / 2;
        cont.append(this.addSpecialCharStr(title, " ", spaceLength, true)).append(lineSep);
        cont.append(this.addSpecialCharStr("", "*", totalLength, true)).append(lineSep);
        return cont.toString();
    }

    private String getTabHeadCont(Map<String, String> tabHeadObjs) {
        StringBuilder cont = new StringBuilder("");
        cont.append(tabHeadObjs.get("port"));
        cont.append(tabHeadObjs.get("linkID"));
        cont.append(tabHeadObjs.get("gateWayIP"));
        cont.append(tabHeadObjs.get("startTime"));
        cont.append(tabHeadObjs.get("periodUnit"));
        cont.append(tabHeadObjs.get("testTotalTime"));
        cont.append(tabHeadObjs.get("testTotalErrBits"));
        cont.append(tabHeadObjs.get("errBitRate"));
        cont.append(tabHeadObjs.get("invalidCount"));
        cont.append(lineSep);
        return cont.toString();
    }

    private String getTabBodyCont(PRBSTestDataBean dataBean, Map<String, String> tabHeadObjs, int neid) {
        StringBuilder cont = new StringBuilder("");
        String str = dataBean.getPortName();
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("port")) - this.getStrLength(str), false));
        str = dataBean.getLinkId();
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("linkID")) - this.getStrLength(str), false));
        str = String.valueOf(dataBean.getNeIp());
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("gateWayIP")) - this.getStrLength(str), false));
        Calendar startTime = Calendar.getInstance();
        startTime.setTimeInMillis(dataBean.getStartTimeLong());
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        str = timezonebean.calendarToTime(startTime);
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("startTime")) - this.getStrLength(str), false));
        str = dataBean.getUnit();
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("periodUnit")) - this.getStrLength(str), false));
        str = String.valueOf(dataBean.getTestTotalTime());
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("testTotalTime")) - this.getStrLength(str), false));
        str = String.valueOf(dataBean.getTestTotalErrBits());
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("testTotalErrBits")) - this.getStrLength(str), false));
        str = dataBean.getErrBitRate();
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("errBitRate")) - this.getStrLength(str), false));
        str = String.valueOf(dataBean.getInvalidCount());
        cont.append(this.addSpecialCharStr(str, " ", this.getStrLength(tabHeadObjs.get("invalidCount")) - this.getStrLength(str), false));
        cont.append(lineSep);
        return cont.toString();
    }

    private String addSpecialCharStr(String str, String ch, int length, boolean positon) {
        if (length <= 0) {
            return "";
        }
        StringBuilder res = new StringBuilder("");
        for (int i = 0; i < length; ++i) {
            res.append(ch);
        }
        if (!positon) {
            return str.concat(res.toString());
        }
        res.append(str);
        return res.toString();
    }

    private int getStrLength(String value) {
        char[] charr = value.toCharArray();
        int length = 0;
        for (char ch : charr) {
            if (ch > '\u0080') {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    static {
        lineSep = System.getProperty("line.separator");
    }

    private class PRBSTestDataBean {
        private String linkId;
        private String neIp;
        private int boardType;
        private String portName;
        private long startTime;
        private int unit;
        private long testTotalTime;
        private long testTotalErrBits;
        private String errBitRate;
        private int invalidCount;

        private PRBSTestDataBean() {
        }

        public String getLinkId() {
            return this.linkId;
        }

        public void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        public String getNeIp() {
            return this.neIp;
        }

        public void setNeIp(String neIp) {
            this.neIp = neIp;
        }

        public int getBoardType() {
            return this.boardType;
        }

        public void setBoardType(int boardType) {
            this.boardType = boardType;
        }

        public String getPortName() {
            return this.portName;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public String getStartTime() {
            return new Date(this.startTime).toString();
        }

        public long getStartTimeLong() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public String getUnit() {
            switch (this.unit) {
                case 1: {
                    return "1s";
                }
                case 2: {
                    return "10min";
                }
                case 3: {
                    return "1h";
                }
            }
            return "1s";
        }

        public void setUnit(int unit) {
            this.unit = unit;
        }

        public long getTestTotalTime() {
            return this.testTotalTime;
        }

        public void setTestTotalTime(long testTotalTime) {
            this.testTotalTime = testTotalTime;
        }

        public long getTestTotalErrBits() {
            return this.testTotalErrBits;
        }

        public void setTestTotalErrBits(long testTotalErrBits) {
            this.testTotalErrBits = testTotalErrBits;
        }

        public String getErrBitRate() {
            return this.errBitRate;
        }

        public void setErrBitRate(String errBitRate) {
            this.errBitRate = errBitRate;
        }

        public int getInvalidCount() {
            return this.invalidCount;
        }

        public void setInvalidCount(int invalidCount) {
            this.invalidCount = invalidCount;
        }
    }
}

