/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nemgr.sdh.bittest.TEETHWidthKey;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEETHWidthBean {
    private static TEETHWidthBean instance = null;
    private Map<TEETHWidthKey, Double> ethWidthMap = new HashMap<TEETHWidthKey, Double>();

    private TEETHWidthBean() {
        this.initEthWidthData();
    }

    public static synchronized TEETHWidthBean getInstance() {
        if (instance == null) {
            instance = new TEETHWidthBean();
        }
        return instance;
    }

    private void initEthWidthData() {
        StringBuilder path = new StringBuilder("nemgr").append(File.separator).append("sdh").append(File.separator).append("conf").append(File.separator).append("bittest").append(File.separator).append("ethwidthdata.xml");
        Document doc = this.getXMLDoc(path.toString());
        NodeList amList = doc.getElementsByTagName("amattr");
        NamedNodeMap namedNodeMap = null;
        Node node = null;
        int iLen = amList.getLength();
        for (int i = 0; i < iLen; ++i) {
            node = amList.item(i);
            namedNodeMap = node.getChildNodes().item(1).getAttributes();
            this.calculateEthWidth(node, namedNodeMap);
        }
    }

    private Document getXMLDoc(String path) {
        Document doc = null;
        try {
            Bundle bundle = FrameworkUtil.getBundle(TEETHWidthBean.class);
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)path);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse File ethwidthdata.xml Failed!", (Throwable)e);
        }
        return doc;
    }

    private void calculateEthWidth(Node node, NamedNodeMap map) {
        int bandWidth = Integer.parseInt(node.getAttributes().getNamedItem("bandWidth").getNodeValue());
        int amMode = Integer.parseInt(node.getAttributes().getNamedItem("amMode").getNodeValue());
        TEETHWidthKey key = new TEETHWidthKey();
        key.setAmMode(amMode);
        key.setBandWidth(bandWidth);
        int period = Integer.parseInt(map.getNamedItem("period").getNodeValue());
        int timeSlot_valid = Integer.parseInt(map.getNamedItem("timeSlot_valid").getNodeValue());
        int timeSlot_1588 = Integer.parseInt(map.getNamedItem("timeSlot_1588").getNodeValue());
        int timeSlot_MVB1 = Integer.parseInt(map.getNamedItem("timeSlot_MVB1").getNodeValue());
        int timeSlot_OH = Integer.parseInt(map.getNamedItem("timeSlot_OH").getNodeValue());
        int timeSlot_TDM = Integer.parseInt(map.getNamedItem("timeSlot_TDM").getNodeValue());
        double M6 = timeSlot_valid - (1 + timeSlot_1588 + timeSlot_MVB1 + timeSlot_OH + timeSlot_TDM);
        double C6 = period;
        double capacityPerSecond = M6 * 8.0 * 1000.0 * 1000.0 * 1000.0 / C6;
        this.ethWidthMap.put(key, capacityPerSecond);
    }

    public Double getCapacityPerPeriod(TEETHWidthKey key) {
        return this.ethWidthMap.get(key);
    }
}

