/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestNum;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.List;

public class TEDrawBitTestPic {
    private static final String BASE_PATH = "sdh" + File.separator + "res" + File.separator;
    private static final String PAKAGE_PATH = BASE_PATH + "bittest" + File.separator + "bittestres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private int PIC_HEIGHT = 220;
    private int PIC_WIDTH = 800;
    private BufferedImage spectWaveimage = new BufferedImage(this.PIC_WIDTH, this.PIC_HEIGHT, 1);
    private TEBitTestData testdata = null;
    private int x_lefttop = 90;
    private int y_lefttop = 30;
    private int y_leftbottom = this.PIC_HEIGHT - 20;
    private int x_rightbottom = this.PIC_WIDTH - 3;
    private String ystr = "errnum";
    private String xstr = "time";
    private Color standcoler = new Color(239, 239, 239);
    private static TEDrawBitTestPic instance = null;

    private TEDrawBitTestPic() {
    }

    public static synchronized TEDrawBitTestPic getInstance() {
        if (instance == null) {
            instance = new TEDrawBitTestPic();
        }
        return instance;
    }

    private void initres(int neid) {
        this.ystr = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.ystr);
        this.xstr = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.xstr);
    }

    public BufferedImage drawBitTestPic(int neid, String hashvalue) {
        this.initres(neid);
        this.testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
        if (this.testdata == null) {
            this.drawInitPic2();
        } else {
            this.drawDataPic2();
        }
        return this.spectWaveimage;
    }

    public void drawInitPic2() {
        Graphics2D waveg2d = this.getSVGGraphics2();
        this.paintFrame(waveg2d);
        this.paintinitY(waveg2d);
    }

    public Graphics2D getSVGGraphics2() {
        Graphics2D waveg2d = (Graphics2D)this.spectWaveimage.getGraphics();
        return waveg2d;
    }

    public void drawDataPic2() {
        Graphics2D waveg2d = this.getSVGGraphics2();
        this.paintFrame(waveg2d);
        this.paintBitTestData(waveg2d, this.testdata);
    }

    private long getrealdata2(long querydata) {
        if (querydata >= 0xFFFFFFFFL) {
            return 0L;
        }
        return querydata;
    }

    private long[] getYaxisData(TEBitTestData testdata2) {
        int isaccu = testdata2.isAccumulation();
        long ymax = 100L;
        if (isaccu == 1) {
            if (ymax < testdata2.getTotalErrNum()) {
                ymax = testdata2.getTotalErrNum();
            }
        } else {
            List relist = testdata2.getResultData();
            int len = relist.size();
            for (int i = 0; i < len; ++i) {
                TEBitTestNum testNum = (TEBitTestNum)relist.get(i);
                long num = this.getrealdata2(testNum.getErrnum());
                if (num <= ymax) continue;
                ymax = num;
            }
        }
        long[] ydata2 = new long[6];
        if (ymax <= 120L) {
            ydata2[0] = 0L;
            ydata2[1] = 20L;
            ydata2[2] = 40L;
            ydata2[3] = 60L;
            ydata2[4] = 80L;
            ydata2[5] = ymax;
        } else {
            long gridy = ymax / 5L;
            ydata2[0] = 0L;
            ydata2[1] = gridy * 1L;
            ydata2[2] = gridy * 2L;
            ydata2[3] = gridy * 3L;
            ydata2[4] = gridy * 4L;
            ydata2[5] = ymax;
        }
        return ydata2;
    }

    private long[] getErrData2(TEBitTestData testdata2) {
        int isaccu = testdata2.isAccumulation();
        List relist2 = testdata2.getResultData();
        int size = relist2.size();
        long[] errdata2 = new long[size];
        if (isaccu == 1) {
            long sum = testdata2.getOldErrNum();
            for (int i = 0; i < size; ++i) {
                long num = ((TEBitTestNum)relist2.get(i)).getErrnum();
                if (num >= 0xFFFFFFFFL) {
                    errdata2[i] = -1L;
                    sum += 0L;
                    continue;
                }
                if (num == 0L) {
                    errdata2[i] = 0L;
                    sum += 0L;
                    continue;
                }
                errdata2[i] = sum + num;
                sum += num;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                long num = ((TEBitTestNum)relist2.get(i)).getErrnum();
                errdata2[i] = num >= 0xFFFFFFFFL ? -1L : (num == 0L ? 0L : num);
            }
        }
        return errdata2;
    }

    private String[] getTimeData2(TEBitTestData testdata2) {
        String[] timestr2 = new String[5];
        List relist = testdata2.getResultData();
        int size = relist.size();
        int j = 0;
        int i = 0;
        while (i < size) {
            long time = ((TEBitTestNum)relist.get(i)).getHappenTime();
            Calendar calTime = Calendar.getInstance();
            calTime.setTimeInMillis(time);
            timestr2[j] = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)testdata2.getNeid()).calendarToTime(calTime);
            i += 20;
            ++j;
        }
        for (i = 0; i < timestr2.length; ++i) {
            if (timestr2[i] != null) continue;
            timestr2[i] = "";
        }
        return timestr2;
    }

    public void paintBitTestData(Graphics2D dc2, TEBitTestData testdata) {
        long[] ydata = this.getYaxisData(testdata);
        long[] errdata = this.getErrData2(testdata);
        String[] timedata = this.getTimeData2(testdata);
        dc2.setColor(Color.BLACK);
        long ymax = ydata[ydata.length - 1];
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < ydata.length; ++i) {
            FontMetrics fontmetri = dc2.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata[i] + "");
            dc2.drawString(ydata[i] + "", this.x_lefttop - cswidth - 3, this.y_leftbottom + 5 - y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom - this.x_lefttop) / 100;
        for (int i = 0; i < timedata.length; ++i) {
            dc2.drawString(timedata[i], this.x_lefttop + x_gridw * i * 20, this.y_leftbottom + 15);
        }
        int h = this.y_leftbottom - this.y_lefttop;
        for (int i = 0; i < errdata.length; ++i) {
            int errh;
            if (errdata[i] == -1L) {
                dc2.setColor(Color.YELLOW);
                errh = h;
                dc2.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_lefttop, 3, errh);
                continue;
            }
            if (errdata[i] == 0L) {
                dc2.setColor(Color.GREEN);
                errh = h;
                dc2.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_lefttop, 3, errh);
                continue;
            }
            dc2.setColor(Color.red);
            errh = (int)((double)errdata[i] / (double)ymax * (double)h);
            dc2.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_leftbottom - errh, 3, errh);
        }
    }

    public void paintinitY(Graphics2D dc2) {
        int[] ydata = new int[]{0, 20, 40, 60, 80, 100};
        dc2.setColor(Color.BLACK);
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < ydata.length; ++i) {
            FontMetrics fontmetri = dc2.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata[i] + "");
            dc2.drawString(ydata[i] + "", this.x_lefttop - cswidth - 3, this.y_leftbottom + 5 - y_gridh * i);
        }
    }

    public void paintFrame(Graphics2D dc2) {
        dc2.setColor(this.standcoler);
        dc2.fillRect(0, 0, 820, 250);
        dc2.setColor(Color.BLACK);
        dc2.drawLine(this.x_lefttop, this.y_lefttop - 2, this.x_lefttop, this.y_leftbottom);
        dc2.drawLine(this.x_lefttop, this.y_leftbottom, this.x_rightbottom, this.y_leftbottom);
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < 5; ++i) {
            dc2.drawLine(this.x_lefttop - 2, this.y_lefttop + y_gridh * i, this.x_lefttop + 2, this.y_lefttop + y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom - this.x_lefttop) / 100;
        for (int j = 1; j <= 100; ++j) {
            dc2.setColor(Color.BLACK);
            dc2.drawLine(this.x_lefttop + x_gridw * j, this.y_leftbottom + 2, this.x_lefttop + x_gridw * j, this.y_leftbottom - 2);
            if (j % 10 != 0) continue;
            dc2.setColor(Color.blue);
            dc2.drawLine(this.x_lefttop + x_gridw * j, this.y_leftbottom + 2, this.x_lefttop + x_gridw * j, this.y_leftbottom - 5);
        }
        dc2.drawString("(" + this.ystr + ")", this.x_lefttop + 5, this.y_lefttop - 10);
        dc2.drawString("(" + this.xstr + ")", this.x_rightbottom - 32, this.y_leftbottom + 15);
    }
}

