/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.necommon.configdata.TEPortConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestNum;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEBitTestUtility {
    private static final int ISACCUMULATION = 1;

    public static String getPortName(int neid, int slotid, int portid) {
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName();
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board == null) {
            return "-";
        }
        int boardtype = board.getBoardType();
        String portname = "";
        portname = TEConfigurationDataMgr.getInstance().isIFboard(boardtype) ? TEDataConverter.getPortName((int)neid, (int)slotid, (int)boardtype, (int)portid, (String)String.valueOf(11)) : TEPortConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid);
        String resFilePath = "res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
        String port = TEResourceUtil.getInstance((String)resFilePath).getString("portname");
        if (!TEStringUtils.isEmpty((String)portname) && portname.contains("SDH")) {
            port = "SDH";
        }
        if (boardtype == 3060) {
            portname = portname.replace(port, "SDH_TU");
        }
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        StringBuffer name = new StringBuffer();
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
        name.append(nename);
        if (subrackName != null && !subrackName.equals("")) {
            name.append("-").append(subrackName);
            slotid = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid);
        }
        name.append("-").append(slotid);
        name.append("-").append(boardname);
        name.append("-").append(portname);
        return name.toString();
    }

    public static String getShortPortName(int neid, int slotid, int portid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String portname = TEPortConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid);
        if (TEConfigurationDataMgr.getInstance().isIFboard(boardtype)) {
            portname = portname.replace("SDH", "RTNIF");
        }
        return portname;
    }

    public static String getPortName(int neid, int slotid, int portid, int pathid) {
        String name = TEBitTestUtility.getPortName(neid, slotid, portid);
        if (pathid > 0) {
            name = name + "-" + pathid;
        }
        return name;
    }

    public static Map<String, Integer> getIFAttr(int neid, int slotid, int port) {
        HashMap<String, Integer> ifAttr = new HashMap<String, Integer>();
        ArrayList<Operation> opers = new ArrayList<Operation>();
        Operation amModeOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_AM_CURRMOD");
        amModeOper.getInput().setPartValue("slotid", String.valueOf(slotid));
        amModeOper.getInput().setPartValue("portid", String.valueOf(port));
        opers.add(amModeOper);
        Operation bandWidthOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_IF_BANDWIDTH");
        bandWidthOper.getInput().setPartValue("slotid", String.valueOf(slotid));
        bandWidthOper.getInput().setPartValue("portid", String.valueOf(port));
        opers.add(bandWidthOper);
        Operation linkIDOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_RADIO_LINKID");
        linkIDOper.getInput().setPartValue("slotid", String.valueOf(slotid));
        linkIDOper.getInput().setPartValue("port", String.valueOf(port));
        opers.add(linkIDOper);
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, opers, 10, null);
        if (result.retCode == 0) {
            if (amModeOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0)) && bandWidthOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0)) && linkIDOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) {
                ifAttr.put("amMode", Integer.valueOf(amModeOper.getOutput(0).getPartValue("receivemode")));
                ifAttr.put("bandWidth", Integer.valueOf(bandWidthOper.getOutput(0).getPartValue("bandwidth")));
                ifAttr.put("linkID", Integer.valueOf(linkIDOper.getOutput(0).getPartValue("W32PORT_ATTR_RADIOLINKID")));
            } else {
                TELogFactory.getNormalLogger().info("query IF Attr Failed");
                return null;
            }
        }
        return ifAttr;
    }

    public static long getTotalErrNum(TEBitTestData data) {
        if (data.isAccumulation() == 1) {
            return data.getTotalErrNum();
        }
        List relist = data.getResultData();
        int totalErrNum = 0;
        int len = relist.size();
        for (int i = 0; i < len; ++i) {
            TEBitTestNum testNum = (TEBitTestNum)relist.get(i);
            if (testNum.getErrnum() >= 0xFFFFFFFFL) continue;
            totalErrNum = (int)((long)totalErrNum + testNum.getErrnum());
        }
        return totalErrNum;
    }

    public static int getTotalTestPeriodCount(TEBitTestData data) {
        List relist = data.getResultData();
        if (data.isAccumulation() == 1) {
            return data.getOldValPerCount() + data.getOldInvalPerCount() + relist.size();
        }
        return relist.size();
    }

    public static int getInvalidPeriodCount(TEBitTestData data) {
        List errList = data.getResultData();
        int count = 0;
        int len = errList.size();
        for (int i = 0; i < len; ++i) {
            TEBitTestNum bitTestNum = (TEBitTestNum)errList.get(i);
            if (bitTestNum.getErrnum() < 0xFFFFFFFFL) continue;
            ++count;
        }
        if (data.isAccumulation() == 1) {
            count += data.getOldInvalPerCount();
        }
        return count;
    }

    public static long getTotalSecondsPerPeriod(TEBitTestData data) {
        long time = 0L;
        switch (data.getTimeUnit()) {
            case 1: {
                time = 1L;
                break;
            }
            case 2: {
                if (TEBitTestUtility.isFromQuery(data)) {
                    time = 600L;
                    break;
                }
                time = 60L;
                break;
            }
            case 3: {
                if (TEBitTestUtility.isFromQuery(data)) {
                    time = 3600L;
                    break;
                }
                time = 60L;
                break;
            }
        }
        return time;
    }

    public static boolean isFromQuery(TEBitTestData data) {
        boolean result = false;
        if (data.getTeststate() == 0 && data.getQueryList().size() != 0) {
            result = true;
        }
        return result;
    }
}

