/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestNum;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public class TEBitTestData {
    private int neid;
    private int slotid;
    private int portid;
    private int pathid;
    private int direction = 0;
    private int timeUnit;
    private long startTime;
    private int testtime;
    private int isAccumulation;
    private int progress = 0;
    private long oldErrNum = 0L;
    private long totalErrNum = 0L;
    private LinkedList reportResult = new LinkedList();
    private LinkedList queryResult = new LinkedList();
    private int teststate = 0;
    private int currentNumber = 0;
    private long lastreportTime = 0L;
    private TimeZoneDateBean timeTool;
    private long neToNmsTime = 0L;
    private int oldInvalPerCount = 0;
    private int oldValPerCount = 0;

    public long getNeToNmsTime() {
        return this.neToNmsTime;
    }

    public void setNeToNmsTime(long neToNmsTime) {
        this.neToNmsTime = neToNmsTime;
    }

    public TEBitTestData(int neid) {
        this.neid = neid;
        this.timeTool = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
    }

    public void init() {
        this.setOldErrNum(0L);
        this.totalErrNum = 0L;
        this.queryResult.clear();
        this.oldInvalPerCount = 0;
        this.oldValPerCount = 0;
    }

    public LinkedList getQueryList() {
        return this.queryResult;
    }

    public List getResultData() {
        if (this.teststate == 0) {
            if (this.queryResult.size() != 0) {
                return this.queryResult;
            }
            return this.reportResult;
        }
        return this.reportResult;
    }

    private long getrealdata(long querydata) {
        if (querydata >= 0xFFFFFFFFL) {
            return 0L;
        }
        return querydata;
    }

    public void addQueryResult(long errnum, int firstpoint) {
        if (this.queryResult.size() >= 100) {
            TEBitTestNum tNum = (TEBitTestNum)this.queryResult.removeFirst();
            this.setOldErrNum(this.getOldErrNum() + this.getrealdata(tNum.getErrnum()));
            ++this.currentNumber;
            if (tNum.getErrnum() >= 0xFFFFFFFFL) {
                ++this.oldInvalPerCount;
            } else {
                ++this.oldValPerCount;
            }
        } else {
            this.currentNumber = this.queryResult.size();
        }
        TEBitTestNum testnum = new TEBitTestNum();
        testnum.setErrnum(errnum);
        switch (this.timeUnit) {
            case 1: {
                testnum.setHappenTime(this.startTime + 1000L * (long)this.currentNumber);
                break;
            }
            case 2: {
                testnum.setHappenTime(this.startTime + 600000L * (long)this.currentNumber);
                break;
            }
            case 3: {
                testnum.setHappenTime(this.startTime + 3600000L * (long)this.currentNumber);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEBitTestData.addQueryResult() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        this.progress = (int)((double)(this.currentNumber + 1) / (double)this.testtime * 100.0);
        if (this.progress > 100) {
            this.progress = 100;
        }
        this.queryResult.add(testnum);
        this.totalErrNum += this.getrealdata(errnum);
    }

    public void addReportResult(TEBitTestNum testnum) {
        if (this.reportResult.size() >= 100) {
            TEBitTestNum tNum = (TEBitTestNum)this.reportResult.removeFirst();
            this.oldErrNum += this.getrealdata(tNum.getErrnum());
            ++this.currentNumber;
            if (tNum.getErrnum() >= 0xFFFFFFFFL) {
                ++this.oldInvalPerCount;
            } else {
                ++this.oldValPerCount;
            }
        } else {
            this.currentNumber = this.reportResult.size();
        }
        this.reportResult.add(testnum);
        this.totalErrNum += this.getrealdata(testnum.getErrnum());
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public int getNeid() {
        return this.neid;
    }

    public void setSlotid(int slotid) {
        this.slotid = slotid;
    }

    public int getSlotid() {
        return this.slotid;
    }

    public void setPortid(int portid) {
        this.portid = portid;
    }

    public int getPortid() {
        return this.portid;
    }

    public void setPathid(int pathid) {
        this.pathid = pathid;
    }

    public int getPathid() {
        return this.pathid;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTimeToLong() {
        return this.startTime;
    }

    public String getStartTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.startTime);
        return this.timeTool.calendarToTime(cal);
    }

    public void setAccumulation(int isAccumulation) {
        this.isAccumulation = isAccumulation;
    }

    public int isAccumulation() {
        return this.isAccumulation;
    }

    public void setTesttime(int testtime) {
        this.testtime = testtime;
    }

    public int getTesttime() {
        return this.testtime;
    }

    public long getTotalTesttimeInMillisecond() {
        long timeTotal = 0L;
        switch (this.timeUnit) {
            case 1: {
                timeTotal = (long)this.testtime * 1000L;
                break;
            }
            case 2: {
                timeTotal = (long)this.testtime * 600000L;
                break;
            }
            case 3: {
                timeTotal = (long)this.testtime * 3600000L;
                break;
            }
        }
        return timeTotal;
    }

    public void refreshdata(int elapsetime, long errnum) {
        long time = 0L;
        switch (this.timeUnit) {
            case 1: {
                this.progress = (int)((double)elapsetime / (double)this.testtime * 100.0);
                time = (long)(elapsetime - 1) * 1000L;
                break;
            }
            case 2: {
                this.progress = (int)((double)elapsetime / (double)(this.testtime * 10) * 100.0);
                time = (long)(elapsetime - 1) * 60000L;
                break;
            }
            case 3: {
                this.progress = (int)((double)elapsetime / (double)(this.testtime * 60) * 100.0);
                time = (long)(elapsetime - 1) * 60000L;
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEBitTestData.refreshdata() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        TEBitTestNum testNum = new TEBitTestNum();
        long happentime = this.startTime + time;
        testNum.setHappenTime(happentime);
        testNum.setErrnum(errnum);
        this.addReportResult(testNum);
        this.setLastreportTime(happentime);
        this.teststate = this.progress >= 100 ? 0 : 1;
    }

    public void setTotalErrNum(long totalErrNum) {
        this.totalErrNum = totalErrNum;
    }

    public long getTotalErrNum() {
        return this.totalErrNum;
    }

    public synchronized void setProgress(int progress) {
        this.progress = progress;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public void setTeststate(int teststate) {
        this.teststate = teststate;
    }

    public int getTeststate() {
        return this.teststate;
    }

    public void setOldErrNum(long oldErrNum) {
        this.oldErrNum = oldErrNum;
    }

    public long getOldErrNum() {
        return this.oldErrNum;
    }

    public void setLastreportTime(long lastreportTime) {
        this.lastreportTime = lastreportTime;
    }

    public long getLastreportTime() {
        return this.lastreportTime;
    }

    public int getOldInvalPerCount() {
        return this.oldInvalPerCount;
    }

    public void setOldInvalPerCount(int oldInvalPerCount) {
        this.oldInvalPerCount = oldInvalPerCount;
    }

    public int getOldValPerCount() {
        return this.oldValPerCount;
    }

    public void setOldValPerCount(int oldValPerCount) {
        this.oldValPerCount = oldValPerCount;
    }
}

