/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.HashMap;

public class TEBitTestCache {
    private String QX_DES_PATH = "nemgr" + File.separator + "sdh" + File.separator + "conf" + File.separator + "bittest" + File.separator + "bittestqxdescrib.xml";
    private HashMap bitTestCahce = new HashMap();
    private static TEBitTestCache instance = new TEBitTestCache();

    private TEBitTestCache() {
        this.registerListener();
    }

    public synchronized TEBitTestData getCahce(String key) {
        return (TEBitTestData)this.bitTestCahce.get(key);
    }

    public synchronized void addCahce(String key, TEBitTestData testdata) {
        this.bitTestCahce.put(key, testdata);
    }

    public synchronized boolean containKey(String key) {
        return this.bitTestCahce.containsKey(key);
    }

    public static synchronized TEBitTestCache getInstance() {
        if (instance == null) {
            instance = new TEBitTestCache();
            instance.registerListener();
        }
        return instance;
    }

    public void registerListener() {
        TENormalTestNoticeHandler normalNotice = new TENormalTestNoticeHandler();
        Operation[] operations = TECreateObjectFactory.getOperations((String)this.QX_DES_PATH);
        int m = operations.length;
        for (int i = 0; i < m; ++i) {
            TENECommMgr.getInstance().registerListener(operations[i], (NoticeHandler)normalNotice);
        }
    }

    static class TENormalTestNoticeHandler
    implements NoticeHandler {
        TENormalTestNoticeHandler() {
        }

        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String hashvalue;
            String slotid = "";
            String portid = "";
            int pathid = -1;
            int testtime = 0;
            long errnum = 0L;
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                Part p = outputArr[i].getPart("slotid");
                slotid = p.getValue();
                p = outputArr[i].getPart("portid");
                portid = p.getValue();
                p = outputArr[i].getPart("pathid");
                if (p != null && p.getValue() != null) {
                    pathid = Integer.parseInt(p.getValue());
                }
                p = outputArr[i].getPart("testtime");
                testtime = new Integer(p.getValue());
                p = outputArr[i].getPart("errnum");
                errnum = Long.parseLong(p.getValue(), 10);
            }
            TEBitTestCache testcache = TEBitTestCache.getInstance();
            TEBitTestData testdata = testcache.getCahce(hashvalue = TEBitTestUtility.getPortName(neID, Integer.parseInt(slotid), Integer.parseInt(portid), pathid));
            if (testdata == null) {
                return;
            }
            if (testdata.getTeststate() != 1) {
                return;
            }
            if (errnum <= 0L) {
                errnum = 0L;
            }
            testdata.refreshdata(testtime, errnum);
        }
    }
}

