/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitInitTable;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.nemgr.sdh.bittest.TEETHWidthBean;
import com.huawei.nglct.nemgr.sdh.bittest.TEETHWidthKey;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TEBitInitTable_RTN900
extends TEBitInitTable {
    private static Map<String, Map<String, Integer>> IFATTRMap = new HashMap<String, Map<String, Integer>>();
    private int neid;
    private int slotid;
    private static final String path = "sdh" + File.separator + "conf" + File.separator + "bittest_u2kv1r3c00" + File.separator + "prbstestreport_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static TEResourceUtil resource;
    private static final long ERRBITS_PERSECOND = 2048000L;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int boardType;
        this.neid = neid;
        this.slotid = Integer.valueOf(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        Param firstQuery = inputData.getBussinessParams().getRowParams(0).getParam("firstQuery");
        resource = TEGetFilePath.getResource((int)neid, (String)path);
        TEConfigurationDataMgr cofMgr = TEConfigurationDataMgr.getInstance();
        if (cofMgr.isIFboard(boardType = cofMgr.getBoardType(this.neid, this.slotid))) {
            String key = TEBitTestUtility.getPortName(this.neid, this.slotid, 1);
            if (firstQuery != null) {
                IFATTRMap.clear();
            }
            if (IFATTRMap.get(key) == null) {
                IFATTRMap.put(key, TEBitTestUtility.getIFAttr(this.neid, this.slotid, 1));
            }
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    @Override
    protected RowParams getBlankData(int portid) {
        RowParams row = super.getBlankData(portid);
        row.addParam("errRate", "0" + resource.getString("errRateUnit"));
        TEConfigurationDataMgr cofMgr = TEConfigurationDataMgr.getInstance();
        int boardType = cofMgr.getBoardType(this.neid, this.slotid);
        if (cofMgr.isIFboard(boardType)) {
            row.addParam("linkID", "/");
        } else {
            row.addParam("linkID", "-");
        }
        return row;
    }

    @Override
    protected RowParams getSaveData(TEBitTestData testdata) {
        String linkID;
        String errRate;
        TEConfigurationDataMgr cofMgr = TEConfigurationDataMgr.getInstance();
        int boardType = cofMgr.getBoardType(this.neid, this.slotid);
        String logStr = "cauRate at " + new Date().toLocaleString() + ", neid = " + this.neid + " slotid = " + this.slotid;
        if (testdata != null) {
            logStr = logStr + " portid = " + testdata.getPortid();
        }
        TELogFactory.getNormalLogger().info("start " + logStr);
        if (cofMgr.isIFboard(boardType)) {
            String key = TEBitTestUtility.getPortName(this.neid, this.slotid, 1);
            Map<String, Integer> tmpAttrMap = IFATTRMap.get(key);
            if (tmpAttrMap != null) {
                errRate = this.calculateIFBoardErrBitRate(tmpAttrMap, testdata);
                linkID = tmpAttrMap.get("linkID").toString();
            } else {
                errRate = "0" + resource.getString("errRateUnit");
                linkID = "/";
            }
        } else {
            errRate = this.calculateBranchBoardErrBitRate(testdata);
            linkID = "-";
        }
        TELogFactory.getNormalLogger().info("end " + logStr);
        RowParams row = super.getSaveData(testdata);
        row.addParam("errRate", errRate);
        row.addParam("linkID", linkID);
        return row;
    }

    private String calculateIFBoardErrBitRate(Map<String, Integer> ifAttrs, TEBitTestData data) {
        TEETHWidthKey key = new TEETHWidthKey();
        key.setAmMode(ifAttrs.get("amMode"));
        key.setBandWidth(ifAttrs.get("bandWidth"));
        TELogFactory.getNormalLogger().info("PRBS GET amMode=" + key.getAmMode() + ", bandWidth=" + key.getBandWidth());
        Double capacityPerPeriod = TEETHWidthBean.getInstance().getCapacityPerPeriod(key);
        if (capacityPerPeriod == null) {
            return "0" + resource.getString("errRateUnit");
        }
        double totalErrBits = TEBitTestUtility.getTotalErrNum(data);
        int invalidPeriodCount = TEBitTestUtility.getInvalidPeriodCount(data);
        int totalPeriodCount = TEBitTestUtility.getTotalTestPeriodCount(data);
        long totalSecondsPerPeriod = TEBitTestUtility.getTotalSecondsPerPeriod(data);
        if (invalidPeriodCount == totalPeriodCount) {
            return "0" + resource.getString("errRateUnit");
        }
        double rate = totalErrBits / (capacityPerPeriod * (double)(totalPeriodCount - invalidPeriodCount) * (double)totalSecondsPerPeriod * 65536.0);
        return this.getResultString(rate);
    }

    private String calculateBranchBoardErrBitRate(TEBitTestData data) {
        double totalErrBits = TEBitTestUtility.getTotalErrNum(data);
        int invalidPeriodCount = TEBitTestUtility.getInvalidPeriodCount(data);
        int totalPeriodCount = TEBitTestUtility.getTotalTestPeriodCount(data);
        long totalSecondsPerPeriod = TEBitTestUtility.getTotalSecondsPerPeriod(data);
        if (invalidPeriodCount == totalPeriodCount) {
            return "0" + resource.getString("errRateUnit");
        }
        double rate = totalErrBits / (double)(2048000L * (long)(totalPeriodCount - invalidPeriodCount) * totalSecondsPerPeriod);
        return this.getResultString(rate);
    }

    private String getResultString(double value) {
        TELogFactory.getNormalLogger().info("getResultString  value:" + value);
        if (Double.compare(value, 0.0) <= 0) {
            return "0.0" + resource.getString("errRateUnit");
        }
        int count = 0;
        while (value < 1.0) {
            ++count;
            value *= 10.0;
        }
        String str = BigDecimal.valueOf(value).divide(BigDecimal.valueOf(1L), 4, 4).toString();
        return str + resource.getString("sinUnit") + count;
    }
}

