/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TEBitInitTableByGenCfg
extends TENEExplorerBean {
    private int slotid = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        this.slotid = Integer.parseInt(para.getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotid);
        int boardtype = board.getBoardType();
        boolean isFisrtQuery = true;
        Param flagParam = rowpara.getParam("flag");
        isFisrtQuery = flagParam != null && "1".equals(flagParam.getValue());
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        if (isFisrtQuery) {
            TEGenCfgAttribute gencfgAttr = TEGenCfgDataMgr.getGenCfgMode((int)boardtype).getAttrFromId("W32PORT_ATTR_PRBSTEST");
            int len = gencfgAttr.getPortList().size();
            TEGenCfgPortAttribute portObj = null;
            RowParams rowdata = null;
            for (int i = 0; i < len; ++i) {
                portObj = (TEGenCfgPortAttribute)gencfgAttr.getPortList().get(i);
                String hashvalue = TEBitTestUtility.getPortName(neid, this.slotid, portObj.getPort(), portObj.getPath());
                TEBitTestData testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
                rowdata = testdata == null ? this.getBlankData(portObj.getPort(), portObj.getPath()) : this.getSaveData(testdata, portObj.getPath());
                bussiness.addRowParams(rowdata);
            }
        } else {
            int portid = 1;
            int pathid = 1;
            Param portidParam = rowpara.getParam("portid");
            Param pathidParam = rowpara.getParam("pathid");
            if (portidParam != null) {
                String portidStr = portidParam.getValue();
                portid = Integer.parseInt(portidStr);
            }
            if (pathidParam != null) {
                String pathidStr = pathidParam.getValue();
                pathid = Integer.parseInt(pathidStr);
            }
            String hashvalue = TEBitTestUtility.getPortName(neid, this.slotid, portid, pathid);
            TEBitTestData testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
            RowParams rowdata = null;
            rowdata = testdata == null ? this.getBlankData(portid, pathid) : this.getSaveData(testdata, pathid);
            bussiness.addRowParams(rowdata);
        }
        this.outputData.setBussinessParams(bussiness);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        return this.outputData;
    }

    private RowParams getBlankData(int portid, int pathid) {
        boolean isLine = true;
        isLine = TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, this.slotid);
        RowParams param = new RowParams();
        String portname = TEBitTestUtility.getPortName(this.neid, this.slotid, portid);
        param.addParam("portid", portid + "");
        param.addParam("portname", portname);
        param.addParam("vc4", pathid + "");
        if (isLine) {
            param.addParam("direction", "2");
        } else {
            param.addParam("direction", "0");
        }
        param.addParam("timeunit", "1");
        param.addParam("testtime", "1");
        param.addParam("starttime", "-");
        param.addParam("progress", "0%");
        param.addParam("totalErrNum", "0");
        param.addParam("isaccu", "0");
        param.addParam("teststate", "0");
        param.addParam("isline", "" + isLine);
        return param;
    }

    private RowParams getSaveData(TEBitTestData testdata, int pathid) {
        this.handledata(testdata);
        RowParams param = new RowParams();
        String portname = TEBitTestUtility.getPortName(this.neid, this.slotid, testdata.getPortid());
        param.addParam("portid", testdata.getPortid() + "");
        param.addParam("portname", portname);
        param.addParam("vc4", testdata.getPathid() + "");
        param.addParam("direction", testdata.getDirection() + "");
        param.addParam("timeunit", testdata.getTimeUnit() + "");
        param.addParam("testtime", testdata.getTesttime() + "");
        param.addParam("starttime", this.getStarttime(testdata));
        param.addParam("progress", testdata.getProgress() + "%");
        param.addParam("totalErrNum", testdata.getTotalErrNum() + "");
        param.addParam("isaccu", testdata.isAccumulation() + "");
        param.addParam("teststate", testdata.getTeststate() + "");
        if (1 == testdata.getDirection()) {
            param.addParam("isline", "true");
        } else {
            param.addParam("isline", "false");
        }
        return param;
    }

    private String getStarttime(TEBitTestData testdata) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
        Calendar startTime = Calendar.getInstance();
        startTime.setTimeInMillis(testdata.getStartTimeToLong());
        String formatstr = TimeZoneDateBean.getTimeConvertFormat();
        String returnstr = null;
        if (testdata.getQueryList().size() <= 0) {
            SimpleDateFormat dataFormatterOther = new SimpleDateFormat(formatstr, Locale.ENGLISH);
            return dataFormatterOther.format(startTime.getTime());
        }
        returnstr = timezonebean.calendarToTime(startTime);
        return returnstr;
    }

    private void handledata(TEBitTestData testdata) {
        if (testdata.getTeststate() == 0) {
            return;
        }
        int timeUnit = testdata.getTimeUnit();
        int abletime = 0;
        abletime = timeUnit == 1 ? 25000 : 120000;
        Date d = new Date();
        long current = d.getTime();
        long lastreporttime = testdata.getLastreportTime();
        if (lastreporttime == 0L && testdata.getQueryList().size() <= 0) {
            testdata.setTeststate(1);
            return;
        }
        if (current - lastreporttime > (long)abletime) {
            testdata.setTeststate(0);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

