/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.sdh.bittest;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.necommon.netimelocalization.TENETimeUtility;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.sdh.bittest.TEBitTestUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.HashSet;
import java.util.List;

public class TEBitInitTable
extends TENEExplorerBean {
    private int slotid = 0;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        this.slotid = Integer.parseInt(para.getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotid);
        if (null == board) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        int boardType = this.mgr.getBoardType(neid, this.slotid);
        List portList = null;
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        if (this.mgr.isIFboard(boardType)) {
            portList = this.mgr.getPortListFromPortType(neid, boardType, 2817);
            portList.addAll(this.mgr.getPortListFromPortType(neid, boardType, 1802));
        } else {
            portList = this.mgr.getBoardPortList(neid, boardType);
        }
        HashSet portSet = new HashSet();
        portSet.addAll(portList);
        portList.clear();
        portList.addAll(portSet);
        int m = portList.size();
        for (int i = 0; i < m; ++i) {
            int portid = (Integer)portList.get(i);
            RowParams rowdata = null;
            String hashvalue = TEBitTestUtility.getPortName(neid, this.slotid, portid);
            TEBitTestData testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
            rowdata = testdata == null ? this.getBlankData(portid) : this.getSaveData(testdata);
            bussiness.addRowParams(rowdata);
        }
        this.outputData.setBussinessParams(bussiness);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        return this.outputData;
    }

    protected RowParams getBlankData(int portid) {
        boolean isbranch = true;
        isbranch = this.mgr.isBranchBoard(this.neid, this.slotid);
        RowParams param = new RowParams();
        String portname = TEBitTestUtility.getPortName(this.neid, this.slotid, portid);
        param.addParam("portid", portid + "");
        param.addParam("portname", portname);
        param.addParam("channel", "-");
        if (isbranch) {
            param.addParam("direction", "1");
        } else {
            param.addParam("direction", "0");
        }
        param.addParam("timeunit", "1");
        param.addParam("testtime", "1");
        param.addParam("starttime", "-");
        param.addParam("progress", "0%");
        param.addParam("totalErrNum", "0");
        param.addParam("isaccu", "0");
        param.addParam("teststate", "0");
        param.addParam("isbranch", "" + isbranch);
        return param;
    }

    protected RowParams getSaveData(TEBitTestData testdata) {
        this.handledata(testdata);
        RowParams param = new RowParams();
        String portname = TEBitTestUtility.getPortName(this.neid, this.slotid, testdata.getPortid());
        param.addParam("portid", testdata.getPortid() + "");
        param.addParam("portname", portname);
        param.addParam("channel", "-");
        param.addParam("direction", testdata.getDirection() + "");
        param.addParam("timeunit", testdata.getTimeUnit() + "");
        param.addParam("testtime", testdata.getTesttime() + "");
        param.addParam("starttime", testdata.getStartTime());
        param.addParam("progress", testdata.getProgress() + "%");
        param.addParam("totalErrNum", testdata.getTotalErrNum() + "");
        param.addParam("isaccu", testdata.isAccumulation() + "");
        param.addParam("teststate", testdata.getTeststate() + "");
        if (0 == testdata.getDirection()) {
            param.addParam("isbranch", "false");
        } else {
            param.addParam("isbranch", "true");
        }
        return param;
    }

    private void handledata(TEBitTestData testdata) {
        long totaltesttime;
        if (testdata.getTeststate() == 0) {
            return;
        }
        int timeUnit = testdata.getTimeUnit();
        int abletime = 0;
        abletime = timeUnit == 1 ? 25000 : 120000;
        long currenttime = TENETimeUtility.getNmsUTCTime() + testdata.getNeToNmsTime();
        long starttime = testdata.getStartTimeToLong();
        if (starttime + (totaltesttime = testdata.getTotalTesttimeInMillisecond()) + (long)abletime < currenttime) {
            testdata.setProgress(100);
            testdata.setTeststate(0);
            return;
        }
        long lastreporttime = testdata.getLastreportTime();
        if (lastreporttime == 0L && testdata.getQueryList().size() <= 0) {
            testdata.setTeststate(1);
            return;
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

