 
/* page element id 
 o.1.* represent NE
 o.2.* represent slot
 o.3.* represent board/card
*/

/*
 *            
 */
loadXMLdoc("../../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../../../../../necommon/res/boardview_" + language + ".xml");
colon = ": ";
if ("zh" == language)
{
	colon = " ";
}
var eid;
var neobject = getNeProperty(top);
var neSlots = new Array(1,2,3,4,5,6,23,24);

var bfirstenter=true;

var BLANK_AREAR = 1;
var SLOT_AREAR = 2;
var BOARD_AREAR = 3;

function hfPostInitView()
{
   hfRelayout("contentContainer", 20, 20);//resize width, height
   
   if(0 == SYSTEMCONF.getDemo())
   {
   	  qLogicboard();
      window.setInterval("qLogicboard()",6000);
   }
}

function hfInitDiv()
{
	$("bpgimg").alt = RESOURCE["bpgimg"] ;
	$("bloopimg").alt = RESOURCE["bloopimg"];
	$("showmap").alt = RESOURCE["showmap"];	
	$("batchadd").value = RESOURCE["batchadd"];
}

/**
 *           
 * 
 * @param evt:  
 * @return  
 */
function hfItemContextMenuHandler(evt)
{
	hfClearSelState();
	var eid = hfGetEIDFromEvent(evt);
	if (!eid)
	{
		return false;
	}
	
	
	if (eid.cid == SLOT_AREAR)
	{
		var boardid = 'o.3.' + eid.id;
		var elem = document.getElementById(boardid);
		if (elem)
		{
			return true;
		}
	}
   	
	hfSetSelState(eid);
	hfSetSelectedItem(eid.asOID());
	hfGetPopupMenu(eid);
	rightClickHandler(evt);
    return false;
}

/*
Event handler that handles left click event.
*/
function leftClickHandler(e) { // Private method

  if (getX(e) > getClientWidth() || getY(e) > getClientHeight()) {
    return;
  }
  if (!e) {
    var e = window.event;
  }
  if (e.button && e.button == 2) {
    return;
  }
  hideVisibleMenus();
  hideMenu(e);
  
	var eid = hfGetEIDFromEvent(hfWrapEvent(event, this));
	if (!eid)
	{
		return false;
	}
	
  if(eid.cid == BOARD_AREAR)
  {
	  var slotid = eid.id;
	
    var bdEle = window.top.frames["objecttree"].tree[slotid];
    if(null == bdEle)
    {
    	return;
    }

    
    bdEle.isSelect();
    
    window.top.frames["functiontree"].refreshLastFuncID();
    
    bdEle.onClick();  	
 	}	
}


function hfGetPopupMenu(eid)
{
	var menuObj = null;

	for ( var i = 1; i <= menuCount; i++)
	{
		menuObj = $("DOMenu" + i);
		menuObj.parentNode.removeChild(menuObj);
	}
	menuCount = 0;

	if (eid.cid == BLANK_AREAR)
	{
		createjsDOMenu();
	}
	else if (eid.cid == SLOT_AREAR) // slot
	{
		var url = "../../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_GET_SUPPORTED_CIRCUITPACK;
		loadXMLdoc(url, "POST", false, getSlotCardCallback, eid, "inputdata="
				+ createGetBoardXML(eid.id));
	}
	else if (eid.cid == BOARD_AREAR) // board
	{

		if (eid.bstate == "2")//       60020637
		{
			var url = "../../../../../../neExlorerServlet?sfid="
					+ TECMDCODE_GET_SUPPORTED_CIRCUITPACK;
			loadXMLdoc(url, "POST", false, getSlotCardCallback, eid,
					"inputdata=" + createGetBoardXML(eid.id));
		}
		else
		{
			var url = "../../../../../../neExlorerServlet?sfid="
					+ TECMDCODE_GET_CPINFO;
			loadXMLdoc(url, "POST", false, initMenu, eid, "inputdata="
					+ createGetMenuXML(eid.id));
		}
	}
}   
 
function createjsDOMenu()
{
	removejsDOMmenu(); 
    var cursorMenu1 = new jsDOMenu(150); //   150
    		    
    with (cursorMenu1)
    {   	
  	  	addMenuItem(new menuItem(RESOURCE["clear_alarm_indication"],"",alarmReset,0));
  	}
    setPopUpMenu(cursorMenu1); 
    
}

/*
 *        
 */
function alarmReset()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	var neid =  getNeProperty(top).neid;

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",neid);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","reset");
	thirdlevel.setAttribute("value","0");//    
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	var xml = root.toString();	 	 
	var URL = "../../../../../../neExlorerServlet?sfid="
			+ TE_CLR_NE_ALM_INDICATE_CMD + "&flag=1";
	loadXMLdoc(URL,"POST",true,alarmResetHandBack,null,"inputdata="+xml); 
}

function alarmResetHandBack(doc)
{
	var datainterface = EncapsulateData(doc);
	 
	var errArr = [];
	errArr[0] = "nename";	  
	openErrPage("../../../../../../page/", datainterface.getError(), errArr);
}
 
/**
 *              XML  
 * 
 * @param slotid   ID
 * @return String:   XML  
 */
function createGetMenuXML (slotid)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row =  new tagElement("row-params");
    var param = new tagElement("param");
    var neid =  getNeProperty(top).neid;
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *      
 * 
 * @param doc        
 *            evt:  
 * @return  
 */
function initMenu (doc,eid)
{
	var data = EncapsulateData(doc);

       var topmenuList = getChildMenuItemList(data,"");
       if(0 != data.getSErrorCode() || 0 == topmenuList.length)
       {
	  			isRefreshBoard = true;
          hfClearSelState();
          return;
       }

    var topmenu = new jsDOMenu(150);
    for(var i = 0, len = topmenuList.length; i < len; i++)
    {
    	var id = topmenuList[i]["id"].value;
    	var name = topmenuList[i]["name"].value;
    	var funcid = topmenuList[i]["funcid"].value;
    	var action = topmenuList[i]["action"].value;
    	var parent = topmenuList[i]["parent"].value;
    	var paramArr = [eid,funcid];
    	with(topmenu)
    	{
    		if("" == id)
    		{
    			addMenuItem(new menuItem(name));
    		}
    		else
    		{
		    	addMenuItem(new menuItem(name,id,eval(action),paramArr));
    	        handleSubMenu(data,topmenu, id,eid);
    		}
    	}    	
    }
   setPopUpMenu(topmenu);

}

/**
 *      ID        
 * 
 * @param data        
 *            parentid:   ID
 * @return Array:     
 */
function getChildMenuItemList(data,parentid)
{
	var childMenuItemList = [];
	var parent = null;
	var count = 0;
    for(var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
    	parent = data.getDataRowParam(i,"parent");
    	if(parent == parentid)
    	{
    		childMenuItemList[count] = data.rows[i];
    		count ++;
    	}
    }
    return childMenuItemList;
}

/**
 *      
 * 
 * @param data        
 *            parentmenu       parentMenuid:   ID
 * @return  
 */
function handleSubMenu(data, parentmenu, parentMenuid, eid)
{
	var subMenuList = getChildMenuItemList(data,parentMenuid);
    if(0 == subMenuList.length)
    {
        return
    }
    var subMenu = new jsDOMenu();


    for(var i = 0, len = subMenuList.length; i < len; i++)
    {
    	var id = subMenuList[i]["id"].value; //  ID
    	var name = subMenuList[i]["name"].value; //    
    	var funcid = subMenuList[i]["funcid"].value; //     ID
    	var action = subMenuList[i]["action"].value; //   action
    	var parent = subMenuList[i]["parent"].value; //    ID
    	var paramArr = [eid,funcid];
    	with(subMenu)
    	{
    		if("" == id)
    		{
    			addMenuItem(new menuItem(name));
    		}
    		else
    		{
	    		addMenuItem(new menuItem(name,id,eval(action),paramArr));
    			handleSubMenu(data,subMenu, id);
    		}
    	}    	
    }
    parentmenu.items[parentMenuid].setSubMenu(subMenu);
}

/**
 *                
 * @param paramArr          ID   ID
 * @return  
 */
function goNEFuncBrowse(paramArr)
{
    hfClearSelState();
    
	eid = paramArr[0];
    var funcid = paramArr[1];
	
    var bdEle = window.top.frames["objecttree"].tree[getNeProperty(top).realNEID];
    if(null == bdEle)
    {
    	return;
    }

    
    bdEle.isSelect();
    
    
    bdEle.onClick();


    var fun = window.top.frames["functiontree"].tree[funcid];
    if(null == fun)
    {
    	return;
    }

    
    fun.expand();
    
    
    fun.isSelect();
    
    
    fun.onClick();
    if(3084==funcid)
    {
        goAlarm();
    }
    else
    {
        fun = null;
        bdEle = null; 
    }
    
       
}

function goAlarm()
{
    top.globalparam = 1;
    if(top.frames["data"].frames["tab_body_3084"].slotId)
	{
	   var curAlarmWin = top.frames["data"].frames["tab_body_3084"];
	   
       curAlarmWin.slotId = eid.id;
       curAlarmWin.firstFlag = 1;	
       curAlarmWin.refreshAlarmlist();
       
       fun = null;
       bdEle = null;
       top.globalparam = 0;
    }
	else
	{
	   window.setTimeout(goAlarm,100);	   
    }
    
}
/**
 *                
 * @param paramArr          ID   ID
 * @return  
 */
function goBoardFuncBrowse(paramArr)
{
    hfClearSelState();
    
	var eid = paramArr[0];
    var funcid = paramArr[1];
    
	var slotid = eid.id;
	
    var bdEle = window.top.frames["objecttree"].tree[slotid];
    if(null == bdEle)
    {
    	return;
    }

    
    bdEle.isSelect();
    
    
    bdEle.onClick();


    var fun = window.top.frames["functiontree"].tree[funcid];
    if(null == fun)
    {
    	return;
    }

    
    fun.expand();
    
    
    fun.isSelect();
    
    
    fun.onClick();
    fun = null;
    bdEle = null;    
}

/**
 *         hop    
 * @param paramArr          id
 * @return  
 */
function goOpenHopMgr(paramArr)
{
    var eid = paramArr[0];
    var slotid = eid.id;
    queryOppositeNE(slotid);
}

function queryOppositeNE(slotid)
{
    var xml = createOppositeNEXML(slotid);
    var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_HOP_QUEERY_PEERNE;
    loadXMLdoc(urlreq, "POST", false, showHopMgrShotcut, slotid, "inputdata=" + xml);
}

function createOppositeNEXML(slotid)
{
    var di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function showHopMgrShotcut(doc, slotid)
{
    var data = EncapsulateData(doc);
    hopMgrErrorDialog(data);
    if (data.getSErrorCode() == 0 && data.getDataRowLength() == 1) 
    {
        var peerNeid = data.getDataRowParam(0, "peerNEID");
        var peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
        var peerNeName = data.getDataRowParam(0, "peerNEName");
        var peerNeType = data.getDataRowParam(0, "peerNEType");
        var peerNeUser = data.getDataRowParam(0, "peerNEUser");
        var peerNeVersion = data.getDataRowParam(0, "peerNEVersion");
        var peerNeState = data.getDataRowParam(0, "peerNEState");
        var peerSlotId = data.getDataRowParam(0, "peerSlotId");
        var subUrl = "neid=" + peerNeid + "&realNEID=" + peerRealNEID + "&neName=" + peerNeName + "&neType=" + peerNeType;
        subUrl += "&neuser=" + peerNeUser + "&neversion=" + peerNeVersion + "&nestate=" + peerNeState + "&hslotid=" + peerSlotId;
        
        var mainUrl = parent.parent.parent.location.search + "&hslotid=" + slotid;
        var linkUrl = mainUrl + "&" + "left" + "=" + "0" + "||" + subUrl + "&" + "right" + "=" + "1";
        var url = "../../../../../page/hopmgr/hopnemgr.html" + linkUrl;
        var hopManagePage = window.open(url, "hopmgr", "menubar=no,status=yes,scrollbars=yes,resizable=yes");
        hopManagePage.focus();
        hopManagePage.moveTo(20, 20);
        hopManagePage.resizeTo(screen.availWidth - 40, screen.availHeight - 40);
    }
}

function hopMgrErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *              XML  
 * @param slotid   ID
 * @return String:   XML  
 */
function createGetBoardXML(slotid)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slotid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "shelfType");
    var shelf =document.getElementById("o.1.1").getAttribute("shelfType");
    param.setAttribute("value", shelf);
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *                 
 * @param doc         eid:  ID
 * @return  
 */
function getSlotCardCallback(doc,eid)
{
    var result = EncapsulateData(doc);
    if(0 != result.getError().getGlobleECode())
    {
    	return;
    }

    var topmenu=getSlotPopupMenu(result,eid);

    setPopUpMenu(topmenu);
    return topmenu;
}
/*
         
@param doc     
*/
function getSlotPopupMenu(result, eid)
{
	  var topmenu = new jsDOMenu(150);
	  topmenu.setMenuType(eid.cid);
	  
	  if(result.getDataRowLength() > 10)
	  {
	  	topmenu.setMenuType(slotMenuType);
	  }
	  
	  
    with(topmenu)
    {
    	var elem=document.getElementById('o.3.8');
    	
        if(eid.bstate == "2")
	    {
		  	var bdname = eid.bname;
		    var boardType = eid.btype;
		    var slotList = eid.bslotlist;
		    var paramArr = [eid.id,boardType,bdname,slotList];
			addMenuItem(new menuItem(RESOURCE['addPhyBoard'], boardType,
					addCard, paramArr));
	    }
		  
	    for(var rowidx = 0; rowidx < result.getDataRowLength(); rowidx++)
	    {
	        var bdname = result.getDataRowParam(rowidx, 'boardName');
	        var boardType = result.getDataRowParam(rowidx, 'boardType');
	        var slotList = result.getDataRowParam(rowidx, 'slotList');
	        var paramArr = [eid.id,boardType,bdname,slotList];
	        
			if (elem && bdname == 'APIU')
			{
				addMenuItem(new menuItem(RESOURCE['add'] + ' ' + bdname,
						boardType, addCard, paramArr, false));
			}
			else
			{
				addMenuItem(new menuItem(RESOURCE['add'] + ' ' + bdname,
						boardType, addCard, paramArr));
			}
		}

	}

	return topmenu;
}

/**
 *     
 * @param args:    
 * @return  
 */
function delCard(args)
{
	
	  disableRefreshBoard=true;
	  var eid = args[0];

    if(1 == SYSTEMCONF.getDemo())
    {
        var card = document.getElementById(eid.toString());
        card.parentNode.removeChild(card);
        return false;
    }
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    var slotid = eid.id;
    param.setAttribute("value", slotid);
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_DEL_CIRCUITPACK, "POST", true, delCardCallback, eid,
			"inputdata=" + di.toString());
}

/**
 *          
 * @param doc        eid   ID
 * @return  
 */
function delCardCallback(doc, eid)
{
	  disableRefreshBoard=false;
    var result = EncapsulateData(doc);
    if(0 == result.getError().getGlobleECode())
    {
    	  
        var card = document.getElementById(eid.toString());
        var boardName=card.boardName;
        card.parentNode.removeChild(card);
        var soltid=eid.id;
       	var rootNode=top.frames["objecttree"].rootNode;
		if (rootNode && (soltid == top.frames["objecttree"].tree.selectID))
		{
        	 rootNode.isSelect();
           rootNode.expand();
           rootNode.onClick();
        }
       top.frames["objecttree"].opentree_servlet(); 
               
    }
    else //           
    {
        var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
		openErrPage("../../../../../../page/", result.getError(), oArray);
    }
}


function qLogicboardCallback(result)
{
    if(0 == result.getError().getGlobleECode())
    {
        var boardSlot = neSlots.slice(0);// copy neSlots array
        for(var rowidx = 1; rowidx < result.getDataRowLength(); rowidx++)
        {
            var slot = result.getDataRowParam(rowidx, 'slotID');
            var bdid = result.getDataRowParam(rowidx, 'boardType');
            var label = result.getDataRowParam(rowidx, 'boardName');
            var bstate = result.getDataRowParam(rowidx, 'boardState');//60020637   
            var bloop = result.getDataRowParam(rowidx, 'boardLoop');//60020637     
            var bpg = result.getDataRowParam(rowidx, 'boardPG');//60020637     
            var slotList = result.getDataRowParam(rowidx, 'slotList');  //    
            
		        var slotDiv = document.getElementById('o.3.'+slot)  	            
		        if(null == slotDiv)
		        {
		            paintCard(slot,bdid,label,slotList,bstate,bloop,bpg);//60020637         
            }
            else
            {
               repaintCardLabel(slot,bdid,label,slotList,bstate,bloop,bpg);//     
            }
           
           if(bstate != "2")
           {
              boardAlarmLevel(slot); 
           }               
		       rmFromArray(slot,boardSlot);
        }

        for (var j=0; j<boardSlot.length; j++)
        {
            var card = document.getElementById("o.3."+boardSlot[j]);
            if (null != card)
            {
                card.parentNode.removeChild(card);
            }
        }
    }
}

function repaintCardLabel(slot,bdid,label,slotList,bstate,bloop,bpg)
{
   var board = document.getElementById("o.3."+slot);
	 var childDiv = board.firstChild.childNodes;//   Div
	 var childDivlength = childDiv.length ;
	 var labelDiv ;
   if (!board)
   {
     return false; 
   }
   if(bdid != board.bdid)//                    
   { 
   	if(slotList != board.slotlist)//        ,     
   	{
   	 	var  slotDiv = calcBoardPostion(slotList);
      board.style.top = (parseInt(slotDiv.top)+1)+'px';
      if(slotDiv.left) board.style.left = (parseInt(slotDiv.left)+1)+'px';
      if(slotDiv.right) board.style.right = (parseInt(slotDiv.right)+1)+'px';
      board.style.width = (parseInt(slotDiv.width)-4)+'px';
      board.style.height = (parseInt(slotDiv.height)-4)+'px';  	 	
      board.slotlist = slotList ;
   	}  
    if( label != board.blabel) //        
    {
        for(var i = 0 ; i < childDivlength ;i++)
        {
        	if('Label' == childDiv[i].className)
        	{
        	  	labelDiv = childDiv[i];//  Label Div
        	  	break;
        	}
        }  
        if(labelDiv)     
        {
           var boardwidth  = parseInt(board.firstChild.style.width);
           var boardheight = parseInt(board.firstChild.style.height);
       
           if (boardwidth < boardheight)
           {
           	  var str = "";
           	  for (var i=0; i<label.length-1; i++)
           	  {
           	  	str = str+label.charAt(i)+'<br/>';
           	  }
           	  labelDiv.innerHTML = str+label.charAt(label.length-1);
           }
           else
           {
           	  labelDiv.innerHTML = label;
           }
        }
        board.blabel = label;  
        labelDiv = null; 
    }
    board.bdid = bdid ;
   }

   if(bstate != board.bstate)
   {

      if( bstate == "0")
      {
          board.className = 'Card SelStateOff';
      }
      else if(bstate == "1")
      	{
      		board.className = 'Cardlogic SelStateOff';
      	}
      else if(bstate == "2")
      	{
      		board.className = 'Cardphy SelStateOff';
      		
      		
      	}
      else if(bstate == "3")
      	{
      		board.className = 'Cardphylog SelStateOff';
      	}
      else
      	{
      		board.className = 'Cardlogic SelStateOff';
      	}  
      board.bstate = bstate ;
   } 
{
      var labelDiv ;
        for(var i = 0 ; i < childDivlength ;i++)
        {
        	if('alarmlight' == childDiv[i].id)
        	{
        	  	labelDiv = childDiv[i];//      DIV
        	  	break;
        	}
        }  
        if(labelDiv)// labelDiv    
        {
         	if(board.bstate == "2")//            DIV    
         	{     		
         	  labelDiv.style.visibility = "Hidden" ;	
         	} 
         	else
         	{
         		labelDiv.style.visibility = "visible" ;		
         	} 
          labelDiv = null;
       }
 }
   if(bloop != board.bloop)//         60020637
   {
    for(var i = 0 ; i < childDivlength ;i++)
    {
    	if('Loop' == childDiv[i].className)
    	{
    	  	labelDiv = childDiv[i];
    	  	break;
    	}
    }   
    if(labelDiv)//        
    {
     if(bloop == "1")	
     {
     	 labelDiv.style.visibility = "visible";    
     }
     else
     {
     	 labelDiv.style.visibility = "hidden";
     }
    }
    else if(bloop == "1")//bloop               Div 
    {
       var div5 = board.firstChild.appendChild(document.createElement('div'));
       div5.style.position = 'absolute';
       div5.className = 'Loop';	
       div5.style.left= '-2px';                     
       div5.style.bottom = '-7px';                     
       div5.style.width = '10px';                     
       div5.style.height = '10px';    	 
    }  
    board.bloop = bloop;
    labelDiv = null;
   }   

    if(bpg != board.bpg)//        60020637
   {
    for(var i = 0 ; i < childDivlength ;i++)
    {
    	if('bpg' == childDiv[i].className)
    	{
    	  	labelDiv = childDiv[i];
    	  	break;
    	}
    }  
    if(labelDiv)//        
    {
     if(bpg == "1")	
     {
     	 labelDiv.style.visibility ="visible";    
     }
     else
     {
     	 labelDiv.style.visibility = "hidden";
     }
    }
    else if(bpg == "1")
    {
    	 var div6 = board.firstChild.appendChild(document.createElement('div'));
    	 div6.style.position = 'absolute';
       div6.className = 'bpg';
       div6.style.right= '-5px';
       div6.style.bottom = '-5px';
       div6.style.width = '10px';
       div6.style.height = '10px';   	 
    }  
    board.bpg = bpg;
    labelDiv = null ;
   }   
   
      
}
function qLogicboard()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_QUERY_LOGIC_CIRCUITPACK, "POST", true,
			refreshBoardCallBack, null, "inputdata=" + di.toString());
	clean(param);
	param = null;
	clean(row);
	row = null;
	clean(bussiness);
	bussiness = null;
	clean(di);
	di = null;
}


  
/*
           
*/
function refreshBoardCallBack(doc)
{  
	  if(popUpMenuObj && "hidden" != popUpMenuObj.menuObj.style.visibility && !isRefreshBoard)
    {
    	  isRefreshBoard = false;
	 	    return;
	 	}
	  
    if(disableRefreshBoard)
    {
  	    return;	
	  }
	  
	  var data = EncapsulateData(doc);
	  
    if(0 != data.getSErrorCode())
    {
        return;
    }
    
    qLogicboardCallback(data);

	  if(top.frames["objecttree"]&&top.frames["objecttree"].handlerTreeDate)
    {
        top.frames["objecttree"].window.handlerTreeDate(data);
    }
}

/*
     left,top,width,height(           
*/
    
function calcBoardPostion(slotList){

    var boardPos=new Object();
    boardPos.top=Number.MAX_VALUE;
    boardPos.left=Number.MAX_VALUE;
    boardPos.right=0;
    boardPos.bottom=0;

   
   var top,left,right,bottom;
   
   var slotArray = slotList.split(",");
   
   for (var j=0; j<slotArray.length; j++)
   {
   	   var slotDiv = document.getElementById('o.2.'+slotArray[j]);
   	   if(!slotDiv)
   	   {
   	     continue;	
       }
       
   	   top=parseInt(slotDiv.style.top);
       if(top<boardPos.top){
        	boardPos.top =top;
       }
       
       left=parseInt(slotDiv.style.left);
       if(left<boardPos.left)
       {
       	 boardPos.left=left;
       }
       
       right=parseInt(slotDiv.style.left)+parseInt(slotDiv.style.width);
       if(right>boardPos.right)
       {
         	boardPos.right = right;
       }
       
       
       bottom =parseInt(slotDiv.style.top)+parseInt(slotDiv.style.height);
       if(bottom >boardPos.bottom)
       {
         	boardPos.bottom =bottom;
       }
       
   }
	
	   boardPos.width = boardPos.right-boardPos.left;
	   boardPos.height = boardPos.bottom-boardPos.top;
	   
	   return boardPos;
	   
	  
}
function paintCard(slot,bdid,label,slotList,bstate,bloop,bpg)
{
  	if (null != document.getElementById('o.3.'+slot))
		{
				return;	
		}
  	
    var  slotDiv = calcBoardPostion(slotList);
    
    var neDiv =document.getElementById("o.1.1");
    var shelfDiv = gerFirstTagElement(neDiv);
    var div = shelfDiv.appendChild(document.createElement("div"));
    if("0" == bstate)
    {
        div.className = 'Card SelStateOff';
    }
    else if("1" == bstate)
    {
    	  div.className = 'Cardlogic SelStateOff';
    }
    else if("2" == bstate)
    {
    	  div.className = 'Cardphy SelStateOff';
    }
    else if("3" == bstate)
    {
    	  div.className = 'Cardphylog SelStateOff';
    }    
    else
    {
        div.className = 'Cardlogic SelStateOff';       
    }
    div.setAttribute('id', 'o.3.'+slot);		
    div.setAttribute('bdid', bdid); 
    
    div.setAttribute('bstate',bstate);
    div.setAttribute('blabel',label);
    div.setAttribute('slotlist',slotList);
    div.style.position = 'absolute';
    div.style.padding = '1px'; 
    
    div.boardType=bdid;
    div.boardName=label;
    
    div.style.top = (parseInt(slotDiv.top)+1)+'px';
	if (slotDiv.left)
		div.style.left = (parseInt(slotDiv.left) + 1) + 'px';
	if (slotDiv.right)
		div.style.right = (parseInt(slotDiv.right) + 1) + 'px';
    div.style.width = (parseInt(slotDiv.width)-4)+'px';
    div.style.height = (parseInt(slotDiv.height)-4)+'px';
        
    var div2 = div.appendChild(document.createElement("div"));
    div2.style.position = 'relative';
    div2.style.width = (parseInt(div.style.width)-4)+'px';
    div2.style.height = (parseInt(div.style.height)-4)+'px';

    var ycenter= parseInt(div2.style.height);
    
    var div3 = div2.appendChild(document.createElement('div'));
    div3.style.position = 'absolute';
    div3.className = 'LED';
    div3.setAttribute('id', 'alarmlight');//      ID  
    div3.style.top="6px";  
    div3.style.left = '6px';
    div3.style.width = '7px';
    div3.style.height = '7px';
    if("2" == bstate) //            
    {
        div3.style.visibility = "hidden" ;  
    }
   
    
    if (parseInt(div2.style.width) > parseInt(div2.style.height))
    {
    	  div3.style.top = (ycenter - 7) / 2 + 'px';
    }
        

    var div4 = div2.appendChild(document.createElement('div'));
    div4.style.position = 'absolute';
    div4.className = 'Label';
    div4.style.right= '1px';
    div4.style.bottom = '1px';

    if (parseInt(div2.style.width) > parseInt(div2.style.height))
    {
        div4.appendChild(document.createTextNode(label));
        
        div4.style.bottom = (ycenter - 14) / 2 + 'px';
    }
    else
    {
        var s = '';
        for (var i=0;i<label.length ;i++)
        {
            s = s + label.charAt(i) ;
            if (i < label.length-1) // last char need not append <br />
            {
                s = s + "<br />";
            }
        }
        div4.innerHTML = s;

        var slotWidth = 26; //    
        var len = slotList.split(",").length;
        var div2width = slotWidth*len + 3*(len-1) - 8;
        div4.style.right = (div2width-15)/2+"px";
    }
    
       if (bloop == "1")
   {
    var div5 = div2.appendChild(document.createElement('div'));
    div5.style.position = 'absolute';
    div5.className = 'Loop';
    div5.style.left= '-2px';
    div5.style.bottom = '-7px';
    div5.style.width = '10px';
    div5.style.height = '10px';
   }
   
    if(bpg == "1")
    {
    var div6 = div2.appendChild(document.createElement('div'));
    div6.style.position = 'absolute';
    div6.className = 'bpg';
    div6.style.right= '-5px';
    div6.style.bottom = '-5px';
    div6.style.width = '10px';
    div6.style.height = '10px';
    }    
    
}


function addCard(args)
{
	  disableRefreshBoard=true;
	  
		var slot = args[0]; //  ID
	  var bdid = args[1]; //  ID
	  var label = args[2]; //    
	  var slotList = args[3]; //       
    if(1 == SYSTEMCONF.getDemo())
    {
        paintCard(slot,bdid,label);
        return false;
    }

    function addCardCallback(doc, args)
    {
    	  disableRefreshBoard=false;
        var result = EncapsulateData(doc);
        if(0 == result.getError().getGlobleECode())
        {
            if( "2" == args[4])
              {
              $('o.3.'+args[0]).className = 'Cardphylog SelStateOff';
              $('o.3.'+args[0]).firstChild.childNodes[0].style.visibility ="visible"
              $('o.3.'+args[0]).bstate = "3" ;
              }
              else
             	{
                  if (null == args[3]) //slotList
                  {
                      paintCard(args[0],args[1],args[2]);
                  }
                  else
                  {
                      paintCard(args[0],args[1],args[2],args[3]);
                  }
              }
              
                 top.frames["objecttree"].opentree_servlet(); 
         }
        else
        {
            var oArray = new Array();
            oArray[0]= "nename";
            oArray[1]= "slotID";
            oArray[2]= "boardname";
			openErrPage("../../../../../../page/", result.getError(), oArray);
        }
        
        isAdding = false;
    }

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slot);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "boardType");
    param.setAttribute("value", bdid);
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);

    if (!isAdding)
    {
    	isAdding = true;
		loadXMLdoc("../../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_CREATE_CIRCUITPACK, "POST", false, addCardCallback,
				args, "inputdata=" + di.toString());
    }
    else
    {
    	alert(RESOURCE["isadding"]);
    }
}


function batchAddCard(args)
{
	disableRefreshBoard=true;	  
    function batchAddCardCallback(doc, args)
    {
    	disableRefreshBoard=false;
        var result = EncapsulateData(doc);
        if(0 == result.getError().getGlobleECode())
        {             
            top.frames["objecttree"].opentree_servlet(); 
        }
        else
        {
            var oArray = new Array();
            oArray[0]= "nename";
            oArray[1]= "slotID";
            oArray[2]= "boardname";
			openErrPage("../../../../../../page/", result.getError(), oArray);
        }
        
        isAdding = false;
    }

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    if (!isAdding)
    {
    	isAdding = true;
		loadXMLdoc("../../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_ADD_BOARDS_IN_BATCHES, "POST", false,
				batchAddCardCallback, args, "inputdata=" + di.toString());
    }
    else
    {
    	alert(RESOURCE["isadding"]);
    }
}



function boardAlarmLevel(slot)
{
    function boardAlarmLevelCallback(doc, slot)
    {//alert('boardAlarmLevelCallback()'+slot);
        var result = EncapsulateData(doc);

        if(result.getDataRowLength() > 0)
        {//alert("topAlmLevel="+result.getDataRowParam(0, 'topAlmLevel'));
            var lev = result.getDataRowParam(0, 'topAlmLevel');
            setBoardLED(slot,lev);
        }
    }

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slot);
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_GET_NECPSANDALM, "POST", true, boardAlarmLevelCallback,
			slot, "inputdata=" + di.toString());
}

function setBoardLED(slot,almLevel)
{
    var board = document.getElementById("o.3."+slot);
    if (!board)
    {
        return false; // if board element not exist, do nothing, return false.
    }
    var c = board.firstChild.childNodes;
    var ledDiv = ('Label' == c[0].className) ? c[1] : c[0];

	switch (almLevel)
	{
		case "-1":
			if ("LED" != ledDiv.className)
			{
				ledDiv.className = "LED";
			}
			break;
		case "1":
			if ("RedLED" != ledDiv.className)
			{
				ledDiv.className = "RedLED";
			}
			break;
		case "2":
			if ("major" != ledDiv.className)
			{
				ledDiv.className = "major";
			}
			break;
		case "3":
			if ("YellowLED" != ledDiv.className)
			{
				ledDiv.className = "YellowLED";
			}
			break;
		case "4":
			if ("warning" != ledDiv.className)
			{
				ledDiv.className = "warning";
			}
			break;
		default:
			ledDiv.className = "GreenLED";
			break;
	}
}

function delayGoPage(n)
{
    var fun=window.top.frames["functiontree"].tree[n];
    fun.expand();
    fun.isSelect();
    fun.onClick();
    fun = null;
}

function goAlmBrowse(id)
{
	  if(1==SYSTEMCONF.getDemo()){
	  	return;
	  }	
	 
    if ("o.1.1" == id)
    {
        var ne=window.top.frames["objecttree"].tree[getNeProperty(top).neid];
        ne.isSelect();
        ne.onClick();
        window.setTimeout("delayGoPage(3084)", 600);
    }

    if (id.indexOf("o.3")>=0)
    {
        var ps = id.lastIndexOf(".");
        var slot = id.substring(ps+1);
        var bdEle=window.top.frames["objecttree"].tree[slot];
        bdEle.isSelect();
        bdEle.onClick();
        window.setTimeout("delayGoPage(3084)", 600);
    }
}

function goNeAttrib()
{
	 if(1==SYSTEMCONF.getDemo()){
	   return;	
	 }
	
    var ne=window.top.frames["objecttree"].tree[getNeProperty(top).neid];
    ne.isSelect();
    ne.onClick();
    window.setTimeout("delayGoPage(8193)", 600);
}

function rmFromArray(value,oArray)
{
    var i=0;
    for(i=0;i<oArray.length;i++)
    {
        if(value == oArray[i])
        {
            oArray.splice(i,1);
        }
    }
}

function clean(obj)
{
    for(var k in obj)
    {
        obj.k = null;
    }
}

/*
 *      
*/
function boardHardReset(args)
{
	hideAllMenus();
	if (confirm(RESOURCE["resetinfo"]))
	{
		var eid = args[0];
  	eid.mode=0;
  	boardReset(eid); 	
	}
}

function boardSoftReset(args)
{
	hideAllMenus();
	if (confirm(RESOURCE["softresetinfo"]))
	{
		var eid = args[0];
  	eid.mode=1;
  	boardReset(eid); 	
	}
}

function sccBoardSoftReset(args)
{
	hideAllMenus();
	if(confirm(RESOURCE["resetsccalarm"]))
	{
      var di = new inputxml("datainterface");
	    var bussiness = new tagElement("bussiness-params");
	    var row = new tagElement("row-params");
	    var param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", getNeProperty(top).neid);
	    row.appendChild(param);
	    bussiness.appendChild(row);
      di.getRoot().appendChild(bussiness);
      
		loadXMLdoc("../../../../../../neExlorerServlet?sfid="
				+ TECOMCODE_RESETSCC, "POST", true, boardResetCallback, "",
				"inputdata=" + di.toString());
   }
}

function boardReset(eid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", eid.id);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "mode");
    param.setAttribute("value", eid.mode);
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_RESETBOARDSOFT, "POST", true, boardResetCallback, "",
			"inputdata=" + di.toString());
}
/*
 *          
 */
function boardResetCallback(doc)
{
	  var result = EncapsulateData(doc);
    
    if(0 == result.getError().getGlobleECode())
    {
    	var error = new AllError();
		  var eTag = new ErrorTag();
		  eTag.code = "succ";
		  eTag.info = RESOURCE["optSucc"];
		  error.s_error = eTag;
		openErrPage("../../../../../../page/", error, "");
    }
    else
    {
        if(1090650120==result.getError().getGlobleECode())
        {
            return;
        }
        var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
		openErrPage("../../../../../../page/", result.getError(), oArray);
    }
	 
}


/*
       
*/
function boardVersion(args)
{
    var eid = args[0];
    var xml = createBoardVersionXml(eid,1);
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_QUERY_BD_VER, "POST", true, boardVersionCallback, "",
			"inputdata=" + xml);
}

/*
        
*/
function sccBoardVersion(args)
{
    var eid = args[0];	
    var xml = createBoardVersionXml(eid,0);
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_QUERY_NE_VER, "POST", true, SccBoardVersionCallback,
			"", "inputdata=" + xml);
}
	
function createBoardVersionXml(eid,verid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    if(verid==1)
    {
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", eid.id);
    row.appendChild(param);
    }
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
	}
	
function boardVersionCallback(doc)
{
	var result = EncapsulateData(doc);
	var verString = "";
    if(0 != result.getError().getGlobleECode())
    {
 				var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
        openErrPage("../../../../../../page/",result.getError(),oArray);
        return;
    }
    var softVerLowBit = result.getDataRowParam(0, "softVerLowBit");
    if(softVerLowBit.length < 2)
    {
    	softVerLowBit = "0" + softVerLowBit;
    }
    verString = RESOURCE["boardversion"] + colon + result.getDataRowParam(0, "softVerHighBit")+ "." + softVerLowBit;
    alert(verString);
	}

function SccBoardVersionCallback(doc)
{
	var result = EncapsulateData(doc);
	var verSignal = "";
	var verString = "";
    if(0 != result.getError().getGlobleECode())
    {
 				var oArray = new Array();
        oArray[0]= "nename";
        openErrPage("../../../../../../page/",result.getError(),oArray);
        return;
    }

    for(i=0 , resultlen = result.getDataRowLength() ; i < resultlen ; i++)
    {
        verSignal = result.getDataRowParam(i, "verSignal");
        if( verSignal=="NSF1" || verSignal=="NSF2")
        {
        	if("active" == result.getDataRowParam(i, "activeSignal"))//          
          { 
             verString = RESOURCE["sccversion"] + colon + result.getDataRowParam(i, "versionStr");
             break;
          }
        }
    }
    alert(verString);
	}
	
/*
     
*/
function goPathChannel(args){
	  
	  var eid =args[0];
	  if(eid)
	  {
	    var pos=eid.toString().lastIndexOf(".");
	    var slotID= eid.toString().substring(pos+1); 	
	    var neid = getNeProperty(top).neid;
	    
		var pageurl = "../../../../../sdh/page/channel/channelpathgraph.html?" + "neid=" + neid
				+ "&slotID=" + slotID;
	   var sFeatures = "top=100,left=100,height=400,width=600,status=yes,toolbar=no,menubar=no,location=no";
     var newWin=window.open(pageurl,"channelpath", sFeatures);
     newWin.focus();
	  	
	  }
	 
}

/*
*      60020637
*
*/
function tableview()
{
    if($(maptable).style.visibility =="hidden")
    {
    $(maptable).style.visibility ="visible";
    $(showmap).src = "../../../../../../images/tree/mapsample.gif";
    }
    else if($(maptable).style.visibility =="visible")
    {
    $(maptable).style.visibility ="hidden"
    $(showmap).src = "../../../../../../images/tree/mapsample.gif";
    }
}

function getPhyBoard(eid)
{
	var PHYSTATE = "2" ;
  var topmenu = new jsDOMenu(150);
	  topmenu.setMenuType(PHYSTATE);
    with(topmenu)
    {     
    	    var bdname = eid.bname;
	        var boardType = eid.btype;
	        var slotList = eid.bslotlist;
	        var paramArr = [eid.id,boardType,bdname,slotList,PHYSTATE];	        
 	   	    addMenuItem(new menuItem(RESOURCE['add']+' '+bdname,boardType,addCard,paramArr));			    	 
	}
 setPopUpMenu(topmenu);
}

function queryBoard1p1Group()
{
    var xmlstr = createQueryXML();
	var urlreq = "../../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_1P1_GET_NM;
	  loadXMLdoc(urlreq, "POST",false,updatePG,null,"inputdata="+xmlstr);   
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue =getNeProperty(top)["neid"]; 
    param.setAttribute("name","neid");
    param.setAttribute("value",neidvalue);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();	
}
var backupSlotId;
function updatePG(doc)
{
    var data = EncapsulateData(doc);
    if(0 != data.getSErrorCode())
    { 
        var oArray = new Array();
        oArray[0]= "nename";
		openErrPage("../../../../../../page/", data.getError(), oArray);
        return;
    }   
    else
    {   
        if(data.getDataRowLength() > 0)
        {
            backupSlotId = data.getDataRowParam(0,"backupSlotNo");
            if(backupSlotId == 0)
            {
                var allerror = new AllError();
                var reobj = new RowError();
                reobj.errorObj["neid"] = getNeProperty(top).neid;
                var eTag = new ErrorTag();
                eTag.code = "38669";
                eTag.info = RESOURCE["bdoutposition"];
                reobj.error = eTag;
                allerror.rowErrors[allerror.rowErrors.length] = reobj;
                
                var eTag = new ErrorTag();
                eTag.code = "2";
                eTag.info = RESOURCE["operationfail"];
                allerror.s_error = eTag;
                
                var oArray = new Array();
                oArray[0]= "nename";
                openErrPage("../../../../.../../page/",allerror,oArray);
                return;
            }
            else
            {
                switchPG();
            }
        }
    }
}

function createSwitchXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
	var row = new tagElement("row-params");
            
    var param = new tagElement("param");
    neidvalue = getNeProperty(top)["neid"];
    param.setAttribute("name","neid");
    param.setAttribute("value",neidvalue);
    row.appendChild(param);
                
    param = new tagElement("param");            
    var dstSlotID = backupSlotId;
    param.setAttribute("name", "dstSlotID");
    param.setAttribute("value", dstSlotID);
    row.appendChild(param);
            
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();	
}

function switchPG(mode)
{

   var flag = window.confirm(RESOURCE["confirmswitch"]);
   if (!flag)  
   {
        return;   
   }
        
   xmlstr = createSwitchXML();
	urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_1P1_SWITCH;
	loadXMLdoc(urlreq, "POST", true, refreshWorkBoard, null, "inputdata="
			+ xmlstr);
   
}

function refreshWorkBoard(doc)
{
   
   var data = EncapsulateData(doc);
   if(0 != data.getSErrorCode()) 
   {
     showErrorDialog(data);
     return;
   }
}


var disableRefreshBoard=false;

var isAdding = false;

var isRefreshBoard = false;
