/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bundleactivator;

import com.huawei.nglct.bundleactivator.TESDHLineMspAdapter;
import com.huawei.nglct.bundlemgr.TEBundleSuperActivator;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.TELoadDataUtil;
import com.huawei.nglct.nemgr.device.sdh.TESDHDevFileProvider;
import com.huawei.nglct.nemgr.neadapter.NEFunctionAdapterInterface;
import com.huawei.nglct.nemgr.neadapter.TENEFuntionAdapterMgr;
import com.huawei.nglct.util.string.IFileRegisterer;
import com.huawei.nglct.util.string.TEFileRegisterer;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.IFileProvider;
import gnu.trove.TIntArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class SDHDevBundleActivator
extends TEBundleSuperActivator {
    private static final String NE_FILEPATH = "device/sdh/conf/ne.xml";
    private TIntArrayList fbMapping = new TIntArrayList();
    private ServiceRegistration sr;

    public void start(BundleContext context) throws Exception {
        context.registerService(IFileProvider.class.getName(), (Object)new TESDHDevFileProvider(), null);
        try {
            this.fbMapping = TEFileRegisterer.registerFiles((Bundle)context.getBundle());
            this.sr = context.registerService(IFileRegisterer.class.getName(), (Object)this, null);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("SDHDevBundleActivator.start() fail!", (Throwable)e);
        }
        Bundle commBundle = FrameworkUtil.getBundle(IFileProvider.class);
        if (commBundle.getState() == 32) {
            this.loadNeWhenBundleStart();
        }
        context.addBundleListener((BundleListener)new ActivatorBundleListener());
        this.registerFunctionInterface(context.getBundle());
    }

    public void stop(BundleContext context) throws Exception {
        this.sr.unregister();
    }

    public void registerFunctionInterface(Bundle bundle) {
        TENEFuntionAdapterMgr.getInstance().registerFunctionInterface(bundle.getSymbolicName(), (NEFunctionAdapterInterface)new TESDHLineMspAdapter());
    }

    public void loadNeStaticData() {
        TELoadDataUtil.loadNemgrData((String)NE_FILEPATH);
    }

    public boolean containsResFile(String filePaht) {
        int hash = TEStringUtils.hashString((String)filePaht);
        return this.fbMapping.contains(hash);
    }

    public String getDomain() {
        return "sdh";
    }

    class ActivatorBundleListener
    implements BundleListener {
        ActivatorBundleListener() {
        }

        public void bundleChanged(BundleEvent arg0) {
            Bundle bundle = (Bundle)arg0.getSource();
            if ("com.huawei.weblct.common".equals(bundle.getSymbolicName()) && bundle.getState() == 32) {
                SDHDevBundleActivator.this.loadNeWhenBundleStart();
            }
        }
    }
}

