var ATPCUPPERNUM = "-45.0";
var ATPCDOWMPERNUM = "-70.0";
var TRANSMITPOWER = "100.000";
var NONREVERTIVWTRTIME = 0;

var PORTNO = 1;
var board = new Object();

var boardList = null;

var win = getParentWindow();
var neid = win.neid;
var ct = null;

var isSuccess = false;

var hasApplied = false;
var MIN_PG_ID = 1;
var MAX_PG_ID = 2;

var workStatus = new Object();
workStatus[0] = "disable";
workStatus[1] = "enable";

var atpcEnableStatus = new Object();
atpcEnableStatus[0] = "sleep";
atpcEnableStatus[1] = "shoot";

/**var atpcAdjustment = new Object();
atpcAdjustment[0] = "num1";
atpcAdjustment[1] = "num2";
atpcAdjustment[2] = "num3";
atpcAdjustment[3] = "num4";
atpcAdjustment[4] = "num5";**/
var UsedBoardList = [];

function init()
{
	UsedBoardList = win.getUsedBoardList();
	
	ct = new CTable();
	ct.addHead(RESOURCE["attr"], RESOURCE["value"]);

	var bandWidthAtom = new Atom("select");
	bandWidthAtom.element.style.width = "100%";
	ct.addAttrRow("bandWidth", RESOURCE["bandWidth"], bandWidthAtom);

	var pDVAtom = new Atom("select");
	ct.addAttrRow("pDV", RESOURCE["pDV"], pDVAtom);

	var radioidVAtom = new Atom("text");
	ct.addAttrRow("radioidV", RESOURCE["radioidV"], radioidVAtom);

	var pDHAtom = new Atom("select");
	ct.addAttrRow("pDH", RESOURCE["pDH"], pDHAtom);

	var radioidHAtom = new Atom("text");
	ct.addAttrRow("radioidH", RESOURCE["radioidH"], radioidHAtom);

	var maxTransmitPowerAtom = new Atom("text");
	ct.addAttrRow("maxTransmitPower", RESOURCE["maxTransmitPower"],
			maxTransmitPowerAtom);
	
	var transmitPowerAtom = new Atom("text");
	ct
			.addAttrRow("transmitPower", RESOURCE["transmitPower"],
					transmitPowerAtom);

	var transmitFrequencyAtom = new Atom("text");
	ct.addAttrRow("transmitFrequency", RESOURCE["transmitFrequency"],
			transmitFrequencyAtom);

	var trIntervalAtom = new Atom("text");
	ct.addAttrRow("trInterval", RESOURCE["trInterval"], trIntervalAtom);

	var workStatusAtom = new Atom("select");
	ct.addAttrRow("workStatus", RESOURCE["workStatus"], workStatusAtom);

	var atpcEnableStatusAtom = new Atom("select");
	ct.addAttrRow("atpcEnableStatus", RESOURCE["atpcEnableStatus"],
			atpcEnableStatusAtom);
			

	var atpcUpperThresholdAtom = new Atom("text");
	ct.addAttrRow("atpcUpperThreshold", RESOURCE["atpcUpperThreshold"],
			atpcUpperThresholdAtom);

	var atpcLowerThresholdAtom = new Atom("text");
	ct.addAttrRow("atpcLowerThreshold", RESOURCE["atpcLowerThreshold"],
			atpcLowerThresholdAtom);

	var atpcAutoEnableAtom = new Atom("select");
	ct.addAttrRow("atpcAutoEnable", RESOURCE["atpcAutoEnable"],
			atpcAutoEnableAtom);

	document.getElementById("ctable").appendChild(ct.getTable());

	initTableData();
}

function initTableData()
{
	sendGetAvailableResourceInfo();
	var bandWidthAtom = ct.getAtom("bandWidth");
	for ( var j = bandWidthAtom.element.options.length - 1; j >= 0; j--)
	{
		bandWidthAtom.element.options[j] = null;
	}
	bandWidthAtom.addOption("7M", "2");
	bandWidthAtom.addOption("14M", "3");
	bandWidthAtom.addOption("28M", "4");
	bandWidthAtom.addOption("56M", "6");
	bandWidthAtom.element.selectedIndex = 2;

	bandWidthAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	};

	var pDHAtom = ct.getAtom("pDH");
	for ( var j = pDHAtom.element.options.length - 1; j >= 0; j--)
	{
		pDHAtom.element.options[j] = null;
	}

	for ( var i = 0, len = boardList.length; i < len; i++)
	{
		if(isUsedBoard(boardList[i]))
		{
			continue;
		}
		pDHAtom.addOption(boardList[i].slotID.value + "-"
				+ boardList[i].boardName.value + "-"
				+ boardList[i].portNo.value, boardList[i].slotID.value);
	}
	pDHAtom.element.selectedIndex = 0;
	pDHAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	};

	var radioidHAtom = ct.getAtom("radioidH");
	radioidHAtom.element.style.width = "100%";
	radioidHAtom.setValue(2);
	radioidHAtom.element.disabled = false;
	checkText(radioidHAtom.element, "1", "4094");

	var pDVAtom = ct.getAtom("pDV");
	for ( var j = pDVAtom.element.options.length - 1; j >= 0; j--)
	{
		pDVAtom.element.options[j] = null;
	}

	for ( var i = 0, len = boardList.length; i < len; i++)
	{
		if(isUsedBoard(boardList[i]))
		{
			continue;
		}
		pDVAtom.addOption(boardList[i].slotID.value + "-"
				+ boardList[i].boardName.value + "-"
				+ boardList[i].portNo.value, boardList[i].slotID.value);
	}
	pDVAtom.element.selectedIndex = 0;
	pDVAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	};

	var radioidVAtom = ct.getAtom("radioidV");
	radioidVAtom.element.style.width = "100%";
	radioidVAtom.setValue(1);
	radioidVAtom.element.disabled = false;
	checkText(radioidVAtom.element, "1", "4094");

	var maxTransmitPowerAtom = ct.getAtom("maxTransmitPower");
	maxTransmitPowerAtom.element.style.width = "100%";
	maxTransmitPowerAtom.setValue("0.0");
	maxTransmitPowerAtom.element.disabled = false;
	checkText(maxTransmitPowerAtom.element, "-10.0", "35.0");

	var transmitPowerAtom = ct.getAtom("transmitPower");
	transmitPowerAtom.element.style.width = "100%";
	transmitPowerAtom.setValue("0.0");
	transmitPowerAtom.element.disabled = false;
	checkTransmitPower(transmitPowerAtom.element);

	var transmitFrequencyAtom = ct.getAtom("transmitFrequency");
	transmitFrequencyAtom.element.style.width = "100%";
	transmitFrequencyAtom.setValue(TRANSMITPOWER);
	transmitFrequencyAtom.element.disabled = false;
	checkText(transmitFrequencyAtom.element, "0", "4294967.295", 3);

	var trIntervalAtom = ct.getAtom("trInterval");
	trIntervalAtom.element.style.width = "100%";
	trIntervalAtom.setValue("0.000");
	trIntervalAtom.element.disabled = false;
	checkText(trIntervalAtom.element, "0", "4294967.295", 3);

	var workStatusAtom = ct.getAtom("workStatus");
	for ( var j = workStatusAtom.element.options.length - 1; j >= 0; j--)
	{
		workStatusAtom.element.options[j] = null;
	}
	workStatusAtom.addOption(RESOURCE["sleep"], "0");
	workStatusAtom.addOption(RESOURCE["shoot"], "1");
	workStatusAtom.element.selectedIndex = 1;

	workStatusAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	};

	var atpcEnableStatusAtom = ct.getAtom("atpcEnableStatus");
	for ( var j = atpcEnableStatusAtom.element.options.length - 1; j >= 0; j--)
	{
		atpcEnableStatusAtom.element.options[j] = null;
	}
	atpcEnableStatusAtom.addOption(RESOURCE["disable"], "0");
	atpcEnableStatusAtom.addOption(RESOURCE["enable"], "1");
	atpcEnableStatusAtom.element.selectedIndex = 0;
	atpcEnableStatusAtom.element["onchange"] = function()
	{
		var v = this.value;
		if (v == 0)
		{
			/**ct.getAtom("atpcAdjustment").element.disabled = true;
			ct.getAtom("atpcAdjustment").element.style.backgroundColor = "";**/
			
			ct.getAtom("atpcUpperThreshold").element.disabled = true;
			ct.getAtom("atpcUpperThreshold").element.style.backgroundColor = "";
			ct.setAttrValue("atpcUpperThreshold", "-");

			ct.getAtom("atpcLowerThreshold").element.disabled = true;
			ct.getAtom("atpcLowerThreshold").element.style.backgroundColor = "";
			ct.setAttrValue("atpcLowerThreshold", "-");
		}
		else
		{
			/**ct.getAtom("atpcAdjustment").element.disabled = false;
		  ct.getAtom("atpcAdjustment").element.style.backgroundColor = "#ffffff";**/
			
			ct.getAtom("atpcUpperThreshold").element.disabled = false;
			ct.getAtom("atpcUpperThreshold").element.style.backgroundColor = "#ffffff";
			ct.setAttrValue("atpcUpperThreshold", "-45.0");

			ct.getAtom("atpcLowerThreshold").element.disabled = false;
			ct.getAtom("atpcLowerThreshold").element.style.backgroundColor = "#ffffff";
			ct.setAttrValue("atpcLowerThreshold", "-70.0");
		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	};
	
	/**ct.getAtom("atpcAdjustment").element.disabled = true;
	ct.getAtom("atpcAdjustment").element.style.backgroundColor = "";**/

	var atpcAutoEnableAtom = ct.getAtom("atpcAutoEnable");
	for ( var k = atpcAutoEnableAtom.element.options.length - 1; k >= 0; k--)
	{
		atpcAutoEnableAtom.element.options[k] = null;
	}
	atpcAutoEnableAtom.addOption(RESOURCE["disable"], "0");
	atpcAutoEnableAtom.addOption(RESOURCE["enable"], "1");
	atpcAutoEnableAtom.element.selectedIndex = 0;
	
	/**var atpcAdjustmentAtom = ct.getAtom("atpcAdjustment");
    for (var j = atpcAdjustmentAtom.element.options.length - 1; j >= 0; j--)
    {
    	atpcAdjustmentAtom.element.options[j] = null;
    } 
    atpcAdjustmentAtom.addOption(RESOURCE["num1"],"1");
    atpcAdjustmentAtom.addOption(RESOURCE["num2"],"2");
    atpcAdjustmentAtom.addOption(RESOURCE["num3"],"3");
    atpcAdjustmentAtom.addOption(RESOURCE["num4"],"4");
    atpcAdjustmentAtom.addOption(RESOURCE["num5"],"5");**/
    atpcEnableStatusAtom.element.selectedIndex = 0;

	var atpcUpperThresholdAtom = ct.getAtom("atpcUpperThreshold");
	atpcUpperThresholdAtom.element.style.width = "100%";
	atpcUpperThresholdAtom.setValue("-");
	atpcUpperThresholdAtom.element.disabled = true;
	checkText(atpcUpperThresholdAtom.element, "-75.0", "-20.0");

	var atpcLowerThresholdAtom = ct.getAtom("atpcLowerThreshold");
	atpcLowerThresholdAtom.element.style.width = "100%";
	atpcLowerThresholdAtom.setValue("-");
	atpcLowerThresholdAtom.element.disabled = true;
	checkText(atpcLowerThresholdAtom.element, "-90.0", "-35.0");
}

function checkTransmitPower(obj)
{	
	obj.style.imeMode = "disabled";
	
	obj.onpaste = function()
	{
		return false;
	};
	
    obj.onblur = function()
	{
    	var maxTransmitPowerAtom = ct.getAtom("maxTransmitPower");
		blurValidate(obj,"-10.0", maxTransmitPowerAtom.getValue());
    };
    
    obj.onkeypress = function()
    {
    	var evt= EventUtil.getEvent();
    	var maxTransmitPowerAtom = ct.getAtom("maxTransmitPower");
        return digitalCheck(obj, "-10.0", maxTransmitPowerAtom.getValue(),null,null,evt);  
    };
}

function sendGetAvailableResourceInfo()
{
	var xmlstr = createGetAvailableResXML();
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_GET_OWN_XPIC + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshGetAvailableRes, null,
			"inputdata=" + xmlstr);
}

function createGetAvailableResXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function refreshGetAvailableRes(doc)
{
	boardList = new Array();
	var dinterface = EncapsulateData(doc);
	if (0 == dinterface.getSErrorCode())
	{
		for ( var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
		{
			var tmpboard = new Object();
			var obj = dinterface.rows[i];
			tmpboard.slotID = obj["slotId"];
			tmpboard.boardName = obj["boardName"];
			var portNo = new Object();
			portNo.value = PORTNO;
			portNo.options = null;
			tmpboard.portNo = portNo;
			boardList.append(tmpboard);
		}
	}
}

function sendApplyInfo()
{
	if ($("applyBtn").disabled)
	{
		xcloseDialog();
	}

	if (ct.getAttrValue("pDH") == ct.getAttrValue("pDV"))
	{
		alert(RESOURCE["HVAlert"]);
		return;

	}
	if ((ct.getAttrValue("atpcUpperThreshold") - ct
			.getAttrValue("atpcLowerThreshold")) < 15)
	{
		alert(RESOURCE["atpcUpperLowerAlert"]);
		return;

	}

	var xmlstr = createXpicXML();
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_ADD_XPIC_GROUP + "&nmUser=" + win.obj["nmUser"];

	loadXMLdoc(urlreq, "POST", false, openCreateErrDialog, null, "inputdata="
			+ xmlstr);
}

function sendConfirmInfo()
{
	sendApplyInfo();
	if (true == isSuccess)
	{
		closeClick();
	}
}

function closeClick()
{
	xcloseDialog();
}

function createXpicXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	var param = new tagElement("param");

	var groupIdValue;
	if (win.xpicworkgrouptable.getDataRowLength() <= 0)
	{
		groupIdValue = "1";
	}
	else
	{
		groupIdValue = win.xpicworkgrouptable.getCellStoreValue(0, "groupid", "groupid");
		if (groupIdValue == null || groupIdValue == "2")
		{
			groupIdValue = "1";
		}
		else if (groupIdValue == "1")
		{
			groupIdValue = "2";
		}
	}

	param.setAttribute("name", "groupid");
	param.setAttribute("value", groupIdValue);
	row.appendChild(param);

	param = new tagElement("param");
	var hPolarBdidValue = ct.getAttrValue("pDH");
	param.setAttribute("name", "hPolarBdid");
	param.setAttribute("value", hPolarBdidValue);
	row.appendChild(param);

	param = new tagElement("param");
	var vPolarBdidValue = ct.getAttrValue("pDV");
	param.setAttribute("name", "vPolarBdid");
	param.setAttribute("value", vPolarBdidValue);
	row.appendChild(param);

	param = new tagElement("param");
	var radioidHValue = ct.getAttrValue("radioidH");
	param.setAttribute("name", "W32PORT_ATTR_RADIOLINKIDh");
	param.setAttribute("value", radioidHValue);
	row.appendChild(param);

	param = new tagElement("param");
	var radioidVValue = ct.getAttrValue("radioidV");
	param.setAttribute("name", "W32PORT_ATTR_RADIOLINKIDv");
	param.setAttribute("value", radioidVValue);
	row.appendChild(param);

	param = new tagElement("param");
	var bandWidthValue = ct.getAttrValue("bandWidth");
	param.setAttribute("name", "bandwidth");
	param.setAttribute("value", bandWidthValue);
	row.appendChild(param);

	param = new tagElement("param");
	var tFValue = ct.getAttrValue("transmitFrequency");
	param.setAttribute("name", "transmitFrequency");
	param.setAttribute("value", tFValue * 1000);
	row.appendChild(param);

	param = new tagElement("param");
	var tRValue = ct.getAttrValue("trInterval");
	param.setAttribute("name", "trInterval");
	param.setAttribute("value", tRValue * 1000);
	row.appendChild(param);

	param = new tagElement("param");
	var transmitPowerValue = ct.getAttrValue("transmitPower");
	param.setAttribute("name", "transmitPower");
	param.setAttribute("value", transmitPowerValue * 10);
	row.appendChild(param);

	param = new tagElement("param");
	var maxTransmitPowerValue = ct.getAttrValue("maxTransmitPower");
	param.setAttribute("name", "maxTransmitPower");
	param.setAttribute("value", maxTransmitPowerValue * 10);
	row.appendChild(param);

	param = new tagElement("param");
	var workStatusValue = ct.getAttrValue("workStatus");
	param.setAttribute("name", "workStatus");
	param.setAttribute("value", workStatusValue);
	row.appendChild(param);

	param = new tagElement("param");
	var atpcEnableStatusValue = ct.getAttrValue("atpcEnableStatus");
	param.setAttribute("name", "atpcEnableStatus");
	param.setAttribute("value", atpcEnableStatusValue);
	row.appendChild(param);

	if (atpcEnableStatusValue == 1)
	{
		/**param = new tagElement("param");
	    var atpcAdjustmentValue = ct.getAttrValue("atpcAdjustment");
	    param.setAttribute("name","atpcAdjustment");
	    param.setAttribute("value", atpcAdjustmentValue*10);
	    row.appendChild(param);**/
		
		param = new tagElement("param");
		var atpcUpperValue = ct.getAttrValue("atpcUpperThreshold");
		param.setAttribute("name", "atpcUpperThreshold");
		param.setAttribute("value", atpcUpperValue * 10);
		row.appendChild(param);

		param = new tagElement("param");
		var atpcLowerThreshold = ct.getAttrValue("atpcLowerThreshold");
		param.setAttribute("name", "atpcLowerThreshold");
		param.setAttribute("value", atpcLowerThreshold * 10);
		row.appendChild(param);
	}

	param = new tagElement("param");
	var atpcAutoEnableValue = ct.getAttrValue("atpcAutoEnable");
	param.setAttribute("name", "atpcAutoEnable");
	param.setAttribute("value", atpcAutoEnableValue);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openCreateErrDialog(doc)
{
	var dinterface = EncapsulateData(doc);
	if (0 != dinterface.getSErrorCode() && 1 != dinterface.getSErrorCode())
	{
		showErrorDialog(dinterface);
		isSuccess = false;
		hasApplied = false;
		return;
	}
	UsedBoardList.push({slotID:ct.getAttrValue("pDH"),portID:1});
	UsedBoardList.push({slotID:ct.getAttrValue("pDV"),portID:1});
	$("applyBtn").disabled = true;
	isSuccess = true;
	hasApplied = true;
	win.sendQueryInfo();
	initTableData();
}

function initBtn()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
}

function showErrorDialog(dinterface)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", dinterface.getError(), errArr);
}
function isUsedBoard(board)
{
	for(var i = 0,len = UsedBoardList.length;i < len;i++)
	{
		if(board.slotID.value == UsedBoardList[i].slotID
			&& board.portNo.value == UsedBoardList[i].portID)
		{
			return true;
		}
	}
	return false;
}
