var st = null;

var atpcEnableStatus = new Object();
atpcEnableStatus[0] = "disable";
atpcEnableStatus[1] = "enable";

var atpcAdjustment = new Object();
atpcAdjustment[10] = "num1";
atpcAdjustment[20] = "num2";
atpcAdjustment[30] = "num3";
atpcAdjustment[40] = "num4";
atpcAdjustment[50] = "num5";

function init()
{
	st = new SortTable();
	st.setImage("../../../../images/");
	createTableHead(st, window.tableconf[0]);
	st.setBodyHeight(100);
	st.element.style.width = "100%";
	st.setSingleChoiceFlg(true);

	$("atpcmanagertable").appendChild(st.getTable());
	st.setOnCellEditHandler(cellEditHandler);
	$("atpcmanagertable").oncontextmenu = popupMenuHandler;
	
	var indexes = parent.st.getSelectedRows();
	if (indexes.length == 1)
	{
		refreshTable(parent.atpcData);
	}
}

function cellEditHandler(param)
{
	if (parent.btnRightArr.applyBtn.right && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		parent.$("applyBtn").disabled = !parent.btnRightArr.applyBtn.right;
	}
}

function refreshTable(data)
{
	st.clearTableData();

	createTableBody(st, window.tableconf[0], data, RESOURCE);
	var atpcStatusValue = st.getCellCurrentValue(0, "atpcEnableStatus",
			"atpcEnableStatus");
	var cell = st.getCell(0, "atpcEnableStatus");
	tagCellEvent(cell, 0);
	if (atpcStatusValue == 0)
	{
		st.setCellIsEdit(st.getCell(0, "atpcUpperThreshold"), 0);
		st.getCell(0, "atpcUpperThreshold").element.style.backgroundColor = "";
		st.getCell(0, "atpcUpperThreshold").element.ondblclick = null;

		st.setCellIsEdit(st.getCell(0, "atpcLowerThreshold"), 0);
		st.getCell(0, "atpcLowerThreshold").element.style.backgroundColor = "";
		st.getCell(0, "atpcLowerThreshold").element.ondblclick = null;
	}

	if (!st.element.colsArray.selectedId)
	{
		st.element.colsArray.selectedId = "groupid";
		st.element.colsArray.imgflag = 1;
	}
	var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
	st.sortRows(td, st.element.colsArray.imgflag);
}

function tagCellEvent(cell)
{
	var atom = cell.element.editElement;
	atom.element["onchange"] = function()
	{
		var v = this.value;
		if (v == 0)
		{
			st.setCellIsEdit(st.getCell(0, "atpcUpperThreshold"), 0);
			st.getCell(0, "atpcUpperThreshold").element.modify = false;
			st.getCell(0, "atpcUpperThreshold").element.style.backgroundColor = "";
			st.getCell(0, "atpcUpperThreshold").element.ondblclick = null;

			st.setCellIsEdit(st.getCell(0, "atpcLowerThreshold"), 0);
			st.getCell(0, "atpcLowerThreshold").element.modify = false;
			st.getCell(0, "atpcLowerThreshold").element.style.backgroundColor = "";
			st.getCell(0, "atpcLowerThreshold").element.ondblclick = null;
		}
		else
		{
			st.setCellIsEdit(st.getCell(0, "atpcUpperThreshold"), 1);
			st.getCell(0, "atpcUpperThreshold").element.modify = true;
			st.getCell(0, "atpcUpperThreshold").element.style.backgroundColor = "#d0f946";
			st.getCell(0, "atpcUpperThreshold").element.ondblclick = cellondbclick;

			st.setCellIsEdit(st.getCell(0, "atpcLowerThreshold"), 1);
			st.getCell(0, "atpcLowerThreshold").element.modify = true;
			st.getCell(0, "atpcLowerThreshold").element.style.backgroundColor = "#d0f946";
			st.getCell(0, "atpcLowerThreshold").element.ondblclick = cellondbclick;
		}
	}
}
