
function refreshBandAndBoard()
{
    var pDVAtom = ct.getAtom("pDV");
    var pDHAtom = ct.getAtom("pDH");
    var bandAtom = ct.getAtom("bandWidth");
    var vBoard = "";
    var hBoard = "";
    
    var vSlotID = -1;
    var hSlotID = -1;
    
    if(pDVAtom.element.options.length > 0)
    {
    	vBoard = pDVAtom.element.options[pDVAtom.element.selectedIndex].innerText.split('-')[1];
    	vSlotID = pDVAtom.element.options[pDVAtom.element.selectedIndex].innerText.split('-')[0];
    }
    
    if(pDHAtom.element.options.length > 0)
    {
    	hBoard = pDHAtom.element.options[pDHAtom.element.selectedIndex].innerText.split('-')[1];
    	hSlotID = pDHAtom.element.options[pDHAtom.element.selectedIndex].innerText.split('-')[0];
    }

    var opts = bandAtom.element.options;
    var tmpValue =  bandAtom.element.value;
    opts.length = 0;
    
    var verArray = win.obj.neversion.split(".");
    var ver1 = verArray[2];
    var ver2 = verArray[3];
	var r3c02Flag = ((ver1 > "03") || (ver1 == "03" &&  ver2>= "30")) ? true : false;
	var r5c00Flag = (ver1 >= "05") ? true : false;
	var isxpicboard = (vBoard == 'IFX2' || hBoard == 'IFX2') || (vBoard == 'ISX2' || hBoard == 'ISX2') || (vBoard == 'ISV3' || hBoard == 'ISV3') ||
					  (SpecialAttrMgr.isCPSupport(neid, vSlotID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_SUPPORT_XPIC") && 
					   SpecialAttrMgr.isCPSupport(neid, hSlotID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_SUPPORT_XPIC") );
    
    var isxpicboardsupportfcc50m = SpecialAttrMgr.isCPSupport(neid, hSlotID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_NOT_SUPPORT_XPIC_FCC50M");
    
    /**
     * RTN V1R3C03       ISX2    7M 14M
     */
	if( r3c02Flag == true && isxpicboard)
	{
		bandAtom.addOption("7M", "2");
		bandAtom.addOption("14M", "3");
	}
    
    bandAtom.addOption("28M", "4");
    if(vBoard != 'IFX2' && hBoard != 'IFX2' )
    {
        bandAtom.addOption("40M", "5");
    }
    bandAtom.addOption("56M", "6");
    
    if(r5c00Flag && isxpicboard && !isxpicboardsupportfcc50m)
    {
    	bandAtom.addOption("FCC50M", "9");
    }
    
    for(var i = 0, len = bandAtom.element.options.length; i < len; i++)
    {
        if(bandAtom.element.options[i].value == tmpValue)
        {
            bandAtom.element.selectedIndex = i;
            break;
        }
    }
}
