 var dinterface = null;
var st = null;
var tab = null;
var atpcmanagertable = null;

var obj = getNeProperty(parent);
var neid = obj["neid"];

var netype = obj["neType"];

var btnRightArr = new Object();

var usedPGList = new Array();
var delPGList = new Array();
var pgBoardMap = new Object();
var bdData = null;

var workStatus = new Object();
workStatus[0] = "sleep";
workStatus[1] = "shoot";

var bandwidth = new Object();
bandwidth[2] = "7M";
bandwidth[3] = "14M";
bandwidth[4] = "28M";
bandwidth[5] = "40M";
bandwidth[6] = "56M";
bandwidth[9] = "50M";
bandwidth[8] = "40M";
bandwidth[7] = "30M";

var oduSlotGap = 20

if(obj["neType"] == '83')
{
    oduSlotGap = 50;
}

var atpcAdjustment = new Object();
atpcAdjustment[10] = "num1";
atpcAdjustment[20] = "num2";
atpcAdjustment[30] = "num3";
atpcAdjustment[40] = "num4";
atpcAdjustment[50] = "num5";

window.onunload = function()
{
	clearTable();
};

var btnRightArr = new Object();

function clearTable()
{
	if (tab && tab.getTabWindow(1).st)
	{
		tab.getTabWindow(1).st.clearTableData();
		tab.getTabWindow(1).st.deleteHeadRow();
	}
	if (tab && tab.getTabWindow(2).st)
	{
		tab.getTabWindow(2).st.clearTableData();
		tab.getTabWindow(2).st.deleteHeadRow();
	}
	if (st)
	{
		st.clearTableData();
		st.deleteHeadRow();
	}
}

function initXpicWorkGroup()
{
	st = new SortTable();
	st.setImage("../../../../images/");
	var totalHeight = getComponetHeight($("total"), 150);
	createTableHead(st, window.tableconf[0]);
	st.setBodyHeight(totalHeight * 0.5);
	$("tab").style.height = totalHeight*0.5 + "px";
	st.element.style.width = "100%";

	$("xpicworkgrouptable").appendChild(st.getTable());
	$("xpicworkgrouptable").oncontextmenu = menuPopup;
	st.setOnRowSelectHandler(talbeRowSelecteHandler);
	st.setOnCellEditHandler(cellEditHandler);
}

window.onresize = function()
{
	var totalHeight = getComponetHeight($("total"), 150);

	st.setBodyHeight(totalHeight* 0.5);
	$("tab").style.height = totalHeight*0.5 + "px";
}

function talbeRowSelecteHandler()
{
	var rows = st.getSelectedRows();
	if (btnRightArr.applyBtn.right)
	{
		if (st.getSelectedRowCount() > 0)
		{
			$("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
			queryBoardMap(st.getCellStoreValue(rows[0], "groupid", "groupid"));
		}
		else
		{
			tab.getTabWindow(1).st.clearTableData();
			tab.getTabWindow(2).st.clearTableData();
			$("deleteBtn").disabled = true;
		}
	}
}

function cellEditHandler(param)
{
    var rowIndex = param.rowindex;
    
	if (btnRightArr.applyBtn.right && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applyBtn").disabled = !btnRightArr.applyBtn.right;
	}
	if (param.colid == "transmitPower"
			&& param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var maxHybird = st.getCellStoreValue(param.rowindex,
				"maxTransmitPower", "maxTransmitPower");
		
		if(maxHybird == "")
		{
			maxHybird = "35.0";
		}
		
		textCheck(st.getCellEdit(param.rowindex, "transmitPower").element,
				"-10.0", maxHybird + "");
	}
	
	if (param.colid == "receivedPowerV"
		&& param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{	
		 textCheck(st.getCellEdit(param.rowindex, "receivedPowerV").element, "-90.0", "-20.0",1,"-10.0");
	}
	if (param.colid == "receivedPowerH"
		&& param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		 textCheck(st.getCellEdit(param.rowindex, "receivedPowerH").element, "-90.0", "-20.0",1,"-10.0");
	}
	
	if (param.colid == "ifbdwidthmode"
			&& param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
	    var ifbdtype = st.getCellEdit(rowIndex, param.colid).element;
            
        ifbdtype.onchange = function()
		{
		    var ifbdtypevar = this.value;
		    var channelwidth = st.getCellEdit(rowIndex,"bandwidth"); 
		    var channelwdcell = st.getCell(rowIndex, "bandwidth");
		    if (ifbdtypevar == "FCC")
		    {
                channelwdcell.element.style.backgroundColor = "#d0f946";
                channelwdcell.element.modify = true;
                channelwdcell.element.parentNode.modify = true;
                channelwidth.element.selectedIndex = 0;
                channelwdcell.element.showElement.element.innerText = bandwidth["9"];
                st.setCellValue(channelwdcell,"bandwidth",9);
		    }
		    else if (ifbdtypevar == "ETSI")
		    {
                channelwdcell.element.style.backgroundColor = "#d0f946";
                channelwdcell.element.modify = true;
                channelwdcell.element.parentNode.modify = true;
                channelwidth.element.selectedIndex = 0;
                channelwdcell.element.showElement.element.innerText = bandwidth["4"];
                st.setCellValue(channelwdcell,"bandwidth",4);
		    }
		}
	}
	
	if (param.colid == "bandwidth" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
	    var tmpcelledit = st.getCellEdit(param.rowindex, "bandwidth");
	    var editElement = tmpcelledit.element;
	    var boardName = st.getCellStoreValue(param.rowindex, "polarizationDirectionV", "vBoardName");
	    
	    var ops = editElement.options;
	    
	    var tmpifbdwidthmode = st.getCellStoreValue(param.rowindex, "ifbdwidthmode", "ifbdwidthmode");
	    
	    if (tmpifbdwidthmode == "FCC")
	    {
            tmpcelledit.clearOptions();
            tmpcelledit.addOption(bandwidth["9"], "9");
            tmpcelledit.addOption(bandwidth["8"], "8");
            tmpcelledit.addOption(bandwidth["7"], "7");
	    }
	    else
	    {
    	    switch(boardName)
    	    {
    	        case 'IFX2':
    	            ops.length = 0;
    	            ops[ops.length] = new Option(bandwidth[4], 4);
    	            ops[ops.length] = new Option(bandwidth[6], 6);
    	            break;
    	        case 'ISX2':
    	            ops.length = 0;
    	            ops[ops.length] = new Option(bandwidth[4], 4);
    	            ops[ops.length] = new Option(bandwidth[5], 5);
    	            ops[ops.length] = new Option(bandwidth[6], 6);
    	            break;
    	        default:
    	            break;   
    	    }
	    }
	}
}

function initBtn()
{
	$("queryBtn").value = RESOURCE["querybutton"];
	$("newBtn").value = RESOURCE["newbutton"];
	$("deleteBtn").value = RESOURCE["deletebutton"];
	$("applyBtn").value = RESOURCE["applybutton"];

	btnRightArr.queryBtn = new BtnRightObj("queryBtn", NSCMD_CFG_GET_XPIC);
	btnRightArr.applyBtn = new BtnRightObj("applyBtn", NSCMD_CFG_SET_XPIC);
	btnRightArr.newBtn = new BtnRightObj("newBtn", NSCMD_CFG_ADD_XPIC_GROUP);
	btnRightArr.deleteBtn = new BtnRightObj("deleteBtn",
			NSCMD_CFG_DEL_XPIC_GROUP);
	getRightInfo(obj, btnRightArr);
}

function initBtnState()
{
	if (btnRightArr.queryBtn.right)
	{
		$("queryBtn").disabled = false;
	}

	if (btnRightArr.applyBtn.right)
	{
		$("newBtn").disabled = !btnRightArr.newBtn.right;
		if (st.getSelectedRowCount() > 0)
		{
			$("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
		}
		else
		{
			$("deleteBtn").disabled = true;
		}
		if((netype == '77' || netype == '90') &&  st.getDataRowLength() >= 3)//950    
		{
			$("newBtn").disabled = true;
		}
		else if((netype == '76' || netype == '89') &&  st.getDataRowLength() >= 1)//910    
		{
			$("newBtn").disabled = true;
		}
		else
		{
			$("newBtn").disabled = !btnRightArr.newBtn.right;
			$("applyBtn").disabled = true;
		}
	}
}

function disableAllBtnState()
{
	$("queryBtn").disabled = true;
	$("newBtn").disabled = true;
	$("deleteBtn").disabled = true;
	$("applyBtn").disabled = true;
}

function menuPopup()
{
	if (st.getSelectedRowCount() > 0)
	{
		if (btnRightArr.applyBtn.right)
		{
			removejsDOMmenu();
			createjsDOMenu();
			showMenu(event);
		}
	}
}

var firstQuery = true;
function tabSelectHandler()
{
	if(firstQuery)
	{
		sendQueryInfo();
		firstQuery = false;
	}
}


function initXpic()
{
	initBtn();
	initXpicWorkGroup();
	initTab();

	if (btnRightArr.queryBtn.right)
	{
	}
	else
	{
		$("queryBtn").disabled = !btnRightArr.queryBtn.right;
		$("newBtn").disabled = !btnRightArr.newBtn.right;
		$("applyBtn").disabled = true;
		$("deleteBtn").disabled = true;
	}
}

function initTab()
{
	tab = new Tabs();
	tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame",
			"tabs_li_select");
	tab.addTab(2, RESOURCE["amparamtable"], "amparam.html");
	tab.addTab(1, RESOURCE["atpcmanagertable"], "atpc.html");

	tab.selectTab(2);
	$("tab").appendChild(tab.getTabs());
}

function queryBoardMap(pgID)
{
	atpcData = new DataInterface();
	for ( var i = 0; i < dinterface.rows.length; i++)
	{
		if (dinterface.rows[i].groupid.value == pgID)
		{
			atpcData.rows[0] = dinterface.rows[i];
		}
	}
	if (tab.getTabWindow(1).st)
	{
		tab.getTabWindow(1).refreshTable(atpcData);
	}
	if (tab.getTabWindow(2).st && bdData != null)
	{
		tab.getTabWindow(2).refreshTable(bdData);
	}
}

function sendQueryInfo()
{
	disableAllBtnState();
	bdData = null;
	atpcData = null;
	LoadingProcess.showWaitStatus("../../../../images");
	var xmlstr = createQueryXpicXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_GET_XPIC
			+ "&flag=1" + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, refreshTable, true, "inputdata=" + xmlstr);
}

function createQueryXpicXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neId");
	param.setAttribute("value", neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function refreshTable(doc, isalert)
{
	dinterface = EncapsulateData(doc);
	LoadingProcess.removeWaitStatus();
	if (0 != dinterface.getSErrorCode())
	{
		if (isalert)
		{
			showErrorDialog(dinterface);
		}
	}

	st.clearTableData();

	if (tab.getTabWindow(1).st)
	{
		tab.getTabWindow(1).st.clearTableData();
	}
	if (tab.getTabWindow(2).st)
	{
		tab.getTabWindow(2).st.clearTableData();
	}

	if (dinterface.getDataRowLength() == 0)
	{
		initBtnState();
		return;
	}

	constructtbXML(dinterface);


}

function constructtbXML(dinterface)
{
	var downDinterface = null;
	var downObj = null;
	var tempObj = null;
	var pgID = 0;
	usedPGList = [];
	pgBoardMap = new Object();

	queryradiolinkid(dinterface);
}

function fillData(dinterface)
{
	createTableBody(st, window.tableconf[0], dinterface, RESOURCE);

	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		var cell = st.getCellElement(i, "transmitFrequency");
		checkText(cell.editElement.element, "0", "4294967.295", 3);
		st.getCellEdit(i, "transmitFrequency").element.onblur = cellonblur;

		var cell = st.getCellElement(i, "trInterval");
		checkText(cell.editElement.element, "0", "4294967.295", 3);
		st.getCellEdit(i, "trInterval").element.onblur = cellonblur;
	}

	st.element.colsArray.selectedId = "groupid";
	var tdsort = st.element.headRow.element.cols["groupid"].element;
	st.sortRows(tdsort, 1);

	st.setRowSelect(0);

	talbeRowSelecteHandler();

	if (!st.element.colsArray.selectedId)
	{
		st.element.colsArray.selectedId = "groupid";
	}
	if (!st.element.colsArray.imgflag)
	{
		st.element.colsArray.imgflag = 1;
	}
	var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
	st.sortRows(td, st.element.colsArray.imgflag);
}

function createXpic()
{
	hideMenu();
	xshowModalDialog("createXpic.html", RESOURCE["createXpic"], 500, 440,
			"../../../../images/");
}

function deleteXpic()
{
	if (st.getSelectedRowCount() < 1)
	{
		return;
	}

	if (confirm(RESOURCE["deleteconfirm"]))
	{
		sendDeleteInfo();
	}
}

function sendDeleteInfo()
{
	disableAllBtnState();
	var xmlstr = createDeleteXpicXML();
	LoadingProcess.showWaitStatus("../../../../images");
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_DEL_XPIC_GROUP + "&flag=1" + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openDeleteErrDialog, null, "inputdata="
			+ xmlstr);
}

function createDeleteXpicXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var rows = st.getSelectedRows();
	delPGList = [];
	for ( var i = 0, len = rows.length; i < len; i++)
	{
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neId");

		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupId");
		param.setAttribute("value", st.getCellCurrentValue(rows[i], "groupid",
				"groupid"));
		row.appendChild(param);

		bussiness.appendChild(row);
		delPGList.push(st.getCellStoreValue(rows[i], "groupid", "groupId"));
	}

	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openDeleteErrDialog(doc)
{
	var dinterface = EncapsulateData(doc);
	LoadingProcess.removeWaitStatus();
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", dinterface.getError(), errArr);
	if (0 == dinterface.getSErrorCode() || 1 == dinterface.getSErrorCode())
	{
		var faultPGList = [];
		for ( var i = 0, len = dinterface.getBErrLength(); i < len; i++)
		{
			faultPGList.push(dinterface.getBErrParam(i, "groupid"));
		}
		for ( var j = st.getDataRowLength() - 1; j >= 0; j--)
		{
			var pgid = st.getCellStoreValue(j, "groupid", "groupid");
			if (!faultPGList.contains(pgid) && st.getRowSelFlag(j))
			{
				st.deleteRow(j);
				usedPGList.remove(pgid);
				pgBoardMap[pgid] = null;
			}
		}
		st.adjustDataRows();
	}
	if (st.getSelectedRowCount() == 0 && st.getDataRowLength() > 0)
	{
		st.setRowSelect(0);
	}

	talbeRowSelecteHandler();

	initBtnState();

}

function modifyXpic()
{
	var cell = null;
	var isNeedAlert = false;
	for (var i = 0, size = st.getDataRowLength(); i < size; i++)
    {
    	if (st.getModify(i))
    	{
    		cell = st.getCell(i, "bandwidth");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "bandwidth")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "receivedPowerV");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "receivedPowerV")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "receivedPowerH");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "receivedPowerH")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "maxTransmitPower");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "maxTransmitPower")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "transmitPower");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "transmitPower")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "transmitFrequency");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "transmitFrequency")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "trInterval");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "trInterval")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "workStatus");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "workStatus")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
    	}
    }
    
    var amst = tab.getTabWindow(2).st;
    for (var j = 0, size1 = amst.getDataRowLength(); j < size1; j++)
    {
    	if (amst.getModify(j))
    	{
    		isNeedAlert = true;
    		break;
    	}
    }
    
    if (isNeedAlert)
    {
    	if (!confirm(RESOURCE["DANGER_ALARM"])) 
	    {
	        return;
	    }
    }
    
	disableAllBtnState();
	LoadingProcess.showWaitStatus("../../../../images");
	var xmlStr = createModifyXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_SET_XPIC
			+ "&flag=1" + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openModifyErrDialog, null, "inputdata="
			+ xmlStr);
}

function createModifyXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		var modifyFlg = false;
		if (st.getModify(i))
		{
			modifyFlg = true;
			row = new tagElement("row-params");

			param = new tagElement("param");
			param.setAttribute("name", "neid");
			param.setAttribute("value", neid);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "groupId");
			param.setAttribute("value", st.getCellCurrentValue(i, "groupid",
					"groupid"));
			row.appendChild(param);

			if (st.getCellModify(i, "bandwidth"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "bandwidth");
				param.setAttribute("value", st.getCellCurrentValue(i,
						"bandwidth", "bandwidth"));
				row.appendChild(param);
			}

			if (st.getCellModify(i, "transmitPower"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "transmitPower");
				param.setAttribute("value", st.getCellCurrentValue(i,
						"transmitPower", "transmitPower") * 10);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "maxTransmitPower"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "maxTransmitPower");
				param.setAttribute("value", st.getCellCurrentValue(i,
						"maxTransmitPower", "maxTransmitPower") * 10);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "transmitFrequency"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "transmitFrequency");
				param.setAttribute("value", st.getCellCurrentValue(i,
						"transmitFrequency", "transmitFrequency") * 1000);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "trInterval"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "trInterval");
				param.setAttribute("value", st.getCellCurrentValue(i,
						"trInterval", "trInterval") * 1000);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "workStatus"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "workStatus");
				param.setAttribute("value", st.getCellCurrentValue(i,
						"workStatus", "workStatus"));
				row.appendChild(param);
			}
		}
		if ((tab.getTabWindow(1).st
				.getCellCurrentValue(0, "groupid", "groupid") == st
				.getCellStoreValue(i, "groupid", "groupid"))
				&& (tab.getTabWindow(1).st.getModify(0)))
		{
			modifyFlg = true;
			if (row == null)
			{
				row = new tagElement("row-params");
				param = new tagElement("param");
				param.setAttribute("name", "neid");
				param.setAttribute("value", neid);
				row.appendChild(param);

				param = new tagElement("param");
				param.setAttribute("name", "groupid");
				param.setAttribute("value", tab.getTabWindow(1).st
						.getCellCurrentValue(0, "groupid", "groupid"));
				row.appendChild(param);
			}
			param = new tagElement("param");
			param.setAttribute("name", "atpcEnableStatus");
			param.setAttribute("value", tab.getTabWindow(1).st
					.getCellCurrentValue(0, "atpcEnableStatus",
							"atpcEnableStatus"));
			row.appendChild(param);

			var atpcEnableStatus = tab.getTabWindow(1).st.getCellCurrentValue(
					0, "atpcEnableStatus", "atpcEnableStatus");
			if (atpcEnableStatus == 1)
			{
				param = new tagElement("param");
				param.setAttribute("name", "atpcUpperThreshold");
				param.setAttribute("value", tab.getTabWindow(1).st
						.getCellCurrentValue(0, "atpcUpperThreshold",
								"atpcUpperThreshold") * 10);
				row.appendChild(param);

				param = new tagElement("param");
				param.setAttribute("name", "atpcLowerThreshold");
				param.setAttribute("value", tab.getTabWindow(1).st
						.getCellCurrentValue(0, "atpcLowerThreshold",
								"atpcLowerThreshold") * 10);
				row.appendChild(param);
			}

			param = new tagElement("param");
			param.setAttribute("name", "atpcAdjustment");
			param
					.setAttribute("value", tab.getTabWindow(1).st
							.getCellCurrentValue(0, "atpcAdjustment",
									"atpcAdjustment"));
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "atpcAutoEnable");
			param
					.setAttribute("value", tab.getTabWindow(1).st
							.getCellCurrentValue(0, "atpcAutoEnable",
									"atpcAutoEnable"));
			row.appendChild(param);
		}
		if (modifyFlg)
		{
			bussiness.appendChild(row);
		}

		if (st.getCellModify(i, "receivedPowerV"))
		{
			row = new tagElement("row-params");
			param = new tagElement("param");
			param.setAttribute("name", "neid");
			param.setAttribute("value", neid);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", parseInt(st.getCellStoreValue(i,
					"polarizationDirectionV", "vPolarBdid")) + oduSlotGap);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "W32BRD_ATTR_RECEIVEPOWER");
			param.setAttribute("value", st.getCellStoreValue(i,
					"receivedPowerV", "receivedPowerV") * 10);
			row.appendChild(param);
			bussiness.appendChild(row);
		}

		if (st.getCellModify(i, "receivedPowerH"))
		{
			row = new tagElement("row-params");
			param = new tagElement("param");
			param.setAttribute("name", "neid");
			param.setAttribute("value", neid);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", parseInt(st.getCellStoreValue(i,
					"polarizationDirectionH", "hPolarBdid")) + oduSlotGap);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "W32BRD_ATTR_RECEIVEPOWER");
			param.setAttribute("value", st.getCellStoreValue(i,
					"receivedPowerH", "receivedPowerH") * 10);
			row.appendChild(param);
			bussiness.appendChild(row);
		}

		var amst = tab.getTabWindow(2).st;
		for ( var j = 0, n = amst.getDataRowLength(); j < n; j++)
		{
			if (amst.getCellCurrentValue(j, "groupid", "groupid") == st
					.getCellStoreValue(i, "groupid", "groupid")
					&& amst.getModify(j))
			{
				if (amst.getCellModify(j, "hybridnum"))
				{
				var amRow = new tagElement("row-params");
				amParam = new tagElement("param");
				amParam.setAttribute("name", "neid");
				amParam.setAttribute("value", neid);
				amRow.appendChild(amParam);

				amParam = new tagElement("param");
				amParam.setAttribute("name", "groupid");
				amParam.setAttribute("value", amst.getCellCurrentValue(j,
						"groupid", "groupid"));
				amRow.appendChild(amParam);

				var slotid = amst.getCellStoreValue(j, "polarizationDirection",
						"slotid");
				amParam = new tagElement("param");
				amParam.setAttribute("name", "slotid");
				amParam.setAttribute("value", slotid);
				amRow.appendChild(amParam);

				var portid = amst.getCellStoreValue(j, "polarizationDirection",
						"portid");
				amParam = new tagElement("param");
				amParam.setAttribute("name", "portid");
				amParam.setAttribute("value", portid);
				amRow.appendChild(amParam);

					amParam = new tagElement("param");
					amParam.setAttribute("name", "hybridnum");
					amParam.setAttribute("value", amst.getCellStoreValue(j,
							"hybridnum", "hybridnum"));
					amRow.appendChild(amParam);

					bussiness.appendChild(amRow);
				}

				if (amst.getCellModify(j, "amstate")
						|| amst.getCellModify(j, "ensuremode")
						|| amst.getCellModify(j, "fullmode")
						|| amst.getCellModify(j, "manualmode"))
				{
					var amRow = new tagElement("row-params");
					amParam = new tagElement("param");
					amParam.setAttribute("name", "neid");
					amParam.setAttribute("value", neid);
					amRow.appendChild(amParam);

					amParam = new tagElement("param");
					amParam.setAttribute("name", "groupid");
					amParam.setAttribute("value", amst.getCellCurrentValue(j,
							"groupid", "groupid"));
					amRow.appendChild(amParam);

					amParam = new tagElement("param");
					amParam.setAttribute("name", "amstate");
					amParam.setAttribute("value", amst.getCellStoreValue(j,
							"amstate", "amstate"));
					amRow.appendChild(amParam);

					amParam = new tagElement("param");
					amParam.setAttribute("name", "ensuremode");
					amParam.setAttribute("value", amst.getCellStoreValue(j,
							"ensuremode", "ensuremode"));
					amRow.appendChild(amParam);

					amParam = new tagElement("param");
					amParam.setAttribute("name", "fullmode");
					amParam.setAttribute("value", amst.getCellStoreValue(j,
							"fullmode", "fullmode"));
					amRow.appendChild(amParam);

					amParam = new tagElement("param");
					amParam.setAttribute("name", "manualmode");
					amParam.setAttribute("value", amst.getCellStoreValue(j,
							"manualmode", "manualmode"));
					amRow.appendChild(amParam);

					bussiness.appendChild(amRow);
				}
			}
		}
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openModifyErrDialog(doc)
{
	initBtnState();
	LoadingProcess.removeWaitStatus();
	var dinterface = EncapsulateData(doc);
	refreshTableState(st, window.tableconf[0], dinterface);
	refreshTableState(tab.getTabWindow(1).st,
			tab.getTabWindow(1).window.tableconf[0], dinterface);
	refreshTableState(tab.getTabWindow(2).st,
			tab.getTabWindow(2).window.tableconf[0], dinterface);

	if (0 != dinterface.getSErrorCode())
	{
		$("applyBtn").disabled = !btnRightArr.applyBtn.right;
		showErrorDialog(dinterface);
		return;
	}
}

function xpicConvert(command)
{
	sendConvertInfo(command);
}

function sendConvertInfo(command)
{
	if (command > 1)
	{
		removejsDOMmenu();
		var flag = confirm(RESOURCE["confimswitch"]);
		if (!flag)
		{
			return;
		}
	}

	disableAllBtnState();

	var xmlstr = null;

	switch (command)
	{
		case 1:
			sendQueryInfo();
			break;
		case 2:
			deleteXpic();
			break;
		case 3:
			hvConvert();
			break;
	}

	if (null != xmlstr)
	{
		var urlreq = "../../../../neExlorerServlet?sfid="
				+ NSCMD_CFG_SET_XPIC_BD_POLAR + "&flag=1" + "&nmUser="
				+ obj["nmUser"];
		loadXMLdoc(urlreq, "POST", true, openConvertErrDialog, command,
				"inputdata=" + xmlstr);
	}

}

function hvConvert()
{
	disableAllBtnState();
	var xmlStr = createHVConvertXML();
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_SET_XPIC_BD_POLAR + "&flag=1" + "&nmUser="
			+ obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openHVconvertErrDialog, null, "inputdata="
			+ xmlStr);
}

function createHVConvertXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = null;
	var param = null;
	var selectedRows = st.getSelectedRows();
	
	for ( var i = 0, len = selectedRows.length; i < len; i++)
	{
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupId");
		param.setAttribute("value", st.getCellCurrentValue(selectedRows[i], "groupid",
				"groupid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "hPolarBdid");
		param.setAttribute("value", st.getCellCurrentValue(selectedRows[i],
				"polarizationDirectionV", "vPolarBdid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "vPolarBdid");
		param.setAttribute("value", st.getCellCurrentValue(selectedRows[i],
				"polarizationDirectionH", "hPolarBdid"));
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openHVconvertErrDialog(doc)
{
	initBtnState();
	var dinterface = EncapsulateData(doc);
	if (0 != dinterface.getSErrorCode())
	{
		$("applyBtn").disabled = !btnRightArr.applyBtn.right;
		showErrorDialog(dinterface);
		return;
	}

	sendQueryInfo();
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr);
}

function openConvertErrDialog(doc, para)
{
	var data = EncapsulateData(doc);

	if (0 != data.getSErrorCode())
	{
		initBtnState();
		showErrorDialog(data);
		return;
	}

	if (para == 5 || para == 6 || para == 3 || para == 4)
	{
		alert(RESOURCE["queryswitchstatus2"]);
	}

	refresh();
}

function queryradiolinkid(dinterface)
{
	var xmlStr = createQueryRadioLinkIDXML(dinterface);

	var urlreq = "../../../../neExlorerServlet?sfid=93731&flag=1" + "&nmUser="
			+ obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openRadioLinkIDErrDialog, dinterface,
			"inputdata=" + xmlStr);
}

function createQueryRadioLinkIDXML(dinterface)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for ( var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
	{
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param
				.setAttribute("value", dinterface.getDataRowParam(i,
						"hPolarBdid"));
		row.appendChild(param);

		var hPolarPortid = dinterface.getDataRowParam(i, "hPolarPortid");
		param = new tagElement("param");
		param.setAttribute("name", "port");
		param.setAttribute("value", hPolarPortid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "portid");
		param.setAttribute("value", hPolarPortid);
		row.appendChild(param);

		bussiness.appendChild(row);

		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param
				.setAttribute("value", dinterface.getDataRowParam(i,
						"vPolarBdid"));
		row.appendChild(param);

		var vPolarPortid = dinterface.getDataRowParam(i, "vPolarPortid");
		param = new tagElement("param");
		param.setAttribute("name", "port");
		param.setAttribute("value", vPolarPortid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "portid");
		param.setAttribute("value", vPolarPortid);
		row.appendChild(param);

		bussiness.appendChild(row);

	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openRadioLinkIDErrDialog(doc, dinterface)
{
	bdData = EncapsulateData(doc);
	showErrorDialog(bdData);

	fillData(dinterface);

	if (0 == bdData.getSErrorCode() || 1 == bdData.getSErrorCode())
	{
		var len = bdData.getDataRowLength();
		var itemcount = len / 2;
		if (len <= 0)
		{
			return;
		}
		for ( var i = 0; i < len; i++)
		{
			var tslotid = bdData.getDataRowParam(i, "slotid");
			var tport = bdData.getDataRowParam(i, "port");
			var tlinkid = bdData.getDataRowParam(i, "W32PORT_ATTR_RADIOLINKID");
			var srPower = bdData.getDataRowParam(i, "W32BRD_ATTR_RECEIVEPOWER");
			for ( var j = 0, m = st.getDataRowLength(); j < m; j++)
			{
				var vPolarBdid = st.getCellStoreValue(j,
						"polarizationDirectionV", "vPolarBdid");
				var vPolarPortid = st.getCellStoreValue(j,
						"polarizationDirectionV", "vPolarPortid");
				if (vPolarBdid == tslotid && vPolarPortid == tport)
				{
					st.setAtomValue(
							st.getCell(j, "radioidV").element.showElement,
							tlinkid);
					st
							.setAtomValue(
									st.getCell(j, "receivedPowerV").element.showElement,
									srPower);
					break;
				}

				var hPolarBdid = st.getCellStoreValue(j,
						"polarizationDirectionH", "hPolarBdid");
				var hPolarPortid = st.getCellStoreValue(j,
						"polarizationDirectionH", "hPolarPortid");
				if (hPolarBdid == tslotid && hPolarPortid == tport)
				{
					st.setAtomValue(
							st.getCell(j, "radioidH").element.showElement,
							tlinkid);
					st
							.setAtomValue(
									st.getCell(j, "receivedPowerH").element.showElement,
									srPower);
					break;
				}
			}
		}
		if (tab.getTabWindow(2).st)
		{
			tab.getTabWindow(2).refreshTable(bdData);
		}
	}
	initBtnState();
}
/**
 *              
 * @return Array
 */
function getUsedBoardList()
{
	var boardlist = [];
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		var vslotid = st.getCellStoreValue(i,"polarizationDirectionV","vPolarBdid");
		var vportid = st.getCellStoreValue(i,"polarizationDirectionV","vPolarPortid");
		var hslotid = st.getCellStoreValue(i,"polarizationDirectionH","hPolarBdid");
		var hportid = st.getCellStoreValue(i,"polarizationDirectionH","hPolarPortid");
		boardlist.push({slotID:vslotid,portID:vportid});
		boardlist.push({slotID:hslotid,portID:hportid});
	}
	return boardlist;
}
