var dinterface = null;
var st = null;
var tab = null;
var atpcmanagertable = null;

var obj = getNeProperty(parent);
var neid = obj["neid"];
var netype = obj["neType"];

var btnRightArr = new Object();

var usedPGList = new Array();
var delPGList = new Array();
var pgBoardMap = new Object();
var bdData = null;

var workStatus = new Object();
workStatus[0] = "sleep";
workStatus[1] = "shoot";

var bandwidth = new Object();
bandwidth[2] = "7M";
bandwidth[3] = "14M";
bandwidth[4] = "28M";
bandwidth[5] = "40M";
bandwidth[6] = "56M";
bandwidth[9] = "FCC50M";
var oduSlotGap = 20

var isFilter = null;

if(netype == '83')
{
    oduSlotGap = 50;
}

var atpcAdjustment = new Object();
atpcAdjustment[10] = "num1";
atpcAdjustment[20] = "num2";
atpcAdjustment[30] = "num3";
atpcAdjustment[40] = "num4";
atpcAdjustment[50] = "num5";

var DISABLED = '0';
var ENABLED = '1';
var INVALID = '255';

var SERVICETYPE_E1ETH = '1';  //Hybrid(Native E1+ETH)
var SERVICETYPE_STM1ETH = '2'; //Hybrid(Native STM-1+ETH)
var SERVICETYPE_SDH = '3'; //SDH


var amBoostState = new Object();
amBoostState[0] = "disable";
amBoostState[1] = "enable";

var ifModifyFlg = false; //                          E1   

var oldSelectedGroupID = -1;

var cacheRowErrs;

window.onunload = function()
{
	clearTable();
};

var btnRightArr = new Object();

function clearTable()
{
	if (tab && tab.getTabWindow(1) && tab.getTabWindow(1).st)
	{
		tab.getTabWindow(1).st.clearTableData();
		tab.getTabWindow(1).st.deleteHeadRow();
	}
	if (tab && tab.getTabWindow(2) && tab.getTabWindow(2).st)
	{
		tab.getTabWindow(2).st.clearTableData();
		tab.getTabWindow(2).st.deleteHeadRow();
	}
	if (st)
	{
		st.clearTableData();
		st.deleteHeadRow();
	}
}

function initXpicWorkGroup()
{
	st = new SortTable();
	st.setImage("../../../../images/");
	createTableHead(st, window.tableconf[0]);
	$("tab").style.height = "150px";
	st.element.style.width = "100%";
	var totalHeight = getComponetHeight($("total"), 330);
	st.setBodyHeight(totalHeight);

	$("xpicworkgrouptable").appendChild(st.getTable());
	$("xpicworkgrouptable").oncontextmenu = menuPopup;
	st.setOnRowSelectHandler(talbeRowSelecteHandler);
	st.setOnCellEditHandler(cellEditHandler);
}

window.onresize = function()
{
	var totalHeight = getComponetHeight($("total"), 330);
	st.setBodyHeight(totalHeight);
}

function talbeRowSelecteHandler()
{
	var rows = st.getSelectedRows();
	if (btnRightArr.applyBtn.right)
	{
		if (st.getSelectedRowCount() > 0)
		{
			var currentSelectedGroupID = st.getCellStoreValue(rows[0], "groupid", "groupid");
			if( oldSelectedGroupID == currentSelectedGroupID )
			{
				return;
			}
			$("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
			queryBoardMap(st.getCellStoreValue(rows[0], "groupid", "groupid"));
			oldSelectedGroupID = st.getCellStoreValue(rows[0], "groupid", "groupid");
		}
		else
		{
			oldSelectedGroupID = -1;
			if (tab.getTabWindow(1) && tab.getTabWindow(1).st) 
			{
				tab.getTabWindow(1).st.clearTableData();
			}
			if (tab.getTabWindow(2) && tab.getTabWindow(2).st) 
			{
				tab.getTabWindow(2).st.clearTableData();
			}
			$("deleteBtn").disabled = true;
		}
	}
}

function cellEditHandler(param)
{
	if (btnRightArr.applyBtn.right && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applyBtn").disabled = !btnRightArr.applyBtn.right;
	}
	if (param.colid == "transmitPower"
			&& param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var maxHybird = st.getCellStoreValue(param.rowindex,
				"maxTransmitPower", "maxTransmitPower");
		
		if(maxHybird == "")
		{
			maxHybird = "35.0";
		}
		
		textCheck(st.getCellEdit(param.rowindex, "transmitPower").element,
				"-10.0", maxHybird + "");
	}
	
	if (param.colid == "bandwidth" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
	    var editElement = st.getCellEdit(param.rowindex, "bandwidth").element;
	    var boardName = st.getCellStoreValue(param.rowindex, "polarizationDirectionV", "vBoardName");
	    
	    var ops = editElement.options;
	    switch(boardName)
	    {
	        case 'IFX2':
	            ops.length = 0;
	            var verArray = obj.neversion.split(".");
	            var ver1 = verArray[2];
	            var ver2 = verArray[3];
	        	var r3c02Flag = ((ver1 > "03") || (ver1 == "03" &&  ver2>= "30")) ? true : false;
	            if( r3c02Flag == true )
	            {
		        	ops[ops.length] = new Option(bandwidth[2], 2);
		        	ops[ops.length] = new Option(bandwidth[3], 3);
	            }
	            ops[ops.length] = new Option(bandwidth[4], 4);
	            ops[ops.length] = new Option(bandwidth[6], 6);
	            break;
	        case 'ISX2':
	            ops.length = 0;
	            ops[ops.length] = new Option(bandwidth[4], 4);
	            ops[ops.length] = new Option(bandwidth[5], 5);
	            ops[ops.length] = new Option(bandwidth[6], 6);
	            break;
	        default:
	            break;   
	    }
	}
}

function initBtn()
{
	$("queryBtn").value = RESOURCE["querybutton"];
	$("newBtn").value = RESOURCE["newbutton"];
	$("deleteBtn").value = RESOURCE["deletebutton"];
	$("applyBtn").value = RESOURCE["applybutton"];

	btnRightArr.queryBtn = new BtnRightObj("queryBtn", query_oduif_params);
	btnRightArr.applyBtn = new BtnRightObj("applyBtn", apply_if_params);
	btnRightArr.newBtn = new BtnRightObj("newBtn", apply_if_params);
	btnRightArr.deleteBtn = new BtnRightObj("deleteBtn",
			apply_if_params);
	getRightInfo(obj, btnRightArr);
}

function initBtnState()
{
	if (btnRightArr.queryBtn.right)
	{
		$("queryBtn").disabled = false;
	}

	if (btnRightArr.applyBtn.right)
	{
		$("newBtn").disabled = !btnRightArr.newBtn.right;
		if (st.getSelectedRowCount() > 0)
		{
			$("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
		}
		else
		{
			$("deleteBtn").disabled = true;
		}
		if((netype == '77'||netype == '114') &&  st.getDataRowLength() >= 3)//950    
		{
			$("newBtn").disabled = true;
		}
		else if(netype == '76' &&  st.getDataRowLength() >= 1)//910    
		{
			$("newBtn").disabled = true;
		}
		else
		{
			$("newBtn").disabled = !btnRightArr.newBtn.right;
			$("applyBtn").disabled = true;
		}
	}
}

function disableAllBtnState()
{
	$("queryBtn").disabled = true;
	$("newBtn").disabled = true;
	$("deleteBtn").disabled = true;
	$("applyBtn").disabled = true;
}

function menuPopup()
{
	if (st.getSelectedRowCount() > 0)
	{
		if (btnRightArr.applyBtn.right)
		{
			removejsDOMmenu();
			createjsDOMenu();
			showMenu(event);
		}
	}
}

var firstQuery = true;
function tabSelectHandler()
{
	if(firstQuery)
	{
		sendQueryInfo();
		firstQuery = false;
	}
	var totalHeight = getComponetHeight($("total"), 330);
	st.setBodyHeight(totalHeight);
}

function initXpic()
{
	initBtn();
	initTab();
	initXpicWorkGroup();

	if (btnRightArr.queryBtn.right)
	{
		/**
		 *                    XPIC   XPIC         XPIC                    
		 * XPIC    tab 
		 */
		if((parent.Tab) && 0 == parent.Tab.getSelectedTabIndex())
		tabSelectHandler();
	}
	else
	{
		$("queryBtn").disabled = !btnRightArr.queryBtn.right;
		$("newBtn").disabled = !btnRightArr.newBtn.right;
		$("applyBtn").disabled = true;
		$("deleteBtn").disabled = true;
	}
}

function initTab()
{
	tab = new Tabs();
	tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame",
			"tabs_li_select");
	tab.addTab(2, RESOURCE["amparamtable"], "amparam.html");
	tab.addTab(1, RESOURCE["atpcmanagertable"], "../xpic_u2kv1r2c00/atpc.html");
	tab.selectTab(2);
	$("tab").appendChild(tab.getTabs());
	tab.setTabsNoScroll();
	tab.setTabsHeight("150px");
}

function queryBoardMap(pgID)
{
	atpcData = new DataInterface();
	for ( var i = 0; i < dinterface.rows.length; i++)
	{
		if (dinterface.rows[i].groupid.value == pgID)
		{
			atpcData.rows[0] = dinterface.rows[i];
		}
	}

	if (tab.getTabWindow(1).st)
	{
		tab.getTabWindow(1).refreshTable(atpcData);
	}
	if (tab.getTabWindow(2).st && bdData != null)
	{
		tab.getTabWindow(2).refreshTable(bdData);
	}
}

function sendQueryInfo(dinterface)
{
	disableAllBtnState();
	bdData = null;
	atpcData = null;
	LoadingProcess.showWaitStatus("../../../../images");
	var xmlstr = createQueryXpicXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_GET_XPIC
			+ "&flag=1" + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, refreshTable, dinterface, "inputdata=" + xmlstr);
}

function createQueryXpicXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neId");
	param.setAttribute("value", neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function refreshTable(doc, data)
{
	dinterface = EncapsulateData(doc);	
	LoadingProcess.removeWaitStatus();
	if(typeof(data) != "undefined" && data && dinterface.getSErrorCode() < data.getSErrorCode())
	{
		dinterface.setSErrorCode(data.getSErrorCode());
		dinterface.setSErrorInfo(data.getSErrorInfo());
		dinterface.getError().rowErrors = dinterface.getError().rowErrors.concat(data.getError().rowErrors);
	}
    
    if (0 != dinterface.getSErrorCode()) 
    {
        cacheRowErrs = dinterface.getError().rowErrors;
        
        if (dinterface.getDataRowLength() == 0) 
        {
            showErrorDialog(dinterface);
        }
    }

	st.clearTableData();

	if (tab.getTabWindow(1).st)
	{
		tab.getTabWindow(1).st.clearTableData();
	}
	if (tab.getTabWindow(2).st)
	{
		tab.getTabWindow(2).st.clearTableData();
	}

	if (dinterface.getDataRowLength() == 0)
	{
		initBtnState();
		return;
	}

	constructtbXML(dinterface);


}

function constructtbXML(dinterface)
{
	var downDinterface = null;
	var downObj = null;
	var tempObj = null;
	var pgID = 0;
	usedPGList = [];
	pgBoardMap = new Object();

	queryradiolinkid(dinterface);
}

function fillData(dinterface)
{
	createTableBody(st, window.tableconf[0], dinterface, RESOURCE);

	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		var cell = st.getCellElement(i, "transmitFrequency");
		checkText(cell.editElement.element, "0", "4294967.295", 3);
		st.getCellEdit(i, "transmitFrequency").element.onblur = cellonblur;

		var cell = st.getCellElement(i, "trInterval");
		checkText(cell.editElement.element, "0", "4294967.295", 3);
		st.getCellEdit(i, "trInterval").element.onblur = cellonblur;		

		var amBoostCell = st.getCell(i, "W32PORT_ATTR_XPICAMBOOSTSTATUS");
		
		if(amBoostCell != null && 
		(st.getCellStoreValue(i, "W32PORT_ATTR_XPICAMBOOSTSTATUS","W32PORT_ATTR_XPICAMBOOSTSTATUS")	== undefined) ||
		("" == st.getCellStoreValue(i, "W32PORT_ATTR_XPICAMBOOSTSTATUS","W32PORT_ATTR_XPICAMBOOSTSTATUS")))
		{
			st.setCellIsEdit(amBoostCell, false);			
			st.setAtomValue(amBoostCell.element.showElement,"-");
			amBoostCell.element.ondblclick = null;
		}
	}

	st.element.colsArray.selectedId = "groupid";
	var tdsort = st.element.headRow.element.cols["groupid"].element;
	st.sortRows(tdsort, 1);

	st.setRowSelect(0);

	talbeRowSelecteHandler();

	if (!st.element.colsArray.selectedId)
	{
		st.element.colsArray.selectedId = "groupid";
	}
	if (!st.element.colsArray.imgflag)
	{
		st.element.colsArray.imgflag = 1;
	}
	var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
	st.sortRows(td, st.element.colsArray.imgflag);
}

function createXpic()
{
	hideMenu();
	xshowModalDialog("../xpic_u2kv1r2c00/createXpic.html", RESOURCE["createXpic"], 500, 440,
			"../../../../images/");
}

function deleteXpic()
{
	if (st.getSelectedRowCount() < 1)
	{
		return;
	}

	if (confirm(RESOURCE["deleteconfirm"]))
	{
		sendDeleteInfo();
	}
}

function sendDeleteInfo()
{
	disableAllBtnState();
	LoadingProcess.showWaitStatus("../../../../images");
	var xmlstr = createDeleteXpicXML();

	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_DEL_XPIC_GROUP + "&flag=1" + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openDeleteErrDialog, null, "inputdata="
			+ xmlstr);
}

function createDeleteXpicXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var rows = st.getSelectedRows();
	delPGList = [];
	for ( var i = 0, len = rows.length; i < len; i++)
	{
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neId");

		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupId");
		param.setAttribute("value", st.getCellCurrentValue(rows[i], "groupid",
				"groupid"));
		row.appendChild(param);

		bussiness.appendChild(row);
		delPGList.push(st.getCellStoreValue(rows[i], "groupid", "groupId"));
	}

	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openDeleteErrDialog(doc)
{
	var dinterface = EncapsulateData(doc);
	LoadingProcess.removeWaitStatus();
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", dinterface.getError(), errArr);
	if (0 == dinterface.getSErrorCode() || 1 == dinterface.getSErrorCode())
	{
		var faultPGList = [];
		for ( var i = 0, len = dinterface.getBErrLength(); i < len; i++)
		{
			faultPGList.push(dinterface.getBErrParam(i, "groupid"));
		}
		for ( var j = st.getDataRowLength() - 1; j >= 0; j--)
		{
			var pgid = st.getCellStoreValue(j, "groupid", "groupid");
			if (!faultPGList.contains(pgid) && st.getRowSelFlag(j))
			{
				st.deleteRow(j);
				usedPGList.remove(pgid);
				pgBoardMap[pgid] = null;
			}
		}
		st.adjustDataRows();
	}
	oldSelectedGroupID = -1;
	if (st.getSelectedRowCount() == 0 && st.getDataRowLength() > 0)
	{
		st.setRowSelect(0);
	}

	talbeRowSelecteHandler();

	initBtnState();

}

function modifyXpic()
{
	var cell = null;
	var isNeedAlert = false;
	for (var i = 0, size = st.getDataRowLength(); i < size; i++)
    {
    	if (st.getModify(i))
    	{
    		cell = st.getCell(i, "bandwidth");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "bandwidth")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "receivedPowerV");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "receivedPowerV")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "receivedPowerH");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "receivedPowerH")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "maxTransmitPower");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "maxTransmitPower")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "transmitPower");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "transmitPower")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "transmitFrequency");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "transmitFrequency")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "trInterval");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "trInterval")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "workStatus");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "workStatus")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
    	}
    }
    
    var amst = tab.getTabWindow(2).st;
    for (var j = 0, size1 = amst.getDataRowLength(); j < size1; j++)
    {
    	if (amst.getModify(j))
    	{
    		isNeedAlert = true;
    		break;
    	}
    }
    
    if (isNeedAlert)
    {
    	if (!confirm(RESOURCE["DANGER_ALARM"])) 
	    {
	        return;
	    }
    }
    
	disableAllBtnState();
	LoadingProcess.showWaitStatus("../../../../images");
	var xmlStr = createModifyXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_SET_XPIC
			+ "&flag=1" + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openModifyErrDialog, null, "inputdata="
			+ xmlStr);
}

function createModifyXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var amst = tab.getTabWindow(2).st;
		
	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		var modifyFlg = false;
		ifModifyFlg = isIFAttrsModify(i, st.getCellCurrentValue(i, "groupid", "groupid"));
		
		/******************************************************************************************************/
		if (st.getModify(i) || ifModifyFlg)
		{
			modifyFlg = true;
			row = new tagElement("row-params");

			param = new tagElement("param");
			param.setAttribute("name", "neid");
			param.setAttribute("value", neid);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "groupId");
			param.setAttribute("value", st.getCellCurrentValue(i, "groupid","groupid"));
			row.appendChild(param);
			/******************************************ACM PARAM*****************************************************/
			if (st.getCellModify(i, "bandwidth")  || ifModifyFlg)
			{
				param = new tagElement("param");
				param.setAttribute("name", "bandwidth");
				param.setAttribute("value", st.getCellCurrentValue(i,"bandwidth", "bandwidth"));
				row.appendChild(param);
                var amObj = getAmObject(amst, st.getCellCurrentValue(i, "groupid", "groupid"));
                                
				param = new tagElement("param");
				param.setAttribute("name", "amstate");
				param.setAttribute("value", amObj.amstate);
				row.appendChild(param);

				param = new tagElement("param");
				param.setAttribute("name", "ensuremode");
				param.setAttribute("value", amObj.ensuremode);
				row.appendChild(param);

				param = new tagElement("param");
				param.setAttribute("name", "fullmode");
				param.setAttribute("value", amObj.fullmode);
				row.appendChild(param);

				param = new tagElement("param");
				param.setAttribute("name", "manualmode");
				param.setAttribute("value", amObj.manualmode);
				row.appendChild(param);
			}
			/******************************************ACM PARAM*****************************************************/
			/**********************************************RF Frequency**********************************************/
			if (st.getCellModify(i, "transmitPower"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "transmitPower");
				param.setAttribute("value", st.getCellCurrentValue(i,"transmitPower", "transmitPower") * 10);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "maxTransmitPower"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "maxTransmitPower");
				param.setAttribute("value", st.getCellCurrentValue(i,"maxTransmitPower", "maxTransmitPower") * 10);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "transmitFrequency"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "transmitFrequency");
				param.setAttribute("value", st.getCellCurrentValue(i,"transmitFrequency", "transmitFrequency") * 1000);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "trInterval"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "trInterval");
				param.setAttribute("value", st.getCellCurrentValue(i,"trInterval", "trInterval") * 1000);
				row.appendChild(param);
			}

			if (st.getCellModify(i, "workStatus"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "workStatus");
				param.setAttribute("value", st.getCellCurrentValue(i,"workStatus", "workStatus"));
				row.appendChild(param);
			}
			
			if (st.getCell(i, "W32PORT_ATTR_XPICAMBOOSTSTATUS")!= null 
				&& st.getCellModify(i, "W32PORT_ATTR_XPICAMBOOSTSTATUS"))
			{
				param = new tagElement("param");
				param.setAttribute("name", "W32PORT_ATTR_XPICAMBOOSTSTATUS");
				param.setAttribute("value", st.getCellCurrentValue(i,"W32PORT_ATTR_XPICAMBOOSTSTATUS", "W32PORT_ATTR_XPICAMBOOSTSTATUS"));
				row.appendChild(param);
			}
		}
		/**********************************************RF Frequency**********************************************/
		
		/**********************************************atpc******************************************************/
		if ( tab.getTabWindow(1).st &&
			 tab.getTabWindow(1).st.getCellCurrentValue(0, "groupid", "groupid") == st.getCellStoreValue(i, "groupid", "groupid") &&
			 tab.getTabWindow(1).st.getModify(0) )
		{
			modifyFlg = true;
			if (row == null)
			{
				row = new tagElement("row-params");
				param = new tagElement("param");
				param.setAttribute("name", "neid");
				param.setAttribute("value", neid);
				row.appendChild(param);

				param = new tagElement("param");
				param.setAttribute("name", "groupid");
				param.setAttribute("value", tab.getTabWindow(1).st
						.getCellCurrentValue(0, "groupid", "groupid"));
				row.appendChild(param);
			}
			param = new tagElement("param");
			param.setAttribute("name", "atpcEnableStatus");
			param.setAttribute("value", tab.getTabWindow(1).st
					.getCellCurrentValue(0, "atpcEnableStatus",
							"atpcEnableStatus"));
			row.appendChild(param);

			var atpcEnableStatus = tab.getTabWindow(1).st.getCellCurrentValue(
					0, "atpcEnableStatus", "atpcEnableStatus");
			if (atpcEnableStatus == 1)
			{
				param = new tagElement("param");
				param.setAttribute("name", "atpcUpperThreshold");
				param.setAttribute("value", tab.getTabWindow(1).st
						.getCellCurrentValue(0, "atpcUpperThreshold",
								"atpcUpperThreshold") * 10);
				row.appendChild(param);

				param = new tagElement("param");
				param.setAttribute("name", "atpcLowerThreshold");
				param.setAttribute("value", tab.getTabWindow(1).st
						.getCellCurrentValue(0, "atpcLowerThreshold",
								"atpcLowerThreshold") * 10);
				row.appendChild(param);
			}

			param = new tagElement("param");
			param.setAttribute("name", "atpcAdjustment");
			var atpcAdjustmentValue = tab.getTabWindow(1).st.getCellCurrentValue(0, "atpcAdjustment",	"atpcAdjustment");
			param.setAttribute("value", atpcAdjustmentValue);
			if( atpcAdjustmentValue != null && atpcAdjustmentValue != "" )
			{
				row.appendChild(param);
			}

			param = new tagElement("param");
			param.setAttribute("name", "atpcAutoEnable");
			param
					.setAttribute("value", tab.getTabWindow(1).st
							.getCellCurrentValue(0, "atpcAutoEnable",
									"atpcAutoEnable"));
			row.appendChild(param);
		}
		/**********************************************atpc******************************************************/
		
		/**********************************************RF POWER**************************************************/
		if (modifyFlg)
		{
			bussiness.appendChild(row);
		}

		if (st.getCellModify(i, "receivedPowerV"))
		{
			row = new tagElement("row-params");
			param = new tagElement("param");
			param.setAttribute("name", "neid");
			param.setAttribute("value", neid);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", parseInt(st.getCellStoreValue(i,
					"polarizationDirectionV", "vPolarBdid")) + oduSlotGap);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "W32BRD_ATTR_RECEIVEPOWER");
			param.setAttribute("value", st.getCellStoreValue(i,
					"receivedPowerV", "receivedPowerV") * 10);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "receivedPowerVFalg");
			param.setAttribute("value", "1");
			row.appendChild(param);
			
			
			bussiness.appendChild(row);
		}

		if (st.getCellModify(i, "receivedPowerH"))
		{
			row = new tagElement("row-params");
			param = new tagElement("param");
			param.setAttribute("name", "neid");
			param.setAttribute("value", neid);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", parseInt(st.getCellStoreValue(i,
					"polarizationDirectionH", "hPolarBdid")) + oduSlotGap);
			row.appendChild(param);

			param = new tagElement("param");
			param.setAttribute("name", "W32BRD_ATTR_RECEIVEPOWER");
			param.setAttribute("value", st.getCellStoreValue(i,
					"receivedPowerH", "receivedPowerH") * 10);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "receivedPowerHFalg");
			param.setAttribute("value", "1");			
			row.appendChild(param);
			
			bussiness.appendChild(row);
		}
		/**********************************************RF POWER**************************************************/
		/********************************************************************************************************/
		for ( var j = 0, n = amst.getDataRowLength(); j < n; j++)
		{
			if (amst.getCellCurrentValue(j, "groupid", "groupid") == st
					.getCellStoreValue(i, "groupid", "groupid")
					&& (amst.getModify(j) || ifModifyFlg))
			{
				if(amst.getCellModify(j, "hybridnum"))
				{
					var amRow = new tagElement("row-params");
					amParam = new tagElement("param");
					amParam.setAttribute("name", "neid");
					amParam.setAttribute("value", neid);
					amRow.appendChild(amParam);
	
					amParam = new tagElement("param");
					amParam.setAttribute("name", "groupid");
					amParam.setAttribute("value", amst.getCellCurrentValue(j,
							"groupid", "groupid"));
					amRow.appendChild(amParam);
	
					var slotid = amst.getCellStoreValue(j, "polarizationDirection",
							"slotid");
					amParam = new tagElement("param");
					amParam.setAttribute("name", "slotid");
					amParam.setAttribute("value", slotid);
					amRow.appendChild(amParam);
	
					var portid = amst.getCellStoreValue(j, "polarizationDirection","portid");
					amParam = new tagElement("param");
					amParam.setAttribute("name", "portid");
					amParam.setAttribute("value", portid);
					amParam.setAttribute("modifyFlag", true);
					amRow.appendChild(amParam);
	
					amParam = new tagElement("param");
					amParam.setAttribute("name", "hybridnum");
					amParam.setAttribute("value", amst.getCellStoreValue(j,"hybridnum", "hybridnum"));
					amRow.appendChild(amParam);
	
					bussiness.appendChild(amRow);
				}

				if (amst.getCellModify(j, "amstate")
						|| amst.getCellModify(j, "ensuremode")
						|| amst.getCellModify(j, "fullmode")
						|| amst.getCellModify(j, "manualmode") || ifModifyFlg)
				{
					var amRow = new tagElement("row-params");
					amParam = new tagElement("param");
					amParam.setAttribute("name", "neid");
					amParam.setAttribute("value", neid);
					amRow.appendChild(amParam);
					
					var slotid = amst.getCellStoreValue(j, "polarizationDirection","slotid");
					amParam = new tagElement("param");
					amParam.setAttribute("name", "slotid");
					amParam.setAttribute("value", slotid);
					amRow.appendChild(amParam);
					
					var portid = amst.getCellStoreValue(j, "polarizationDirection","portid");
					amParam = new tagElement("param");
					amParam.setAttribute("name", "portid");
					amParam.setAttribute("value", portid);
					amRow.appendChild(amParam);
					
					amParam = new tagElement("param","port",portid);
					amRow.appendChild(amParam);
					/*****************************            **********************************************/
					
					/**
					 * var SERVICETYPE_E1ETH = '1';  //Hybrid(Native E1+ETH)
					 * var SERVICETYPE_STM1ETH = '2'; //Hybrid(Native STM-1+ETH)
					 * var SERVICETYPE_SDH = '3'; //SDH
					 */
					var serviceType = amst.getCellStoreValue(j, "IFPORT_ATTR_SERVICETYPE","IFPORT_ATTR_SERVICETYPE");
					if(SERVICETYPE_E1ETH == serviceType)
					{
						if(amst.getCell(j, "e1enable","e1enable"))
						{
						    var e1Status = amst.getCellStoreValue(j, "e1enable", "e1enable");
						    var amStatus = amst.getCellStoreValue(j, "amstate", "amstate");
						    var fullNumVal = amst.getCellStoreValue(j, "fullnum", "fullnum");
						    var guaranteeNumVal = amst.getCellStoreValue(j, "guaranteenum", "guaranteenum");
						    if(amStatus == DISABLED)
						    {
						        fullNumVal = INVALID;
						    } 
						    else if(amStatus == ENABLED && e1Status == DISABLED)
						    {
						        fullNumVal = guaranteeNumVal;
						    }
						    
						    amParam = new tagElement("param");
						    amParam.setAttribute("name", "guaranteenum");
						    amParam.setAttribute("value", guaranteeNumVal);
						    amParam.setAttribute("modifyFlag", true);
						    amRow.appendChild(amParam);
						    
						    amParam = new tagElement("param");
						    amParam.setAttribute("name", "fullnum");
						    amParam.setAttribute("value", fullNumVal);
						    amParam.setAttribute("modifyFlag", true);
						    amRow.appendChild(amParam);
						}
					}
					else if(SERVICETYPE_STM1ETH == serviceType || SERVICETYPE_SDH == serviceType)
					{
					    var stm1num = amst.getCellStoreValue(j, "IFPORT_ATTR_STM1NUM", "IFPORT_ATTR_STM1NUM")||"1";//   1
					    amParam = new tagElement("param");
					    amParam.setAttribute("name", "IFPORT_ATTR_STM1NUM");
					    amParam.setAttribute("value", stm1num);
					    amParam.setAttribute("modifyFlag", true);
					    amRow.appendChild(amParam);
					}
					
					/*****************************            **********************************************/
					bussiness.appendChild(amRow);
				}
			}
		}
		ifModifyFlg = false;
	}
	di.getRoot().appendChild(bussiness);
	
	return di.toString();
}

function openModifyErrDialog(doc)
{
	initBtnState();
	LoadingProcess.removeWaitStatus();
	var dinterface = EncapsulateData(doc);
	
	if (0 != dinterface.getSErrorCode())
	{
		$("applyBtn").disabled = !btnRightArr.applyBtn.right;
		showErrorDialog(dinterface);
		return;
	} else {
	    refreshTableState(st, window.tableconf[0], dinterface);
	    if (tab.getTabWindow(1).st)
	    {
	       refreshTableState(tab.getTabWindow(1).st,
	       tab.getTabWindow(1).window.tableconf[0], dinterface);
	    }
	    if (tab.getTabWindow(2).st)
	    {
	        refreshTableState(tab.getTabWindow(2).st,
			tab.getTabWindow(2).window.tableconf[0], dinterface);
	    }
	   updateBdData();

	}
}


/**
 *   am  
 */
function updateBdData()
{
	var amst = tab.getTabWindow(2).st;
	if(amst)
	{
		for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
		{
			var groupid = st.getCellCurrentValue(i, "groupid", "groupid");
		    var amObj = getAmObject(amst, groupid);
		    
		    for ( var j = 0, length = bdData.getDataRowLength(); j < length; j++)
	    	{
		    	var bdrows = bdData.getDataRow(j);
		    	if(groupid == bdrows.groupid.value)
	    		{
		    		if(bdrows.amstate)
		    		{
		    			bdrows.amstate.value = amObj.amstate;
		    		}
		    		if(bdrows.ensuremode)
		    		{
		    		  bdrows.ensuremode.value = amObj.ensuremode;
		    		}
		    		if(bdrows.fullmode)
		    		{
		    		  bdrows.fullmode.value = amObj.fullmode;
		    		}
		    		if(bdrows.manualmode)
		    		{
		    		  bdrows.manualmode.value = amObj.manualmode;	
		    		}
	    		}
	    	
	    	 }		     
		}
	}
}

function xpicConvert(command)
{
	sendConvertInfo(command);
}

function sendConvertInfo(command)
{
	if (command > 1)
	{
		removejsDOMmenu();
		var flag = confirm(RESOURCE["confimswitch"]);
		if (!flag)
		{
			return;
		}
	}

	disableAllBtnState();

	var xmlstr = null;

	switch (command)
	{
		case 1:
			sendQueryInfo();
			break;
		case 2:
			deleteXpic();
			break;
		case 3:
			hvConvert();
			break;
	}

	if (null != xmlstr)
	{
		var urlreq = "../../../../neExlorerServlet?sfid="
				+ NSCMD_CFG_SET_XPIC_BD_POLAR + "&flag=1" + "&nmUser="
				+ obj["nmUser"];
		loadXMLdoc(urlreq, "POST", true, openConvertErrDialog, command,
				"inputdata=" + xmlstr);
	}

}

function hvConvert()
{
	disableAllBtnState();
	var xmlStr = createHVConvertXML();
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_SET_XPIC_BD_POLAR + "&flag=1" + "&nmUser="
			+ obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openHVconvertErrDialog, null, "inputdata="
			+ xmlStr);
}

function createHVConvertXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = null;
	var param = null;
	var selectedRows = st.getSelectedRows();
	
	for ( var i = 0, len = selectedRows.length; i < len; i++)
	{
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupId");
		param.setAttribute("value", st.getCellCurrentValue(selectedRows[i], "groupid",
				"groupid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "hPolarBdid");
		param.setAttribute("value", st.getCellCurrentValue(selectedRows[i],
				"polarizationDirectionV", "vPolarBdid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "vPolarBdid");
		param.setAttribute("value", st.getCellCurrentValue(selectedRows[i],
				"polarizationDirectionH", "hPolarBdid"));
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openHVconvertErrDialog(doc)
{
	initBtnState();
	var dinterface = EncapsulateData(doc);
	if (0 != dinterface.getSErrorCode())
	{
		$("applyBtn").disabled = !btnRightArr.applyBtn.right;
		showErrorDialog(dinterface);
		return;
	}

	sendQueryInfo();
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../page/", data.getError(), errArr);
}

function openConvertErrDialog(doc, para)
{
	var data = EncapsulateData(doc);

	if (0 != data.getSErrorCode())
	{
		initBtnState();
		showErrorDialog(data);
		return;
	}

	if (para == 5 || para == 6 || para == 3 || para == 4)
	{
		alert(RESOURCE["queryswitchstatus2"]);
	}

	refresh();
}

function queryradiolinkid(dinterface)
{
	var xmlStr = createQueryRadioLinkIDXML(dinterface);

	var urlreq = "../../../../neExlorerServlet?sfid=93731&flag=1" + "&nmUser="
			+ obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openRadioLinkIDErrDialog, dinterface,
			"inputdata=" + xmlStr);
}

function createQueryRadioLinkIDXML(dinterface)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for ( var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
	{
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param
				.setAttribute("value", dinterface.getDataRowParam(i,
						"hPolarBdid"));
		row.appendChild(param);

		var hPolarPortid = dinterface.getDataRowParam(i, "hPolarPortid");
		param = new tagElement("param");
		param.setAttribute("name", "port");
		param.setAttribute("value", hPolarPortid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "portid");
		param.setAttribute("value", hPolarPortid);
		row.appendChild(param);

		bussiness.appendChild(row);

		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param
				.setAttribute("value", dinterface.getDataRowParam(i,
						"vPolarBdid"));
		row.appendChild(param);

		var vPolarPortid = dinterface.getDataRowParam(i, "vPolarPortid");
		param = new tagElement("param");
		param.setAttribute("name", "port");
		param.setAttribute("value", vPolarPortid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "portid");
		param.setAttribute("value", vPolarPortid);
		row.appendChild(param);

		bussiness.appendChild(row);

	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function openRadioLinkIDErrDialog(doc, dinterface)
{
	bdData = EncapsulateData(doc);
	
	if (isFilter != "filter")
	{
	    if(cacheRowErrs != null && cacheRowErrs.length > 0)
	    {
	        var tempRowErrs = bdData.getError().rowErrors;
	        for(var i = 0, len = cacheRowErrs.length; i < len; i++)
	        {
	            tempRowErrs[tempRowErrs.length] = cacheRowErrs[i];
	        }
	    }	  
	   
	    showErrorDialog(bdData);
	}
	
	isFilter = null;

	fillData(dinterface);

	if (0 == bdData.getSErrorCode() || 1 == bdData.getSErrorCode())
	{
		var len = bdData.getDataRowLength();
		var itemcount = len / 2;
		if (len <= 0)
		{
			return;
		}
		for ( var i = 0; i < len; i++)
		{
			var tslotid = bdData.getDataRowParam(i, "slotid");
			var tport = bdData.getDataRowParam(i, "port");
			var tlinkid = bdData.getDataRowParam(i, "W32PORT_ATTR_RADIOLINKID");
			var srPower = bdData.getDataRowParam(i, "W32BRD_ATTR_RECEIVEPOWER");
			for ( var j = 0, m = st.getDataRowLength(); j < m; j++)
			{
				var vPolarBdid = st.getCellStoreValue(j,
						"polarizationDirectionV", "vPolarBdid");
				var vPolarPortid = st.getCellStoreValue(j,
						"polarizationDirectionV", "vPolarPortid");
				if (vPolarBdid == tslotid && vPolarPortid == tport)
				{
					st.setAtomValue(
							st.getCell(j, "radioidV").element.showElement,
							tlinkid);
					st
							.setAtomValue(
									st.getCell(j, "receivedPowerV").element.showElement,
									srPower);
					break;
				}

				var hPolarBdid = st.getCellStoreValue(j,
						"polarizationDirectionH", "hPolarBdid");
				var hPolarPortid = st.getCellStoreValue(j,
						"polarizationDirectionH", "hPolarPortid");
				if (hPolarBdid == tslotid && hPolarPortid == tport)
				{
					st.setAtomValue(
							st.getCell(j, "radioidH").element.showElement,
							tlinkid);
					st
							.setAtomValue(
									st.getCell(j, "receivedPowerH").element.showElement,
									srPower);
					break;
				}
			}
		}
		var rows = st.getSelectedRows();

		if (st.getSelectedRowCount() > 0)
		{
			var currentSelectedGroupID = st.getCellStoreValue(rows[0], "groupid", "groupid");
			queryBoardMap(st.getCellStoreValue(rows[0], "groupid", "groupid"));
		}
		
	}
	initBtnState();
}

function isIFAttrsModify(rowIndex, groupid)
{
    if(st.getCellModify(rowIndex, "bandwidth"))
    {
        return true;
    }
    
    var amst = tab.getTabWindow(2).st;
    var amGroupid;
    for(var i = 0, len = amst.getDataRowLength(); i < len; i++)
    {
        amGroupid = amst.getCellCurrentValue(i, "groupid", "groupid");
        if(amGroupid != groupid)
        {
            continue;
        }
        
        if(amst.getCellModify(i, "amstate") || amst.getCellModify(i, "ensuremode") || amst.getCellModify(i, "fullmode") || amst.getCellModify(i, "manualmode"))
        {
            return true;
        }
    }
    
    return false;
}

function getAmObject(st, groupid)
{
    var amGroupid;
    var amObject = new Object();
    for(var i = 0, len = st.getDataRowLength(); i < len; i++)
    {
        amGroupid = st.getCellCurrentValue(i, "groupid", "groupid");
        if(amGroupid == groupid)
        {
            amObject.amstate = st.getCellCurrentValue(i, "amstate", "amstate");
            amObject.ensuremode = st.getCellCurrentValue(i, "ensuremode", "ensuremode");
            amObject.fullmode = st.getCellCurrentValue(i, "fullmode", "fullmode");
            amObject.manualmode = st.getCellCurrentValue(i, "manualmode", "manualmode");
            
            break;
        }
    }
    
    if(!amObject.amstate)
    {
        for ( var i = 0, len = bdData.rows.length; i < len; i++)
	{
            if (bdData.getDataRowParam(i, "groupid") == groupid)
	    {
		amObject.amstate = bdData.getDataRowParam(i, "amstate");
                amObject.ensuremode = bdData.getDataRowParam(i, "ensuremode");
                amObject.fullmode = bdData.getDataRowParam(i, "fullmode");
                amObject.manualmode = bdData.getDataRowParam(i, "manualmode");
            
                break;
	    }
	}
    }
    
    return amObject;
}

/**
 *              
 * @return Array
 */
function getUsedBoardList()
{
	var boardlist = [];
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		var vslotid = st.getCellStoreValue(i,"polarizationDirectionV","vPolarBdid");
		var vportid = st.getCellStoreValue(i,"polarizationDirectionV","vPolarPortid");
		var hslotid = st.getCellStoreValue(i,"polarizationDirectionH","hPolarBdid");
		var hportid = st.getCellStoreValue(i,"polarizationDirectionH","hPolarPortid");
		boardlist.push({slotID:vslotid,portID:vportid});
		boardlist.push({slotID:hslotid,portID:hportid});
	}
	return boardlist;
}
