
/**
 *            ODU            
 *                                 
 *                      
 *              
 */
var IFODUBoardGroupList = function(/*int*/neid)
{
    var _this = this;
    this.neId = neid;
    this.boardList = [];
    /**
     *          
     * @param doc       XML  
     * @param params     ,         
     */
    this.queryBoardCallback = function(/*DOMXML*/doc,/*Array*/ params)
    {
        var data = EncapsulateData(doc);
        var len = data.getDataRowLength();
        for (var i = 0; i < len; i++) 
        {
            var boardObj = new IFODUBoardGroupObj();
            boardObj.setNEid(_this.neId);
            boardObj.mIfSlotId = data.getDataRowParam(i, "mSlotId");
            boardObj.mBoardName = data.getDataRowParam(i, "mBoardName");
            boardObj.mIfPhy = data.getDataRowParam(i, "mIfPhy");
            boardObj.mOduSlotId = data.getDataRowParam(i, "mOduSlotId");
            boardObj.mOduBoardName = data.getDataRowParam(i, "mOduBoardName");
            boardObj.mOduPhy = data.getDataRowParam(i, "mOduPhy");
            _this.addIFODUBoardGroup(boardObj);
            
        }
    }

    
    /**
     *              
     *
     */
    this.queryBoardAlarmLevelCallback = function(/*DOMXML*/doc,/*Array*/ params)
    {
        var data = EncapsulateData(doc);
        var len = data.getDataRowLength();
        for (var i = 0; i < len; i++) 
        {
            var slotid = data.getDataRowParam(i, "slotID");
            var ifoduBoard = _this.getBoardBySlotID(slotid);
            if (ifoduBoard != null) 
            {
                if (ifoduBoard.mIfSlotId == slotid) 
                {
                    ifoduBoard.mIfBoardAlarmLevel = data.getDataRowParam(i, "topAlmLevel");
                }
                else 
                {
                    ifoduBoard.mOduBoardAlarmLevel = data.getDataRowParam(i, "topAlmLevel");
                }
            }
        }
    }
    
    /**
     *     ID         
     * @param {Object} slotid
     */
    this.getBoardBySlotID = function(/*int*/slotid)
    {
        var len = _this.boardList.length;
        for (var i = 0; i < len; i++) 
        {
            if (_this.boardList[i].mIfSlotId == slotid || _this.boardList[i].mOduSlotId == slotid) 
            {
                return _this.boardList[i];
            }
        }
        return null;
    }
}


IFODUBoardGroupList.prototype.setNEid = function(/*int*/neid)
{
    this.neId = neid;
}
IFODUBoardGroupList.prototype.getNEid = function()
{
    return this.neId;
}

IFODUBoardGroupList.prototype.addIFODUBoardGroup = function(/*IFODUBoardGroupObj*/ifoduGroup)
{
    if (ifoduGroup != null) 
    {
        this.boardList[this.boardList.length] = ifoduGroup;
    }
}

/**
 *   TECMDCODE_IFLOOPBACKTEST_GET_BOARD          
 *                                         
 */
IFODUBoardGroupList.prototype.loadBoardInfo = function(/*String*/nmuser,/*String*/servlet)
{
    var xmlstr = this.createQueryBoardXML();
    var urlreq = servlet+"?sfid=" + TECMDCODE_IFLOOPBACKTEST_GET_BOARD + "&nmUser=" + nmuser;
    loadXMLdoc(urlreq, "POST", false, this.queryBoardCallback, null, "inputdata=" + xmlstr);
}
/**
 *          XML
 * Slotid=0          ODU      
 * @param neid   ID
 * @param slotid   ID
 * @param bInterval       
 */
IFODUBoardGroupList.prototype.createQueryBoardXML = function()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    createXMLparam(row, "neid", this.neId);
    createXMLparam(row, "slotid", 0);
    createXMLparam(row, "querytype", "getallIFODUBoard");
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}
/**
 *          
 */
IFODUBoardGroupList.prototype.getBoardAlarmLevel = function(nmuser,/*String*/servlet)
{
    var xmlstr = this.createQueryBoardAlarmLevelXML();
    if (xmlstr == null) 
    {
        return;
    }
    var urlreq = servlet+"?sfid=" + TECMDCODE_GET_NECPSANDALM + "&nmUser=" + nmuser;
    loadXMLdoc(urlreq, "POST", false, this.queryBoardAlarmLevelCallback, null, "inputdata=" + xmlstr);
}

/**
 *            XML
 *
 */
IFODUBoardGroupList.prototype.createQueryBoardAlarmLevelXML = function()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var boardlength = this.boardList.length;
    if (boardlength <= 0) 
    {
        return null;
    }
    for (var i = 0; i < boardlength; i++) 
    {
        var row = new tagElement("row-params");
        createXMLparam(row, "neid", this.neId);
        createXMLparam(row, "slotID", this.boardList[i].mIfSlotId);
        bussiness.appendChild(row);
        
        row = new tagElement("row-params");
        createXMLparam(row, "neid", this.neId);
        createXMLparam(row, "slotID", this.boardList[i].mOduSlotId);
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
    
}
/**
 *       -ODU         
 * @return
 */
var IFODUBoardGroupObj = function()
{
    this.neId = -1;
    this.protectType = null;
    this.convert = null;
    
    /**
     *              
     */
    this.mIfSlotId = null;//     
    this.mBoardName = null;//     
    this.mIfPhy = null;//            
    this.mOduSlotId = null;//      
    this.mOduPhy = null;//            
    this.mOduBoardName = null;//             ODU FO     ODU 
    /**
     *       TEGetTopLevelAlmBean    
     */
    this.mIfBoardAlarmLevel = 0;//        
    this.mOduBoardAlarmLevel = 0;//ODU      
    /**
     *              
     */
    this.bandwidth = null;//         	
    this.oduWork = null;//        0:mute 1:unmute
    this.minFilter = null;//           KHz
    this.curFilter = null;//           KHz
    this.curFreq = null;//         
    this.minFreq = null;//                
    this.maxFreq = null;//                
    this.cfgFreq = null;//                  
    this.curRxPower = null;//                  
    this.nextFreq = null;//              
}

IFODUBoardGroupObj.prototype.setNEid = function(/*int*/neid)
{
    this.neId = neid;
}
IFODUBoardGroupObj.prototype.getNEid = function()
{
    return this.neId;
}

