
var mtable;

var atpcAtom_src;
var atpcAtom_snk;
var txpowerAtom_src;
var txpowerAtom_snk;
var rxpowerAtom_src;
var rxpowerAtom_snk;
var maxtxpowerAtom_src;
var maxtxpowerAtom_snk;
var txfreqencyAtom_src;
var txfreqencyAtom_snk;
var rxfreqencyAtom_src;
var rxfreqencyAtom_snk;
var ifBandwidthAtom_src;
var ifBandwidthAtom_snk;
var currentModulationAtom_src;
var currentModulationAtom_snk;
var availableBandwdithAtom_src;
var availableBandwdithAtom_snk;

var QUERY_STATUS_TIME_INTERVAL = 5000;

var m_localNeInforStruct = null;
var m_remoteNeInforStruct = null;

window.onload = function()
{
	initTable();
	
	$("querybtn").value = RESOURCE["querybutton"];
	
	setInterval("queryBothNEsLinkStatus(true)", QUERY_STATUS_TIME_INTERVAL);
}

function initTable()
{
	mtable = new MTable();

	/*     TableHead */
	mtable.addHead("", RESOURCE["SOURCE_NE"], RESOURCE["SINK_NE"]);

	
	/*        ATPC start */
	atpcAtom_src = new Atom("select");
	atpcAtom_src.addOption("-", "-1");
	atpcAtom_src.addOption(RESOURCE["disabled"], "0");
	atpcAtom_src.addOption(RESOURCE["enabled"], "1");
	
	atpcAtom_snk = new Atom("select");
	atpcAtom_snk.addOption("-", "-1");
	atpcAtom_snk.addOption(RESOURCE["disabled"], "0");
	atpcAtom_snk.addOption(RESOURCE["enabled"], "1");
	
	mtable.addAttrRow("atpc", RESOURCE["atpc"], atpcAtom_src, atpcAtom_snk);
	/*        ATPC end */

	
	/*       TX Power start */
	txpowerAtom_src = new Atom("text");
	txpowerAtom_src.setValue("-");
	txpowerAtom_snk = new Atom("text");
	txpowerAtom_snk.setValue("-");
	
	mtable.addAttrRow("txpower", RESOURCE["sendpwtx"], txpowerAtom_src, txpowerAtom_snk);
	/*       TX Power end */
	
	
	/*       RX Power start */
	rxpowerAtom_src = new Atom("text");
	rxpowerAtom_src.setValue("-");
	rxpowerAtom_snk = new Atom("text");
	rxpowerAtom_snk.setValue("-");
	
	mtable.addAttrRow("rxpower", RESOURCE["rxpwtx"], rxpowerAtom_src, rxpowerAtom_snk);
	/*       RX Power end */
	
	
	/*       Max RX Power start */
	maxtxpowerAtom_src = new Atom("text");
	maxtxpowerAtom_src.setValue("-");
	maxtxpowerAtom_snk = new Atom("text");
	maxtxpowerAtom_snk.setValue("-");

	mtable.addAttrRow("maxrxpower", RESOURCE["maxrxpwtx"], maxtxpowerAtom_src, maxtxpowerAtom_snk);
	/*       Max RX Power end */	

	
	/*       TX Frequency start */
	txfreqencyAtom_src = new Atom("text");
	txfreqencyAtom_src.setValue("-");
	txfreqencyAtom_snk = new Atom("text");
	txfreqencyAtom_snk.setValue("-");

	mtable.addAttrRow("txfrequency", RESOURCE["sendfretx"], txfreqencyAtom_src, txfreqencyAtom_snk);
	/*       TX Frequency end */
	
	
	/*       RX Frequency start */
	rxfreqencyAtom_src = new Atom("text");
	rxfreqencyAtom_src.setValue("-");
	rxfreqencyAtom_snk = new Atom("text");
	rxfreqencyAtom_snk.setValue("-");

	mtable.addAttrRow("rxfrequency", RESOURCE["rxfrespan"], rxfreqencyAtom_src, rxfreqencyAtom_snk);
	/*       RX Frequency end */
	
	
	/*       IF Channel Bandwidth start */
	ifBandwidthAtom_src = new Atom("select");
	addIFBandWidthOptions(ifBandwidthAtom_src);

	ifBandwidthAtom_snk = new Atom("select");
	addIFBandWidthOptions(ifBandwidthAtom_snk);

	mtable.addAttrRow("ifbandwidth", RESOURCE["bandwidth"], ifBandwidthAtom_src, ifBandwidthAtom_snk);
	/*       IF Channel Bandwidth end */
	
	
	/*       Current Modulation start */
	currentModulationAtom_src = new Atom("select");
	addModulationOptions(currentModulationAtom_src);
	
	currentModulationAtom_snk = new Atom("select");
	addModulationOptions(currentModulationAtom_snk);

	mtable.addAttrRow("currentmodulation", RESOURCE["currentmodulation"], currentModulationAtom_src, currentModulationAtom_snk);
	/*       Current Modulation end */

	
	/*       Available Bandwidth start */
	availableBandwdithAtom_src = new Atom("text");
	availableBandwdithAtom_src.setValue("-");
	availableBandwdithAtom_snk = new Atom("text");
	availableBandwdithAtom_snk.setValue("-");

	mtable.addAttrRow("availablebandwidth", RESOURCE["availablebandwidth"], availableBandwdithAtom_src, availableBandwdithAtom_snk);
	/*       Available Bandwidth end */
	
	/*   Atom         start */
	setAllAtomsDefaultStatus();
	/*   Atom         end */
	
	document.getElementById("tablecontainer").appendChild(mtable.getTable());
}

/**
 *       
 * @return
 */
function refreshRadioLinkStatus(localNeInforStruct, remoteNeInforStruct)
{
	/*	//demo         
	var neInforStruct = new NeInforStruct();
	neInforStruct.init(parent.winurlobj.neid, 4, 24, true);
	var neInforStruct2 = new NeInforStruct();
	neInforStruct2.init(21, 1, 51, false);*/
	
	m_localNeInforStruct = localNeInforStruct;
	m_remoteNeInforStruct = remoteNeInforStruct;
	
	queryBothNEsLinkStatus();
}

/**
 *           
 * @return
 */
function queryBothNEsLinkStatus(flag)
{
	if( parent.st0 && parent.st0.getSelectedRowCount() == 0 )
	{
		clearTableData();
		return;
	}
	
	if( m_localNeInforStruct != null )
	{
		queryRadioLinkStatus(m_localNeInforStruct, flag);
	}
	
	if( m_remoteNeInforStruct != null )
	{
		queryRadioLinkStatus(m_remoteNeInforStruct, flag);
	}
}

/**
 *       
 * @return
 */
function clearTableData()
{
	atpcAtom_src.setValue("-");
	atpcAtom_snk.setValue("-");
	txpowerAtom_src.setValue("-");
	txpowerAtom_snk.setValue("-");
	rxpowerAtom_src.setValue("-");
	rxpowerAtom_snk.setValue("-");
	maxtxpowerAtom_src.setValue("-");
	maxtxpowerAtom_snk.setValue("-");
	txfreqencyAtom_src.setValue("-");
	txfreqencyAtom_snk.setValue("-");
	rxfreqencyAtom_src.setValue("-");
	rxfreqencyAtom_snk.setValue("-");
	ifBandwidthAtom_src.setValue("-");
	ifBandwidthAtom_snk.setValue("-");
	currentModulationAtom_src.setValue("-");
	currentModulationAtom_snk.setValue("-");
	availableBandwdithAtom_src.setValue("-");
	availableBandwdithAtom_snk.setValue("-");
}

/**
 *     Atom        
 * @return
 */
function setAllAtomsDefaultStatus()
{
	setAtomDefaultStatus(atpcAtom_src);
	setAtomDefaultStatus(atpcAtom_snk);
	setAtomDefaultStatus(txpowerAtom_src);
	setAtomDefaultStatus(txpowerAtom_snk);
	setAtomDefaultStatus(rxpowerAtom_src);
	setAtomDefaultStatus(rxpowerAtom_snk);
	setAtomDefaultStatus(maxtxpowerAtom_src);
	setAtomDefaultStatus(maxtxpowerAtom_snk);
	setAtomDefaultStatus(txfreqencyAtom_src);
	setAtomDefaultStatus(txfreqencyAtom_snk);
	setAtomDefaultStatus(rxfreqencyAtom_src);
	setAtomDefaultStatus(rxfreqencyAtom_snk);
	setAtomDefaultStatus(ifBandwidthAtom_src);
	setAtomDefaultStatus(ifBandwidthAtom_snk);
	setAtomDefaultStatus(currentModulationAtom_src);
	setAtomDefaultStatus(currentModulationAtom_snk);
	setAtomDefaultStatus(availableBandwdithAtom_src);
	setAtomDefaultStatus(availableBandwdithAtom_snk);
}


function queryRadioLinkStatus(neInforStruct, flag)
{	
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_LINKSTATUS + "&nmUser="+ parent.nmUser;

	var xmlstr = createQueryRadioLinkStatusXML(neInforStruct, flag);
	
	loadXMLdoc(urlreq, "POST", true, queryRadioLinkStatusXMLCallback, neInforStruct, "inputdata=" + xmlstr);	
}

/**
 *     XML
 * @return
 */
function createQueryRadioLinkStatusXML(neInforStruct ,flag)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null; 

    row = new tagElement("row-params");
    if(flag)
    {
        addParam(row, "isLogFlag", "0");
    }
    addParam(row, "neid", neInforStruct.getNEID() );
    addParam(row, "slotid", neInforStruct.getIFSlotID() );
    addParam(row, "port", "1");
    
    bussiness.appendChild(row);

    row = new tagElement("row-params");
    addParam(row, "neid", neInforStruct.getNEID() );
    addParam(row, "slotid", neInforStruct.getODUSlotID() );
    addParam(row, "port", "1");
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);

    return di.toString();
}

/**
 *           
 * @param doc
 * @return
 */
function queryRadioLinkStatusXMLCallback(doc, neInforStruct)
{
	var data = EncapsulateData(doc);

	/*
    if( !(data.getSErrorCode() == OPERATION_SUCCESS || data.getSErrorCode() == OPERATION_PART_SUCCESS) )
    {
    	showErrorDialog(data);
    	return;
    }
    */
	
	var isLocal = neInforStruct.isLocal();
	var colIndex = isLocal ? 0 : 1;						//     index:	0    1   
	var ifSlotID = neInforStruct.getIFSlotID();
	var oduSlotID = neInforStruct.getODUSlotID();
	
	var atom;
	var slotIDVal;
	for( var i = 0; i < data.getDataRowLength(); i++ )
	{
		slotIDVal = data.getDataRowParam(i, "slotid");

		if( slotIDVal == ifSlotID )
		{
			var atpcEnableVal = data.getDataRowParam(i, "W32PORT_ATTR_ATPCENABLE");
			atom = mtable.getAtom("atpc",colIndex);
			atom.setValue(atpcEnableVal);
			
			var channelSpaceVal = data.getDataRowParam(i, "W32PORT_ATTR_CHANNELSPACE");
			atom = mtable.getAtom("ifbandwidth",colIndex);
			atom.setValue( isDataInBusinessValid(channelSpaceVal)?channelSpaceVal:-1 );
			
			var curModulationVal = data.getDataRowParam(i, "W32PORT_ATTR_SENDMODID");
			atom = mtable.getAtom("currentmodulation",colIndex);
			atom.setValue( isDataInBusinessValid(curModulationVal)?curModulationVal:-1 );
			
			var availCapacityVal = data.getDataRowParam(i, "capacity");
			atom = mtable.getAtom("availablebandwidth",colIndex);
			atom.setValue( isDataInBusinessValid(channelSpaceVal) && isDataInBusinessValid(curModulationVal) ? availCapacityVal : "-" );
		}
		
		if( slotIDVal == oduSlotID )
		{
			var txPowerVal = replaceInvalidValue(data.getDataRowParam(i, "W32BRD_ATTR_TRANSMITPOWER"));
			atom = mtable.getAtom("txpower",colIndex);
			atom.setValue(txPowerVal);
			
			var rxPowerVal = replaceInvalidValue(data.getDataRowParam(i, "W32BRD_ATTR_ACTRECEIVEPOWER"));
			atom = mtable.getAtom("rxpower",colIndex);
			atom.setValue(rxPowerVal);

			var rxMaxPowerVal = replaceInvalidValue(mtable.getAtom("maxrxpower",colIndex).getValue());
			
			if( isDataInBusinessValid(rxMaxPowerVal) )	//                
			{
				if( isDataInBusinessValid(rxPowerVal) )
				{
					if( parseFloat(rxPowerVal) > parseFloat(rxMaxPowerVal) )
					{
						mtable.getAtom("maxrxpower",colIndex).setValue(rxPowerVal);
					}
				}
			}
			else		//                         
			{
				mtable.getAtom("maxrxpower",colIndex).setValue(rxPowerVal);
			}
			
			var rxFreVal = replaceInvalidValue(data.getDataRowParam(i, "W32BRD_ATTR_TRANSMITFRE"));
			atom = mtable.getAtom("txfrequency",colIndex);
			atom.setValue(rxFreVal);			

			var rxFreVal = replaceInvalidValue(data.getDataRowParam(i, "W32BRD_ATTR_ACTTRECEIVEFRE"));
			atom = mtable.getAtom("rxfrequency",colIndex);
			atom.setValue(rxFreVal);
		}
	}
}

/**
 *        
 * @param isdisabledflag
 * @return
 */
function setbuttonstatus(isdisabledflag)
{
	$("querybtn").disabled = isdisabledflag;
}
