var queryParam;
var winurlobj = getNeProperty(self);

var CELL_ALARMEXIST_BGCOLOR = "#ff1919";
var CELL_ALARMNOTEXIST_BGCOLOR = "#00ff00";
var CELL_LINKNOTEXIST_BGCOLOR = "#dddddd";

var tab;
var st0;

var NETYPE_RTN980 = 83;

var QUERY_RADIOLINK_TIME_INTERVAL = 60000;

/*
 Get neid from url param
 */
function getNeID()
{
    return queryParam["neid"];
}

/*
 Get neid from url param
 */
window.onload = function()
{
    queryParam = getNeProperty(top);
    setButtonText();
    createTable();
    initTabPanel();
    
    setTimeout(refreshTable, 2000);
    
    setInterval("refreshTable(true)", QUERY_RADIOLINK_TIME_INTERVAL);
}

/*
 set button and title text
 */
function setButtonText()
{   
	$("radiolinkconfbtn").value = RESOURCE["radiolinkconfbtn"];
	$("radiolinkconfbtn").style.width = "180px";    
}

function tableSelectHandler(rows)
{
	return;
}

/**
 * table selection change
 */
function rowSelected(rows)
{
	if( rows[0] == null )
	{
		$("radiolinkconfbtn").disabled = true;
		
		this.frames[0].refreshRadioLinkStatus(null, null);	//                            
		this.frames[0].clearTableData();					//    
		return;
	}
	
	$("radiolinkconfbtn").disabled = false;
	
	var localNeInforStruct = new NeInforStruct();
	var localIFSlotID = st0.getCellStoreValue(rows[0], "SRC_SLOTID", "SRC_SLOTID");
	var localODUSlotID = winurlobj.neType == NETYPE_RTN980 ?
			(parseInt(localIFSlotID)+50) : (parseInt(localIFSlotID)+20);
	localNeInforStruct.init(winurlobj.neid, localIFSlotID, localODUSlotID, true);
	
	var remoteNeInforStruct = null;
	var remoteLogicID = st0.getCellStoreValue(rows[0], "DES_LOGIC_NE_ID", "DES_LOGIC_NE_ID");
	var remoteIFSlotID = st0.getCellStoreValue(rows[0], "DES_SLOTID", "DES_SLOTID");
	var remoteNeType = st0.getCellStoreValue(rows[0], "DES_NE_TYPE", "DES_NE_TYPE");
	
	if( isDataInBusinessValid(remoteLogicID) && 
		isDataInBusinessValid(remoteIFSlotID) &&
		isDataInBusinessValid(remoteNeType)		)
	{
		var remoteODUSlotID = remoteNeType == NETYPE_RTN980 ?
				(parseInt(remoteIFSlotID)+50) : (parseInt(remoteIFSlotID)+20);
		remoteNeInforStruct = new NeInforStruct();
		remoteNeInforStruct.init(remoteLogicID, remoteIFSlotID, remoteODUSlotID, false);
	}
	
	this.frames[0].refreshRadioLinkStatus(localNeInforStruct, remoteNeInforStruct);
}

function clearTable()
{
    for (var i = 0; i < st0.getDataRowLength(); ++i) 
    {
        st0.deleteRow(i);
    }
    st0.adjustDataRows();
}

/*
 create ecc link table
 */
function createTable()
{
    st0 = new SortTable();
    st0.setImage("../../../../images/");
    st0.setOnRowSelectHandler(rowSelected);
    createTableHead(st0, window.tableconf[0]);
    $("tablecontainer").appendChild(st0.getTable());
    st0.setBodyHeight(getComponetHeight($("tablecontainer"), 350)+"px");
    st0.setSingleChoiceFlg(true);
}

/*
 refresh table data
 */
function refreshTable(flag)
{
    var xml = createRequestData(flag);
    if (null == xml) 
    {
        return;
    }

    $("radiolinkconfbtn").disabled = true;
    this.frames[0].setbuttonstatus(true);
    this.frames[0].refreshRadioLinkStatus(null, null);	//                            
    
    clearTable();
    this.frames[0].clearTableData();
    
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_RADIOLINK_WITHALARM + "&flag=1&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshTableCallBack, null, "inputdata=" + xml);
}

/*
 create request data
 */
function createRequestData(flag)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    if(flag)
    {
        addParam(row, "isLogFlag", "0");
    }
        
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    var neid = getNeID();
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/*
 Handler response data,construct table data
 */
function refreshTableCallBack(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    createTableBody(st0, window.tableconf[0], dinterface, RESOURCE);
    
    for( var i = 0; i < st0.getDataRowLength(); i++ )
    {
    	var isAlarmExist = st0.getCellStoreValue(i, "isAlarmExist", "isAlarmExist");
    	var isAlarmExistCell = st0.getCell(i, "isAlarmExist");
    	st0.getCellShow(i, "isAlarmExist").setValue("");

    	if( isAlarmExist == 0 )
    	{
    		isAlarmExistCell.element.style.backgroundColor = CELL_ALARMNOTEXIST_BGCOLOR;
    	}
    	else if( isAlarmExist == 1 )
    	{
    		isAlarmExistCell.element.style.backgroundColor = CELL_ALARMEXIST_BGCOLOR;
    	}
    	else		//-1
    	{
    		isAlarmExistCell.element.style.backgroundColor = CELL_LINKNOTEXIST_BGCOLOR;	
    	}
    }
    
    this.frames[0].setbuttonstatus(false);
}


/**
 *        tab  
 * @return
 */
function initTabPanel()
{
	tab = new Tabs();
	tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
	tab.addTab("radiolinkstatus", RESOURCE["radiolinkstatus"], "radiolinkstatus.html");
	
	setTabsHeight(tab, "270px");
	$("radiolinkstab").appendChild(tab.getTabs());
	tab.selectTab("radiolinkstatus");
}

function setTabsHeight(tab, tabodyheight)
{
    for(var key in tab.tabNodes)
    {
        tab.tabNodes[key].body.style.height = tabodyheight;
    }
}

/**
 *          
 * @return
 */
function gotoLinkConfiguration()
{
	if( st0.getSelectedRowCount() == 0 )
	{
		return;
	}
	
	parent.Tab.selectTab("49221");
	
	var localIFSlotID = st0.getCellStoreValue( st0.getSelectedRows()[0], "SRC_SLOTID", "SRC_SLOTID" );
	
	if( parent.Tab.getTabWindow("49221") != null )
	{
		var ifoduselectElement = parent.Tab.getTabWindow("49221").
			terminalStruct.LocalEnd.ifBdSelectModule.getIFODUBoardSelectElement();
		
		for(var i = 0,len = ifoduselectElement.options.length;i < len;i++)
		{
		  var ifoduObj = JSON.parse(ifoduselectElement.options[i].value);
		  if(ifoduObj != null && ifoduObj.ifSlotId == localIFSlotID)
		  {
		      ifoduselectElement.selectedIndex = i;
		      break;
		  }
		}
		
		if( ifoduselectElement != null )
		{
			ifoduselectElement.onchange();
		}
	}
}
