
var bandWidthStru = new Object();
bandWidthStru.FREQ_7MHz = "7MHz";
bandWidthStru.FREQ_14MHz = "14MHz";
bandWidthStru.FREQ_28MHz = "28MHz";
bandWidthStru.FREQ_40MHz = "40MHz";
bandWidthStru.FREQ_56MHz = "56MHz";
bandWidthStru.FREQ_30MHz_NA = "30MHz";	//For NA
bandWidthStru.FREQ_40MHz_NA = "40MHz";	//For NA
bandWidthStru.FREQ_50MHz_NA = "50MHz";	//For NA
bandWidthStru.FREQ_7MHz_VAL = 2;
bandWidthStru.FREQ_14MHz_VAL = 3;
bandWidthStru.FREQ_28MHz_VAL = 4;
bandWidthStru.FREQ_40MHz_VAL = 5;
bandWidthStru.FREQ_56MHz_VAL = 6;
bandWidthStru.FREQ_30MHz_VAL_NA = 7;	//For NA
bandWidthStru.FREQ_40MHz_VAL_NA = 8;	//For NA
bandWidthStru.FREQ_50MHz_VAL_NA = 9;	//For NA

var ensureCalModeStru = new Object();
ensureCalModeStru.MODE_QPSK = "QPSK";
ensureCalModeStru.MODE_16QAM = "16QAM";
ensureCalModeStru.MODE_32QAM = "32QAM";
ensureCalModeStru.MODE_64QAM = "64QAM";
ensureCalModeStru.MODE_128QAM = "128QAM";
ensureCalModeStru.MODE_256QAM = "256QAM";
ensureCalModeStru.MODE_QPSK_VAL = 1;
ensureCalModeStru.MODE_16QAM_VAL = 2;
ensureCalModeStru.MODE_32QAM_VAL = 3;
ensureCalModeStru.MODE_64QAM_VAL = 4;
ensureCalModeStru.MODE_128QAM_VAL = 5;
ensureCalModeStru.MODE_256QAM_VAL = 6;


function NeInforStruct()
{
	var _this = this;
	
	this._islocal = true;
	
	this._neid = -1;
	
	this._ifslotid = -1;
	
	this._oduslotid = -1;
	
	this.init = function(t_neid, t_ifslotid, t_oduslotid, t_isLocal)
	{
		_this._islocal = t_isLocal;
		
		_this._neid = t_neid;
		
		_this._ifslotid = t_ifslotid;
		
		_this._oduslotid = t_oduslotid;
	}

	this.isLocal = function()
	{
		return _this._islocal;
	}
	
	this.getNEID = function()
	{
		return _this._neid;
	}
	
	this.getIFSlotID = function()
	{
		return _this._ifslotid;
	}
	
	this.getODUSlotID = function()
	{
		return _this._oduslotid;
	}
}

/**
 *     
 * @param row
 * @param attriName
 * @param attriVal
 * @return
 */
function addParam(row, attriName, attriVal)
{
    var param = new tagElement("param");
    param.setAttribute("name", attriName);
    param.setAttribute("value", attriVal );
    row.appendChild(param);
}


/**
 *              
 * @param atom
 * @return
 */
function addIFBandWidthOptions(atom)
{
	atom.addOption("-", "-1");
	atom.addOption(bandWidthStru.FREQ_7MHz, bandWidthStru.FREQ_7MHz_VAL);
	atom.addOption(bandWidthStru.FREQ_14MHz, bandWidthStru.FREQ_14MHz_VAL);
	atom.addOption(bandWidthStru.FREQ_28MHz, bandWidthStru.FREQ_28MHz_VAL);
	atom.addOption(bandWidthStru.FREQ_40MHz, bandWidthStru.FREQ_40MHz_VAL);
	atom.addOption(bandWidthStru.FREQ_40MHz, bandWidthStru.FREQ_40MHz_VAL);
	atom.addOption(bandWidthStru.FREQ_56MHz, bandWidthStru.FREQ_56MHz_VAL);
	atom.addOption(bandWidthStru.FREQ_30MHz_NA, bandWidthStru.FREQ_30MHz_VAL_NA);
	atom.addOption(bandWidthStru.FREQ_40MHz_NA, bandWidthStru.FREQ_40MHz_VAL_NA);
	atom.addOption(bandWidthStru.FREQ_50MHz_NA, bandWidthStru.FREQ_50MHz_VAL_NA);	
}

/**
 *               
 * @param atom
 * @return
 */
function addModulationOptions(atom)
{
	atom.addOption("-", "-1");
	atom.addOption(ensureCalModeStru.MODE_QPSK, ensureCalModeStru.MODE_QPSK_VAL);
	atom.addOption(ensureCalModeStru.MODE_16QAM, ensureCalModeStru.MODE_16QAM_VAL);
	atom.addOption(ensureCalModeStru.MODE_32QAM, ensureCalModeStru.MODE_32QAM_VAL);
	atom.addOption(ensureCalModeStru.MODE_64QAM, ensureCalModeStru.MODE_64QAM_VAL);
	atom.addOption(ensureCalModeStru.MODE_128QAM, ensureCalModeStru.MODE_128QAM_VAL);
	atom.addOption(ensureCalModeStru.MODE_256QAM, ensureCalModeStru.MODE_256QAM_VAL);
}

/**
 *   Atom        
 * @param atom
 * @return
 */
function setAtomDefaultStatus(atom)
{
	atom.element.style.width="100%";
	atom.element.disabled=true;
}

/**
 *     
 */
function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
}

/**
 *         
 * @param val
 * @return
 */
function isDataInBusinessValid(val)
{
	if( val == null || val == "" || val == "undefined" || val == "-1" || val == "-" || val == "/" )
	{
		return false; 
	}
	else
	{
		return true;
	}
}

/**
 *   
 * @param val
 * @return
 */
function replaceInvalidValue(val)
{
	if( val == "-1" )
	{
		return "-";
	}
	else
	{
		return val;
	}
}
