var queryParam;
var winurlobj = getNeProperty(self);
var portRes = null;   //      PLA/EPLA      
var ifPortRes = null; //     PLA/EPLA       
var servicePortRes = null; //     PLA/EPLA     /     

var BOARD_TYPE_RESOURCE = 1;
var PORT_TYPE_RESOURCE = 2;
var TE_PTN_NE = 16;

var convertCascadetype = new Object();
convertCascadetype[0] = RESOURCE["cascadetype0"];
convertCascadetype[1] = RESOURCE["cascadetype1"];

var convertGgrouptype = new Object();
convertGgrouptype[0] = "PLA";
convertGgrouptype[1] = "EPLA";

var convertProtectType = new Object();
convertProtectType[0] = RESOURCE["noprotect"];

var convertNEStatus = new Object();
convertNEStatus[0] = RESOURCE["slaveneport"];
convertNEStatus[1] = RESOURCE["mainneport"];

var convertWorkStatus = new Object();
convertWorkStatus[0] = RESOURCE["slaveneport"];
convertWorkStatus[1] = RESOURCE["mainneport"];
convertWorkStatus[255] = RESOURCE["unknown"];

var convertPortStatus = new Object();
convertPortStatus[0] = RESOURCE["portstatus0"];
convertPortStatus[1] = RESOURCE["portstatus1"];
convertPortStatus[255] = RESOURCE["unknown"];

var convertStatus  = new Object();
convertStatus[0] = RESOURCE["normal"];
convertStatus[1] = RESOURCE["abnormal"];
convertStatus[255] = RESOURCE["unknown"];

var convertBelongne  = new Object();
convertBelongne[0] = RESOURCE["blongne0"];
convertBelongne[1] = RESOURCE["blongne1"];

var btnRightArr = new Object();

var st0;
var slavest;

function getNeID()
{
    return queryParam["neid"];
}

function setButtonStatus(btnStatus)
{
    $("querybtn").disabled = !btnStatus;
}

/*
 Get neid from url param
 */
window.onload = function()
{
    queryParam = getNeProperty(top);
    setButtonText();
    createTable();
    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_RTN_QUERY_PLA_GROUP);    
    btnRightArr.createbtn = new BtnRightObj("createbtn",TECMDCODE_RTN_ADD_PLA_GROUP);   
    btnRightArr.deletebtn = new BtnRightObj("deletebtn",TECMDCODE_RTN_DEL_PLA_GROUP);
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_RTN_MODIFY_PLA_MINUPLINKTH);
    
    getRightInfo(winurlobj,btnRightArr);
    
    initrightbtn(btnRightArr);
    
    if ($("querybtn").disabled == false) 
    {
        refreshTable();
    }
}

function initBtnStatus()
{
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("createbtn").disabled = !btnRightArr.createbtn.right;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
}

/*
 set button and title text
 */
function setButtonText()
{
    $("title").innerHTML = RESOURCE["oppositenelist"];
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("createbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function tableSelectHandler(rows)
{
	
}

/**
 * table selection change
 */
function rowSelected(rows)
{
	if (st0.getSelectedRows().length > 0)
	{
		querySlavePortInfo(st0.getSelectedRows()[0]);
		$("deletebtn").disabled = !btnRightArr.createbtn.right;
	}
	else
	{
		slavest.clearTableData();
		$("deletebtn").disabled = true;
	}
}

function querySlavePortInfo(rowIndex)
{
	if (st0.getCellStoreValue(rowIndex, "nestatus", "nestatus") == "0")
	{
		return;
	}
	var xml = createQuerySlavePortInfo(rowIndex);
    if (null == xml) 
    {
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_PLA_SLAVEPORTINFO_NEW + "&flag=1&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshSlaveTableCallBack, null, "inputdata=" + xml);
}

function createQuerySlavePortInfo(rowIndex)
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    var neid = getNeID();
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var ggroupid = st0.getCellStoreValue(rowIndex, "ggroupid", "ggroupid");
    param = new tagElement("param");
    param.setAttribute("name", "ggroupid");
    param.setAttribute("value", ggroupid);
    row.appendChild(param);
    
    var cascadetype = st0.getCellStoreValue(rowIndex, "cascadetype", "cascadetype");
    param = new tagElement("param");
    param.setAttribute("name", "cascadetype");
    param.setAttribute("value", cascadetype);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function refreshSlaveTableCallBack(doc)
{
	var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    slavest.clearTableData();
    createTableBody(slavest, window.tableconf[1], dinterface, RESOURCE);
}

/*
 create ecc link table
 */
function createTable()
{
    st0 = new SortTable();
    st0.setImage("../../../../images/");
    st0.setOnRowSelectHandler(rowSelected);
    st0.setOnCellEditHandler(cellEditHandler);
    createTableHead(st0, window.tableconf[0]);
    $("tablecontainer").appendChild(st0.getTable());
    st0.setBodyHeight("200px");
    $("tablecontainer").oncontextmenu = popupMenuHandler;
    
    slavest = new SortTable();
    slavest.setImage("../../../../images/");
    createTableHead(slavest, window.tableconf[1]);
    $("slaveTablecontainer").appendChild(slavest.getTable());
    slavest.setBodyHeight("200px");
}

function cellEditHandler(param)
{
	if (btnRightArr.applybtn.right)
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

function modifyLAG()
{
	$("querybtn").disabled = true;
	$("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xmlstr = createModifyLAGXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_MODIFY_PLA_MINUPLINKTH + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, modifyLAGCallback, null,
			"inputdata=" + xmlstr);
}

function modifyLAGCallback(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    
    initBtnStatus();
    
    var selectrows = st0.getSelectedRows();
    
    if (selectrows.length > 0)
    {
    	rowSelected(st0.getRow(selectrows[0]).element);
    }
    
    if (dinterface.getSErrorCode() != 0) 
    {
    	$("applybtn").disabled = false;
    }
    
    refreshTableState(st0, window.tableconf[0], dinterface);
}

function createModifyLAGXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var param = null;
	var row = null;
	
	for (var i = 0; i < st0.getDataRowLength(); i++)
	{
		if (!st0.getModify(i))
		{
			continue;
		}
		
		row = new tagElement("row-params");
		
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", getNeID());
		row.appendChild(param);
		
		var lagid = st0.getCellStoreValue(i, "ggroupid", "ggroupid");
		param = new tagElement("param");
		param.setAttribute("name", "ggroupid");
		param.setAttribute("value", lagid);
		row.appendChild(param);
		
		var minUpLinkTH = st0.getCellStoreValue(i, "minUpLinkTH", "minUpLinkTH");
		param = new tagElement("param");
		param.setAttribute("name", "minUpLinkTH");
		param.setAttribute("value", minUpLinkTH);
		row.appendChild(param);
	
		bussiness.appendChild(row);
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/*
 refresh table data
 */
function refreshTable()
{
	$("querybtn").disabled = true;
	$("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
	
    var xml = createRequestData();
    if (null == xml) 
    {
    	initBtnStatus();
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_PLA_GROUP + "&flag=1&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshTableCallBack, null, "inputdata=" + xml);
}

/*
 create request data
 */
function createRequestData()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    var neid = getNeID();
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/*
 Handler response data,construct table data
 */
function refreshTableCallBack(doc)
{
	var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    
    if (dinterface.getSErrorCode() != 2) 
    {
    	st0.clearTableData();
	    slavest.clearTableData();
	    createTableBody(st0, window.tableconf[0], dinterface, RESOURCE);
	    for ( var i = 0, len = st0.getDataRowLength(); i < len; i++)
		{
	    	var minUpLinkTH = st0.getCellStoreValue(i, "minUpLinkTH", "minUpLinkTH");
			 if(minUpLinkTH == "-")
			 {
				 st0.setCellIsEdit(st0.getCell(i, "minUpLinkTH"), 0);
				 st0.getCellElement(i, "minUpLinkTH").ondblclick = null;
			 }
		}		 
    }
    
    initBtnStatus();
    
    if (st0.getDataRowLength() > 0)
    {
    	st0.setRowSelect(0);
    	rowSelected(st0.getRow(0).element);
    }
}


function deleteLAG()
{
	var selectrows = st0.getSelectedRows();
	var alertFlag = false;
	for (var i = 0; i < selectrows.length; i++)
	{
		if(st0.getCellStoreValue(selectrows[i], "ggrouptype", "ggrouptype") == 0)
		{
			alertFlag = true;
			break;
		}	
	}
	
	if (alertFlag)
	{
	}
	else
	{
		if(!confirm(RESOURCE["SERICE_DELETE_WARN"]))
		{
			return;
		}
		
	}
	
	var xmlstr = createDeleteLAGXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_DEL_PLA_GROUP + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, deleteLAGCallback, null,
			"inputdata=" + xmlstr);
}

function createDeleteLAGXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var param = null;
	var row = null;
	
	var selectrows = st0.getSelectedRows();
	
	for (var i = 0; i < selectrows.length; i++)
	{
		row = new tagElement("row-params");
		
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", getNeID());
		row.appendChild(param);
		
		var lagid = st0.getCellStoreValue(selectrows[i], "ggroupid", "ggroupid");
		param = new tagElement("param");
		param.setAttribute("name", "ggroupid");
		param.setAttribute("value", lagid);
		row.appendChild(param);
	
		bussiness.appendChild(row);
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function deleteLAGCallback(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    
    if (dinterface.getSErrorCode() != 2)
    {
    	refreshTable();
    }
}

function getAvailableResourceInfo()
{
	var xmlstr = createGetAvailableResXML();
	var urlreq = "../../../../neExlorerServlet?sfid=900123&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshAvailableRes, null,
			"inputdata=" + xmlstr);

}

function createGetAvailableResXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeID());
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();

}

function refreshAvailableRes(doc)
{
	portRes = new Array();
    
    var portObj = null;
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        portObj = new Object();
        portObj.slotId = data.getDataRowParam(i, "slotid");
        portObj.boardName = data.getDataRowParam(i, "boardname");
        portObj.portId = data.getDataRowParam(i, "portid");
        portObj.portName = data.getDataRowParam(i, "portname");
        
        portRes[portRes.length] = portObj;
    }
}

function createPLA()
{
	hideMenu();
	getAvailableResourceInfo(); //         
	getIFAvailableResourceInfo();  //           
	getServiceAvailableResourceInfo();  //         /     
	filterUsedResource();
	
	if (portRes.length <= 0 && ifPortRes <= 0 && servicePortRes <= 0) 
    {
        alert(RESOURCE["noportres"]);
        return;
    }

    xshowModalDialog("createPLA.html", RESOURCE["createTitle"], 540, 700,
			"../../../../images/", false);
}

function getIFAvailableResourceInfo()
{
	var xmlstr = createGetPortAvailableResXML("ATTR_IF_PORT_PLA", PORT_TYPE_RESOURCE, TE_PTN_NE);
 	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_COMMON_FIND_RESURCE + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshGetAvailableRes, "ATTR_IF_PORT_PLA", "inputdata=" + xmlstr);
}

function getServiceAvailableResourceInfo()
{
	var xmlstr = createGetPortAvailableResXML("ATTR_SERVICE_PORT_PLA", PORT_TYPE_RESOURCE, TE_PTN_NE);
 	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_COMMON_FIND_RESURCE + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshGetAvailableRes, "ATTR_SERVICE_PORT_PLA", "inputdata=" + xmlstr);
}

function filterUsedResource()
{
	for (var i = 0, len = st0.getDataRowLength(); i < len; i++)
	{
		var ifslotidc = st0.getCellStoreValue(i, "mainslotid", "mainslotid");
		var ifportidc = st0.getCellStoreValue(i, "mainportid", "mainportid");
		var conslotidc = st0.getCellStoreValue(i, "conslotid", "conslotid");
		var conportidc = st0.getCellStoreValue(i, "conportid", "conportid");
		var serviceslotidc = slavest.getCellStoreValue(i, "slotids", "slotids");
		var serviceportidc = slavest.getCellStoreValue(i, "portids", "portids");
		
		for (var j = ifPortRes.length - 1; j >= 0; j--)
		{
			var portObj = ifPortRes[j];
			if (portObj.slotId == ifslotidc && portObj.portId == ifportidc)
			{
				ifPortRes.removeAt(j);
			}
		}
		
		for (var k = servicePortRes.length - 1; k >= 0; k--)
		{
			var portObj = servicePortRes[k];
			var serviceres = portObj.slotId + "-" + portObj.portId
			if ((portObj.slotId == serviceslotidc && portObj.portId == serviceportidc) 
					|| (portObj.slotId == conslotidc && portObj.portId == conportidc))
			{
				servicePortRes.removeAt(k);
			}
		}
	}
}

/**
 *        XML
 * @param {Object} supportAttrName
 * @param {Object} resourceType
 */
function createGetPortAvailableResXML(supportAttrName, resourceType, funDomainType)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeID());
	row.appendChild(param);
	
	var param = new tagElement("param");
	param.setAttribute("name", "supportAttrName");
	param.setAttribute("value", supportAttrName);
	row.appendChild(param);
	
	var param = new tagElement("param");
	param.setAttribute("name", "resourceType");
	param.setAttribute("value", resourceType);
	row.appendChild(param);
	
	var param = new tagElement("param");
	param.setAttribute("name", "funDomainType");
	param.setAttribute("value", funDomainType);
	row.appendChild(param);
	   
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	
	return di.toString();
}

function refreshGetAvailableRes(doc, portType)
{
	if (portType == "ATTR_IF_PORT_PLA")
	{
		ifPortRes = new Array();
	    
	    var portObj = null;
	    var data = EncapsulateData(doc);
	    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
	    {
	        portObj = new Object();
	        portObj.slotId = data.getDataRowParam(i, "slotId");
	        portObj.portId = data.getDataRowParam(i, "portId");
	        portObj.portName = data.getDataRowParam(i, "portname");
	        
	        ifPortRes[ifPortRes.length] = portObj;
	    }
	}
	else
	{
		servicePortRes = new Array();
	    
	    var portObj = null;
	    var data = EncapsulateData(doc);
	    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
	    {
	        portObj = new Object();
	        portObj.slotId = data.getDataRowParam(i, "slotId");
	        portObj.portId = data.getDataRowParam(i, "portId");
	        portObj.portName = data.getDataRowParam(i, "portname");
	        
	        servicePortRes[servicePortRes.length] = portObj;
	    }
	}
}

function popupMenuHandler(evt)
{
	if(SYSTEMCONF.getStatus() != 1)
	{
		return;
	}
	if (!evt)
	{
		evt = window.event;
	}
	var elem = (evt.target) ? evt.target : evt.srcElement;
	if (elem != null && elem.blur)
	{
		elem.blur();
	}
	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}
	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	}
	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if (rows.contains(rowid))
	{
		removejsDOMmenu();
		var cursorMenu1 = new jsDOMenu(180);
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["browsecurrentalm"], "",switchInterFunc, 1,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["browsehistoryalm"], "",switchInterFunc, 2,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["alarmsuppress"], "",switchInterFunc, 3,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["browsepfm"], "",switchInterFunc, 4,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["pfmstatic"], "",switchInterFunc, 5,true));
		setPopUpMenu(cursorMenu1);
		showMenu(evt);
	}
}

function switchInterFunc(funcid)
{
	var xml = createSwitchInterFuncXML(funcid);


	if(xml == null)
	{
		return;
	}
	var urlstr = "../../../../linkInterFuncServlet?neid=" + winurlobj["neid"] + "&prohandler=0&switchtype=7";
	loadXMLdoc(urlstr, "POST", true, switchInterFuncCallback, null, "inputdata="+xml);
}

function switchInterFuncCallback(doc)
{

}

function createSwitchInterFuncXML(funcid)
{
	var rows = st0.getSelectedRows();
	if(rows.length > 0)
	{
			var root = new inputxml("datainterface");
	    var business = new tagElement("bussiness-params");
	    var row = new tagElement("row-params");
	    var param = new tagElement("param","neid",winurlobj["neid"]);
	    row.appendChild(param);
	    param = new tagElement("param","sessionid",winurlobj["sessionid"]);
	    row.appendChild(param);
	    param = new tagElement("param","funcid",funcid);
	    row.appendChild(param);
	    
	    var ggrouptype = st0.getCellStoreValue(rows[0],"ggrouptype","ggrouptype");
	    	var ggroupid = st0.getCellStoreValue(rows[0],"ggroupid","ggroupid");
	    	param = new tagElement("param","grouptype",ggrouptype); 
	    	row.appendChild(param);
	    	param = new tagElement("param","groupid",ggroupid); 
	    	row.appendChild(param);
	    
	    business.appendChild(row);

	  
	    
	    root.getRoot().appendChild(business);
	    return root.toString();
	}
	else
	{
		return null;
	}
}
