
var win = getParentWindow();
var neid = win.getNeID();
var netype = win.winurlobj.neType;
var shelfType = win.winurlobj.shelfType;
var ct = null;
var portRes;
var INVALID_SLOT = 0xFFFF;
var CASCADETYPE_YES = 1; //  
var CASCADETYPE_NO = 0; //   

var selectePorts = null;
var selecteConports = null;

function init()
{
	initBtn();
	initEvent();
	changeCascadeType();
	fillBoard("mainboard");
	fillBoard("slaveboard");
	changeBoard("mainboard", "mainport");
	changeBoard("slaveboard", "slaveport");
	if ($("cascadetype").value == CASCADETYPE_YES)
	{
		fillBoard("conboard");  
		changeBoard("conboard", "conport");
	}
}

function initEvent()
{
	$("ggroupid").value = 1;//     1
	$("ggroupid").disabled = true;
	
	$("mainboard").onchange = function()
	{
		changeBoard("mainboard", "mainport");
	};
	$("conboard").onchange = function()
	{
		changeBoard("conboard", "conport");
	};
	$("slaveboard").onchange = function()
	{
		changeBoard("slaveboard", "slaveport");
	};
	
	$("selectconport").onclick = function()
	{
		conRight();
	};
	$("unselectconport").onclick = function()
	{
		conLeft();
	};
	
	$("selectport").onclick = function()
	{
		if($("mainboard").value == $("slaveboard").value )
		{
			alert(RESOURCE["eplaalert"]);
			return;
		}
		slaveRight();
	};
	$("unselectport").onclick = function()
	{
		slaveLeft();
	};
	
	$("ggrouptype").onchange = function()
	{
	    refreshBoardPort();
	    
		if ($("cascadetype").value == CASCADETYPE_YES)
		{
			fillBoard("conboard");  
			changeBoard("conboard", "conport");
		}
	};
	$("cascadetype").onchange = function()
	{
		changeCascadeType();
	};
}

function refreshBoardPort()
{
	var ops = $("slaveportSelected").options;
    for(var i = 0, len = ops.length; i < len; i++)
    {
        removeObjFromMem(ops[i]);
    }
    $("slaveportSelected").options.length = 0;
    selectePorts = null;   
    var ops = $("conportSelected").options;
    for(var i = 0, len = ops.length; i < len; i++)
    {
        removeObjFromMem(ops[i]);
    }
    $("conportSelected").options.length = 0;
    selecteConports = null;
	var atom = $("mainport");
    atom.options.length = 0;
    atom = $("slaveport");
    atom.options.length = 0;
	fillBoard("mainboard");
	fillBoard("slaveboard");
	changeBoard("mainboard", "mainport");
	changeBoard("slaveboard", "slaveport");
}

function changeCascadeType()
{
	if ($("cascadetype").value == CASCADETYPE_NO)
	{
		$("protecttype").parentNode.parentNode.style.display = "none";
		$("protecttype").style.display = "none";
		$("nestatus").style.display = "none";
		$("conboardset").style.display = "none";
	}
	else
	{
		$("protecttype").parentNode.parentNode.style.display = "";
		$("protecttype").style.display = "";
		$("nestatus").style.display = "";
		$("conboardset").style.display = "";
	}
	
	refreshBoardPort();
	fillBoard("conboard");  
	changeBoard("conboard", "conport");
}

function conRight()
{
	if (selecteConports == null)
	{
		selecteConports = new Array();
	}
	var boardIndex = $("conboard").options.selectedIndex;
	var conboard = $("conboard").value;
	var conboardname = $("conboard").options[boardIndex].innerText;
	
	var portIndex = $("conport").options.selectedIndex;
	if (portIndex < 0)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var conport = $("conport").options[portIndex].value;
	var conportname = $("conport").options[portIndex].innerText;
	
	var conportObj = new Object();
	conportObj.slotId = conboard;
	conportObj.boardName = conboardname;
	conportObj.portId = conport;
	conportObj.portName = conportname;
    
	selecteConports[selecteConports.length] = conportObj;
    
    $("conportSelected").options[$("conportSelected").options.length] = new Option(conboardname + "-" + conportname, conboard + "-" + conport);
    
    $("conport").options.remove(portIndex);
    
    if ($("conport").options.length == 0)
    {
    	$("conboard").options.remove(boardIndex);
    	changeBoard("conboard", "conport");
    }
    
    refeshApplyBtn();
}

function conLeft()
{
	if (selecteConports == null)
	{
		selecteConports = new Array();
	}
	
	var boardIndex = $("conboard").options.selectedIndex;
	var curconboard = $("conboard").value;
	
	var portIndex = $("conportSelected").options.selectedIndex;
	if (portIndex < 0)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var conportvar = $("conportSelected").options[portIndex].value;
	var conportname = $("conportSelected").options[portIndex].innerText;
	
	var portarr = conportvar.split("-");
	var conboard = portarr[0];
	var conport = portarr[1];
	var conpathid = conportname.substring(conportname.length-1);
	
	var conportObjed = null;
	for (var i = selecteConports.length-1; i >= 0; i--)
	{
		conportObjed =  selecteConports[i];
		var conportObjPath = conportObjed.portName.substring(conportObjed.portName.length-1);
		if (conportObjed.slotId == conboard && conportObjed.portId == conport && conportObjPath == conpathid)
		{
			selecteConports.removeAt(i);
			$("conportSelected").options.remove(portIndex);
			
			if ($("conboard").options.length == 0)
		    {
		    	$("conboard").options[$("conboard").options.length] = new Option(conportObjed.boardName, conportObjed.slotId);
		    	$("conport").options[$("conport").options.length] = new Option(conportObjed.portName, conportObjed.portId);
		    }
		    else if (curconboard == conportObjed.slotId)
		    {
		    	$("conport").options[$("conport").options.length] = new Option(conportObjed.portName, conportObjed.portId);
		    }
		    else
		    {
		    	$("conboard").options[$("conboard").options.length] = new Option(conportObjed.boardName, conportObjed.slotId);
		    }
		}
	}
	
	refeshApplyBtn();
}

function slaveRight()
{
	if (selectePorts == null)
	{
		selectePorts = new Array();
	}
	var boardIndex = $("slaveboard").options.selectedIndex;
	var slaveboard = $("slaveboard").value;
	var slaveboardname = $("slaveboard").options[boardIndex].innerText;
	
	var portIndex = $("slaveport").options.selectedIndex;
	if (portIndex < 0)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var slaveport = $("slaveport").options[portIndex].value;
	var slaveportname = $("slaveport").options[portIndex].innerText;
	
	var slaveportObj = new Object();
    slaveportObj.slotId = slaveboard;
    slaveportObj.boardName = slaveboardname;
    slaveportObj.portId = slaveport;
    slaveportObj.portName = slaveportname;
    
    selectePorts[selectePorts.length] = slaveportObj;
    
    $("slaveportSelected").options[$("slaveportSelected").options.length] = new Option(slaveboardname + "-" + slaveportname, slaveboard + "-" + slaveport);
    
    $("slaveport").options.remove(portIndex);
    
    if ($("slaveport").options.length == 0)
    {
    	$("slaveboard").options.remove(boardIndex);
    	changeBoard("slaveboard", "slaveport");
    }
    
    refeshApplyBtn();
}

function slaveLeft()
{
	if (selectePorts == null)
	{
		selectePorts = new Array();
	}
	
	var boardIndex = $("slaveboard").options.selectedIndex;
	var curslaveboard = $("slaveboard").value;
	
	var portIndex = $("slaveportSelected").options.selectedIndex;
	if (portIndex < 0)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var slaveportvar = $("slaveportSelected").options[portIndex].value;
	var slaveportname = $("slaveportSelected").options[portIndex].innerText;
	
	var portarr = slaveportvar.split("-");
	var slaveboard = portarr[0];
	var slaveport = portarr[1];
	
	var slaveportObjed = null
	for (var i = selectePorts.length-1; i >= 0; i--)
	{
		slaveportObjed =  selectePorts[i];
		if (slaveportObjed.slotId == slaveboard && slaveportObjed.portId == slaveport)
		{
			selectePorts.removeAt(i);
			$("slaveportSelected").options.remove(portIndex);
			
			if ($("slaveboard").options.length == 0)
		    {
		    	$("slaveboard").options[$("slaveboard").options.length] = new Option(slaveportObjed.boardName, slaveportObjed.slotId);
		    	$("slaveport").options[$("slaveport").options.length] = new Option(slaveportObjed.portName, slaveportObjed.portId);
		    }
		    else if (curslaveboard == slaveportObjed.slotId)
		    {
		    	$("slaveport").options[$("slaveport").options.length] = new Option(slaveportObjed.portName, slaveportObjed.portId);
		    }
		    else
		    {
		    	$("slaveboard").options[$("slaveboard").options.length] = new Option(slaveportObjed.boardName, slaveportObjed.slotId);
		    }
		}
	}
	
	refeshApplyBtn();
}

function getCurPortRes(atomid)
{
	if ($("cascadetype").value == CASCADETYPE_NO)
	{
		portRes = win.portRes;
	}
	else
	{
		if (atomid == "mainboard" || atomid == "slaveboard")
		{
			portRes = win.ifPortRes;
		}
		else
		{
			portRes = win.servicePortRes;
		}
	}
	
	return portRes;
}

function fillBoard(atomid)
{
	portRes = getCurPortRes(atomid);
	var atom = $(atomid);
    atom.options.length = 0;
    
    var portObj = null;
    var bdName = null;
    var tmpArr = new Array();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = getBoardName(portObj);
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        
        if(bdName == "IFU2")
        {
        	 continue;
        }
        
        if (!tmpArr.contains(bdName)) 
        {
            tmpArr[tmpArr.length] = bdName;
            atom.options[atom.options.length] = new Option(bdName, portObj.slotId);
        }
    }
}

function changeBoard(b1, p1)
{
	var atom = $(b1);
    var index = atom.options.selectedIndex;
    if (index < 0) 
    {
    	atom = $(p1);
        atom.options.length = 0;
    	return;
    }
    var option = atom.options[index];
    var slotId = option.value;
    var board = option.text;
    
    var portObj = null;
    var bdName = null;
    atom = $(p1);
    atom.options.length = 0;
    portRes = getCurPortRes(b1);
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = getBoardName(portObj);
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        if (board == bdName) 
        {
            if(p1 == "conport")
            {
            	atom.options[atom.options.length] = new Option(getPortName(portObj) + "-1", portObj.portId);  //   1
            	atom.options[atom.options.length] = new Option(getPortName(portObj) + "-2", portObj.portId);  //  2
            }
            else
            {
            	atom.options[atom.options.length] = new Option(getPortName(portObj), portObj.portId);
            }
        }
    }
}

function getBoardName(portObj)
{
	if ($("cascadetype").value == CASCADETYPE_YES)
	{
		var arr = portObj.portName.split("-");
		return arr[1];
	}
	else
	{
		return portObj.boardName;
	}
	
}

function getPortName(portObj)
{
	if ($("cascadetype").value == CASCADETYPE_YES)
	{
		var arr = portObj.portName.split("-");
		return portObj.portName.substring(portObj.portName.indexOf(arr[1]) + arr[1].length + 1);
	}
	else
	{
		return portObj.portName;
	}
}

function sendApplyInfo(flag)
{
	if ($("cascadetype").value == CASCADETYPE_YES)
	{
		if (selecteConports == null || selecteConports.length <= 0)
		{
			alert(RESOURCE["conPortAlert"]);
			return;
		}
	}
	else
	{
		if (selectePorts == null || selectePorts.length <= 0)
		{
			alert(RESOURCE["portAlert"]);
			return;
		}
	}
	
	
	$("okBtn").disabled = true;
	$("cancelBtn").disabled = true;
	$("applyBtn").disabled = true;
	
	var xmlstr;
	var urlreq;
	if($("cascadetype").value == CASCADETYPE_YES)
	{
		xmlstr = createPLAXML(true);
		urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_ADD_CASCADE_PLA_GROUP + "&nmUser=" + win.winurlobj["nmUser"];
	}
	else
	{
		xmlstr = createPLAXML(false);
		urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_ADD_PLA_GROUP + "&nmUser=" + win.winurlobj["nmUser"];
	}

	loadXMLdoc(urlreq, "POST", true, openCreateErrDialog, flag, "inputdata="
			+ xmlstr);

}

function createPLAXML(flag)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	param = new tagElement("param");
	var ggroupid = $("ggroupid").value;
	param.setAttribute("name", "ggroupid");
	param.setAttribute("value", ggroupid);
	row.appendChild(param);
	
	var ggrouptype = $("ggrouptype").value;
	var cascadetype = $("cascadetype").value;
	param = new tagElement("param");
	param.setAttribute("name", "cascadetype");
	param.setAttribute("value", cascadetype);
	row.appendChild(param);
	
	if(flag)
	{
		param = new tagElement("param");
		param.setAttribute("name", "ggrouptype");
		param.setAttribute("value", parseInt(cascadetype * 2) + parseInt(ggrouptype));
		row.appendChild(param);
		
		param = new tagElement("param");
		var protecttype = $("protecttype").value;
		param.setAttribute("name", "protecttype");
		param.setAttribute("value", protecttype);
		row.appendChild(param);
		
		param = new tagElement("param");
		var nestatus = $("nestatus").value;
		param.setAttribute("name", "nestatus");
		param.setAttribute("value", nestatus);
		row.appendChild(param);
		
		if(nestatus == "1")
		{
			param = new tagElement("param");
			param.setAttribute("name", "lcneportnum");
			param.setAttribute("value", 0);
			row.appendChild(param);
			
			param = new tagElement("param");
			var nbneslotids = getSelectedString("conboard");
			param.setAttribute("name", "nbneslotids");
			param.setAttribute("value", nbneslotids);
			row.appendChild(param);
			
			param = new tagElement("param");
			var nbneports = getSelectedString("conport");
			param.setAttribute("name", "nbneports");
			param.setAttribute("value", nbneports);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "nbneportnum");
			param.setAttribute("value", selecteConports.length);
			row.appendChild(param);
		}
		else
		{
			param = new tagElement("param");
			param.setAttribute("name", "lcneportnum");
			param.setAttribute("value", selecteConports.length);
			row.appendChild(param);
			
			param = new tagElement("param");
			var lcneslotids = getSelectedString("conboard");
			param.setAttribute("name", "lcneslotids");
			param.setAttribute("value", lcneslotids);
			row.appendChild(param);
			
			param = new tagElement("param");
			var lcneports = getSelectedString("conport");
			param.setAttribute("name", "lcneports");
			param.setAttribute("value", lcneports);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "nbneportnum");
			param.setAttribute("value", 0);
			row.appendChild(param);
		}
	}
	else
	{
		param = new tagElement("param");
		param.setAttribute("name", "ggrouptype");
		param.setAttribute("value", ggrouptype);
		row.appendChild(param);
	}
	
	param = new tagElement("param");
	var mainslotid = $("mainboard").value;
	param.setAttribute("name", "mainslotid");
	param.setAttribute("value", mainslotid);
	row.appendChild(param);

	param = new tagElement("param");
	var mainportid = $("mainport").value;
	param.setAttribute("name", "mainportid");
	param.setAttribute("value", mainportid);
	row.appendChild(param);

	param = new tagElement("param");
	var slaveportnum;
	if(selectePorts == null)
	{
		slaveportnum = 0;
	}
	else
	{
		slaveportnum = selectePorts.length;
	}
	param.setAttribute("name", "slaveportnum");
	param.setAttribute("value", slaveportnum);
	row.appendChild(param);
	if(selectePorts != null)
	{
		param = new tagElement("param");
		var slaveslotids = getSelectedString("slaveboard");
		param.setAttribute("name", "slaveslotids");
		param.setAttribute("value", slaveslotids);
		row.appendChild(param);
		
		param = new tagElement("param");
		var slaveportids = getSelectedString("slaveport");
		param.setAttribute("name", "slaveportids");
		param.setAttribute("value", slaveportids);
		row.appendChild(param);
	}
	else
	{
		param = new tagElement("param");
		param.setAttribute("name", "slaveslotids");
		param.setAttribute("value", "");
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "slaveportids");
		param.setAttribute("value", "");
		row.appendChild(param);
	}
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function getSelectedString(arr)
{
	var selStr = "";
	var portobject = null;
	if (arr == "slaveboard")
	{
		for (var i = 0; i < selectePorts.length; i++)
		{
			portobject = selectePorts[i];
			selStr = selStr + portobject.slotId + ",";
		}
	}
	
	if (arr == "slaveport")
	{
		for (var i = 0; i < selectePorts.length; i++)
		{
			portobject = selectePorts[i];
			selStr = selStr + portobject.portId + ",";
		}
	}
	
	if (arr == "conboard")
	{
		for (var i = 0; i < selecteConports.length; i++)
		{
			portobject = selecteConports[i];
			selStr = selStr + portobject.slotId + ",";
		}
	}
	
	if (arr == "conport")
	{
		var pathId;
		for (var i = 0; i < selecteConports.length; i++)
		{
			portobject = selecteConports[i];
			pathId = portobject.portName.substring(portobject.portName.length - 1);
			selStr = selStr + portobject.portId + "-" + pathId + ",";
		}
	}

	return selStr;
}

function closeClick()
{
	xcloseDialog();
}


function openCreateErrDialog(doc, flag)
{	
	$("okBtn").disabled = false;
    $("cancelBtn").disabled = false;
        
	var dinterface = EncapsulateData(doc);

	if (0 != dinterface.getSErrorCode())
	{
		isSuccess = false;
		hasApplied = false;
		showErrorDialog(dinterface);
		$("applyBtn").disabled = false;
		return;
	}

	isSuccess = true;
	hasApplied = true;
	win.refreshTable();
	
	
	
	if(dinterface.getSErrorCode() == 0)
	{
		var ops = $("slaveportSelected").options;
	    
	    for(var i = 0, len = ops.length; i < len; i++)
	    {
	        removeObjFromMem(ops[i]);
	    }
	    
	    $("slaveportSelected").options.length = 0;
	    
	    fillBoard("slaveboard");
	    changeBoard("slaveboard", "slaveport");
	    
        ops = $("conportSelected").options;
	    for(var i = 0, len = ops.length; i < len; i++)
	    {
	        removeObjFromMem(ops[i]);
	    }
	    $("conportSelected").options.length = 0;
	    fillBoard("conboard");
	    changeBoard("conboard", "conport");
	    
	    refeshApplyBtn();
	}
	
	if (dinterface.getSErrorCode() == 0 && flag)
	{
		closeClick();
	}
}

function initBtn()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	$("selectport").value = ">>";
	$("unselectport").value = "<<";
	$("selectconport").value = ">>";
	$("unselectconport").value = "<<";
}

function showErrorDialog(dinterface)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", dinterface.getError(), errArr);
}

function refeshApplyBtn()
 {
	if ((selectePorts && selectePorts.length > 0 && $("slaveportSelected").options.length > 0)
			|| (selecteConports && selecteConports.length > 0 && $("conportSelected").options.length > 0)) 
	{
		$('applyBtn').disabled = false;
	} 
	else 
	{
		$('applyBtn').disabled = true;
	}
}

/**
 * *        OPTION  
 */
function removeObjFromMem(opt)
{
    var portarr = opt.value.split("-");
    var slaveboard = portarr[0];
    var slaveport = portarr[1];
    
    var slaveportObjed = null;
    if(selectePorts)
    {
    for (var i = selectePorts.length-1; i >= 0; i--)
    {
        slaveportObjed =  selectePorts[i];
	    if (slaveportObjed.slotId == slaveboard && slaveportObjed.portId == slaveport)
	    {
	        selectePorts.removeAt(i);
	    }
    }
    }
}
