var queryParam;
var winurlobj = getNeProperty(self);
var IFPortRes = null;
var ServicePortRes = null;

var BOARD_TYPE_RESOURCE = 1;
var PORT_TYPE_RESOURCE = 2;
var TE_PTN_NE = 16;
var SHELF_RTN905_1C = 18;

var convertWorkStatus = new Object();
convertWorkStatus[0] = "asslaveport";
convertWorkStatus[1] = "asmainport";
convertWorkStatus[255] = "unknown";

var convertStatus  = new Object();
convertStatus[0] = "normal";
convertStatus[1] = "abnormal";
convertStatus[255] = "unknown";

var convertNEWorkStatus = new Object();
convertNEWorkStatus[0] = "asslaveneport";
convertNEWorkStatus[1] = "asmainneport";
convertNEWorkStatus[255] = "unknown";

var convertNEStatus = new Object();
convertNEStatus[0] = "slaveneport";
convertNEStatus[1] = "mainneport";

var convertProtectType = new Object();
convertProtectType[0] = "noprotect";
convertProtectType[1] = "lagprotect";
convertProtectType[255] = "noprotect";

function convertbasicinfo(str)
{
	if ("4294967295" == str || "65535" == str || "255" == str || "-1" == str)
	{
		return RESOURCE["unknown"];
	}
	else
	{
		return str;
	}
}

var btnRightArr = new Object();

var st0;
var slavest;

/*
 Get neid from url param
 */
function getNeID()
{
    return queryParam["neid"];
}

function setButtonStatus(btnStatus)
{
    $("querybtn").disabled = !btnStatus;
}

/*
 Get neid from url param
 */
window.onload = function()
{
    queryParam = getNeProperty(top);
    setButtonText();
    createTable();
    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_RTN_QUERY_PLA_GROUP);    
    btnRightArr.createbtn = new BtnRightObj("createbtn",TECMDCODE_RTN_ADD_PLA_GROUP);   
    btnRightArr.deletebtn = new BtnRightObj("deletebtn",TECMDCODE_RTN_DEL_PLA_GROUP);
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_RTN_MODIFY_PLA_MINUPLINKTH);
    
    getRightInfo(winurlobj,btnRightArr);
    
    initrightbtn(btnRightArr);
    
    if ($("querybtn").disabled == false) 
    {
        refreshTable();
    }
}

function initBtnStatus()
{
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("createbtn").disabled = !btnRightArr.createbtn.right;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
}

/*
 set button and title text
 */
function setButtonText()
{
    $("title").innerHTML = RESOURCE["oppositenelist"];
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("createbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function tableSelectHandler(rows)
{
	
}

/**
 * table selection change
 */
function rowSelected(rows)
{
	if (st0.getSelectedRows().length > 0)
	{
		querySlavePortInfo(st0.getSelectedRows()[0]);
		$("deletebtn").disabled = !btnRightArr.createbtn.right;
	}
	else
	{
		slavest.clearTableData();
		$("deletebtn").disabled = true;
	}
}

function querySlavePortInfo(rowIndex)
{
	var xml = createQuerySlavePortInfo(rowIndex);
    if (null == xml) 
    {
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_PLA_SLAVEPORTINFO_EXT + "&flag=1&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshSlaveTableCallBack, null, "inputdata=" + xml);
}

function createQuerySlavePortInfo(rowIndex)
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    var neid = getNeID();
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var ggroupid = st0.getCellStoreValue(rowIndex, "ggroupid", "ggroupid");
    param = new tagElement("param");
    param.setAttribute("name", "ggroupid");
    param.setAttribute("value", ggroupid);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function refreshSlaveTableCallBack(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    slavest.clearTableData();
    createTableBody(slavest, window.tableconf[1], dinterface, RESOURCE);
    
    /**
     *                             "  "
     */
    for (var i = 0, len = slavest.getDataRowLength(); i < len; i++)
    {
    	var mainneslotid = slavest.getCellStoreValue(i, "mainneportname", "mainneslotid");
    	var mainslotname = slavest.getCellStoreValue(i, "mainneportname", "mainslotname");
    	var mainportname = slavest.getCellStoreValue(i, "mainneportname", "mainportname");
    	if (mainneslotid == "65535" && mainslotname == "-1" && mainportname == "-1")
    	{
    		slavest.getCellShow(i, "mainneportname").element.innerHTML = RESOURCE["unknown"];
    	}
    	
    	var slaveneslotid = slavest.getCellStoreValue(i, "slaveneportname", "slaveneslotid"); 
    	var slaveslotname = slavest.getCellStoreValue(i, "slaveneportname", "slaveslotname"); 
    	var slaveportname = slavest.getCellStoreValue(i, "slaveneportname", "slaveportname"); 
    	if (slaveneslotid == "65535" && slaveslotname == "-1" && slaveportname == "-1")
    	{
    		slavest.getCellShow(i, "slaveneportname").element.innerHTML = RESOURCE["unknown"];
    	}
    }
}

/*
 create ecc link table
 */
function createTable()
{
    st0 = new SortTable();
    st0.setImage("../../../../images/");
    st0.setOnRowSelectHandler(rowSelected);
    st0.setOnCellEditHandler(cellEditHandler);
    createTableHead(st0, window.tableconf[0]);
    $("tablecontainer").appendChild(st0.getTable());
    st0.setBodyHeight("200px");
    $("tablecontainer").oncontextmenu = popupMenuHandler;
    
    slavest = new SortTable();
    slavest.setImage("../../../../images/");
    createTableHead(slavest, window.tableconf[1]);
    $("slaveTablecontainer").appendChild(slavest.getTable());
    slavest.setBodyHeight("200px");
}

function cellEditHandler(param)
{
	if (btnRightArr.applybtn.right)
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

function modifyLAG()
{
	$("querybtn").disabled = true;
	$("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xmlstr = createModifyLAGXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_MODIFY_PLA_MINUPLINKTH_EXT + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, modifyLAGCallback, null,
			"inputdata=" + xmlstr);
}

function modifyLAGCallback(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    
    initBtnStatus();
    
    var selectrows = st0.getSelectedRows();
    
    if (selectrows.length > 0)
    {
    	rowSelected(st0.getRow(selectrows[0]).element);
    }
    
    if (dinterface.getSErrorCode() != 0) 
    {
    	$("applybtn").disabled = false;
    }
    
    refreshTableState(st0, window.tableconf[0], dinterface);
}

function createModifyLAGXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var param = null;
	var row = null;
	
	for (var i = 0; i < st0.getDataRowLength(); i++)
	{
		if (!st0.getModify(i))
		{
			continue;
		}
		
		row = new tagElement("row-params");
		
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", getNeID());
		row.appendChild(param);
		
		var lagid = st0.getCellStoreValue(i, "ggroupid", "ggroupid");
		param = new tagElement("param");
		param.setAttribute("name", "ggroupid");
		param.setAttribute("value", lagid);
		row.appendChild(param);
		
		var minUpLinkTH = st0.getCellStoreValue(i, "minUpLinkTH", "minUpLinkTH");
		param = new tagElement("param");
		param.setAttribute("name", "minUpLinkTH");
		param.setAttribute("value", minUpLinkTH);
		row.appendChild(param);
	
		bussiness.appendChild(row);
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/*
 refresh table data
 */
function refreshTable()
{
	$("querybtn").disabled = true;
	$("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
	
    var xml = createRequestData();
    if (null == xml) 
    {
    	initBtnStatus()
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_PLA_GROUP_EXT + "&flag=1&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshTableCallBack, null, "inputdata=" + xml);
}

/*
 create request data
 */
function createRequestData()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    var neid = getNeID();
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ggroupid");
    param.setAttribute("value", 1);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/*
 Handler response data,construct table data
 */
function refreshTableCallBack(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    
    if (dinterface.getSErrorCode() != 2) 
    {
    	st0.clearTableData();
	    slavest.clearTableData();
	    createTableBody(st0, window.tableconf[0], dinterface, RESOURCE);
    }
    
    if (SHELF_RTN905_1C == winurlobj.shelfType)
    {
    	for (var i = 0, len = st0.getDataRowLength(); i < len; i++)
    	{
    		var tmpnestatus = st0.getCellStoreValue(i, "nestatus", "nestatus");
    		if (tmpnestatus == "0")
    		{
    			var tmpcell = st0.getCell(i, "minUpLinkTH");
    			st0.setCellIsEdit(tmpcell, "0");
    		}
    	}
    }
    
    initBtnStatus();
    
    if (st0.getDataRowLength() > 0)
    {
    	st0.setRowSelect(0);
    	rowSelected(st0.getRow(0).element);
    }
}

function deleteLAG()
{
	if (!confirm(RESOURCE["confirmDelete"]))
	{
		return;
	}
	var xmlstr = createDeleteLAGXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_DEL_PLA_GROUP_EXT + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, deleteLAGCallback, null,
			"inputdata=" + xmlstr);
}

function createDeleteLAGXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var param = null;
	var row = null;
	
	var selectrows = st0.getSelectedRows();
	
	for (var i = 0; i < selectrows.length; i++)
	{
		row = new tagElement("row-params");
		
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", getNeID());
		row.appendChild(param);
		
		var lagid = st0.getCellStoreValue(selectrows[i], "ggroupid", "ggroupid");
		param = new tagElement("param");
		param.setAttribute("name", "ggroupid");
		param.setAttribute("value", lagid);
		row.appendChild(param);
	
		bussiness.appendChild(row);
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function deleteLAGCallback(doc)
{
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }
    
    if (dinterface.getSErrorCode() != 2)
    {
    	refreshTable();
    }
}

function getIFAvailableResourceInfo()
{
	var xmlstr = createGetPortAvailableResXML("ATTR_IF_PORT_PLA", PORT_TYPE_RESOURCE, TE_PTN_NE);
 	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_COMMON_FIND_RESURCE + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshGetAvailableRes, "ATTR_IF_PORT_PLA", "inputdata=" + xmlstr);
}

function getServiceAvailableResourceInfo()
{
	var xmlstr = createGetPortAvailableResXML("ATTR_SERVICE_PORT_PLA", PORT_TYPE_RESOURCE, TE_PTN_NE);
 	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_COMMON_FIND_RESURCE + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshGetAvailableRes, "ATTR_SERVICE_PORT_PLA", "inputdata=" + xmlstr);
}

/**
 *        XML
 * @param {Object} supportAttrName
 * @param {Object} resourceType
 */
function createGetPortAvailableResXML(supportAttrName, resourceType, funDomainType)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeID());
	row.appendChild(param);
	
	var param = new tagElement("param");
	param.setAttribute("name", "supportAttrName");
	param.setAttribute("value", supportAttrName);
	row.appendChild(param);
	
	var param = new tagElement("param");
	param.setAttribute("name", "resourceType");
	param.setAttribute("value", resourceType);
	row.appendChild(param);
	
	var param = new tagElement("param");
	param.setAttribute("name", "funDomainType");
	param.setAttribute("value", funDomainType);
	row.appendChild(param);
	   
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	
	return di.toString();
}

function refreshGetAvailableRes(doc, portType)
{
	if (portType == "ATTR_IF_PORT_PLA")
	{
		IFPortRes = new Array();
	    
	    var portObj = null;
	    var data = EncapsulateData(doc);
	    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
	    {
	        portObj = new Object();
	        portObj.slotId = data.getDataRowParam(i, "slotId");
	        portObj.portId = data.getDataRowParam(i, "portId");
	        portObj.portName = data.getDataRowParam(i, "portname");
	        
	        IFPortRes[IFPortRes.length] = portObj;
	    }
	}
	else
	{
		ServicePortRes = new Array();
	    
	    var portObj = null;
	    var data = EncapsulateData(doc);
	    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
	    {
	        portObj = new Object();
	        portObj.slotId = data.getDataRowParam(i, "slotId");
	        portObj.portId = data.getDataRowParam(i, "portId");
	        portObj.portName = data.getDataRowParam(i, "portname");
	        
	        ServicePortRes[ServicePortRes.length] = portObj;
	    }
	}
}

function createPLA()
{
	hideMenu();
	getIFAvailableResourceInfo();
	getServiceAvailableResourceInfo();
	for (var i = 0, len = st0.getDataRowLength(); i < len; i++)
	{
		var ifslotidc = st0.getCellStoreValue(i, "ifslotid", "ifslotid");
		var ifportidc = st0.getCellStoreValue(i, "ifportid", "ifportid");
		var serviceslotidc = st0.getCellStoreValue(i, "serviceslotid", "serviceslotid");
		var serviceportidc = st0.getCellStoreValue(i, "serviceportid", "serviceportid");
		var conslotidc = st0.getCellStoreValue(i, "conslotid", "conslotid");
		var conportidc = st0.getCellStoreValue(i, "conportid", "conportid");
		for (var j = IFPortRes.length - 1; j >= 0; j--)
		{
			var portObj = IFPortRes[j];
			if (portObj.slotId == ifslotidc && portObj.portId == ifportidc)
			{
				IFPortRes.removeAt(j);
			}
		}
		
		for (var k = ServicePortRes.length - 1; k >= 0; k--)
		{
			var portObj = ServicePortRes[k];
			var serviceres = portObj.slotId + "-" + portObj.portId
			if ((portObj.slotId == serviceslotidc && portObj.portId == serviceportidc) 
					|| (portObj.slotId == conslotidc && portObj.portId == conportidc))
			{
				ServicePortRes.removeAt(k);
			}
		}
	}
	
	if (IFPortRes.length <= 0 && ServicePortRes.length <= 0) 
    {
        alert(RESOURCE["noportres"]);
        return;
    }
    
    	xshowModalDialog("createPLA_smart.html", RESOURCE["createTitle"], 600, 280,
			"../../../../images/", "yes");
}

function popupMenuHandler(evt)
{
	if(SYSTEMCONF.getStatus() != 1)
	{
		return;
	}
	if (!evt)
	{
		evt = window.event;
	}
	var elem = (evt.target) ? evt.target : evt.srcElement;
	if (elem != null && elem.blur)
	{
		elem.blur();
	}
	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}
	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	}
	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;

	if (rows.contains(rowid))
	{
		removejsDOMmenu();
		var cursorMenu1 = new jsDOMenu(180);
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["browsecurrentalm"], "",switchInterFunc, 1,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["browsehistoryalm"], "",switchInterFunc, 2,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["alarmsuppress"], "",switchInterFunc, 3,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["browsepfm"], "",switchInterFunc, 4,true));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["pfmstatic"], "",switchInterFunc, 5,true));
		setPopUpMenu(cursorMenu1);
		showMenu(evt);
	}
}

function switchInterFunc(funcid)
{
	var xml = createSwitchInterFuncXML(funcid);


	if(xml == null)
	{
		return;
	}
	var urlstr = "../../../../linkInterFuncServlet?neid=" + winurlobj["neid"] + "&prohandler=0&switchtype=7";
	loadXMLdoc(urlstr, "POST", true, switchInterFuncCallback, null, "inputdata="+xml);
}

function switchInterFuncCallback(doc)
{

}

function createSwitchInterFuncXML(funcid)
{
	var rows = st0.getSelectedRows();
	if(rows.length > 0)
	{
			var root = new inputxml("datainterface");
	    var business = new tagElement("bussiness-params");
	    var row = new tagElement("row-params");
	    var param = new tagElement("param","neid",winurlobj["neid"]);
	    row.appendChild(param);
	    param = new tagElement("param","sessionid",winurlobj["sessionid"]);
	    row.appendChild(param);
	    param = new tagElement("param","funcid",funcid);
	    row.appendChild(param);
	    
	    var ggrouptype = st0.getCellStoreValue(rows[0],"ggrouptype","ggrouptype");
	    	var ggroupid = st0.getCellStoreValue(rows[0],"ggroupid","ggroupid");
	    	param = new tagElement("param","grouptype","0"); 
	    	row.appendChild(param);
	    	param = new tagElement("param","groupid",ggroupid); 
	    	row.appendChild(param);
	    
	    business.appendChild(row);

	  
	    
	    root.getRoot().appendChild(business);
	    return root.toString();
	}
	else
	{
		return null;
	}
}
