
var win = getParentWindow();
var neid = win.getNeID();
var netype = win.winurlobj.neType;
var shelfType = win.winurlobj.shelfType;
var ct = null;
var portRes;
var INVALID_SLOT = 0xFFFF;

var selectePorts = null;

var lagidmin = 1;
var lagidmax_910 = 1;
var lagidmax_950 = 3;
var lagidmax_980 = 7;

var ifStorePort = ""; 
var serviceStorePort = ""; 
var conStorePort = "";

var ELAGMGR_FUNCID = 8494;
var SHELF_RTN905_1C = 18;

function init()
{
	initTable();
	initBtn();
	fillPortRes("ifport", null);
	
	if (shelfType == SHELF_RTN905_1C)
	{
		fillNullRes("serviceport");
	}
	else
	{
		fillPortRes("serviceport", null);
	}
	fillPortRes("conport", null);
	
	servicePortChange("serviceport");
}

function initTable()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
	
	/**
	 * PLA  
	 */
	var ggroupidAtom = new Atom("text");
	ggroupidAtom.element.value = "1"
	ggroupidAtom.element.disabled = true;
	ct.addAttrRow("ggroupid", RESOURCE["aggID"], ggroupidAtom);

	/**
	 *     
	 */
	var protecttypeAtom = new Atom("select");
	protecttypeAtom.addOption(RESOURCE["protecttype0"], 0);
	protecttypeAtom.addOption(RESOURCE["protecttype1"], 1);
	protecttypeAtom.element.selectedIndex = 0;
	ct.addAttrRow("protecttype", RESOURCE["protecttyperes"], protecttypeAtom);

	var linktolagAtom = new Atom("span");
	ct.addAttrRow("laglink", RESOURCE["laglink"], linktolagAtom);
	var elem = document.createElement("a");
    elem.href="###";
    elem.innerText = RESOURCE["laglinkInfo"];
    elem.id = "laglinkBtn";
	elem.style.width = "100%";
    elem.onclick = onGotoLagMgr;
    linktolagAtom.element.parentNode.appendChild(elem);
	
	/**
	 *     
	 */
	var nestatusAtom = new Atom("select");
	nestatusAtom.addOption(RESOURCE["nestatus0"], 0);
	nestatusAtom.addOption(RESOURCE["nestatus1"], 1);
	nestatusAtom.element.selectedIndex = 0;
	ct.addAttrRow("nestatus", RESOURCE["nestatusres"], nestatusAtom);

	/**
	 *    
	 */
	var ifportAtom = new Atom("select");
	ct.addAttrRow("ifport", RESOURCE["ifportres"], ifportAtom);

	/**
	 *    
	 */
	var serviceportAtom = new Atom("select");
	serviceportAtom.element.onchange = servicePortChange;
	ct.addAttrRow("serviceport", RESOURCE["serviceportres"], serviceportAtom);

	/**
	 *    
	 */
	var conportAtom = new Atom("select");
	conportAtom.element.onchange = conPortChange;
	ct.addAttrRow("conport", RESOURCE["conportres"], conportAtom);

	document.getElementById("plaTableID").appendChild(ct.getTable());
	
	if (shelfType == SHELF_RTN905_1C)
	{
		ct.getAtom("protecttype").element.disabled = true;
		ct.getAttrRow("laglink").style.display = "none";
	}
}

function changeProtectType()
{
	if (this.value == "1")
	{
		ct.getAttrRow("laglink").style.display = "";
	}
	else
	{
		ct.getAttrRow("laglink").style.display = "none";
	}
}

/**
 *   LAG     
 */
function onGotoLagMgr()
{
	if (SYSTEMCONF.getStatus() == 1)
	{
		var winobj = win.winurlobj;
		var urlstr = "../../../../linkInterFuncServlet?neid=" + neid + "&prohandler=0&switchtype=1";
		var xmlData = createLinkFunctionTreeXml(neid,winobj["sessionid"],"8494");
		loadXMLdoc(urlstr, "POST", true, linkFunctionTreeCallback, null, "inputdata="+xmlData);
	}
	else
	{
		var fun = win.top.frames["functiontree"].tree[ELAGMGR_FUNCID];
		if(null == fun)
		{
	    	return;
		}
		fun.isSelect();
		fun.expand();
		fun.onClick();
		xcloseDialog();
	}
}

function createLinkFunctionTreeXml(neid,sessionid,funcid)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",neid);
    row.appendChild(param);
    param = new tagElement("param","sessionid",sessionid);
    row.appendChild(param);
    param = new tagElement("param","funcid",funcid); 
    row.appendChild(param);
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

function linkFunctionTreeCallback(doc)
{
	xcloseDialog();
}

function servicePortChange(str)
{
	var currentSPort = this.value;
	if ("serviceport" == str)
	{
		currentSPort = ct.getAttrValue("serviceport");
	}
	/**
	 *                                    
	 *                                      
	 *           
	 */
	
	var idAtom = ct.getAtom("conport").element;
	var conPortRes = idAtom.options;
	for (var i = 0, len = conPortRes.length; i < len; i++)
	{
		if (conPortRes[i].value != currentSPort)
		{
			idAtom.selectedIndex = i;
			break;
		}
	}
}

function conPortChange()
{
	var currentSPort = this.value;
	var idAtom = ct.getAtom("serviceport").element;
	var conPortRes = idAtom.options;
	for (var i = 0, len = conPortRes.length; i < len; i++)
	{
		if (conPortRes[i].value != currentSPort)
		{
			idAtom.selectedIndex = i;
			break;
		}
	}
}

function fillPortRes(atomid, changeres)
{
	if (atomid == "ifport")
	{
		portRes = win.IFPortRes;
	}
	else
	{
		portRes = win.ServicePortRes;
	}
	
	if (changeres != null)
	{
		portRes = changeres
	}
	
    var atom = ct.getAtom(atomid).element;
    atom.options.length = 0;
    
    var portObj = null;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        
        atom.options[atom.options.length] = new Option(portObj.portName, portObj.slotId + "-" + portObj.portId);
    }
}

function fillNullRes(atomid)
{
	if (atomid == "serviceport")
	{
		var atom = ct.getAtom(atomid).element;
    	atom.options.length = 0;
    	atom.options[atom.options.length] = new Option("-", "-");
    	atom.disabled = true;
	}
}

function sendApplyInfo(flag)
{
	var ifportvar = ct.getAttrValue("ifport");
	var serviceportvar = ct.getAttrValue("serviceport");
	var conportvar = ct.getAttrValue("conport");
	if (null == ifportvar || undefined == ifportvar || "" == ifportvar)
	{
		alert(RESOURCE["ifPortAlert"]);
		return;
	}
	
	if (null == serviceportvar || undefined == serviceportvar || "" == serviceportvar)
	{
		alert(RESOURCE["servicePortAlert"]);
		return;
	}
	
	if (null == conportvar || undefined == conportvar || "" == conportvar)
	{
		alert(RESOURCE["conPortAlert"]);
		return;
	}
	
	if (serviceportvar == conportvar)
	{
		alert(RESOURCE["servicePortErr"]);
		return;
	}
	
	if (!confirm(RESOURCE["confirmCreate"]))
	{
		return;
	}
	
	$("okBtn").disabled = true;
	$("cancelBtn").disabled = true;
	$("applyBtn").disabled = true;
	
	var xmlstr = createPLAXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_ADD_PLA_GROUP_EXT + "&nmUser=" + win.winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, openCreateErrDialog, flag, "inputdata=" + xmlstr);
}

function createPLAXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	var ggroupid = ct.getAttrValue("ggroupid");
	param = new tagElement("param");
	param.setAttribute("name", "ggroupid");
	param.setAttribute("value", ggroupid);
	row.appendChild(param);

	var ifport = ct.getAttrValue("ifport");
	ifStorePort = ifport;
	var ifportArr = ifport.split("-");
	param = new tagElement("param");
	param.setAttribute("name", "ifslotid");
	param.setAttribute("value", ifportArr[0]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "ifportid");
	param.setAttribute("value", ifportArr[1]);
	row.appendChild(param);
	
	var serviceportnum = 1;
	if (shelfType == SHELF_RTN905_1C)
	{
		serviceportnum = 0;
	}
	param = new tagElement("param");
	param.setAttribute("name", "serviceportnum");
	param.setAttribute("value", serviceportnum);
	row.appendChild(param);
	
	if (shelfType != SHELF_RTN905_1C)
	{
		var serviceport = ct.getAttrValue("serviceport");
		serviceStorePort = serviceport;
		var serviceArr = serviceport.split("-");
		param = new tagElement("param");
		param.setAttribute("name", "serviceslotid");
		param.setAttribute("value", serviceArr[0]);
		row.appendChild(param);
	
		param = new tagElement("param");
		param.setAttribute("name", "serviceportid");
		param.setAttribute("value", serviceArr[1]);
		row.appendChild(param);
	}
	
	var nestatus = ct.getAttrValue("nestatus");
	param = new tagElement("param");
	param.setAttribute("name", "nestatus");
	param.setAttribute("value", nestatus);
	row.appendChild(param);
	
	var protecttype = ct.getAttrValue("protecttype");
	if (shelfType == SHELF_RTN905_1C)
	{
		protecttype = "255";
	}
	param = new tagElement("param");
	param.setAttribute("name", "protecttype");
	param.setAttribute("value", protecttype);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "conportnum");
	param.setAttribute("value", "1");
	row.appendChild(param);
	
	var conport = ct.getAttrValue("conport");
	conStorePort = conport;
	param = new tagElement("param");
	param.setAttribute("name", "conports");
	param.setAttribute("value", conport);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function closeClick()
{
	xcloseDialog();
}


function openCreateErrDialog(doc, flag)
{	
	var dinterface = EncapsulateData(doc);

	if (0 != dinterface.getSErrorCode())
	{
		isSuccess = false;
		hasApplied = false;
		showErrorDialog(dinterface);
		$("okBtn").disabled = false;
		$("cancelBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}

	isSuccess = true;
	hasApplied = true;
	win.refreshTable();
	
	if(dinterface.getSErrorCode() == 0)
	{
		var ifops = ct.getAtom("ifport").element.options
		var serviceops = ct.getAtom("serviceport").element.options
		var conops = ct.getAtom("conport").element.options
		for (var i = (ifops.length - 1); i >= 0; i-- )
		{
			var tmpop = ifops[i];
			if (tmpop.value == ifStorePort)
			{
				ifops[i] = null;
				break;
			}
		}
		
		
		for (var j = (serviceops.length - 1); j >= 0; j-- )
		{
			var tmpop = serviceops[j];
			if (tmpop.value == serviceStorePort || tmpop.value == conStorePort)
			{
				serviceops[j] = null;
			}
		}
		
		for (var k = (conops.length - 1); k >= 0; k-- )
		{
			var tmpop = conops[k];
			if (tmpop.value == conStorePort || tmpop.value == serviceStorePort)
			{
				conops[k] = null;
			}
		}
		
	    
	    
	}
	
	$("okBtn").disabled = false;
	$("cancelBtn").disabled = false;
	$("applyBtn").disabled = false;
	
	if (dinterface.getSErrorCode() == 0 && flag)
	{
		closeClick();
	}
}

function initBtn()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
}

function showErrorDialog(dinterface)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", dinterface.getError(), errArr);
}

function refeshApplayBtn()
{
    if(selectePorts.length > 0 && $("slaveportSelected").options.length > 0)
    {
        $('applyBtn').disabled = false;
    } 
    else 
    {
        $('applyBtn').disabled = true;
    }
}

/**
 **        OPTION  
 **/
function removeObjFromMem(opt)
{
    var portarr = opt.value.split("-");
    var slaveboard = portarr[0];
    var slaveport = portarr[1];
    
    var slaveportObjed = null
    for (var i = selectePorts.length-1; i >= 0; i--)
    {
        slaveportObjed =  selectePorts[i];
		if (slaveportObjed.slotId == slaveboard && slaveportObjed.portId == slaveport)
		{
		    selectePorts.removeAt(i);
		}
    }
}
