
var win = getParentWindow();
var neid = win.getNeID();
var netype = win.winurlobj.neType;
var ct = null;
var portRes = win.portRes;
var INVALID_SLOT = 0xFFFF;

var selectePorts = null;

var lagidmin = 1;
var lagidmax_905 = 1;
var lagidmax_910 = 1;
var lagidmax_950 = 3;
var lagidmax_980 = 7;


function init()
{
	initBtn();
	initEvent();
	fillBoard("mainboard");
	fillBoard("slaveboard");
	changeBoard("mainboard", "mainport");
	changeBoard("slaveboard", "slaveport");
}

function initEvent()
{
	var lagidmax = 1;
    if (netype == 77 || netype == 114)
	{
		lagidmax = lagidmax_950;
	}
	else if (netype == 83)
	{
		lagidmax = lagidmax_980;
	}
	else if( netype == 95 )
	{
		lagidmax = lagidmax_905;
		$("ggroupid").disabled = true;
	}
	else
	{
		var tmpLagIdMax =  SpecialAttrMgr.getNEAttrIntValue(neid, "TE_FUNC_RTN_CFG_PLA", "TE_ATTR_RTN_PLA_MAXGROUPNUM");
		if( lagidmax != null && lagidmax != "" )
		{
			lagidmax = tmpLagIdMax;	
		}
	}
	textCheck($("ggroupid"), lagidmin, lagidmax);
	$("ggroupid").value = 1;//     1
	
	$("mainboard").onchange = function()
	{
		changeBoard("mainboard", "mainport");
	};
	$("slaveboard").onchange = function()
	{
		changeBoard("slaveboard", "slaveport");
	};
	
	$("selectport").onclick = function()
	{
		right();
	};
	$("unselectport").onclick = function()
	{
		left();
	};
}

function right()
{
	if (selectePorts == null)
	{
		selectePorts = new Array();
	}
	var boardIndex = $("slaveboard").options.selectedIndex;
	var slaveboard = $("slaveboard").value;
	var slaveboardname = $("slaveboard").options[boardIndex].innerText;
	
	var portIndex = $("slaveport").options.selectedIndex;
	if (portIndex < 0)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var slaveport = $("slaveport").options[portIndex].value;
	var slaveportname = $("slaveport").options[portIndex].innerText;
	
	var slaveportObj = new Object();
    slaveportObj.slotId = slaveboard;
    slaveportObj.boardName = slaveboardname;
    slaveportObj.portId = slaveport;
    slaveportObj.portName = slaveportname;
    
    selectePorts[selectePorts.length] = slaveportObj;
    
    $("slaveportSelected").options[$("slaveportSelected").options.length] = new Option(slaveboardname + "-" + slaveportname, slaveboard + "-" + slaveport);
    
    $("slaveport").options.remove(portIndex);
    
    if ($("slaveport").options.length == 0)
    {
    	$("slaveboard").options.remove(boardIndex);
    	changeBoard("slaveboard", "slaveport");
    }
    
    refeshApplayBtn();
}

function left()
{
	if (selectePorts == null)
	{
		selectePorts = new Array();
	}
	
	var boardIndex = $("slaveboard").options.selectedIndex;
	var curslaveboard = $("slaveboard").value;
	
	var portIndex = $("slaveportSelected").options.selectedIndex;
	if (portIndex < 0)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var slaveportvar = $("slaveportSelected").options[portIndex].value;
	var slaveportname = $("slaveportSelected").options[portIndex].innerText;
	
	var portarr = slaveportvar.split("-");
	var slaveboard = portarr[0];
	var slaveport = portarr[1];
	
	var slaveportObjed = null
	for (var i = selectePorts.length-1; i >= 0; i--)
	{
		slaveportObjed =  selectePorts[i];
		if (slaveportObjed.slotId == slaveboard && slaveportObjed.portId == slaveport)
		{
			selectePorts.removeAt(i);
			$("slaveportSelected").options.remove(portIndex);
			
			if ($("slaveboard").options.length == 0)
		    {
		    	$("slaveboard").options[$("slaveboard").options.length] = new Option(slaveportObjed.boardName, slaveportObjed.slotId);
		    	$("slaveport").options[$("slaveport").options.length] = new Option(slaveportObjed.portName, slaveportObjed.portId);
		    }
		    else if (curslaveboard == slaveportObjed.slotId)
		    {
		    	$("slaveport").options[$("slaveport").options.length] = new Option(slaveportObjed.portName, slaveportObjed.portId);
		    }
		    else
		    {
		    	$("slaveboard").options[$("slaveboard").options.length] = new Option(slaveportObjed.boardName, slaveportObjed.slotId);
		    }
		}
	}
	
	refeshApplayBtn();
}

function fillBoard(board1)
{
    var atom = $(board1);
    atom.options.length = 0;
    
    var portObj = null;
    var bdName = null;
    var tmpArr = new Array();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        
        if(bdName == "IFU2")
        {
        	 continue;
        }
        
        if (!tmpArr.contains(bdName)) 
        {
            tmpArr[tmpArr.length] = bdName;
            atom.options[atom.options.length] = new Option(bdName, portObj.slotId);
        }
    }
}

function changeBoard(b1, p1)
{
    var atom = $(b1);
    var index = atom.options.selectedIndex;
    if (index < 0) 
    {
        return;
    }
    var option = atom.options[index];
    var slotId = option.value;
    var board = option.text;
    
    var portObj = null;
    var bdName = null;
    atom = $(p1);
    atom.options.length = 0;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        if (board == bdName) 
        {
            atom.options[atom.options.length] = new Option(portObj.portName, portObj.portId);
        }
    }
}

function sendApplyInfo(flag)
{
	if (selectePorts == null || selectePorts.length <= 0)
	{
		alert(RESOURCE["portAlert"]);
		return;
	}
	
	if (!confirm(RESOURCE["confirmCreate"]))
	{
		return;
	}
	
	$("okBtn").disabled = true;
	$("cancelBtn").disabled = true;
	$("applyBtn").disabled = true;
	
	var xmlstr = createPLAXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_ADD_PLA_GROUP + "&nmUser=" + win.winurlobj["nmUser"];

	loadXMLdoc(urlreq, "POST", true, openCreateErrDialog, flag, "inputdata="
			+ xmlstr);

}

function createPLAXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	param = new tagElement("param");
	var ggroupid = $("ggroupid").value;
	param.setAttribute("name", "ggroupid");
	param.setAttribute("value", ggroupid);
	row.appendChild(param);

	param = new tagElement("param");
	var mainslotid = $("mainboard").value;
	param.setAttribute("name", "mainslotid");
	param.setAttribute("value", mainslotid);
	row.appendChild(param);

	param = new tagElement("param");
	var mainportid = $("mainport").value;
	param.setAttribute("name", "mainportid");
	param.setAttribute("value", mainportid);
	row.appendChild(param);
	
	param = new tagElement("param");
	var slaveportnum = selectePorts.length;
	param.setAttribute("name", "slaveportnum");
	param.setAttribute("value", slaveportnum);
	row.appendChild(param);
	
	param = new tagElement("param");
	var slaveslotids = getSelectedString("slaveboard");
	param.setAttribute("name", "slaveslotids");
	param.setAttribute("value", slaveslotids);
	row.appendChild(param);
	
	param = new tagElement("param");
	var slaveportids = getSelectedString("slaveport");
	param.setAttribute("name", "slaveportids");
	param.setAttribute("value", slaveportids);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function getSelectedString(arr)
{
	var selStr = "";
	var portobject = null;
	if (arr == "slaveboard")
	{
		for (var i = 0; i < selectePorts.length; i++)
		{
			portobject = selectePorts[i];
			selStr = selStr + portobject.slotId + ",";
		}
	}
	
	if (arr == "slaveport")
	{
		for (var i = 0; i < selectePorts.length; i++)
		{
			portobject = selectePorts[i];
			selStr = selStr + portobject.portId + ",";
		}
	}
	
	return selStr
}

function closeClick()
{
	xcloseDialog();
}


function openCreateErrDialog(doc, flag)
{	
        $("okBtn").disabled = false;
        $("cancelBtn").disabled = false;
        
	var dinterface = EncapsulateData(doc);

	if (0 != dinterface.getSErrorCode())
	{
		isSuccess = false;
		hasApplied = false;
		showErrorDialog(dinterface);
		$("applyBtn").disabled = false;
		return;
	}

	isSuccess = true;
	hasApplied = true;
	win.refreshTable();
	
	
	
	if(dinterface.getSErrorCode() == 0)
	{
	    var ops = $("slaveportSelected").options;
	    
	    for(var i = 0, len = ops.length; i < len; i++)
	    {
	        removeObjFromMem(ops[i]);
	    }
	    
	    $("slaveportSelected").options.length = 0;
	    
	    fillBoard("slaveboard");
	    changeBoard("slaveboard", "slaveport");
	    
	    refeshApplayBtn();
	}
	
	if (dinterface.getSErrorCode() == 0 && flag)
	{
		closeClick();
	}
}

function initBtn()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	$("selectport").value = ">>";
	$("unselectport").value = "<<";
}

function showErrorDialog(dinterface)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", dinterface.getError(), errArr);
}

function refeshApplayBtn()
{
    if(selectePorts.length > 0 && $("slaveportSelected").options.length > 0)
    {
        $('applyBtn').disabled = false;
    } else {
        $('applyBtn').disabled = true;
    }
}

/**
 **        OPTION  
 **/
function removeObjFromMem(opt)
{
    var portarr = opt.value.split("-");
    var slaveboard = portarr[0];
    var slaveport = portarr[1];
    
    var slaveportObjed = null
    for (var i = selectePorts.length-1; i >= 0; i--)
    {
        slaveportObjed =  selectePorts[i];
	if (slaveportObjed.slotId == slaveboard && slaveportObjed.portId == slaveport)
	{
	    selectePorts.removeAt(i);
	}
    }
}
